/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.cooccurrenceMatrix;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.function.Functions;
import org.scijava.ops.image.image.cooccurrenceMatrix.CooccurrenceMatrix2D;
import org.scijava.ops.image.image.cooccurrenceMatrix.CooccurrenceMatrix3D;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class CooccurrenceMatrix<T extends RealType<T>>
implements Functions.Arity4<RandomAccessibleInterval<T>, MatrixOrientation, Integer, Integer, double[][]> {
    @OpDependency(name="stats.minMax")
    private Function<RandomAccessibleInterval<T>, Pair<T, T>> minmax;

    public double[][] apply(RandomAccessibleInterval<T> input, MatrixOrientation orientation, @Nullable Integer nrGreyLevels, @Nullable Integer distance) {
        if (nrGreyLevels == null) {
            nrGreyLevels = 32;
        }
        if (nrGreyLevels < 0 || nrGreyLevels > 128) {
            throw new IllegalArgumentException("nrGreyLevels must be between 0 and 128 (inclusive) but was " + nrGreyLevels);
        }
        if (distance == null) {
            distance = 1;
        }
        if (distance < 0 || distance > 128) {
            throw new IllegalArgumentException("distance must be between 0 and 128 (inclusive) but was " + distance);
        }
        if (input.numDimensions() == 3 && orientation.isCompatible(3)) {
            return CooccurrenceMatrix3D.apply(input, nrGreyLevels, distance, this.minmax, orientation);
        }
        if (input.numDimensions() == 2 && orientation.isCompatible(2)) {
            return CooccurrenceMatrix2D.apply(input, nrGreyLevels, distance, this.minmax, orientation);
        }
        throw new IllegalArgumentException("Only 2 and 3-dimensional inputs are supported!");
    }
}

