/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.cooccurrenceMatrix;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;

public class CooccurrenceMatrix3D {
    public static final <T extends RealType<T>> double[][] apply(RandomAccessibleInterval<T> input, Integer nrGreyLevels, Integer distance, Function<RandomAccessibleInterval<T>, Pair<T, T>> minmax, MatrixOrientation orientation) {
        double[][] matrix = new double[nrGreyLevels.intValue()][nrGreyLevels.intValue()];
        Pair<T, T> minMax = minmax.apply(input);
        double localMin = ((RealType)minMax.getA()).getRealDouble();
        double localMax = ((RealType)minMax.getB()).getRealDouble();
        int[][][] pixels = new int[(int)input.dimension(2)][(int)input.dimension(1)][(int)input.dimension(0)];
        int minimumX = (int)input.min(0);
        int minimumY = (int)input.min(1);
        int minimumZ = (int)input.min(2);
        double diff = localMax - localMin;
        LoopBuilder.setImages(input, (RandomAccessibleInterval)Intervals.positions(input)).multiThreaded().forEachPixel((pixel, pos) -> {
            pixels[pos.getIntPosition((int)2) - minimumZ][pos.getIntPosition((int)1) - minimumY][pos.getIntPosition((int)0) - minimumX] = (int)((pixel.getRealDouble() - localMin) / diff * (double)(nrGreyLevels - 1));
        });
        double orientationAtX = orientation.getValueAtDim(0) * distance;
        double orientationAtY = orientation.getValueAtDim(1) * distance;
        double orientationAtZ = orientation.getValueAtDim(2) * distance;
        int nrPairs = 0;
        for (int z = 0; z < pixels.length; ++z) {
            for (int y = 0; y < pixels[z].length; ++y) {
                for (int x = 0; x < pixels[z][y].length; ++x) {
                    if (pixels[z][y][x] == Integer.MAX_VALUE) continue;
                    int sx = (int)((double)x + orientationAtX);
                    int sy = (int)((double)y + orientationAtY);
                    int sz = (int)((double)z + orientationAtZ);
                    if (sx < 0 || sy < 0 || sz < 0 || sz >= pixels.length || sy >= pixels[sz].length || sx >= pixels[sz][sy].length || pixels[sz][sy][sx] == Integer.MAX_VALUE) continue;
                    double[] dArray = matrix[pixels[z][y][x]];
                    int n = pixels[sz][sy][sx];
                    dArray[n] = dArray[n] + 1.0;
                    ++nrPairs;
                }
            }
        }
        if (nrPairs > 0) {
            double divisor = 1.0 / (double)nrPairs;
            for (int row = 0; row < matrix.length; ++row) {
                int col = 0;
                while (col < matrix[row].length) {
                    double[] dArray = matrix[row];
                    int n = col++;
                    dArray[n] = dArray[n] * divisor;
                }
            }
        }
        return matrix;
    }
}

