/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;

class NextPhaseCal<T extends RealType<T>>
implements Runnable {
    private final double[] actualValues;
    private final int[] dimensSizes;
    private final int[] positions;
    private final int[] positions2;
    private final int actualDimension;
    private final double[] calibration;

    public NextPhaseCal(double[] actualValues, int[] dimensSizes, int[] positions, int actualDimension, double[] calibration) {
        this.actualValues = actualValues;
        this.dimensSizes = dimensSizes;
        this.positions = positions;
        this.positions2 = (int[])positions.clone();
        this.actualDimension = actualDimension;
        this.calibration = calibration;
    }

    private double distancefunc(int x, int i, double raOutValue) {
        return this.calibration[this.actualDimension] * this.calibration[this.actualDimension] * (double)(x - i) * (double)(x - i) + raOutValue;
    }

    private int sep(int i, int u, double w, double v) {
        return (int)Math.floor(Math.nextUp(((double)(u * u - i * i) + w / (this.calibration[this.actualDimension] * this.calibration[this.actualDimension]) - v / (this.calibration[this.actualDimension] * this.calibration[this.actualDimension])) / (double)(2 * (u - i))));
    }

    @Override
    public void run() {
        int u;
        int[] s = new int[this.dimensSizes[this.actualDimension]];
        int[] t = new int[this.dimensSizes[this.actualDimension]];
        int q = 0;
        s[0] = 0;
        t[0] = 0;
        for (int u2 = 1; u2 < this.dimensSizes[this.actualDimension]; ++u2) {
            this.positions[this.actualDimension] = s[q];
            this.positions2[this.actualDimension] = u2;
            while (q >= 0 && this.distancefunc(t[q], s[q], this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)]) > this.distancefunc(t[q], u2, this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions2, (int[])this.dimensSizes)])) {
                if (--q < 0) continue;
                this.positions[this.actualDimension] = s[q];
            }
            if (q < 0) {
                q = 0;
                s[0] = u2;
                continue;
            }
            this.positions[this.actualDimension] = s[q];
            this.positions2[this.actualDimension] = u2;
            int w = 1 + this.sep(s[q], u2, this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions2, (int[])this.dimensSizes)], this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)]);
            if (w >= this.dimensSizes[this.actualDimension]) continue;
            s[++q] = u2;
            t[q] = w;
        }
        double[] newValues = new double[this.dimensSizes[this.actualDimension]];
        for (u = this.dimensSizes[this.actualDimension] - 1; u >= 0; --u) {
            this.positions[this.actualDimension] = s[q];
            newValues[u] = this.distancefunc(u, s[q], this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)]);
            if (u != t[q]) continue;
            --q;
        }
        for (u = this.dimensSizes[this.actualDimension] - 1; u >= 0; --u) {
            this.positions[this.actualDimension] = u;
            this.actualValues[IntervalIndexer.positionToIndex((int[])this.positions, (int[])this.dimensSizes)] = newValues[u];
        }
    }
}

