/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;

class Phase2Runnable2D<T extends RealType<T>>
implements Runnable {
    private final RandomAccessibleInterval<T> raOut;
    private final int[][] tempValues;
    private final int xPos;
    private final int height;

    public Phase2Runnable2D(int[][] tempValues, RandomAccessibleInterval<T> raOut, int xPos) {
        this.tempValues = tempValues;
        this.raOut = raOut;
        this.xPos = xPos;
        this.height = (int)raOut.dimension(1);
    }

    private int distancefunc(int x, int i, int raOutValue) {
        return (x - i) * (x - i) + raOutValue * raOutValue;
    }

    private int sep(int i, int u, int w, int v) {
        return (u * u - i * i + w * w - v * v) / (2 * (u - i));
    }

    @Override
    public void run() {
        int[] s = new int[this.height];
        int[] t = new int[this.height];
        int q = 0;
        s[0] = 0;
        t[0] = 0;
        for (int u = 1; u < this.height; ++u) {
            while (q >= 0 && this.distancefunc(t[q], s[q], this.tempValues[this.xPos][s[q]]) > this.distancefunc(t[q], u, this.tempValues[this.xPos][u])) {
                --q;
            }
            if (q < 0) {
                q = 0;
                s[0] = u;
                continue;
            }
            int w = 1 + this.sep(s[q], u, this.tempValues[this.xPos][u], this.tempValues[this.xPos][s[q]]);
            if (w >= this.height) continue;
            s[++q] = u;
            t[q] = w;
        }
        RandomAccess ra = this.raOut.randomAccess();
        for (int u = this.height - 1; u >= 0; --u) {
            ra.setPosition(u, 1);
            ra.setPosition(this.xPos, 0);
            ((RealType)ra.get()).setReal(Math.sqrt(this.distancefunc(u, s[q], this.tempValues[this.xPos][s[q]])));
            if (u != t[q]) continue;
            --q;
        }
    }
}

