/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.watershed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class Watershed<T extends RealType<T>, B extends BooleanType<B>>
implements Computers.Arity4<RandomAccessibleInterval<T>, Boolean, Boolean, RandomAccessibleInterval<B>, ImgLabeling<Integer, IntType>> {
    @OpDependency(name="create.img")
    BiFunction<Dimensions, IntType, RandomAccessibleInterval<IntType>> imgCreator;
    private static final int WSHED = -1;
    private static final int INIT = -2;
    private static final int MASK = -3;

    public void compute(RandomAccessibleInterval<T> in, Boolean useEightConnectivity, Boolean drawWatersheds, @Nullable RandomAccessibleInterval<B> mask, ImgLabeling<Integer, IntType> outputLabeling) {
        RandomAccess raIn = in.randomAccess();
        RandomAccess raMask = null;
        if (mask != null) {
            raMask = mask.randomAccess();
        }
        long[] dimensSizes = new long[in.numDimensions()];
        in.dimensions(dimensSizes);
        long numPixels = Intervals.numElements(in);
        ArrayList<Long> imiList = new ArrayList<Long>();
        if (mask != null) {
            Cursor c = Regions.iterable(mask).inside().localizingCursor();
            while (c.hasNext()) {
                c.next();
                imiList.add(IntervalIndexer.positionToIndex((Localizable)c, in));
            }
        } else {
            for (long i = 0L; i < numPixels; ++i) {
                imiList.add(i);
            }
        }
        Long[] imi = imiList.toArray(new Long[imiList.size()]);
        Arrays.sort(imi, (o1, o2) -> {
            IntervalIndexer.indexToPosition((long)o1, (Dimensions)in, (Positionable)raIn);
            RealType value = (RealType)((RealType)raIn.get()).copy();
            IntervalIndexer.indexToPosition((long)o2, (Dimensions)in, (Positionable)raIn);
            return value.compareTo((Object)((RealType)raIn.get()));
        });
        RandomAccessibleInterval<IntType> lab = this.imgCreator.apply((Dimensions)in, new IntType());
        ExtendedRandomAccessibleInterval labExt = Views.extendBorder(lab);
        OutOfBounds raLab = labExt.randomAccess();
        RandomAccessibleInterval<IntType> dist = this.imgCreator.apply((Dimensions)in, new IntType());
        RandomAccess raDist = dist.randomAccess();
        for (IntType pixel : Views.flatIterable(lab)) {
            pixel.set(-2);
        }
        int current_label = 0;
        ArrayList<Long> fifo = new ArrayList<Long>();
        Object shape = useEightConnectivity != false ? new RectangleShape(1, true) : new DiamondShape(1L);
        RandomAccessible neighborhoods = shape.neighborhoodsRandomAccessible(in);
        RandomAccess raNeighbor = neighborhoods.randomAccess();
        for (int j = 0; j < imi.length; ++j) {
            Cursor neighborHood;
            long p;
            IntervalIndexer.indexToPosition((long)imi[j], in, (Positionable)raIn);
            RealType actualH = (RealType)((RealType)raIn.get()).copy();
            int i = j;
            while (actualH.compareTo((Object)((RealType)raIn.get())) == 0) {
                p = imi[i];
                IntervalIndexer.indexToPosition((long)p, in, (Positionable)raIn);
                raLab.setPosition((Localizable)raIn);
                ((IntType)raLab.get()).set(-3);
                raNeighbor.setPosition((Localizable)raIn);
                neighborHood = ((Neighborhood)raNeighbor.get()).cursor();
                while (neighborHood.hasNext()) {
                    int f;
                    neighborHood.fwd();
                    raLab.setPosition((Localizable)neighborHood);
                    if (raLab.isOutOfBounds() || (f = ((IntType)raLab.get()).get()) <= 0 && f != -1) continue;
                    raDist.setPosition((Localizable)raIn);
                    ((IntType)raDist.get()).set(1);
                    fifo.add(p);
                    break;
                }
                if (++i == imi.length) break;
                IntervalIndexer.indexToPosition((long)imi[i], in, (Positionable)raIn);
            }
            int current_dist = 1;
            fifo.add(-1L);
            block6: while (true) {
                if ((p = ((Long)fifo.remove(0)).longValue()) == -1L) {
                    if (fifo.isEmpty()) break;
                    fifo.add(-1L);
                    ++current_dist;
                    p = (Long)fifo.remove(0);
                }
                IntervalIndexer.indexToPosition((long)p, in, (Positionable)raNeighbor);
                neighborHood = ((Neighborhood)raNeighbor.get()).cursor();
                raLab.setPosition((Localizable)raNeighbor);
                int labp = ((IntType)raLab.get()).get();
                long[] posNeighbor = new long[neighborHood.numDimensions()];
                while (true) {
                    if (!neighborHood.hasNext()) continue block6;
                    neighborHood.fwd();
                    neighborHood.localize(posNeighbor);
                    raLab.setPosition(posNeighbor);
                    if (raLab.isOutOfBounds()) continue;
                    raDist.setPosition(posNeighbor);
                    int labq = ((IntType)raLab.get()).get();
                    int distq = ((IntType)raDist.get()).get();
                    if (distq < current_dist && (labq > 0 || labq == -1)) {
                        if (labq > 0) {
                            if (labp == -3 || labp == -1) {
                                labp = labq;
                            } else if (labp != labq) {
                                labp = -1;
                            }
                        } else if (labp == -3) {
                            labp = -1;
                        }
                        raLab.setPosition((Localizable)raNeighbor);
                        ((IntType)raLab.get()).set(labp);
                        continue;
                    }
                    if (labq != -3 || distq != 0) continue;
                    raDist.setPosition(posNeighbor);
                    ((IntType)raDist.get()).set(current_dist + 1);
                    fifo.add(IntervalIndexer.positionToIndex((long[])posNeighbor, (long[])dimensSizes));
                }
                break;
            }
            IntervalIndexer.indexToPosition((long)imi[j], in, (Positionable)raIn);
            i = j;
            while (actualH.compareTo((Object)((RealType)raIn.get())) == 0) {
                p = imi[i];
                IntervalIndexer.indexToPosition((long)p, dist, (Positionable)raDist);
                ((IntType)raDist.get()).set(0);
                raLab.setPosition((Localizable)raDist);
                if (((IntType)raLab.get()).get() == -3) {
                    fifo.add(p);
                    ((IntType)raLab.get()).set(++current_label);
                    while (!fifo.isEmpty()) {
                        long q = (Long)fifo.remove(0);
                        IntervalIndexer.indexToPosition((long)q, in, (Positionable)raNeighbor);
                        Cursor neighborHood2 = ((Neighborhood)raNeighbor.get()).cursor();
                        long[] posNeighbor = new long[neighborHood2.numDimensions()];
                        while (neighborHood2.hasNext()) {
                            neighborHood2.fwd();
                            neighborHood2.localize(posNeighbor);
                            raLab.setPosition(posNeighbor);
                            if (raLab.isOutOfBounds()) continue;
                            long r = IntervalIndexer.positionToIndex((long[])posNeighbor, (long[])dimensSizes);
                            if (((IntType)raLab.get()).get() != -3) continue;
                            fifo.add(r);
                            ((IntType)raLab.get()).set(current_label);
                        }
                    }
                }
                if (++i == imi.length) break;
                IntervalIndexer.indexToPosition((long)imi[i], in, (Positionable)raIn);
            }
            j = i - 1;
        }
        Cursor cursorOut = outputLabeling.cursor();
        while (cursorOut.hasNext()) {
            cursorOut.fwd();
            boolean maskValue = true;
            if (mask != null) {
                raMask.setPosition((Localizable)cursorOut);
                if (!((BooleanType)raMask.get()).get()) {
                    maskValue = false;
                }
            }
            raLab.setPosition((Localizable)cursorOut);
            if (!maskValue) {
                ((LabelingType)cursorOut.get()).clear();
                continue;
            }
            if (!drawWatersheds.booleanValue() && ((IntType)raLab.get()).get() == -1) {
                raNeighbor.setPosition((Localizable)cursorOut);
                Cursor neighborHood = ((Neighborhood)raNeighbor.get()).cursor();
                int newLab = -1;
                while (neighborHood.hasNext()) {
                    neighborHood.fwd();
                    raLab.setPosition((Localizable)neighborHood);
                    if (raLab.isOutOfBounds() || (newLab = ((IntType)raLab.get()).get()) <= -1) continue;
                }
                if (newLab == -1) {
                    ((LabelingType)cursorOut.get()).clear();
                    continue;
                }
                ((LabelingType)cursorOut.get()).add((Object)newLab);
                continue;
            }
            ((LabelingType)cursorOut.get()).add((Object)((IntType)raLab.get()).get());
        }
        if (outputLabeling != null) {
            Cursor cursor = outputLabeling.cursor();
            RandomAccess raOut = outputLabeling.randomAccess();
            while (cursor.hasNext()) {
                cursor.fwd();
                raOut.setPosition((Localizable)cursor);
                ArrayList labels = new ArrayList();
                ((LabelingType)cursor.get()).iterator().forEachRemaining(labels::add);
                ((LabelingType)raOut.get()).addAll(labels);
            }
        }
    }
}

