/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;

public final class DefaultQNorm
implements Functions.Arity5<Double, Double, Double, Boolean, Boolean, Double> {
    public Double apply(Double p, @Nullable Double mean, @Nullable Double sd, @Nullable Boolean lowerTail, @Nullable Boolean logP) {
        if (mean == null) {
            mean = 0.0;
        }
        if (sd == null) {
            sd = 1.0;
        }
        if (lowerTail == null) {
            lowerTail = true;
        }
        if (logP == null) {
            logP = false;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (p == 0.0 || p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        NormalDistribution dist = new NormalDistribution(mean.doubleValue(), sd.doubleValue());
        if (logP.booleanValue()) {
            p = Math.exp(p);
        }
        double q = dist.inverseCumulativeProbability(p.doubleValue());
        return lowerTail != false ? q : -q;
    }
}

