/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.thread.chunker;

import java.util.ArrayList;
import org.scijava.concurrent.Parallelization;
import org.scijava.function.Inplaces;
import org.scijava.ops.image.thread.chunker.Chunk;

public class ChunkerInterleaved
implements Inplaces.Arity2_1<Chunk, Long> {
    private String cancellationMsg;

    public void mutate(Chunk chunk, Long numberOfElements) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        int numStepsFloor = (int)(numberOfElements / (long)numThreads);
        int remainder = numberOfElements.intValue() - numStepsFloor * numThreads;
        ArrayList<Runnable> list = new ArrayList<Runnable>(numThreads);
        int i = 0;
        while (i < numThreads) {
            int j = i++;
            list.add(() -> {
                if (j < remainder) {
                    chunk.execute(j, numThreads, numStepsFloor + 1);
                } else {
                    chunk.execute(j, numThreads, numStepsFloor);
                }
            });
        }
        Parallelization.getTaskExecutor().runAll(list);
    }
}

