/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold;

import java.util.function.Function;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public abstract class AbstractApplyThresholdImg<T extends RealType<T>, I extends Iterable<T>, J extends Iterable<BitType>>
implements Computers.Arity1<I, J> {
    @OpDependency(name="image.histogram")
    private Function<I, Histogram1d<T>> createHistogramOp;
    @OpDependency(name="threshold.apply")
    private Computers.Arity2<I, T, J> applyThresholdOp;

    public void compute(I input, J output) {
        Histogram1d<T> inputHistogram = this.createHistogramOp.apply(input);
        RealType threshold = (RealType)((RealType)input.iterator().next()).createVariable();
        this.getComputeThresholdOp().compute(inputHistogram, (Object)threshold);
        this.applyThresholdOp.compute(input, (Object)threshold, output);
    }

    protected abstract Computers.Arity1<Histogram1d<T>, T> getComputeThresholdOp();
}

