/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localContrast;

import java.util.function.Function;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalContrastThreshold<T extends RealType<T>>
implements Computers.Arity2<Iterable<T>, T, BitType> {
    @OpDependency(name="stats.minMax")
    private Function<Iterable<T>, Pair<T, T>> minMaxOp;

    public void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, BitType output) {
        ComputeLocalContrastThreshold.compute(inputNeighborhood, inputCenterPixel, this.minMaxOp, output);
    }

    public static <T extends RealType<T>> void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Function<Iterable<T>, Pair<T, T>> minMaxOp, BitType output) {
        double diffMax;
        Pair<T, T> outputs = minMaxOp.apply(inputNeighborhood);
        double centerValue = inputCenterPixel.getRealDouble();
        double diffMin = centerValue - ((RealType)outputs.getA()).getRealDouble();
        output.set(diffMin <= (diffMax = ((RealType)outputs.getB()).getRealDouble() - centerValue));
    }
}

