/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localPhansalkar;

import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalPhansalkarThreshold<T extends RealType<T>>
implements Computers.Arity4<Iterable<T>, T, Double, Double, BitType> {
    public static final double DEFAULT_K = 0.25;
    public static final double DEFAULT_R = 0.5;
    private static final double P = 2.0;
    private static final double Q = 10.0;
    @OpDependency(name="stats.mean")
    private Computers.Arity1<Iterable<T>, DoubleType> meanOp;
    @OpDependency(name="stats.stdDev")
    private Computers.Arity1<Iterable<T>, DoubleType> stdDeviationOp;

    public void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, @Nullable Double k, @Nullable Double r, BitType output) {
        if (k == null) {
            k = 0.25;
        }
        if (r == null) {
            r = 0.5;
        }
        DoubleType meanValue = new DoubleType();
        this.meanOp.compute(inputNeighborhood, (Object)meanValue);
        DoubleType stdDevValue = new DoubleType();
        this.stdDeviationOp.compute(inputNeighborhood, (Object)stdDevValue);
        double threshold = meanValue.get() * (1.0 + 2.0 * Math.exp(-10.0 * meanValue.get()) + k * (stdDevValue.get() / r - 1.0));
        output.set(inputCenterPixel.getRealDouble() >= threshold);
    }
}

