/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;

public class OvalRoi
extends Roi {
    public OvalRoi(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.type = 1;
    }

    public OvalRoi(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.type = 1;
    }

    public static OvalRoi create(double x, double y, double width, double height) {
        return new OvalRoi(x, y, width, height);
    }

    public OvalRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        this.type = 1;
    }

    public OvalRoi(int x, int y, int width, int height, ImagePlus imp) {
        this(x, y, width, height);
        this.setImage(imp);
    }

    @Override
    public double[] getFeretValues() {
        double[] a = new double[16];
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        boolean highAspect = ph * (double)this.height > pw * (double)this.width;
        a[0] = highAspect ? (double)this.height * ph : (double)this.width * pw;
        a[1] = highAspect ? 90.0 : 0.0;
        a[2] = highAspect ? (double)this.width * pw : (double)this.height * ph;
        a[3] = ((double)this.x + (highAspect ? 0.5 * (double)this.width : 0.0)) * pw;
        a[4] = ((double)this.y + (highAspect ? (double)this.height : 0.5 * (double)this.height)) * ph;
        int i = 8;
        a[i++] = (double)this.x + (highAspect ? 0.5 * (double)this.width : 0.0);
        a[i++] = (double)this.y + (highAspect ? (double)this.height : 0.5 * (double)this.height);
        a[i++] = (double)this.x + (highAspect ? 0.5 * (double)this.width : (double)this.width);
        a[i++] = (double)this.y + (highAspect ? 0.0 : 0.5 * (double)this.height);
        a[i++] = (double)this.x + (highAspect ? 0.0 : 0.5 * (double)this.width);
        a[i++] = (double)this.y + (highAspect ? 0.5 * (double)this.height : (double)this.height);
        a[i++] = (double)this.x + (highAspect ? (double)this.width : 0.5 * (double)this.width);
        a[i++] = (double)this.y + (highAspect ? 0.5 * (double)this.height : 0.0);
        return a;
    }

    @Override
    protected void moveHandle(int sx, int sy) {
        double asp;
        if (this.clipboard != null) {
            return;
        }
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        int x1 = this.x;
        int y1 = this.y;
        int x2 = this.x + this.width;
        int y2 = this.y + this.height;
        int xc = this.x + this.width / 2;
        int yc = this.y + this.height / 2;
        int w2 = (int)(0.14645 * (double)this.width);
        int h2 = (int)(0.14645 * (double)this.height);
        if (this.width > 7 && this.height > 7) {
            this.asp_bk = asp = (double)this.width / (double)this.height;
        } else {
            asp = this.asp_bk;
        }
        switch (this.activeHandle) {
            case 0: {
                this.x = ox - w2;
                this.y = oy - h2;
                break;
            }
            case 1: {
                this.y = oy;
                break;
            }
            case 2: {
                x2 = ox + w2;
                this.y = oy - h2;
                break;
            }
            case 3: {
                x2 = ox;
                break;
            }
            case 4: {
                x2 = ox + w2;
                y2 = oy + h2;
                break;
            }
            case 5: {
                y2 = oy;
                break;
            }
            case 6: {
                this.x = ox - w2;
                y2 = oy + h2;
                break;
            }
            case 7: {
                this.x = ox;
            }
        }
        if (this.x < x2) {
            this.width = x2 - this.x;
        } else {
            this.width = 1;
            this.x = x2;
        }
        if (this.y < y2) {
            this.height = y2 - this.y;
        } else {
            this.height = 1;
            this.y = y2;
        }
        if (this.center) {
            switch (this.activeHandle) {
                case 0: {
                    this.width = (xc - this.x) * 2;
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 1: {
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 2: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 3: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    break;
                }
                case 4: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 5: {
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 6: {
                    this.width = (xc - this.x) * 2;
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 7: {
                    this.width = (xc - this.x) * 2;
                }
            }
            if (this.x >= x2) {
                this.width = 1;
                this.x = x2 = xc;
            }
            if (this.y >= y2) {
                this.height = 1;
                this.y = y2 = yc;
            }
        }
        if (this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = this.height;
            } else {
                this.height = this.width;
            }
            if (this.x >= x2) {
                this.width = 1;
                this.x = x2 = xc;
            }
            if (this.y >= y2) {
                this.height = 1;
                this.y = y2 = yc;
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = x2 - this.width;
                    this.y = y2 - this.height;
                    break;
                }
                case 1: {
                    this.x = xc - this.width / 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 2: {
                    this.y = y2 - this.height;
                    break;
                }
                case 3: {
                    this.y = yc - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = xc - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = x2 - this.width;
                    break;
                }
                case 7: {
                    this.y = yc - this.height / 2;
                    this.x = x2 - this.width;
                }
            }
            if (this.center) {
                this.x = xc - this.width / 2;
                this.y = yc - this.height / 2;
            }
        }
        if (this.aspect && !this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = (int)Math.rint((double)this.height * asp);
            } else {
                this.height = (int)Math.rint((double)this.width / asp);
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = x2 - this.width;
                    this.y = y2 - this.height;
                    break;
                }
                case 1: {
                    this.x = xc - this.width / 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 2: {
                    this.y = y2 - this.height;
                    break;
                }
                case 3: {
                    this.y = yc - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = xc - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = x2 - this.width;
                    break;
                }
                case 7: {
                    this.y = yc - this.height / 2;
                    this.x = x2 - this.width;
                }
            }
            if (this.center) {
                this.x = xc - this.width / 2;
                this.y = yc - this.height / 2;
            }
            if (this.width < 8) {
                if (this.width < 1) {
                    this.width = 1;
                }
                this.height = (int)Math.rint((double)this.width / this.asp_bk);
            }
            if (this.height < 8) {
                if (this.height < 1) {
                    this.height = 1;
                }
                this.width = (int)Math.rint((double)this.height * this.asp_bk);
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.cachedMask = null;
        this.bounds = null;
    }

    @Override
    public void draw(Graphics g) {
        Color color;
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        g.setColor(color);
        this.mag = this.getMagnification();
        int sw = (int)((double)this.width * this.mag);
        int sh = (int)((double)this.height * this.mag);
        int sx1 = this.screenX(this.x);
        int sy1 = this.screenY(this.y);
        if (this.subPixelResolution() && this.bounds != null) {
            sw = (int)(this.bounds.width * this.mag);
            sh = (int)(this.bounds.height * this.mag);
            sx1 = this.screenXD(this.bounds.x);
            sy1 = this.screenYD(this.bounds.y);
        }
        int sw2 = (int)(0.14645 * (double)this.width * this.mag);
        int sh2 = (int)(0.14645 * (double)this.height * this.mag);
        int sx2 = sx1 + sw / 2;
        int sy2 = sy1 + sh / 2;
        int sx3 = sx1 + sw;
        int sy3 = sy1 + sh;
        Graphics2D g2d = (Graphics2D)g;
        if (this.stroke != null) {
            g2d.setStroke(this.getScaledStroke());
        }
        this.setRenderingHint(g2d);
        if (this.fillColor != null) {
            if (!this.overlay && this.isActiveOverlayRoi()) {
                g.setColor(Color.cyan);
                g.drawOval(sx1, sy1, sw, sh);
            } else {
                g.fillOval(sx1, sy1, sw, sh);
                if (this.strokeColor != null) {
                    g.setColor(this.strokeColor);
                    g.drawOval(sx1, sy1, sw, sh);
                }
            }
        } else {
            g.drawOval(sx1, sy1, sw, sh);
        }
        if (this.clipboard == null && !this.overlay) {
            this.drawHandle(g, sx1 + sw2, sy1 + sh2);
            this.drawHandle(g, sx3 - sw2, sy1 + sh2);
            this.drawHandle(g, sx3 - sw2, sy3 - sh2);
            this.drawHandle(g, sx1 + sw2, sy3 - sh2);
            this.drawHandle(g, sx2, sy1);
            this.drawHandle(g, sx3, sy2);
            this.drawHandle(g, sx2, sy3);
            this.drawHandle(g, sx1, sy2);
        }
        this.drawPreviousRoi(g);
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        if (this.state != 3) {
            this.showStatus();
        }
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        Polygon p = this.getPolygon();
        if (p.npoints > 0) {
            int saveWidth = ip.getLineWidth();
            if (this.getStrokeWidth() > 1.0f) {
                ip.setLineWidth(Math.round(this.getStrokeWidth()));
            }
            ip.drawPolygon(p);
            ip.setLineWidth(saveWidth);
        }
        if (Line.getWidth() > 1 || this.getStrokeWidth() > 1.0f) {
            this.updateFullWindow = true;
        }
    }

    @Override
    public Polygon getPolygon() {
        return this.getPolygon(true);
    }

    Polygon getPolygon(boolean absoluteCoordinates) {
        ImageProcessor mask = this.getMask();
        Wand wand = new Wand(mask);
        wand.autoOutline(this.width / 2, this.height / 2, 255, 255);
        if (absoluteCoordinates) {
            int i = 0;
            while (i < wand.npoints) {
                int n = i;
                wand.xpoints[n] = wand.xpoints[n] + this.x;
                int n2 = i++;
                wand.ypoints[n2] = wand.ypoints[n2] + this.y;
            }
        }
        return new Polygon(wand.xpoints, wand.ypoints, wand.npoints);
    }

    @Override
    public FloatPolygon getFloatPolygon() {
        ShapeRoi sr = new ShapeRoi(new Ellipse2D.Double((double)this.x - 4.0E-4, (double)this.y - 4.0E-4, (double)this.width + 8.0E-4, (double)this.height + 8.0E-4));
        return sr.getFloatPolygon();
    }

    public FloatPolygon getFloatPolygon4() {
        return super.getFloatPolygon();
    }

    @Override
    public int size() {
        return this.getPolygon().npoints;
    }

    @Override
    public boolean contains(int ox, int oy) {
        double a = (double)this.width * 0.5;
        double cx = (double)this.x + a - 0.5;
        double dx = (double)ox - cx;
        double b = (double)this.height * 0.5;
        double cy = (double)this.y + b - 0.5;
        double dy = (double)oy - cy;
        return dx * dx / (a * a) + dy * dy / (b * b) <= 1.0;
    }

    @Override
    public boolean containsPoint(double x, double y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        Ellipse2D.Double e = new Ellipse2D.Double(this.x, this.y, this.width, this.height);
        return e.contains(x, y);
    }

    @Override
    public int isHandle(int sx, int sy) {
        if (this.clipboard != null || this.ic == null) {
            return -1;
        }
        double mag = this.ic.getMagnification();
        int size = this.getHandleSize() + 3;
        int halfSize = size / 2;
        int sx1 = this.screenX(this.x) - halfSize;
        int sy1 = this.screenY(this.y) - halfSize;
        int sx3 = this.screenX(this.x + this.width) - halfSize;
        int sy3 = this.screenY(this.y + this.height) - halfSize;
        int sx2 = sx1 + (sx3 - sx1) / 2;
        int sy2 = sy1 + (sy3 - sy1) / 2;
        int sw2 = (int)(0.14645 * (double)(sx3 - sx1));
        int sh2 = (int)(0.14645 * (double)(sy3 - sy1));
        if (sx >= sx1 + sw2 && sx <= sx1 + sw2 + size && sy >= sy1 + sh2 && sy <= sy1 + sh2 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy1 && sy <= sy1 + size) {
            return 1;
        }
        if (sx >= sx3 - sw2 && sx <= sx3 - sw2 + size && sy >= sy1 + sh2 && sy <= sy1 + sh2 + size) {
            return 2;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy2 && sy <= sy2 + size) {
            return 3;
        }
        if (sx >= sx3 - sw2 && sx <= sx3 - sw2 + size && sy >= sy3 - sh2 && sy <= sy3 - sh2 + size) {
            return 4;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy3 && sy <= sy3 + size) {
            return 5;
        }
        if (sx >= sx1 + sw2 && sx <= sx1 + sw2 + size && sy >= sy3 - sh2 && sy <= sy3 - sh2 + size) {
            return 6;
        }
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy2 && sy <= sy2 + size) {
            return 7;
        }
        return -1;
    }

    @Override
    public ImageProcessor getMask() {
        ImageProcessor mask = this.cachedMask;
        if (mask != null && mask.getPixels() != null && mask.getWidth() == this.width && mask.getHeight() == this.height) {
            return mask;
        }
        mask = new ByteProcessor(this.width, this.height);
        double a = (double)this.width / 2.0;
        double b = (double)this.height / 2.0;
        double a2 = a * a;
        double b2 = b * b;
        a -= 0.5;
        b -= 0.5;
        byte[] pixels = (byte[])mask.getPixels();
        for (int y = 0; y < this.height; ++y) {
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                double xx = (double)x - a;
                double yy = (double)y - b;
                if (!(xx * xx / a2 + yy * yy / b2 <= 1.0) || offset + x >= pixels.length) continue;
                pixels[offset + x] = -1;
            }
        }
        this.cachedMask = mask;
        return mask;
    }

    @Override
    public double getLength() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        double a = 0.5 * (double)this.width * pw;
        double b = 0.5 * (double)this.height * ph;
        return Math.PI * (3.0 * (a + b) - Math.sqrt((3.0 * a + b) * (a + 3.0 * b)));
    }
}

