/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.TransferHandler;

public class DragAndDropHandler
extends TransferHandler {
    private JFileChooser jFileChooser;

    public DragAndDropHandler(JFileChooser jFileChooser) {
        this.jFileChooser = jFileChooser;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (DataFlavor dataFlavor : transferFlavors) {
            if (!this.isSupportedTransferFlavor(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        DataFlavor[] transferFlavors;
        for (DataFlavor dataFlavor : transferFlavors = t.getTransferDataFlavors()) {
            try {
                ArrayList<File> fileList = null;
                if (dataFlavor.isFlavorJavaFileListType()) {
                    fileList = (ArrayList<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (IJ.debugMode) {
                        IJ.log("dragAndDrop FileList size=" + fileList.size() + " first: " + fileList.get(0));
                    }
                } else if (this.isSupportedTransferFlavor(dataFlavor)) {
                    String str = (String)t.getTransferData(dataFlavor);
                    if (IJ.debugMode) {
                        IJ.log("dragAndDrop str=" + str);
                    }
                    String[] strs = str.split("[\n\r]+");
                    fileList = new ArrayList<File>(strs.length);
                    for (String s : strs) {
                        if (s.length() <= 0) continue;
                        File file = new File(s);
                        if (!file.exists()) {
                            try {
                                file = new File(new URI(s));
                            }
                            catch (URISyntaxException e) {
                                continue;
                            }
                        }
                        if (!file.exists()) continue;
                        fileList.add(file);
                    }
                }
                if (fileList == null || fileList.size() == 0) continue;
                File firstFile = (File)fileList.get(0);
                if (this.jFileChooser.isMultiSelectionEnabled()) {
                    File dir = firstFile.getParentFile();
                    this.jFileChooser.setCurrentDirectory(dir);
                    File[] files = fileList.toArray(new File[0]);
                    this.jFileChooser.setSelectedFiles(files);
                } else {
                    File file = firstFile;
                    if (this.jFileChooser.getFileSelectionMode() == 1 && !file.isDirectory()) {
                        file = file.getParentFile();
                    }
                    if (this.jFileChooser.getDialogType() == 1 && file.isDirectory()) {
                        this.jFileChooser.setCurrentDirectory(file);
                    } else {
                        this.jFileChooser.setSelectedFile(file);
                    }
                }
                this.jFileChooser.rescanCurrentDirectory();
                return true;
            }
            catch (Exception e) {
                if (!IJ.debugMode) continue;
                IJ.handleException(e);
            }
        }
        return false;
    }

    public boolean isSupportedTransferFlavor(DataFlavor flavor) {
        return flavor.isFlavorJavaFileListType() || flavor.getRepresentationClass() == String.class && (flavor.getMimeType().startsWith("text/uri-list") || flavor.getMimeType().startsWith("text/plain"));
    }
}

