/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.ComplexMatrix;
import org.ojalgo.matrix.RationalMatrix;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public abstract class BasicLogger {
    public static Printer DEBUG = new PrintStreamPrinter(System.out);
    public static Printer ERROR = new PrintStreamPrinter(System.err);
    public static final Printer NULL = new Printer(){

        @Override
        public void print(char c) {
        }

        @Override
        public void print(char[] ca) {
        }

        @Override
        public void print(String str) {
        }

        @Override
        public Printer printf(Locale locale, String format, Object ... args) {
            return this;
        }

        @Override
        public Printer printf(String format, Object ... args) {
            return this;
        }

        @Override
        public void println() {
        }
    };
    static final NumberContext MATRIX_ELEMENT_CONTEXT = NumberContext.getGeneral(6);

    public static void debug() {
        BasicLogger.println(DEBUG);
    }

    public static void debug(Object message) {
        BasicLogger.println(DEBUG, message);
    }

    public static void debug(String message, Access2D<?> matrix) {
        BasicLogger.debug(message, matrix, MATRIX_ELEMENT_CONTEXT);
    }

    public static void debug(String message, Access2D<?> matrix, NumberContext context) {
        if (message != null) {
            BasicLogger.println(DEBUG, message);
        }
        BasicLogger.printmtrx(DEBUG, matrix, context);
    }

    public static void debug(String message, Object ... arguments) {
        BasicLogger.println(DEBUG, message, arguments);
    }

    public static void error() {
        BasicLogger.println(ERROR);
    }

    public static void error(Object message) {
        BasicLogger.println(ERROR, message);
    }

    public static void error(String message, Access2D<?> matrix) {
        BasicLogger.error(message, matrix, MATRIX_ELEMENT_CONTEXT);
    }

    public static void error(String message, Access2D<?> matrix, NumberContext context) {
        if (message != null) {
            BasicLogger.println(ERROR, message);
        }
        BasicLogger.printmtrx(ERROR, matrix, context);
    }

    public static void error(String message, Object ... arguments) {
        BasicLogger.println(ERROR, message, arguments);
    }

    private static void printmtrx(Printer appender, BasicMatrix matrix, NumberContext context, boolean plain) {
        String tmpElementString;
        int i;
        int tmpRowDim = (int)matrix.countRows();
        int tmpColDim = (int)matrix.countColumns();
        String[][] tmpElements = new String[tmpRowDim][tmpColDim];
        int tmpWidth = 0;
        for (int j = 0; j < tmpColDim; ++j) {
            for (i = 0; i < tmpRowDim; ++i) {
                Scalar<?> tmpElementNumber = matrix.toScalar(i, j);
                tmpElementString = plain ? tmpElementNumber.toPlainString(context) : tmpElementNumber.toString(context);
                tmpWidth = Math.max(tmpWidth, tmpElementString.length());
                tmpElements[i][j] = tmpElementString;
            }
        }
        ++tmpWidth;
        for (i = 0; i < tmpRowDim; ++i) {
            for (int j = 0; j < tmpColDim; ++j) {
                tmpElementString = tmpElements[i][j];
                int tmpPadding = tmpWidth - tmpElementString.length();
                for (int p = 0; p < tmpPadding; ++p) {
                    appender.print(' ');
                }
                appender.print(tmpElementString);
            }
            appender.println();
        }
    }

    static void println(Printer appender) {
        if (appender != null) {
            appender.println();
        }
    }

    static void println(Printer appender, Object message) {
        if (appender != null) {
            appender.println(message);
        }
    }

    static void println(Printer appender, String messagePattern, Object ... arguments) {
        if (appender != null) {
            appender.println(messagePattern, arguments);
        }
    }

    static void printmtrx(Printer appender, Access2D<?> matrix, NumberContext context) {
        if (appender != null && matrix.count() > 0L) {
            if (matrix instanceof ComplexMatrix) {
                BasicLogger.printmtrx(appender, (ComplexMatrix)matrix, context, false);
            } else if (matrix instanceof BasicMatrix) {
                BasicLogger.printmtrx(appender, (BasicMatrix)matrix, context, true);
            } else if (matrix.get(0L, 0L) instanceof ComplexNumber) {
                BasicLogger.printmtrx(appender, (BasicMatrix)ComplexMatrix.FACTORY.copy(matrix), context, false);
            } else {
                BasicLogger.printmtrx(appender, (BasicMatrix)RationalMatrix.FACTORY.copy(matrix), context, true);
            }
        }
    }

    private BasicLogger() {
    }

    public static final class PrintWriterPrinter
    implements Printer {
        private final PrintWriter myWriter;

        public PrintWriterPrinter(PrintWriter writer) {
            this.myWriter = writer;
        }

        @Override
        public void print(boolean b) {
            this.myWriter.print(b);
        }

        @Override
        public void print(char c) {
            this.myWriter.print(c);
        }

        @Override
        public void print(char[] ca) {
            this.myWriter.print(ca);
        }

        @Override
        public void print(double d) {
            this.myWriter.print(d);
        }

        @Override
        public void print(float f) {
            this.myWriter.print(f);
        }

        @Override
        public void print(int i) {
            this.myWriter.print(i);
        }

        @Override
        public void print(long l) {
            this.myWriter.print(l);
        }

        @Override
        public void print(Object obj) {
            this.myWriter.print(obj);
        }

        @Override
        public void print(String str) {
            this.myWriter.print(str);
        }

        @Override
        public void print(String message, Object ... args) {
            this.print(TypeUtils.format(message, args));
        }

        @Override
        public PrintWriterPrinter printf(Locale locale, String format, Object ... args) {
            this.myWriter.printf(locale, format, args);
            return this;
        }

        @Override
        public PrintWriterPrinter printf(String format, Object ... args) {
            this.myWriter.printf(format, args);
            return this;
        }

        @Override
        public void println() {
            this.myWriter.println();
        }

        @Override
        public void println(boolean b) {
            this.myWriter.println(b);
        }

        @Override
        public void println(char c) {
            this.myWriter.println(c);
        }

        @Override
        public void println(char[] ca) {
            this.myWriter.println(ca);
        }

        @Override
        public void println(double d) {
            this.myWriter.println(d);
        }

        @Override
        public void println(float f) {
            this.myWriter.println(f);
        }

        @Override
        public void println(int i) {
            this.myWriter.println(i);
        }

        @Override
        public void println(long l) {
            this.myWriter.println(l);
        }

        @Override
        public void println(Object obj) {
            this.myWriter.println(obj);
        }

        @Override
        public void println(String str) {
            this.myWriter.println(str);
        }

        @Override
        public void println(String message, Object ... args) {
            this.print(message, args);
            this.println();
        }

        @Override
        public void printmtrx(String message, Access2D<?> matrix) {
            this.printmtrx(message, matrix, MATRIX_ELEMENT_CONTEXT);
        }

        @Override
        public void printmtrx(String message, Access2D<?> matrix, NumberContext context) {
            if (message != null) {
                this.println(message);
            }
            BasicLogger.printmtrx(this, matrix, context);
        }

        PrintWriter getWriter() {
            return this.myWriter;
        }
    }

    public static final class PrintStreamPrinter
    implements Printer {
        private final PrintStream myStream;

        public PrintStreamPrinter(PrintStream stream) {
            this.myStream = stream;
        }

        @Override
        public void print(boolean b) {
            this.myStream.print(b);
        }

        @Override
        public void print(char c) {
            this.myStream.print(c);
        }

        @Override
        public void print(char[] ca) {
            this.myStream.print(ca);
        }

        @Override
        public void print(double d) {
            this.myStream.print(d);
        }

        @Override
        public void print(float f) {
            this.myStream.print(f);
        }

        @Override
        public void print(int i) {
            this.myStream.print(i);
        }

        @Override
        public void print(long l) {
            this.myStream.print(l);
        }

        @Override
        public void print(Object obj) {
            this.myStream.print(obj);
        }

        @Override
        public void print(String str) {
            this.myStream.print(str);
        }

        @Override
        public void print(String message, Object ... args) {
            this.print(TypeUtils.format(message, args));
        }

        @Override
        public PrintStreamPrinter printf(Locale locale, String format, Object ... args) {
            this.myStream.printf(locale, format, args);
            return this;
        }

        @Override
        public PrintStreamPrinter printf(String format, Object ... args) {
            this.myStream.printf(format, args);
            return this;
        }

        @Override
        public void println() {
            this.myStream.println();
        }

        @Override
        public void println(boolean b) {
            this.myStream.println(b);
        }

        @Override
        public void println(char c) {
            this.myStream.println(c);
        }

        @Override
        public void println(char[] ca) {
            this.myStream.println(ca);
        }

        @Override
        public void println(double d) {
            this.myStream.println(d);
        }

        @Override
        public void println(float f) {
            this.myStream.println(f);
        }

        @Override
        public void println(int i) {
            this.myStream.println(i);
        }

        @Override
        public void println(long l) {
            this.myStream.println(l);
        }

        @Override
        public void println(Object obj) {
            this.myStream.println(obj);
        }

        @Override
        public void println(String str) {
            this.myStream.println(str);
        }

        @Override
        public void println(String message, Object ... args) {
            this.print(message, args);
            this.println();
        }

        @Override
        public void printmtrx(String message, Access2D<?> matrix) {
            this.printmtrx(message, matrix, MATRIX_ELEMENT_CONTEXT);
        }

        @Override
        public void printmtrx(String message, Access2D<?> matrix, NumberContext context) {
            if (message != null) {
                this.println(message);
            }
            BasicLogger.printmtrx(this, matrix, context);
        }

        PrintStream getStream() {
            return this.myStream;
        }
    }

    public static interface Printer {
        public void print(char var1);

        public void print(char[] var1);

        public void print(String var1);

        public Printer printf(Locale var1, String var2, Object ... var3);

        public Printer printf(String var1, Object ... var2);

        public void println();

        default public void print(boolean b) {
            this.print(String.valueOf(b));
        }

        default public void print(double d) {
            this.print(String.valueOf(d));
        }

        default public void print(float f) {
            this.print(String.valueOf(f));
        }

        default public void print(int i) {
            this.print(String.valueOf(i));
        }

        default public void print(long l) {
            this.print(String.valueOf(l));
        }

        default public void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        default public void print(String message, Object ... args) {
            this.print(TypeUtils.format(message, args));
        }

        default public void println(boolean b) {
            this.print(b);
            this.println();
        }

        default public void println(char c) {
            this.print(c);
            this.println();
        }

        default public void println(char[] ca) {
            this.print(ca);
            this.println();
        }

        default public void println(double d) {
            this.print(d);
            this.println();
        }

        default public void println(float f) {
            this.print(f);
            this.println();
        }

        default public void println(int i) {
            this.print(i);
            this.println();
        }

        default public void println(long l) {
            this.print(l);
            this.println();
        }

        default public void println(Object obj) {
            this.print(obj);
            this.println();
        }

        default public void println(String str) {
            this.print(str);
            this.println();
        }

        default public void println(String message, Object ... args) {
            this.print(message, args);
            this.println();
        }

        default public void printmtrx(String message, Access2D<?> matrix) {
            this.printmtrx(message, matrix, MATRIX_ELEMENT_CONTEXT);
        }

        default public void printmtrx(String message, Access2D<?> matrix, NumberContext context) {
            if (message != null) {
                this.println(message);
            }
            BasicLogger.printmtrx(this, matrix, context);
        }
    }

    public static interface Buffer {
        public void clear();

        default public void flush(Appendable receiver) {
            this.flush(new AppendablePrinter(receiver));
        }

        public void flush(Printer var1);

        default public void flush(PrintStream receiver) {
            this.flush(new PrintStreamPrinter(receiver));
        }

        default public void flush(PrintWriter receiver) {
            this.flush(new PrintWriterPrinter(receiver));
        }
    }

    public static class AppendablePrinter
    implements Printer {
        private final Appendable myAppendable;
        private transient Formatter myFormatter;

        public AppendablePrinter(Appendable appendable) {
            this.myAppendable = appendable;
        }

        @Override
        public void print(char c) {
            try {
                this.myAppendable.append(c);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void print(char[] ca) {
            try {
                for (int i = 0; i < ca.length; ++i) {
                    this.myAppendable.append(ca[i]);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void print(String str) {
            try {
                this.myAppendable.append(String.valueOf(str));
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Printer printf(Locale locale, String format, Object ... args) {
            Appendable appendable = this.myAppendable;
            synchronized (appendable) {
                if (this.myFormatter == null || this.myFormatter.locale() != locale) {
                    this.myFormatter = new Formatter(this.myAppendable, locale);
                }
                this.myFormatter.format(locale, format, args);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Printer printf(String format, Object ... args) {
            Appendable appendable = this.myAppendable;
            synchronized (appendable) {
                if (this.myFormatter == null || this.myFormatter.locale() != Locale.getDefault()) {
                    this.myFormatter = new Formatter(this.myAppendable);
                }
                this.myFormatter.format(Locale.getDefault(), format, args);
            }
            return this;
        }

        @Override
        public void println() {
            try {
                this.myAppendable.append('\n');
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }

        Appendable getAppendable() {
            return this.myAppendable;
        }
    }
}

