/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixEvd;
import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.EllipsoidGlyph;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.SimpleFrame;
import edu.mines.jtk.sgl.StateSet;
import edu.mines.jtk.sgl.World;
import edu.mines.jtk.util.ArrayMath;
import java.awt.Color;

public class EllipsoidGlyphTest {
    public static void main(String[] args) {
        EllipsoidGlyphTest.test0();
        EllipsoidGlyphTest.test1();
        EllipsoidGlyphTest.test2();
    }

    public static void test0() {
        EllipsoidGlyphTest.show(new OneEllipsoid(1.0f));
        EllipsoidGlyphTest.show(new OneEllipsoid(0.3f));
        EllipsoidGlyphTest.show(new OneEllipsoid(0.1f));
    }

    public static void test1() {
        EllipsoidGlyphTest.show(new EightEllipsoidsInCube());
    }

    public static void test2() {
        EllipsoidGlyphTest.show(new RandomEllipsoidsOnGrid());
    }

    private static void show(Node node) {
        StateSet states = StateSet.forTwoSidedShinySurface(Color.CYAN);
        node.setStates(states);
        World world = new World();
        world.addChild(node);
        SimpleFrame sf = new SimpleFrame(world);
    }

    public static class RandomEllipsoidsOnGrid
    extends Node {
        private float[][] _cx;
        private float[][] _cy;
        private float[][] _cz;
        private float[][] _ux;
        private float[][] _uy;
        private float[][] _uz;
        private float[][] _vx;
        private float[][] _vy;
        private float[][] _vz;
        private float[][] _wx;
        private float[][] _wy;
        private float[][] _wz;
        private EllipsoidGlyph _ellipsoid;
        private BoundingSphere _bs;

        public RandomEllipsoidsOnGrid() {
            int ns = 4;
            int nt = 5;
            this._ux = new float[ns][nt];
            this._uy = new float[ns][nt];
            this._uz = new float[ns][nt];
            this._vx = new float[ns][nt];
            this._vy = new float[ns][nt];
            this._vz = new float[ns][nt];
            this._wx = new float[ns][nt];
            this._wy = new float[ns][nt];
            this._wz = new float[ns][nt];
            this._cx = new float[ns][nt];
            this._cy = new float[ns][nt];
            this._cz = new float[ns][nt];
            float ds = 0.5f / (float)ns;
            float dt = 0.5f / (float)nt;
            float dd = ArrayMath.min(ds, dt);
            for (int is = 0; is < ns; ++is) {
                for (int it = 0; it < nt; ++it) {
                    DMatrix matrix = new DMatrix(ArrayMath.sub(ArrayMath.randdouble(3, 3), 0.5));
                    matrix = matrix.transpose().times(matrix);
                    DMatrixEvd evd = new DMatrixEvd(matrix);
                    DMatrix ev = evd.getV();
                    float[] d = ArrayMath.mul(dd, ArrayMath.randfloat(3));
                    float du = d[0];
                    float dv = d[1];
                    float dw = d[2];
                    if (du < 0.01f) {
                        du = 0.001f;
                    }
                    if (dv < 0.01f) {
                        dv = 0.001f;
                    }
                    if (dw < 0.01f) {
                        dw = 0.001f;
                    }
                    this._ux[is][it] = (float)ev.get(0, 0) * du;
                    this._uy[is][it] = (float)ev.get(1, 0) * du;
                    this._uz[is][it] = (float)ev.get(2, 0) * du * 0.5f;
                    this._vx[is][it] = (float)ev.get(0, 1) * dv;
                    this._vy[is][it] = (float)ev.get(1, 1) * dv;
                    this._vz[is][it] = (float)ev.get(2, 1) * dv * 0.5f;
                    this._wx[is][it] = (float)ev.get(0, 2) * dw;
                    this._wy[is][it] = (float)ev.get(1, 2) * dw;
                    this._wz[is][it] = (float)ev.get(2, 2) * dw * 0.5f;
                    this._cx[is][it] = (float)(1 + 2 * is) * ds;
                    this._cy[is][it] = 0.5f;
                    this._cz[is][it] = (float)(1 + 2 * it) * dt;
                }
            }
            this._ellipsoid = new EllipsoidGlyph();
            this._bs = new BoundingSphere(new BoundingBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }

        @Override
        public void draw(DrawContext dc) {
            int ns = this._cx.length;
            int nt = this._cx[0].length;
            for (int is = 0; is < ns; ++is) {
                for (int it = 0; it < nt; ++it) {
                    this._ellipsoid.draw(this._cx[is][it], this._cy[is][it], this._cz[is][it], this._ux[is][it], this._uy[is][it], this._uz[is][it], this._vx[is][it], this._vy[is][it], this._vz[is][it], this._wx[is][it], this._wy[is][it], this._wz[is][it]);
                }
            }
        }

        @Override
        public BoundingSphere computeBoundingSphere(boolean finite) {
            return this._bs;
        }
    }

    public static class EightEllipsoidsInCube
    extends Node {
        private EllipsoidGlyph _ellipsoid = new EllipsoidGlyph();
        private BoundingSphere _bs = new BoundingSphere(new BoundingBox(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0));

        @Override
        public void draw(DrawContext dc) {
            float cx = 0.5f;
            float cy = 0.5f;
            float cz = 0.5f;
            float ux = 0.5f;
            float uy = 0.0f;
            float uz = 0.0f;
            float vx = 0.0f;
            float vy = 0.1f;
            float vz = 0.0f;
            float wx = 0.0f;
            float wy = 0.0f;
            float wz = 0.5f;
            this._ellipsoid.draw(-cx, cy, -cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
            this._ellipsoid.draw(cx, cy, -cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
            this._ellipsoid.draw(-cx, -cy, -cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
            this._ellipsoid.draw(cx, -cy, -cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
            this._ellipsoid.draw(-cx, cy, cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
            this._ellipsoid.draw(cx, cy, cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
            this._ellipsoid.draw(-cx, -cy, cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
            this._ellipsoid.draw(cx, -cy, cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
        }

        @Override
        public BoundingSphere computeBoundingSphere(boolean finite) {
            return this._bs;
        }
    }

    public static class OneEllipsoid
    extends Node {
        private float _thickness;
        private EllipsoidGlyph _ellipsoid = new EllipsoidGlyph();
        private BoundingSphere _bs = new BoundingSphere(new BoundingBox(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0));

        public OneEllipsoid(float thickness) {
            this._thickness = thickness;
        }

        @Override
        public void draw(DrawContext dc) {
            float cx = 0.0f;
            float cy = 0.0f;
            float cz = 0.0f;
            float ux = 0.0f;
            float uy = 0.0f;
            float uz = this._thickness;
            float vx = 0.0f;
            float vy = 1.0f;
            float vz = 0.0f;
            float wx = 1.0f;
            float wy = 0.0f;
            float wz = 0.0f;
            this._ellipsoid.draw(cx, cy, cz, ux, uy, uz, vx, vy, vz, wx, wy, wz);
        }

        @Override
        public BoundingSphere computeBoundingSphere(boolean finite) {
            return this._bs;
        }
    }
}

