/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.nfunk.jep.JEP;

public class Evaluator
extends Applet {
    private static final long serialVersionUID = 4592714713689369505L;
    private JEP myParser;
    private double xValue;
    private TextField exprField;
    private TextField xField;
    private TextArea errorTextArea;
    private Label resultLabel;
    private Checkbox implicitCheckbox;
    private Checkbox undeclaredCheckbox;

    public static void main(String[] args) {
        Evaluator a = new Evaluator();
        a.init();
        a.start();
        Frame f = new Frame("Evaluator");
        f.add("Center", a);
        f.setSize(400, 200);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
    }

    @Override
    public void init() {
        this.xValue = 10.0;
        this.addGUIComponents();
        this.myParser = new JEP();
        this.myParser.initFunTab();
        this.myParser.addStandardFunctions();
        this.myParser.setTraverse(true);
        this.optionsChanged();
    }

    private void addGUIComponents() {
        this.setBackground(Color.white);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 2;
        c.weightx = 0.0;
        Label exprFieldp = new Label("Expression: ", 2);
        gridbag.setConstraints(exprFieldp, c);
        this.add(exprFieldp);
        c.weightx = 0.8;
        this.exprField = new TextField(27);
        gridbag.setConstraints(this.exprField, c);
        this.add(this.exprField);
        c.weightx = 0.0;
        Label xFieldp = new Label("x: ", 2);
        gridbag.setConstraints(xFieldp, c);
        this.add(xFieldp);
        c.weightx = 0.2;
        c.gridwidth = 0;
        this.xField = new TextField("" + this.xValue, 4);
        gridbag.setConstraints(this.xField, c);
        this.add(this.xField);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label resultLabelText = new Label("Result: ", 2);
        gridbag.setConstraints(resultLabelText, c);
        this.add(resultLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.resultLabel = new Label("", 0);
        gridbag.setConstraints(this.resultLabel, c);
        this.add(this.resultLabel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label optionsLabelText = new Label("Options: ", 2);
        gridbag.setConstraints(optionsLabelText, c);
        this.add(optionsLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.implicitCheckbox = new Checkbox("Implicit multiplication", true);
        gridbag.setConstraints(this.implicitCheckbox, c);
        this.add(this.implicitCheckbox);
        c.weightx = 0.0;
        c.gridwidth = 1;
        Label spaceLabelText = new Label(" ", 2);
        gridbag.setConstraints(spaceLabelText, c);
        this.add(spaceLabelText);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.undeclaredCheckbox = new Checkbox("Allow undeclared identifiers");
        gridbag.setConstraints(this.undeclaredCheckbox, c);
        this.add(this.undeclaredCheckbox);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 11;
        Label errorLabel = new Label("Errors: ", 2);
        gridbag.setConstraints(errorLabel, c);
        this.add(errorLabel);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.errorTextArea = new TextArea("");
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setBackground(Color.white);
        gridbag.setConstraints(this.errorTextArea, c);
        this.add(this.errorTextArea);
        this.exprField.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent evt) {
                Evaluator.this.exprFieldTextValueChanged();
            }
        });
        this.xField.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent evt) {
                Evaluator.this.xFieldTextValueChanged();
            }
        });
        this.implicitCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Evaluator.this.optionsChanged();
            }
        });
        this.undeclaredCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Evaluator.this.optionsChanged();
            }
        });
    }

    private void parseExpression() {
        this.myParser.initSymTab();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("x", this.xValue);
        this.myParser.parseExpression(this.exprField.getText());
    }

    private void exprFieldTextValueChanged() {
        this.parseExpression();
        this.updateResult();
    }

    private void xFieldTextValueChanged() {
        try {
            this.xValue = Double.valueOf(this.xField.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid format in xField");
            this.xValue = 0.0;
        }
        this.myParser.addVariable("x", this.xValue);
        this.updateResult();
    }

    private void optionsChanged() {
        this.myParser.setImplicitMul(this.implicitCheckbox.getState());
        this.myParser.setAllowUndeclared(this.undeclaredCheckbox.getState());
        this.parseExpression();
        this.updateResult();
    }

    private void updateResult() {
        Object result = this.myParser.getValueAsObject();
        if (result != null) {
            this.resultLabel.setText(result.toString());
        } else {
            this.resultLabel.setText("");
        }
        String errorInfo = this.myParser.getErrorInfo();
        if (errorInfo != null) {
            this.errorTextArea.setText(errorInfo);
        } else {
            this.errorTextArea.setText("");
        }
    }
}

