/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.BSplineModel;
import bunwarpj.CumulativeQueue;
import bunwarpj.MainDialog;
import bunwarpj.Mask;
import bunwarpj.MathTools;
import bunwarpj.MiscTools;
import bunwarpj.PointHandler;
import bunwarpj.ProgressBar;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.SaveDialog;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;

public class Transformation {
    private final double FLT_EPSILON = Float.intBitsToFloat(0x33FFFFFF);
    private final boolean PYRAMID = true;
    private final boolean ORIGINAL = false;
    private final int transformationSplineDegree = 3;
    private ImagePlus output_ip_1;
    private ImagePlus output_ip_2;
    private MainDialog dialog;
    private ImagePlus sourceImp;
    private ImagePlus targetImp;
    private BSplineModel source;
    private BSplineModel target;
    private ImageProcessor originalSourceIP;
    private ImageProcessor originalTargetIP;
    private PointHandler sourcePh;
    private PointHandler targetPh;
    private Mask sourceMsk;
    private Mask targetMsk;
    private double[][] sourceAffineMatrix = null;
    private double[][] targetAffineMatrix = null;
    private double tweakShear = 0.0;
    private double tweakScale = 0.0;
    private double tweakIso = 0.0;
    private int sourceHeight;
    private int sourceWidth;
    private int targetHeight;
    private int targetWidth;
    private int targetCurrentHeight;
    private int targetCurrentWidth;
    private int sourceCurrentHeight;
    private int sourceCurrentWidth;
    private double targetFactorHeight;
    private double targetFactorWidth;
    private double sourceFactorHeight;
    private double sourceFactorWidth;
    private double partialDirectSimilarityError;
    private double partialDirectRegularizationError;
    private double partialDirectLandmarkError;
    private double partialDirectConsitencyError;
    private double finalDirectSimilarityError;
    private double finalDirectRegularizationError;
    private double finalDirectLandmarkError;
    private double finalDirectConsistencyError;
    private double partialInverseSimilarityError;
    private double partialInverseRegularizationError;
    private double partialInverseLandmarkError;
    private double partialInverseConsitencyError;
    private double finalInverseSimilarityError;
    private double finalInverseRegularizationError;
    private double finalInverseLandmarkError;
    private double finalInverseConsistencyError;
    private int min_scale_deformation;
    private int max_scale_deformation;
    private int min_scale_image;
    private int outputLevel;
    private boolean showMarquardtOptim;
    private double divWeight;
    private double curlWeight;
    private double landmarkWeight;
    private double imageWeight;
    private double consistencyWeight;
    private double stopThreshold;
    private int accurate_mode;
    private String fn_tnf_1;
    private String fn_tnf_2;
    private int intervals;
    private double[][] cxSourceToTarget = null;
    private double[][] cySourceToTarget = null;
    private double[][] cxTargetToSource = null;
    private double[][] cyTargetToSource = null;
    private BSplineModel swxSourceToTarget = null;
    private BSplineModel swySourceToTarget = null;
    private BSplineModel swxTargetToSource = null;
    private BSplineModel swyTargetToSource = null;
    private double[][] P11_SourceToTarget;
    private double[][] P22_SourceToTarget;
    private double[][] P12_SourceToTarget;
    private double[][] P11_TargetToSource;
    private double[][] P22_TargetToSource;
    private double[][] P12_TargetToSource;

    public Transformation(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel source, BSplineModel target, PointHandler sourcePh, PointHandler targetPh, Mask sourceMsk, Mask targetMsk, double[][] sourceAffineMatrix, double[][] targetAffineMatrix, int min_scale_deformation, int max_scale_deformation, int min_scale_image, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, int outputLevel, boolean showMarquardtOptim, int accurate_mode, String fn_tnf_1, String fn_tnf_2, ImagePlus output_ip_1, ImagePlus output_ip_2, MainDialog dialog) {
        this.sourceImp = sourceImp;
        this.targetImp = targetImp;
        this.source = source;
        this.target = target;
        this.sourcePh = sourcePh;
        this.targetPh = targetPh;
        this.sourceMsk = sourceMsk;
        this.targetMsk = targetMsk;
        this.sourceAffineMatrix = sourceAffineMatrix;
        this.targetAffineMatrix = targetAffineMatrix;
        this.min_scale_deformation = min_scale_deformation;
        this.max_scale_deformation = max_scale_deformation;
        this.min_scale_image = min_scale_image;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
        this.outputLevel = outputLevel;
        this.showMarquardtOptim = showMarquardtOptim;
        this.accurate_mode = accurate_mode;
        this.fn_tnf_1 = fn_tnf_1;
        this.fn_tnf_2 = fn_tnf_2;
        this.output_ip_1 = output_ip_1;
        this.output_ip_2 = output_ip_2;
        this.dialog = dialog;
        this.originalSourceIP = this.dialog.getOriginalSourceIP();
        this.originalTargetIP = this.dialog.getOriginalTargetIP();
        this.sourceWidth = source.getWidth();
        this.sourceHeight = source.getHeight();
        this.targetWidth = target.getWidth();
        this.targetHeight = target.getHeight();
    }

    public Transformation(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel source, BSplineModel target, PointHandler sourcePh, PointHandler targetPh, Mask sourceMsk, Mask targetMsk, double[][] sourceAffineMatrix, double[][] targetAffineMatrix, int min_scale_deformation, int max_scale_deformation, int min_scale_image, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, int outputLevel, boolean showMarquardtOptim, int accurate_mode, String fn_tnf_1, String fn_tnf_2, ImagePlus output_ip_1, ImagePlus output_ip_2, MainDialog dialog, ImageProcessor originalSourceIP, ImageProcessor originalTargetIP) {
        this.sourceImp = sourceImp;
        this.targetImp = targetImp;
        this.source = source;
        this.target = target;
        this.sourcePh = sourcePh;
        this.targetPh = targetPh;
        this.sourceMsk = sourceMsk;
        this.targetMsk = targetMsk;
        this.sourceAffineMatrix = sourceAffineMatrix;
        this.targetAffineMatrix = targetAffineMatrix;
        this.min_scale_deformation = min_scale_deformation;
        this.max_scale_deformation = max_scale_deformation;
        this.min_scale_image = min_scale_image;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
        this.outputLevel = outputLevel;
        this.showMarquardtOptim = showMarquardtOptim;
        this.accurate_mode = accurate_mode;
        this.fn_tnf_1 = fn_tnf_1;
        this.fn_tnf_2 = fn_tnf_2;
        this.output_ip_1 = output_ip_1;
        this.output_ip_2 = output_ip_2;
        this.dialog = dialog;
        this.originalSourceIP = originalSourceIP;
        this.originalTargetIP = originalTargetIP;
        this.sourceWidth = source.getWidth();
        this.sourceHeight = source.getHeight();
        this.targetWidth = target.getWidth();
        this.targetHeight = target.getHeight();
    }

    public void doBidirectionalRegistration() {
        this.source.popFromPyramid();
        this.target.popFromPyramid();
        int sizeCorrectionFactor = 0;
        this.targetCurrentHeight = this.target.getCurrentHeight();
        this.targetCurrentWidth = this.target.getCurrentWidth();
        this.targetFactorHeight = this.target.getFactorHeight();
        this.targetFactorWidth = this.target.getFactorWidth();
        this.sourceCurrentHeight = this.source.getCurrentHeight();
        this.sourceCurrentWidth = this.source.getCurrentWidth();
        this.sourceFactorHeight = this.source.getFactorHeight();
        this.sourceFactorWidth = this.source.getFactorWidth();
        this.intervals = (int)Math.pow(2.0, this.min_scale_deformation + sizeCorrectionFactor);
        this.cxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.cyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.buildRegularizationTemporary(this.intervals, false);
        this.buildRegularizationTemporary(this.intervals, true);
        int K = this.targetPh != null ? this.targetPh.getPoints().size() : 0;
        double[] dxTargetToSource = new double[K];
        double[] dyTargetToSource = new double[K];
        this.computeInitialResidues(dxTargetToSource, dyTargetToSource, false);
        this.computeInitialResidues(dxTargetToSource, dyTargetToSource, false);
        double[][] affineMatrix = null;
        if (this.sourceAffineMatrix != null) {
            affineMatrix = this.sourceAffineMatrix;
            double[] dArray = affineMatrix[0];
            dArray[2] = dArray[2] * this.sourceFactorWidth;
            double[] dArray2 = affineMatrix[1];
            dArray2[2] = dArray2[2] * this.sourceFactorHeight;
        } else {
            affineMatrix = this.computeAffineMatrix(false);
        }
        for (int i = 0; i < this.intervals + 3; ++i) {
            double v = (double)((i - 1) * (this.targetCurrentHeight - 1)) / (double)this.intervals;
            double xv = affineMatrix[0][2] + affineMatrix[0][1] * v;
            double yv = affineMatrix[1][2] + affineMatrix[1][1] * v;
            for (int j = 0; j < this.intervals + 3; ++j) {
                double u = (double)((j - 1) * (this.targetCurrentWidth - 1)) / (double)this.intervals;
                this.cxTargetToSource[i][j] = xv + affineMatrix[0][0] * u;
                this.cyTargetToSource[i][j] = yv + affineMatrix[1][0] * u;
            }
        }
        int K2 = this.sourcePh != null ? this.sourcePh.getPoints().size() : 0;
        double[] dxSourceToTarget = new double[K2];
        double[] dySourceToTarget = new double[K2];
        this.computeInitialResidues(dxSourceToTarget, dySourceToTarget, true);
        this.computeInitialResidues(dxSourceToTarget, dySourceToTarget, true);
        this.cxSourceToTarget = new double[this.intervals + 3][this.intervals + 3];
        this.cySourceToTarget = new double[this.intervals + 3][this.intervals + 3];
        if (this.targetAffineMatrix != null) {
            affineMatrix = this.targetAffineMatrix;
            double[] dArray = affineMatrix[0];
            dArray[2] = dArray[2] * this.targetFactorWidth;
            double[] dArray3 = affineMatrix[1];
            dArray3[2] = dArray3[2] * this.targetFactorHeight;
        } else {
            affineMatrix = this.computeAffineMatrix(true);
        }
        for (int i = 0; i < this.intervals + 3; ++i) {
            double v = (double)((i - 1) * (this.sourceCurrentHeight - 1)) / (double)this.intervals;
            double xv = affineMatrix[0][2] + affineMatrix[0][1] * v;
            double yv = affineMatrix[1][2] + affineMatrix[1][1] * v;
            for (int j = 0; j < this.intervals + 3; ++j) {
                double u = (double)((j - 1) * (this.sourceCurrentWidth - 1)) / (double)this.intervals;
                this.cxSourceToTarget[i][j] = xv + affineMatrix[0][0] * u;
                this.cySourceToTarget[i][j] = yv + affineMatrix[1][0] * u;
            }
        }
        int state = this.min_scale_deformation == this.max_scale_deformation ? 1 : 0;
        int s = this.min_scale_deformation;
        int step = 0;
        this.computeTotalWorkload();
        while (state != -1) {
            int currentDepth = this.target.getCurrentDepth();
            if (state == 0 || state == 1) {
                if (s >= this.min_scale_deformation) {
                    int j;
                    int i;
                    this.intervals = (int)Math.pow(2.0, s + sizeCorrectionFactor);
                    double[][] newcxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcxSourceToTarget = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcySourceToTarget = new double[this.intervals + 3][this.intervals + 3];
                    boolean underconstrained = true;
                    underconstrained = this.divWeight == 0.0 && this.curlWeight == 0.0 ? this.computeCoefficientsScale(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false) : this.computeCoefficientsScaleWithRegularization(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false);
                    if (!underconstrained || step == 0 && this.landmarkWeight != 0.0) {
                        for (i = 0; i < this.intervals + 3; ++i) {
                            for (j = 0; j < this.intervals + 3; ++j) {
                                double[] dArray = this.cxTargetToSource[i];
                                int n = j;
                                dArray[n] = dArray[n] + newcxTargetToSource[i][j];
                                double[] dArray4 = this.cyTargetToSource[i];
                                int n2 = j;
                                dArray4[n2] = dArray4[n2] + newcyTargetToSource[i][j];
                            }
                        }
                    }
                    underconstrained = true;
                    underconstrained = this.divWeight == 0.0 && this.curlWeight == 0.0 ? this.computeCoefficientsScale(this.intervals, dxSourceToTarget, dySourceToTarget, newcxSourceToTarget, newcySourceToTarget, true) : this.computeCoefficientsScaleWithRegularization(this.intervals, dxSourceToTarget, dySourceToTarget, newcxSourceToTarget, newcySourceToTarget, true);
                    if (!underconstrained || step == 0 && this.landmarkWeight != 0.0) {
                        for (i = 0; i < this.intervals + 3; ++i) {
                            for (j = 0; j < this.intervals + 3; ++j) {
                                double[] dArray = this.cxSourceToTarget[i];
                                int n = j;
                                dArray[n] = dArray[n] + newcxSourceToTarget[i][j];
                                double[] dArray5 = this.cySourceToTarget[i];
                                int n3 = j;
                                dArray5[n3] = dArray5[n3] + newcySourceToTarget[i][j];
                            }
                        }
                    }
                }
                this.optimizeCoeffs(this.intervals, this.stopThreshold, this.cxTargetToSource, this.cyTargetToSource, this.cxSourceToTarget, this.cySourceToTarget);
            }
            ++step;
            switch (state) {
                case 0: {
                    if (s < this.max_scale_deformation) {
                        this.cxTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cxTargetToSource, 1.0);
                        this.cyTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cyTargetToSource, 1.0);
                        this.cxSourceToTarget = this.propagateCoeffsToNextLevel(this.intervals, this.cxSourceToTarget, 1.0);
                        this.cySourceToTarget = this.propagateCoeffsToNextLevel(this.intervals, this.cySourceToTarget, 1.0);
                        ++s;
                        this.intervals *= 2;
                        this.buildRegularizationTemporary(this.intervals, false);
                        this.buildRegularizationTemporary(this.intervals, true);
                        if (currentDepth > this.min_scale_image) {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    if (currentDepth > this.min_scale_image) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (state == 1) {
                        state = s == this.max_scale_deformation && currentDepth == this.min_scale_image ? 2 : (s == this.max_scale_deformation ? 1 : 0);
                    } else if (state == 2) {
                        state = currentDepth == 0 ? -1 : 2;
                    }
                    if (currentDepth == 0) break;
                    double oldTargetCurrentHeight = this.targetCurrentHeight;
                    double oldTargetCurrentWidth = this.targetCurrentWidth;
                    double oldSourceCurrentHeight = this.sourceCurrentHeight;
                    double oldSourceCurrentWidth = this.sourceCurrentWidth;
                    this.source.popFromPyramid();
                    this.target.popFromPyramid();
                    this.targetCurrentHeight = this.target.getCurrentHeight();
                    this.targetCurrentWidth = this.target.getCurrentWidth();
                    this.targetFactorHeight = this.target.getFactorHeight();
                    this.targetFactorWidth = this.target.getFactorWidth();
                    this.sourceCurrentHeight = this.source.getCurrentHeight();
                    this.sourceCurrentWidth = this.source.getCurrentWidth();
                    this.sourceFactorHeight = this.source.getFactorHeight();
                    this.sourceFactorWidth = this.source.getFactorWidth();
                    double targetFactorY = (double)(this.targetCurrentHeight - 1) / (oldTargetCurrentHeight - 1.0);
                    double targetFactorX = (double)(this.targetCurrentWidth - 1) / (oldTargetCurrentWidth - 1.0);
                    double sourceFactorY = (double)(this.sourceCurrentHeight - 1) / (oldSourceCurrentHeight - 1.0);
                    double sourceFactorX = (double)(this.sourceCurrentWidth - 1) / (oldSourceCurrentWidth - 1.0);
                    for (int i = 0; i < this.intervals + 3; ++i) {
                        int j = 0;
                        while (j < this.intervals + 3) {
                            double[] dArray = this.cxTargetToSource[i];
                            int n = j;
                            dArray[n] = dArray[n] * targetFactorX;
                            double[] dArray6 = this.cyTargetToSource[i];
                            int n4 = j;
                            dArray6[n4] = dArray6[n4] * targetFactorY;
                            double[] dArray7 = this.cxSourceToTarget[i];
                            int n5 = j;
                            dArray7[n5] = dArray7[n5] * sourceFactorX;
                            double[] dArray8 = this.cySourceToTarget[i];
                            int n6 = j++;
                            dArray8[n6] = dArray8[n6] * sourceFactorY;
                        }
                    }
                    this.buildRegularizationTemporary(this.intervals, false);
                    this.buildRegularizationTemporary(this.intervals, true);
                }
            }
            if (state != 0 && state != 1 || s != this.max_scale_deformation || currentDepth != this.min_scale_image + 1 || this.accurate_mode != 1) continue;
            this.stopThreshold /= 10.0;
        }
        if (this.source.getOriginalImageWidth() > this.sourceCurrentWidth) {
            if (this.source.isSubOutput() || this.target.isSubOutput()) {
                IJ.log((String)("Adapting coefficients from " + this.sourceCurrentWidth + " to " + this.source.getOriginalImageWidth() + "..."));
            }
            double targetFactorY = (this.target.getOriginalImageHeight() - 1) / (this.targetCurrentHeight - 1);
            double targetFactorX = (this.target.getOriginalImageWidth() - 1) / (this.targetCurrentWidth - 1);
            double sourceFactorY = (this.source.getOriginalImageHeight() - 1) / (this.sourceCurrentHeight - 1);
            double sourceFactorX = (this.source.getOriginalImageWidth() - 1) / (this.sourceCurrentWidth - 1);
            for (int i = 0; i < this.intervals + 3; ++i) {
                int j = 0;
                while (j < this.intervals + 3) {
                    double[] dArray = this.cxTargetToSource[i];
                    int n = j;
                    dArray[n] = dArray[n] * targetFactorX;
                    double[] dArray9 = this.cyTargetToSource[i];
                    int n7 = j;
                    dArray9[n7] = dArray9[n7] * targetFactorY;
                    double[] dArray10 = this.cxSourceToTarget[i];
                    int n8 = j;
                    dArray10[n8] = dArray10[n8] * sourceFactorX;
                    double[] dArray11 = this.cySourceToTarget[i];
                    int n9 = j++;
                    dArray11[n9] = dArray11[n9] * sourceFactorY;
                }
            }
            this.targetCurrentHeight = this.target.getOriginalImageHeight();
            this.targetCurrentWidth = this.target.getOriginalImageWidth();
            this.sourceCurrentHeight = this.source.getOriginalImageHeight();
            this.sourceCurrentWidth = this.source.getOriginalImageWidth();
        }
        if (this.outputLevel == 2) {
            if (this.imageWeight != 0.0) {
                IJ.log((String)(" Optimal direct similarity error = " + this.finalDirectSimilarityError));
                IJ.log((String)(" Optimal inverse similarity error = " + this.finalInverseSimilarityError));
            }
            if (this.curlWeight != 0.0 || this.divWeight != 0.0) {
                IJ.log((String)(" Optimal direct regularization error = " + this.finalDirectRegularizationError));
                IJ.log((String)(" Optimal inverse regularization error = " + this.finalInverseRegularizationError));
            }
            if (this.landmarkWeight != 0.0) {
                IJ.log((String)(" Optimal direct landmark error = " + this.finalDirectLandmarkError));
                IJ.log((String)(" Optimal inverse landmark error = " + this.finalInverseLandmarkError));
            }
            if (this.consistencyWeight != 0.0) {
                IJ.log((String)(" Optimal direct consistency error = " + this.finalDirectConsistencyError));
                IJ.log((String)(" Optimal inverse consistency error = " + this.finalInverseConsistencyError));
            }
        }
    }

    public void doUnidirectionalRegistration() {
        int i;
        this.source.popFromPyramid();
        this.target.popFromPyramid();
        this.targetCurrentHeight = this.target.getCurrentHeight();
        this.targetCurrentWidth = this.target.getCurrentWidth();
        this.targetFactorHeight = this.target.getFactorHeight();
        this.targetFactorWidth = this.target.getFactorWidth();
        this.sourceCurrentHeight = this.source.getCurrentHeight();
        this.sourceCurrentWidth = this.source.getCurrentWidth();
        this.sourceFactorHeight = this.source.getFactorHeight();
        this.sourceFactorWidth = this.source.getFactorWidth();
        int sizeCorrectionFactor = 0;
        this.intervals = (int)Math.pow(2.0, this.min_scale_deformation + sizeCorrectionFactor);
        this.cxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.cyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.buildRegularizationTemporary(this.intervals, false);
        int K = this.targetPh != null ? this.targetPh.getPoints().size() : 0;
        double[] dxTargetToSource = new double[K];
        double[] dyTargetToSource = new double[K];
        this.computeInitialResidues(dxTargetToSource, dyTargetToSource, false);
        double[][] affineMatrix = null;
        if (this.sourceAffineMatrix != null) {
            affineMatrix = this.sourceAffineMatrix;
            double[] dArray = affineMatrix[0];
            dArray[2] = dArray[2] * this.sourceFactorWidth;
            double[] dArray2 = affineMatrix[1];
            dArray2[2] = dArray2[2] * this.sourceFactorHeight;
        } else {
            affineMatrix = this.computeAffineMatrix(false);
        }
        for (int i2 = 0; i2 < this.intervals + 3; ++i2) {
            double v = (double)((i2 - 1) * (this.targetCurrentHeight - 1)) / (double)this.intervals;
            double xv = affineMatrix[0][2] + affineMatrix[0][1] * v;
            double yv = affineMatrix[1][2] + affineMatrix[1][1] * v;
            for (int j = 0; j < this.intervals + 3; ++j) {
                double u = (double)((j - 1) * (this.targetCurrentWidth - 1)) / (double)this.intervals;
                this.cxTargetToSource[i2][j] = xv + affineMatrix[0][0] * u;
                this.cyTargetToSource[i2][j] = yv + affineMatrix[1][0] * u;
            }
        }
        int state = this.min_scale_deformation == this.max_scale_deformation ? 1 : 0;
        int s = this.min_scale_deformation;
        int step = 0;
        this.computeTotalWorkload();
        while (state != -1) {
            int currentDepth = this.target.getCurrentDepth();
            if (state == 0 || state == 1) {
                if (s >= this.min_scale_deformation) {
                    this.intervals = (int)Math.pow(2.0, s + sizeCorrectionFactor);
                    double[][] newcxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    boolean underconstrained = true;
                    underconstrained = this.divWeight == 0.0 && this.curlWeight == 0.0 ? this.computeCoefficientsScale(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false) : this.computeCoefficientsScaleWithRegularization(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false);
                    if (!underconstrained || step == 0 && this.landmarkWeight != 0.0) {
                        for (i = 0; i < this.intervals + 3; ++i) {
                            for (int j = 0; j < this.intervals + 3; ++j) {
                                double[] dArray = this.cxTargetToSource[i];
                                int n = j;
                                dArray[n] = dArray[n] + newcxTargetToSource[i][j];
                                double[] dArray3 = this.cyTargetToSource[i];
                                int n2 = j;
                                dArray3[n2] = dArray3[n2] + newcyTargetToSource[i][j];
                            }
                        }
                    }
                }
                this.optimizeCoeffs(this.intervals, this.stopThreshold, this.cxTargetToSource, this.cyTargetToSource);
            }
            ++step;
            switch (state) {
                case 0: {
                    if (s < this.max_scale_deformation) {
                        this.cxTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cxTargetToSource, 1.0);
                        this.cyTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cyTargetToSource, 1.0);
                        ++s;
                        this.intervals *= 2;
                        this.buildRegularizationTemporary(this.intervals, false);
                        if (currentDepth > this.min_scale_image) {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    if (currentDepth > this.min_scale_image) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (state == 1) {
                        state = s == this.max_scale_deformation && currentDepth == this.min_scale_image ? 2 : (s == this.max_scale_deformation ? 1 : 0);
                    } else if (state == 2) {
                        state = currentDepth == 0 ? -1 : 2;
                    }
                    if (currentDepth == 0) break;
                    double oldTargetCurrentHeight = this.targetCurrentHeight;
                    double oldTargetCurrentWidth = this.targetCurrentWidth;
                    this.source.popFromPyramid();
                    this.target.popFromPyramid();
                    this.targetCurrentHeight = this.target.getCurrentHeight();
                    this.targetCurrentWidth = this.target.getCurrentWidth();
                    this.targetFactorHeight = this.target.getFactorHeight();
                    this.targetFactorWidth = this.target.getFactorWidth();
                    this.sourceCurrentHeight = this.source.getCurrentHeight();
                    this.sourceCurrentWidth = this.source.getCurrentWidth();
                    this.sourceFactorHeight = this.source.getFactorHeight();
                    this.sourceFactorWidth = this.source.getFactorWidth();
                    double targetFactorY = (double)(this.targetCurrentHeight - 1) / (oldTargetCurrentHeight - 1.0);
                    double targetFactorX = (double)(this.targetCurrentWidth - 1) / (oldTargetCurrentWidth - 1.0);
                    for (int i3 = 0; i3 < this.intervals + 3; ++i3) {
                        int j = 0;
                        while (j < this.intervals + 3) {
                            double[] dArray = this.cxTargetToSource[i3];
                            int n = j;
                            dArray[n] = dArray[n] * targetFactorX;
                            double[] dArray4 = this.cyTargetToSource[i3];
                            int n3 = j++;
                            dArray4[n3] = dArray4[n3] * targetFactorY;
                        }
                    }
                    this.buildRegularizationTemporary(this.intervals, false);
                }
            }
            if (state != 0 && state != 1 || s != this.max_scale_deformation || currentDepth != this.min_scale_image + 1 || this.accurate_mode != 1) continue;
            this.stopThreshold /= 10.0;
        }
        if (this.source.getOriginalImageWidth() > this.targetCurrentWidth) {
            if (this.source.isSubOutput() || this.target.isSubOutput()) {
                IJ.log((String)("Adapting coefficients from " + this.sourceCurrentWidth + " to " + this.originalSourceIP.getWidth() + "..."));
            }
            double targetFactorY = (this.target.getOriginalImageHeight() - 1) / (this.targetCurrentHeight - 1);
            double targetFactorX = (this.target.getOriginalImageWidth() - 1) / (this.targetCurrentWidth - 1);
            for (i = 0; i < this.intervals + 3; ++i) {
                int j = 0;
                while (j < this.intervals + 3) {
                    double[] dArray = this.cxTargetToSource[i];
                    int n = j;
                    dArray[n] = dArray[n] * targetFactorX;
                    double[] dArray5 = this.cyTargetToSource[i];
                    int n4 = j++;
                    dArray5[n4] = dArray5[n4] * targetFactorY;
                }
            }
            this.targetCurrentHeight = this.target.getOriginalImageHeight();
            this.targetCurrentWidth = this.target.getOriginalImageWidth();
            this.sourceCurrentHeight = this.source.getOriginalImageHeight();
            this.sourceCurrentWidth = this.source.getOriginalImageWidth();
        }
        if (this.outputLevel == 2) {
            if (this.imageWeight != 0.0) {
                IJ.log((String)(" Optimal direct similarity error = " + this.finalDirectSimilarityError));
            }
            if (this.curlWeight != 0.0 || this.divWeight != 0.0) {
                IJ.log((String)(" Optimal direct regularization error = " + this.finalDirectRegularizationError));
            }
            if (this.landmarkWeight != 0.0) {
                IJ.log((String)(" Optimal direct landmark error = " + this.finalDirectLandmarkError));
            }
            if (this.consistencyWeight != 0.0) {
                IJ.log((String)(" Optimal direct consistency error = " + this.finalDirectConsistencyError));
            }
        }
    }

    public double evaluateImageSimilarity(boolean bIsReverse) {
        int int3 = this.intervals + 3;
        int halfM = int3 * int3;
        int M = halfM * 2;
        double[] x = new double[M];
        double[] grad = new double[M];
        BSplineModel auxTarget = this.target;
        BSplineModel swx = this.swxTargetToSource;
        BSplineModel swy = this.swyTargetToSource;
        double[][] cx = this.cxTargetToSource;
        double[][] cy = this.cyTargetToSource;
        if (bIsReverse) {
            auxTarget = this.source;
            swx = this.swxSourceToTarget;
            swy = this.swySourceToTarget;
            cx = this.cxSourceToTarget;
            cy = this.cySourceToTarget;
        }
        int p = 0;
        for (int i = 0; i < this.intervals + 3; ++i) {
            int j = 0;
            while (j < this.intervals + 3) {
                x[p] = cx[i][j];
                x[halfM + p] = cy[i][j];
                ++j;
                ++p;
            }
        }
        if (swx == null) {
            swx = new BSplineModel(cx);
            swy = new BSplineModel(cy);
            swx.precomputed_prepareForInterpolation(auxTarget.getCurrentHeight(), auxTarget.getCurrentWidth(), this.intervals);
            swy.precomputed_prepareForInterpolation(auxTarget.getCurrentHeight(), auxTarget.getCurrentWidth(), this.intervals);
        }
        if (swx.precomputed_getWidth() != auxTarget.getCurrentWidth()) {
            swx.precomputed_prepareForInterpolation(auxTarget.getCurrentHeight(), auxTarget.getCurrentWidth(), this.intervals);
            swy.precomputed_prepareForInterpolation(auxTarget.getCurrentHeight(), auxTarget.getCurrentWidth(), this.intervals);
        }
        double f2 = this.evaluateSimilarityMultiThread(x, this.intervals, grad, true, bIsReverse);
        return f2;
    }

    public void getDeformation(double[][] transformation_x, double[][] transformation_y, boolean bIsReverse) {
        double[][] cx = this.cxTargetToSource;
        double[][] cy = this.cyTargetToSource;
        if (bIsReverse) {
            cx = this.cxSourceToTarget;
            cy = this.cySourceToTarget;
        }
        this.computeDeformation(this.intervals, cx, cy, transformation_x, transformation_y, bIsReverse);
    }

    public double[][] getDirectDeformationCoefficientsX() {
        return this.cxTargetToSource;
    }

    public double[][] getDirectDeformationCoefficientsY() {
        return this.cyTargetToSource;
    }

    public double[][] getInverseDeformationCoefficientsX() {
        return this.cxSourceToTarget;
    }

    public double[][] getInverseDeformationCoefficientsY() {
        return this.cySourceToTarget;
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void transform(double u, double v, double[] xyF, boolean bIsReverse) {
        BSplineModel auxTarget = this.target;
        BSplineModel swx = this.swxTargetToSource;
        BSplineModel swy = this.swyTargetToSource;
        if (bIsReverse) {
            auxTarget = this.source;
            swx = this.swxSourceToTarget;
            swy = this.swySourceToTarget;
        }
        double samplingFactor = this.source.getSubsamplingFactor();
        double tu = u / samplingFactor * (double)this.intervals / (double)(auxTarget.getCurrentWidth() - 1) + 1.0;
        double tv = v / samplingFactor * (double)this.intervals / (double)(auxTarget.getCurrentHeight() - 1) + 1.0;
        boolean ORIGINAL = false;
        swx.prepareForInterpolation(tu, tv, false);
        xyF[0] = swx.interpolateI() * samplingFactor;
        swy.prepareForInterpolation(tu, tv, false);
        xyF[1] = swy.interpolateI() * samplingFactor;
    }

    private void build_Matrix_B(int intervals, int K, double[][] B, boolean bIsReverse) {
        PointHandler auxTargetPh = this.targetPh;
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        if (bIsReverse) {
            auxTargetPh = this.sourcePh;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
        }
        Vector<Point> targetVector = null;
        if (auxTargetPh != null) {
            targetVector = auxTargetPh.getPoints();
        }
        for (int k = 0; k < K; ++k) {
            Point targetPoint = targetVector.elementAt(k);
            double x = auxFactorWidth * (double)targetPoint.x;
            double y = auxFactorHeight * (double)targetPoint.y;
            double[] bx = this.xWeight(x, intervals, true, bIsReverse);
            double[] by = this.yWeight(y, intervals, true, bIsReverse);
            for (int i = 0; i < intervals + 3; ++i) {
                for (int j = 0; j < intervals + 3; ++j) {
                    B[k][(intervals + 3) * i + j] = by[i] * bx[j];
                }
            }
        }
    }

    private void build_Matrix_Rq1q2(int intervals, double weight, int q1, int q2, double[][] R, boolean bIsReverse) {
        this.build_Matrix_Rq1q2q3q4(intervals, weight, q1, q2, q1, q2, R, bIsReverse);
    }

    private void build_Matrix_Rq1q2q3q4(int intervals, double weight, int q1, int q2, int q3, int q4, double[][] R, boolean bIsReverse) {
        double[][] etaq1q3 = new double[16][16];
        int Ydim = this.target.getCurrentHeight();
        int Xdim = this.target.getCurrentWidth();
        if (bIsReverse) {
            Ydim = this.source.getCurrentHeight();
            Xdim = this.source.getCurrentWidth();
        }
        this.build_Matrix_R_geteta(etaq1q3, q1, q3, Xdim, intervals);
        double[][] etaq2q4 = null;
        if (q2 != q1 || q4 != q3 || Ydim != Xdim) {
            etaq2q4 = new double[16][16];
            this.build_Matrix_R_geteta(etaq2q4, q2, q4, Ydim, intervals);
        } else {
            etaq2q4 = etaq1q3;
        }
        int M = intervals + 1;
        int Mp = intervals + 3;
        for (int l = -1; l <= M; ++l) {
            for (int k = -1; k <= M; ++k) {
                for (int n = -1; n <= M; ++n) {
                    for (int m = -1; m <= M; ++m) {
                        int[] ip = new int[2];
                        int[] jp = new int[2];
                        boolean valid_i = this.build_Matrix_R_getetaindex(l, n, intervals, ip);
                        boolean valid_j = this.build_Matrix_R_getetaindex(k, m, intervals, jp);
                        if (!valid_i || !valid_j) continue;
                        int mn = (n + 1) * Mp + (m + 1);
                        int kl = (l + 1) * Mp + (k + 1);
                        double[] dArray = R[kl];
                        int n2 = mn;
                        dArray[n2] = dArray[n2] + weight * etaq1q3[jp[0]][jp[1]] * etaq2q4[ip[0]][ip[1]];
                    }
                }
            }
        }
    }

    private double build_Matrix_R_computeIntegral_aa(double x0, double xF, double s1, double s2, double h, int q1, int q2) {
        double[][] C = new double[3][3];
        int[][] d = new int[3][3];
        double[][] s = new double[3][3];
        C[0][0] = 1.0;
        C[0][1] = 0.0;
        C[0][2] = 0.0;
        C[1][0] = 1.0;
        C[1][1] = -1.0;
        C[1][2] = 0.0;
        C[2][0] = 1.0;
        C[2][1] = -2.0;
        C[2][2] = 1.0;
        d[0][0] = 3;
        d[0][1] = 0;
        d[0][2] = 0;
        d[1][0] = 2;
        d[1][1] = 2;
        d[1][2] = 0;
        d[2][0] = 1;
        d[2][1] = 1;
        d[2][2] = 1;
        s[0][0] = 0.0;
        s[0][1] = 0.0;
        s[0][2] = 0.0;
        s[1][0] = -0.5;
        s[1][1] = 0.5;
        s[1][2] = 0.0;
        s[2][0] = 1.0;
        s[2][1] = 0.0;
        s[2][2] = -1.0;
        double integral = 0.0;
        for (int k = 0; k < 3; ++k) {
            double ck = C[q1][k];
            if (ck == 0.0) continue;
            for (int l = 0; l < 3; ++l) {
                double cl = C[q2][l];
                if (cl == 0.0) continue;
                integral += ck * cl * this.build_matrix_R_computeIntegral_BB(x0, xF, s1 + s[q1][k], s2 + s[q2][l], h, d[q1][k], d[q2][l]);
            }
        }
        return integral;
    }

    private double build_matrix_R_computeIntegral_BB(double x0, double xF, double s1, double s2, double h, int n1, int n2) {
        int k;
        double xFp = xF / h;
        double x0p = x0 / h;
        double[] c1 = new double[n1 + 2];
        double fact_n1 = 1.0;
        for (int k2 = 2; k2 <= n1; ++k2) {
            fact_n1 *= (double)k2;
        }
        double sign = 1.0;
        int k3 = 0;
        while (k3 <= n1 + 1) {
            c1[k3] = sign * MathTools.nchoosek(n1 + 1, k3) / fact_n1;
            ++k3;
            sign *= -1.0;
        }
        double[] c2 = new double[n2 + 2];
        double fact_n2 = 1.0;
        for (k = 2; k <= n2; ++k) {
            fact_n2 *= (double)k;
        }
        sign = 1.0;
        k = 0;
        while (k <= n2 + 1) {
            c2[k] = sign * MathTools.nchoosek(n2 + 1, k) / fact_n2;
            ++k;
            sign *= -1.0;
        }
        double n1_2 = (double)(n1 + 1) / 2.0;
        double n2_2 = (double)(n2 + 1) / 2.0;
        double integral = 0.0;
        for (int k4 = 0; k4 <= n1 + 1; ++k4) {
            for (int l = 0; l <= n2 + 1; ++l) {
                integral += c1[k4] * c2[l] * this.build_matrix_R_computeIntegral_xx(x0p, xFp, s1 + (double)k4 - n1_2, s2 + (double)l - n2_2, n1, n2);
            }
        }
        return integral * h;
    }

    private double build_matrix_R_computeIntegral_xx(double x0, double xF, double s1, double s2, int q1, int q2) {
        double s2p = s2 - s1;
        double xFp = xF - s1;
        double x0p = x0 - s1;
        if (xFp < 0.0) {
            return 0.0;
        }
        if ((x0p = Math.max(x0p, Math.max(s2p, 0.0))) > xFp) {
            return 0.0;
        }
        double IxFp = 0.0;
        double Ix0p = 0.0;
        for (int k = 0; k <= q2; ++k) {
            double aux = MathTools.nchoosek(q2, k) / (double)(q1 + k + 1) * Math.pow(-s2p, q2 - k);
            IxFp += Math.pow(xFp, q1 + k + 1) * aux;
            Ix0p += Math.pow(x0p, q1 + k + 1) * aux;
        }
        return IxFp - Ix0p;
    }

    private void build_Matrix_R_geteta(double[][] etaq1q2, int q1, int q2, int dim, int intervals) {
        boolean[][] done = new boolean[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                etaq1q2[i][j] = 0.0;
                done[i][j] = false;
            }
        }
        int M = intervals + 1;
        double h = (double)dim / (double)intervals;
        for (int ki1 = -1; ki1 <= M; ++ki1) {
            for (int ki2 = -1; ki2 <= M; ++ki2) {
                int[] ip = new int[2];
                boolean valid_i = this.build_Matrix_R_getetaindex(ki1, ki2, intervals, ip);
                if (!valid_i || done[ip[0]][ip[1]]) continue;
                etaq1q2[ip[0]][ip[1]] = this.build_Matrix_R_computeIntegral_aa(0.0, dim, ki1, ki2, h, q1, q2);
                done[ip[0]][ip[1]] = true;
            }
        }
    }

    private boolean build_Matrix_R_getetaindex(int ki1, int ki2, int intervals, int[] ip) {
        ip[0] = 0;
        ip[1] = 0;
        int kir = Math.min(intervals, Math.min(ki1, ki2) + 2);
        int kil = Math.max(0, Math.max(ki1, ki2) - 2);
        if (kil >= kir) {
            return false;
        }
        int two_i = 1;
        int i = 0;
        while (i <= 3) {
            double ki = (double)(ki1 + i) - 1.5;
            if ((double)kil <= ki && ki <= (double)kir) {
                ip[0] = ip[0] + two_i;
            }
            if ((double)kil <= (ki = (double)(ki2 + i) - 1.5) && ki <= (double)kir) {
                ip[1] = ip[1] + two_i;
            }
            ++i;
            two_i *= 2;
        }
        ip[0] = ip[0] - 1;
        ip[1] = ip[1] - 1;
        return true;
    }

    private void buildRegularizationTemporary(int intervals, boolean bIsReverse) {
        int M = intervals + 3;
        int M2 = M * M;
        double[][] P11 = new double[M2][M2];
        if (bIsReverse) {
            this.P11_SourceToTarget = P11;
        } else {
            this.P11_TargetToSource = P11;
        }
        for (int i = 0; i < M2; ++i) {
            for (int j = 0; j < M2; ++j) {
                P11[i][j] = 0.0;
            }
        }
        this.build_Matrix_Rq1q2(intervals, this.divWeight, 2, 0, P11, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.divWeight + this.curlWeight, 1, 1, P11, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.curlWeight, 0, 2, P11, bIsReverse);
        double[][] P22 = new double[M2][M2];
        if (bIsReverse) {
            this.P22_SourceToTarget = P22;
        } else {
            this.P22_TargetToSource = P22;
        }
        for (int i = 0; i < M2; ++i) {
            for (int j = 0; j < M2; ++j) {
                P22[i][j] = 0.0;
            }
        }
        this.build_Matrix_Rq1q2(intervals, this.divWeight, 0, 2, P22, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.divWeight + this.curlWeight, 1, 1, P22, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.curlWeight, 2, 0, P22, bIsReverse);
        double[][] P12 = new double[M2][M2];
        if (bIsReverse) {
            this.P12_SourceToTarget = P12;
        } else {
            this.P12_TargetToSource = P12;
        }
        for (int i = 0; i < M2; ++i) {
            for (int j = 0; j < M2; ++j) {
                P12[i][j] = 0.0;
            }
        }
        this.build_Matrix_Rq1q2q3q4(intervals, 2.0 * this.divWeight, 2, 0, 1, 1, P12, bIsReverse);
        this.build_Matrix_Rq1q2q3q4(intervals, 2.0 * this.divWeight, 1, 1, 0, 2, P12, bIsReverse);
        this.build_Matrix_Rq1q2q3q4(intervals, -2.0 * this.curlWeight, 0, 2, 1, 1, P12, bIsReverse);
        this.build_Matrix_Rq1q2q3q4(intervals, -2.0 * this.curlWeight, 1, 1, 2, 0, P12, bIsReverse);
    }

    private double[][] computeAffineMatrix(boolean bIsReverse) {
        boolean adjust_size = false;
        double[][] D = new double[3][3];
        double[][] H = new double[3][3];
        double[][] U = new double[3][3];
        double[][] V = new double[3][3];
        double[][] X = new double[2][3];
        double[] W = new double[3];
        PointHandler auxSourcePh = this.sourcePh;
        PointHandler auxTargetPh = this.targetPh;
        BSplineModel auxSource = this.source;
        BSplineModel auxTarget = this.target;
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        if (bIsReverse) {
            auxSourcePh = this.targetPh;
            auxTargetPh = this.sourcePh;
            auxSource = this.target;
            auxTarget = this.source;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
        }
        Vector<Point> sourceVector = null;
        sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
        Vector<Point> targetVector = null;
        targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
        int removeLastPoint = 0;
        int n = targetVector.size();
        switch (n) {
            case 0: {
                int j;
                for (int i = 0; i < 2; ++i) {
                    for (j = 0; j < 3; ++j) {
                        X[i][j] = 0.0;
                    }
                }
                if (adjust_size) {
                    X[0][0] = (double)auxSource.getCurrentWidth() / (double)auxTarget.getCurrentWidth();
                    X[1][1] = (double)auxSource.getCurrentHeight() / (double)auxTarget.getCurrentHeight();
                    break;
                }
                X[1][1] = 1.0;
                X[0][0] = 1.0;
                X[0][2] = ((double)auxSource.getCurrentWidth() - (double)auxTarget.getCurrentWidth()) / 2.0;
                X[1][2] = ((double)auxSource.getCurrentHeight() - (double)auxTarget.getCurrentHeight()) / 2.0;
                break;
            }
            case 1: {
                int j;
                for (int i = 0; i < 2; ++i) {
                    for (j = 0; j < 2; ++j) {
                        X[i][j] = i == j ? 1.0 : 0.0;
                    }
                }
                X[0][2] = auxFactorWidth * (double)(sourceVector.firstElement().x - targetVector.firstElement().x);
                X[1][2] = auxFactorHeight * (double)(sourceVector.firstElement().y - targetVector.firstElement().y);
                break;
            }
            case 2: {
                double x0 = auxFactorWidth * (double)sourceVector.elementAt((int)0).x;
                double y0 = auxFactorHeight * (double)sourceVector.elementAt((int)0).y;
                double x1 = auxFactorWidth * (double)sourceVector.elementAt((int)1).x;
                double y1 = auxFactorHeight * (double)sourceVector.elementAt((int)1).y;
                double u0 = auxFactorWidth * (double)targetVector.elementAt((int)0).x;
                double v0 = auxFactorHeight * (double)targetVector.elementAt((int)0).y;
                double u1 = auxFactorWidth * (double)targetVector.elementAt((int)1).x;
                double v1 = auxFactorHeight * (double)targetVector.elementAt((int)1).y;
                sourceVector.addElement(new Point((int)(x1 + y0 - y1), (int)(x1 + y1 - x0)));
                targetVector.addElement(new Point((int)(u1 + v0 - v1), (int)(u1 + v1 - u0)));
                removeLastPoint = 1;
                n = 3;
            }
            default: {
                int i;
                for (i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        H[i][j] = 0.0;
                    }
                }
                for (int k = 0; k < n; ++k) {
                    Point sourcePoint = sourceVector.elementAt(k);
                    Point targetPoint = targetVector.elementAt(k);
                    double sx = auxFactorWidth * (double)sourcePoint.x;
                    double sy = auxFactorHeight * (double)sourcePoint.y;
                    double tx = auxFactorWidth * (double)targetPoint.x;
                    double ty = auxFactorHeight * (double)targetPoint.y;
                    double[] dArray = H[0];
                    dArray[0] = dArray[0] + tx * sx;
                    double[] dArray2 = H[0];
                    dArray2[1] = dArray2[1] + tx * sy;
                    double[] dArray3 = H[0];
                    dArray3[2] = dArray3[2] + tx;
                    double[] dArray4 = H[1];
                    dArray4[0] = dArray4[0] + ty * sx;
                    double[] dArray5 = H[1];
                    dArray5[1] = dArray5[1] + ty * sy;
                    double[] dArray6 = H[1];
                    dArray6[2] = dArray6[2] + ty;
                    double[] dArray7 = H[2];
                    dArray7[0] = dArray7[0] + sx;
                    double[] dArray8 = H[2];
                    dArray8[1] = dArray8[1] + sy;
                    double[] dArray9 = H[2];
                    dArray9[2] = dArray9[2] + 1.0;
                    double[] dArray10 = D[0];
                    dArray10[0] = dArray10[0] + sx * sx;
                    double[] dArray11 = D[0];
                    dArray11[1] = dArray11[1] + sx * sy;
                    double[] dArray12 = D[0];
                    dArray12[2] = dArray12[2] + sx;
                    double[] dArray13 = D[1];
                    dArray13[0] = dArray13[0] + sy * sx;
                    double[] dArray14 = D[1];
                    dArray14[1] = dArray14[1] + sy * sy;
                    double[] dArray15 = D[1];
                    dArray15[2] = dArray15[2] + sy;
                    double[] dArray16 = D[2];
                    dArray16[0] = dArray16[0] + sx;
                    double[] dArray17 = D[2];
                    dArray17[1] = dArray17[1] + sy;
                    double[] dArray18 = D[2];
                    dArray18[2] = dArray18[2] + 1.0;
                }
                MathTools.singularValueDecomposition(H, W, V);
                if (Math.abs(W[0]) < this.FLT_EPSILON || Math.abs(W[1]) < this.FLT_EPSILON || Math.abs(W[2]) < this.FLT_EPSILON) {
                    return this.computeRotationMatrix(bIsReverse);
                }
                for (i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        double[] dArray = V[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] / W[j];
                    }
                }
                for (i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        U[i][j] = 0.0;
                        for (int k = 0; k < 3; ++k) {
                            double[] dArray = U[i];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + D[i][k] * V[k][j];
                        }
                    }
                }
                for (i = 0; i < 2; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        X[i][j] = 0.0;
                        for (int k = 0; k < 3; ++k) {
                            double[] dArray = X[i];
                            int n4 = j;
                            dArray[n4] = dArray[n4] + U[i][k] * H[j][k];
                        }
                    }
                }
            }
        }
        if (removeLastPoint) {
            for (int i = 1; i <= removeLastPoint; ++i) {
                auxSourcePh.getPoints().removeElementAt(n - i);
                auxTargetPh.getPoints().removeElementAt(n - i);
            }
        }
        double centerX = auxSource.getCurrentWidth();
        double centerY = auxSource.getCurrentHeight();
        AffineTransform matrix = new AffineTransform(X[0][0], X[1][0], X[0][1], X[1][1], X[0][2], X[1][2]);
        this.regularizeMatrix(matrix, centerX, centerY);
        X[0][0] = matrix.getScaleX();
        X[0][1] = matrix.getShearX();
        X[1][0] = matrix.getShearY();
        X[1][1] = matrix.getScaleY();
        X[0][2] = matrix.getTranslateX();
        X[1][2] = matrix.getTranslateY();
        return X;
    }

    public void regularizeMatrix(AffineTransform a, double centerX, double centerY) {
        a.translate(centerX, centerY);
        double a11 = a.getScaleX();
        double a21 = a.getShearY();
        double scaleX = Math.sqrt(a11 * a11 + a21 * a21);
        double rotang = Math.atan2(a21 / scaleX, a11 / scaleX);
        double a12 = a.getShearX();
        double a22 = a.getScaleY();
        double shearX = Math.cos(-rotang) * a12 - Math.sin(-rotang) * a22;
        double scaleY = Math.sin(-rotang) * a12 + Math.cos(-rotang) * a22;
        double transX = Math.cos(-rotang) * a.getTranslateX() - Math.sin(-rotang) * a.getTranslateY();
        double transY = Math.sin(-rotang) * a.getTranslateX() + Math.cos(-rotang) * a.getTranslateY();
        double new_shearX = shearX * (1.0 - this.tweakShear);
        double avgScale = (scaleX + scaleY) / 2.0;
        double aspectRatio = scaleX / scaleY;
        double regAvgScale = avgScale * (1.0 - this.tweakScale) + 1.0 * this.tweakScale;
        double regAspectRatio = aspectRatio * (1.0 - this.tweakIso) + 1.0 * this.tweakIso;
        double new_scaleY = 2.0 * regAvgScale / (regAspectRatio + 1.0);
        double new_scaleX = regAspectRatio * new_scaleY;
        AffineTransform b = Transformation.makeAffineMatrix(new_scaleX, new_scaleY, new_shearX, 0.0, rotang, transX, transY);
        b.translate(-centerX, -centerY);
        a.setTransform(b);
    }

    public static AffineTransform makeAffineMatrix(double scalex, double scaley, double shearx, double sheary, double rotang, double transx, double transy) {
        double m00 = Math.cos(rotang) * scalex - Math.sin(rotang) * sheary;
        double m01 = Math.cos(rotang) * shearx - Math.sin(rotang) * scaley;
        double m02 = Math.cos(rotang) * transx - Math.sin(rotang) * transy;
        double m10 = Math.sin(rotang) * scalex + Math.cos(rotang) * sheary;
        double m11 = Math.sin(rotang) * shearx + Math.cos(rotang) * scaley;
        double m12 = Math.sin(rotang) * transx + Math.cos(rotang) * transy;
        return new AffineTransform(m00, m10, m01, m11, m02, m12);
    }

    private void computeAffineResidues(double[][] affineMatrix, double[] dx, double[] dy, boolean bIsReverse) {
        double auxFactorWidth = this.target.getFactorWidth();
        double auxFactorHeight = this.target.getFactorHeight();
        PointHandler auxSourcePh = this.sourcePh;
        PointHandler auxTargetPh = this.targetPh;
        if (bIsReverse) {
            auxFactorWidth = this.source.getFactorWidth();
            auxFactorHeight = this.source.getFactorHeight();
            auxSourcePh = this.targetPh;
            auxTargetPh = this.sourcePh;
        }
        Vector<Point> sourceVector = null;
        sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
        Vector<Point> targetVector = null;
        targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
        int K = auxTargetPh.getPoints().size();
        for (int k = 0; k < K; ++k) {
            Point sourcePoint = sourceVector.elementAt(k);
            Point targetPoint = targetVector.elementAt(k);
            double u = auxFactorWidth * (double)targetPoint.x;
            double v = auxFactorHeight * (double)targetPoint.y;
            double x = affineMatrix[0][2] + affineMatrix[0][0] * u + affineMatrix[0][1] * v;
            double y = affineMatrix[1][2] + affineMatrix[1][0] * u + affineMatrix[1][1] * v;
            dx[k] = auxFactorWidth * (double)sourcePoint.x - x;
            dy[k] = auxFactorHeight * (double)sourcePoint.y - y;
        }
    }

    private boolean computeCoefficientsScale(int intervals, double[] dx, double[] dy, double[][] cx, double[][] cy, boolean bIsReverse) {
        PointHandler auxTargetPh = bIsReverse ? this.sourcePh : this.targetPh;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.getPoints().size();
        }
        boolean underconstrained = false;
        if (0 < K) {
            double[][] B = new double[K][(intervals + 3) * (intervals + 3)];
            this.build_Matrix_B(intervals, K, B, bIsReverse);
            int Nunk = (intervals + 3) * (intervals + 3);
            double[][] iB = new double[Nunk][K];
            underconstrained = MathTools.invertMatrixSVD(K, Nunk, B, iB);
            int ij = 0;
            for (int i = 0; i < intervals + 3; ++i) {
                for (int j = 0; j < intervals + 3; ++j) {
                    cy[i][j] = 0.0;
                    cx[i][j] = 0.0;
                    for (int k = 0; k < K; ++k) {
                        double[] dArray = cx[i];
                        int n = j;
                        dArray[n] = dArray[n] + iB[ij][k] * dx[k];
                        double[] dArray2 = cy[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + iB[ij][k] * dy[k];
                    }
                    ++ij;
                }
            }
        }
        return underconstrained;
    }

    private boolean computeCoefficientsScaleWithRegularization(int intervals, double[] dx, double[] dy, double[][] cx, double[][] cy, boolean bIsReverse) {
        double[][] P11 = this.P11_TargetToSource;
        double[][] P12 = this.P12_TargetToSource;
        double[][] P22 = this.P22_TargetToSource;
        PointHandler auxTargetPh = this.targetPh;
        if (bIsReverse) {
            auxTargetPh = this.sourcePh;
            P11 = this.P11_SourceToTarget;
            P12 = this.P12_SourceToTarget;
            P22 = this.P22_SourceToTarget;
        }
        boolean underconstrained = true;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.getPoints().size();
        }
        if (0 < K) {
            double aux;
            int l;
            int i;
            int M = intervals + 3;
            int M2 = M * M;
            double[][] A = new double[2 * M2][2 * M2];
            double[] b = new double[2 * M2];
            for (int i2 = 0; i2 < 2 * M2; ++i2) {
                b[i2] = 0.0;
                for (int j = 0; j < 2 * M2; ++j) {
                    A[i2][j] = 0.0;
                }
            }
            double[][] B = new double[K][M2];
            this.build_Matrix_B(intervals, K, B, bIsReverse);
            for (i = 0; i < M2; ++i) {
                for (int j = i; j < M2; ++j) {
                    double bitbj = 0.0;
                    for (l = 0; l < K; ++l) {
                        bitbj += B[l][i] * B[l][j];
                    }
                    double d = bitbj *= 2.0;
                    A[j][i] = d;
                    A[i][j] = d;
                    A[M2 + j][M2 + i] = d;
                    A[M2 + i][M2 + j] = d;
                }
            }
            for (i = 0; i < M2; ++i) {
                double bitdx = 0.0;
                double bitdy = 0.0;
                for (int l2 = 0; l2 < K; ++l2) {
                    bitdx += B[l2][i] * dx[l2];
                    bitdy += B[l2][i] * dy[l2];
                }
                b[i] = bitdx *= 2.0;
                b[M2 + i] = bitdy *= 2.0;
            }
            for (i = 0; i < M2; ++i) {
                for (int j = 0; j < M2; ++j) {
                    aux = P11[i][j];
                    double[] dArray = A[i];
                    int n = j;
                    dArray[n] = dArray[n] + aux;
                    double[] dArray2 = A[j];
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + aux;
                }
            }
            for (i = 0; i < M2; ++i) {
                for (int j = 0; j < M2; ++j) {
                    aux = P22[i][j];
                    double[] dArray = A[M2 + i];
                    int n = M2 + j;
                    dArray[n] = dArray[n] + aux;
                    double[] dArray3 = A[M2 + j];
                    int n3 = M2 + i;
                    dArray3[n3] = dArray3[n3] + aux;
                }
            }
            for (i = 0; i < M2; ++i) {
                for (int j = 0; j < M2; ++j) {
                    A[i][M2 + j] = P12[i][j];
                    A[M2 + i][j] = P12[j][i];
                }
            }
            double[][] iA = new double[2 * M2][2 * M2];
            underconstrained = MathTools.invertMatrixSVD(2 * M2, 2 * M2, A, iA);
            int ij = 0;
            for (int i3 = 0; i3 < intervals + 3; ++i3) {
                for (int j = 0; j < intervals + 3; ++j) {
                    cy[i3][j] = 0.0;
                    cx[i3][j] = 0.0;
                    for (l = 0; l < 2 * M2; ++l) {
                        double[] dArray = cx[i3];
                        int n = j;
                        dArray[n] = dArray[n] + iA[ij][l] * b[l];
                        double[] dArray4 = cy[i3];
                        int n4 = j;
                        dArray4[n4] = dArray4[n4] + iA[M2 + ij][l] * b[l];
                    }
                    ++ij;
                }
            }
        }
        return underconstrained;
    }

    private void computeInitialResidues(double[] dx, double[] dy, boolean bIsReverse) {
        double auxFactorWidth = this.target.getFactorWidth();
        double auxFactorHeight = this.target.getFactorHeight();
        PointHandler auxSourcePh = this.sourcePh;
        PointHandler auxTargetPh = this.targetPh;
        if (bIsReverse) {
            auxFactorWidth = this.source.getFactorWidth();
            auxFactorHeight = this.source.getFactorHeight();
            auxSourcePh = this.targetPh;
            auxTargetPh = this.sourcePh;
        }
        Vector<Point> sourceVector = null;
        sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
        Vector<Point> targetVector = null;
        targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
        int K = 0;
        if (auxTargetPh != null) {
            auxTargetPh.getPoints().size();
        }
        for (int k = 0; k < K; ++k) {
            Point sourcePoint = sourceVector.elementAt(k);
            Point targetPoint = targetVector.elementAt(k);
            dx[k] = auxFactorWidth * (double)(sourcePoint.x - targetPoint.x);
            dy[k] = auxFactorHeight * (double)(sourcePoint.y - targetPoint.y);
        }
    }

    private void computeDeformation(int intervals, double[][] cx, double[][] cy, double[][] transformation_x, double[][] transformation_y, boolean bIsReverse) {
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        if (bIsReverse) {
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
        }
        Thread x_thread = new Thread(new ConcurrentDeformation(cx, auxTargetCurrentHeight, auxTargetCurrentWidth, transformation_x, intervals));
        Thread y_thread = new Thread(new ConcurrentDeformation(cy, auxTargetCurrentHeight, auxTargetCurrentWidth, transformation_y, intervals));
        x_thread.start();
        y_thread.start();
        try {
            x_thread.join();
            y_thread.join();
            x_thread = null;
            y_thread = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private double[][] computeRotationMatrix(boolean bIsReverse) {
        double[][] X = new double[2][3];
        double[][] H = new double[2][2];
        double[][] V = new double[2][2];
        double[] W = new double[2];
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        PointHandler auxSourcePh = this.sourcePh;
        PointHandler auxTargetPh = this.targetPh;
        if (bIsReverse) {
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
            auxSourcePh = this.targetPh;
            auxTargetPh = this.sourcePh;
        }
        Vector<Point> sourceVector = null;
        sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
        Vector<Point> targetVector = null;
        targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
        int n = targetVector.size();
        switch (n) {
            case 0: {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        X[i][j] = i == j ? 1.0 : 0.0;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        X[i][j] = i == j ? 1.0 : 0.0;
                    }
                }
                X[0][2] = auxFactorWidth * (double)(sourceVector.firstElement().x - targetVector.firstElement().x);
                X[1][2] = auxFactorHeight * (double)(sourceVector.firstElement().y - targetVector.firstElement().y);
                break;
            }
            default: {
                int i;
                double xTargetAverage = 0.0;
                double yTargetAverage = 0.0;
                for (int i2 = 0; i2 < n; ++i2) {
                    Point p = targetVector.elementAt(i2);
                    xTargetAverage += auxFactorWidth * (double)p.x;
                    yTargetAverage += auxFactorHeight * (double)p.y;
                }
                xTargetAverage /= (double)n;
                yTargetAverage /= (double)n;
                double[] xCenteredTarget = new double[n];
                double[] yCenteredTarget = new double[n];
                for (int i3 = 0; i3 < n; ++i3) {
                    Point p = targetVector.elementAt(i3);
                    xCenteredTarget[i3] = auxFactorWidth * (double)p.x - xTargetAverage;
                    yCenteredTarget[i3] = auxFactorHeight * (double)p.y - yTargetAverage;
                }
                double xSourceAverage = 0.0;
                double ySourceAverage = 0.0;
                for (int i4 = 0; i4 < n; ++i4) {
                    Point p = sourceVector.elementAt(i4);
                    xSourceAverage += auxFactorWidth * (double)p.x;
                    ySourceAverage += auxFactorHeight * (double)p.y;
                }
                xSourceAverage /= (double)n;
                ySourceAverage /= (double)n;
                double[] xCenteredSource = new double[n];
                double[] yCenteredSource = new double[n];
                for (i = 0; i < n; ++i) {
                    Point p = sourceVector.elementAt(i);
                    xCenteredSource[i] = auxFactorWidth * (double)p.x - xSourceAverage;
                    yCenteredSource[i] = auxFactorHeight * (double)p.y - ySourceAverage;
                }
                for (i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        H[i][j] = 0.0;
                    }
                }
                for (int k = 0; k < n; ++k) {
                    double[] dArray = H[0];
                    dArray[0] = dArray[0] + xCenteredTarget[k] * xCenteredSource[k];
                    double[] dArray2 = H[0];
                    dArray2[1] = dArray2[1] + xCenteredTarget[k] * yCenteredSource[k];
                    double[] dArray3 = H[1];
                    dArray3[0] = dArray3[0] + yCenteredTarget[k] * xCenteredSource[k];
                    double[] dArray4 = H[1];
                    dArray4[1] = dArray4[1] + yCenteredTarget[k] * yCenteredSource[k];
                }
                MathTools.singularValueDecomposition(H, W, V);
                if ((H[0][0] * H[1][1] - H[0][1] * H[1][0]) * (V[0][0] * V[1][1] - V[0][1] * V[1][0]) < 0.0) {
                    if (W[0] < W[1]) {
                        double[] dArray = V[0];
                        dArray[0] = dArray[0] * -1.0;
                        double[] dArray5 = V[1];
                        dArray5[0] = dArray5[0] * -1.0;
                    } else {
                        double[] dArray = V[0];
                        dArray[1] = dArray[1] * -1.0;
                        double[] dArray6 = V[1];
                        dArray6[1] = dArray6[1] * -1.0;
                    }
                }
                for (i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        X[i][j] = 0.0;
                        for (int k = 0; k < 2; ++k) {
                            double[] dArray = X[i];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + V[i][k] * H[j][k];
                        }
                    }
                }
                X[0][2] = xSourceAverage - X[0][0] * xTargetAverage - X[0][1] * yTargetAverage;
                X[1][2] = ySourceAverage - X[1][0] * xTargetAverage - X[1][1] * yTargetAverage;
            }
        }
        return X;
    }

    private void computeScaleResidues(int intervals, double[][] cx, double[][] cy, double[] dx, double[] dy, boolean bIsReverse) {
        double auxFactorWidth = this.target.getFactorWidth();
        double auxFactorHeight = this.target.getFactorHeight();
        PointHandler auxSourcePh = this.sourcePh;
        PointHandler auxTargetPh = this.targetPh;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        if (bIsReverse) {
            auxFactorWidth = this.source.getFactorWidth();
            auxFactorHeight = this.source.getFactorHeight();
            auxSourcePh = this.targetPh;
            auxTargetPh = this.sourcePh;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
            auxTargetCurrentHeight = this.sourceCurrentHeight;
        }
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        Vector<Point> sourceVector = null;
        sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
        Vector<Point> targetVector = null;
        targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
        int K = targetVector.size();
        for (int k = 0; k < K; ++k) {
            Point sourcePoint = sourceVector.elementAt(k);
            Point targetPoint = targetVector.elementAt(k);
            double u = auxFactorWidth * (double)targetPoint.x;
            double v = auxFactorHeight * (double)targetPoint.y;
            double tu = u * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
            double tv = v * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
            swx.prepareForInterpolation(tu, tv, false);
            double x = swx.interpolateI();
            swy.prepareForInterpolation(tu, tv, false);
            double y = swy.interpolateI();
            dx[k] = auxFactorWidth * (double)sourcePoint.x - x;
            dy[k] = auxFactorHeight * (double)sourcePoint.y - y;
        }
    }

    private void computeTotalWorkload() {
        int state = this.min_scale_deformation == this.max_scale_deformation ? 1 : 0;
        int s = this.min_scale_deformation;
        int currentDepth = this.target.getCurrentDepth();
        int workload = 0;
        while (state != -1) {
            if ((state == 0 || state == 1) && this.imageWeight != 0.0) {
                workload += 300 * (currentDepth + 1);
            }
            switch (state) {
                case 0: {
                    if (s < this.max_scale_deformation) {
                        ++s;
                        if (currentDepth > this.min_scale_image) {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    if (currentDepth > this.min_scale_image) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (state == 1) {
                        state = s == this.max_scale_deformation && currentDepth == this.min_scale_image ? 2 : (s == this.max_scale_deformation ? 1 : 0);
                    } else if (state == 2) {
                        state = currentDepth == 0 ? -1 : 2;
                    }
                    if (currentDepth == 0) break;
                    --currentDepth;
                }
            }
        }
        ProgressBar.resetProgressBar();
        ProgressBar.addWorkload(workload);
    }

    private double evaluateConsistency(int intervals, double[] grad) {
        double consistencyInverseError;
        int cYdim;
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        for (int k = 0; k < grad.length; ++k) {
            grad[k] = 0.0;
        }
        BSplineModel swx_direct = this.swxTargetToSource;
        BSplineModel swy_direct = this.swyTargetToSource;
        BSplineModel swx_inverse = this.swxSourceToTarget;
        BSplineModel swy_inverse = this.swySourceToTarget;
        double f_direct = 0.0;
        int n_direct = 0;
        for (int v = 0; v < this.targetCurrentHeight; ++v) {
            for (int u = 0; u < this.targetCurrentWidth; ++u) {
                int m;
                int l;
                if (!this.targetMsk.getValue((double)u / this.targetFactorWidth, (double)v / this.targetFactorHeight)) continue;
                int x = (int)Math.round(swx_direct.precomputed_interpolateI(u, v));
                int y = (int)Math.round(swy_direct.precomputed_interpolateI(u, v));
                if (x < 0 || x >= this.sourceCurrentWidth || y < 0 || y >= this.sourceCurrentHeight) continue;
                double x2 = swx_inverse.precomputed_interpolateI(x, y);
                double y2 = swy_inverse.precomputed_interpolateI(x, y);
                double aux1 = (double)u - x2;
                double aux2 = (double)v - y2;
                f_direct += aux1 * aux1 + aux2 * aux2;
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        int k;
                        if (swx_direct.prec_yIndex[v][l] == -1 || swx_direct.prec_xIndex[u][m] == -1) continue;
                        double dddx = swx_direct.precomputed_getWeightI(l, m, u, v);
                        double dixx = swx_inverse.precomputed_getWeightDx(l, m, x, y);
                        double diyy = swy_inverse.precomputed_getWeightDy(l, m, x, y);
                        double weightIx = (dixx + diyy) * dddx;
                        double dddy = swy_direct.precomputed_getWeightI(l, m, u, v);
                        double dixy = swx_inverse.precomputed_getWeightDy(l, m, x, y);
                        double diyx = swy_inverse.precomputed_getWeightDx(l, m, x, y);
                        double weightIy = (diyx + dixy) * dddy;
                        int n = k = swx_direct.prec_yIndex[v][l] * cYdim + swx_direct.prec_xIndex[u][m];
                        grad[n] = grad[n] + -aux1 * weightIx;
                        int n2 = k + twiceNk;
                        grad[n2] = grad[n2] + -aux2 * weightIy;
                    }
                }
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        if (swx_inverse.prec_yIndex[y][l] == -1 || swx_inverse.prec_xIndex[x][m] == -1) continue;
                        double weightI = swx_inverse.precomputed_getWeightI(l, m, x, y);
                        int k = swx_inverse.prec_yIndex[y][l] * cYdim + swx_inverse.prec_xIndex[x][m];
                        int n = k + Nk;
                        grad[n] = grad[n] + -aux1 * weightI;
                        int n3 = k + Nk + twiceNk;
                        grad[n3] = grad[n3] + -aux2 * weightI;
                    }
                }
                ++n_direct;
            }
        }
        if (n_direct != 0) {
            f_direct /= (double)n_direct;
            double aux = this.consistencyWeight * 2.0 / (double)n_direct;
            int k = 0;
            while (k < grad.length) {
                int n = k++;
                grad[n] = grad[n] * aux;
            }
        }
        double[] vgrad = new double[grad.length];
        for (int k = 0; k < vgrad.length; ++k) {
            vgrad[k] = 0.0;
        }
        double f_inverse = 0.0;
        int n_inverse = 0;
        for (int v = 0; v < this.sourceCurrentHeight; ++v) {
            for (int u = 0; u < this.sourceCurrentWidth; ++u) {
                int m;
                int l;
                if (!this.sourceMsk.getValue((double)u / this.sourceFactorWidth, (double)v / this.sourceFactorHeight)) continue;
                int x = (int)Math.round(swx_inverse.precomputed_interpolateI(u, v));
                int y = (int)Math.round(swy_inverse.precomputed_interpolateI(u, v));
                if (x < 0 || x >= this.targetCurrentWidth || y < 0 || y >= this.targetCurrentHeight) continue;
                double x2 = swx_direct.precomputed_interpolateI(x, y);
                double y2 = swy_direct.precomputed_interpolateI(x, y);
                double aux1 = (double)u - x2;
                double aux2 = (double)v - y2;
                f_inverse += aux1 * aux1 + aux2 * aux2;
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        int k;
                        if (swx_direct.prec_yIndex[y][l] == -1 || swx_direct.prec_xIndex[x][m] == -1) continue;
                        double weightI = swx_direct.precomputed_getWeightI(l, m, x, y);
                        int n = k = swx_direct.prec_yIndex[y][l] * cYdim + swx_direct.prec_xIndex[x][m];
                        vgrad[n] = vgrad[n] + -aux1 * weightI;
                        int n4 = k + twiceNk;
                        vgrad[n4] = vgrad[n4] + -aux2 * weightI;
                    }
                }
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        if (swx_inverse.prec_yIndex[v][l] == -1 || swx_inverse.prec_xIndex[u][m] == -1) continue;
                        double diix = swx_inverse.precomputed_getWeightI(l, m, u, v);
                        double ddxx = swx_direct.precomputed_getWeightDx(l, m, x, y);
                        double ddyy = swy_direct.precomputed_getWeightDy(l, m, x, y);
                        double weightIx = (ddxx + ddyy) * diix;
                        double diiy = swy_inverse.precomputed_getWeightI(l, m, u, v);
                        double ddxy = swx_direct.precomputed_getWeightDy(l, m, x, y);
                        double ddyx = swy_direct.precomputed_getWeightDx(l, m, x, y);
                        double weightIy = (ddyx + ddxy) * diiy;
                        int k = swx_inverse.prec_yIndex[v][l] * cYdim + swx_inverse.prec_xIndex[u][m];
                        int n = k + Nk;
                        vgrad[n] = vgrad[n] + -aux1 * weightIx;
                        int n5 = k + Nk + twiceNk;
                        vgrad[n5] = vgrad[n5] + -aux2 * weightIy;
                    }
                }
                ++n_inverse;
            }
        }
        if (n_inverse != 0) {
            f_inverse /= (double)n_inverse;
            double aux = this.consistencyWeight * 2.0 / (double)n_inverse;
            int k = 0;
            while (k < vgrad.length) {
                int n = k++;
                vgrad[n] = vgrad[n] * aux;
            }
        }
        for (int k = 0; k < grad.length; ++k) {
            int n = k;
            grad[n] = grad[n] + vgrad[k];
        }
        this.partialDirectConsitencyError = this.consistencyWeight * f_direct;
        this.partialInverseConsitencyError = this.consistencyWeight * f_inverse;
        double consistencyDirectError = n_direct == 0 ? 1.0 / this.FLT_EPSILON : this.consistencyWeight * f_direct;
        double d = consistencyInverseError = n_inverse == 0 ? 1.0 / this.FLT_EPSILON : this.consistencyWeight * f_inverse;
        if (this.showMarquardtOptim) {
            IJ.log((String)("    Consistency Error (s-t): " + consistencyDirectError));
            IJ.log((String)("    Consistency Error (t-s): " + consistencyInverseError));
        }
        if (n_direct == 0 || n_inverse == 0) {
            return 1.0 / this.FLT_EPSILON;
        }
        return this.consistencyWeight * (f_direct + f_inverse);
    }

    private double evaluateConsistency(double[] c_direct, double[] c_inverse, int intervals, double[] grad) {
        double consistencyInverseError;
        int cYdim;
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        for (int k = 0; k < grad.length; ++k) {
            grad[k] = 0.0;
        }
        BSplineModel swx_direct = this.swxTargetToSource;
        BSplineModel swy_direct = this.swyTargetToSource;
        BSplineModel swx_inverse = this.swxSourceToTarget;
        BSplineModel swy_inverse = this.swySourceToTarget;
        swx_direct.setCoefficients(c_direct, cYdim, cXdim, 0);
        swy_direct.setCoefficients(c_direct, cYdim, cXdim, Nk);
        swx_inverse.setCoefficients(c_inverse, cYdim, cXdim, 0);
        swy_inverse.setCoefficients(c_inverse, cYdim, cXdim, Nk);
        double f_direct = 0.0;
        int n_direct = 0;
        for (int v = 0; v < this.targetCurrentHeight; ++v) {
            for (int u = 0; u < this.targetCurrentWidth; ++u) {
                int m;
                int l;
                if (!this.targetMsk.getValue((double)u / this.targetFactorWidth, (double)v / this.targetFactorHeight)) continue;
                int x = (int)Math.round(swx_direct.precomputed_interpolateI(u, v));
                int y = (int)Math.round(swy_direct.precomputed_interpolateI(u, v));
                if (x < 0 || x >= this.sourceCurrentWidth || y < 0 || y >= this.sourceCurrentHeight) continue;
                double x2 = swx_inverse.precomputed_interpolateI(x, y);
                double y2 = swy_inverse.precomputed_interpolateI(x, y);
                double aux1 = (double)u - x2;
                double aux2 = (double)v - y2;
                f_direct += aux1 * aux1 + aux2 * aux2;
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        int k;
                        if (swx_direct.prec_yIndex[v][l] == -1 || swx_direct.prec_xIndex[u][m] == -1) continue;
                        double dddx = swx_direct.precomputed_getWeightI(l, m, u, v);
                        double dixx = swx_inverse.precomputed_getWeightDx(l, m, x, y);
                        double diyy = swy_inverse.precomputed_getWeightDy(l, m, x, y);
                        double weightIx = (dixx + diyy) * dddx;
                        double dddy = swy_direct.precomputed_getWeightI(l, m, u, v);
                        double dixy = swx_inverse.precomputed_getWeightDy(l, m, x, y);
                        double diyx = swy_inverse.precomputed_getWeightDx(l, m, x, y);
                        double weightIy = (diyx + dixy) * dddy;
                        int n = k = swx_direct.prec_yIndex[v][l] * cYdim + swx_direct.prec_xIndex[u][m];
                        grad[n] = grad[n] + -aux1 * weightIx;
                        int n2 = k + twiceNk;
                        grad[n2] = grad[n2] + -aux2 * weightIy;
                    }
                }
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        if (swx_inverse.prec_yIndex[y][l] == -1 || swx_inverse.prec_xIndex[x][m] == -1) continue;
                        double weightI = swx_inverse.precomputed_getWeightI(l, m, x, y);
                        int k = swx_inverse.prec_yIndex[y][l] * cYdim + swx_inverse.prec_xIndex[x][m];
                        int n = k + Nk;
                        grad[n] = grad[n] + -aux1 * weightI;
                        int n3 = k + Nk + twiceNk;
                        grad[n3] = grad[n3] + -aux2 * weightI;
                    }
                }
                ++n_direct;
            }
        }
        if (n_direct != 0) {
            f_direct /= (double)n_direct;
        }
        if (n_direct != 0) {
            double aux = this.consistencyWeight * 2.0 / (double)n_direct;
            int k = 0;
            while (k < grad.length) {
                int n = k++;
                grad[n] = grad[n] * aux;
            }
        }
        double[] vgrad = new double[grad.length];
        for (int k = 0; k < vgrad.length; ++k) {
            vgrad[k] = 0.0;
        }
        double f_inverse = 0.0;
        int n_inverse = 0;
        for (int v = 0; v < this.sourceCurrentHeight; ++v) {
            for (int u = 0; u < this.sourceCurrentWidth; ++u) {
                int m;
                int l;
                if (!this.sourceMsk.getValue((double)u / this.sourceFactorWidth, (double)v / this.sourceFactorHeight)) continue;
                int x = (int)Math.round(swx_inverse.precomputed_interpolateI(u, v));
                int y = (int)Math.round(swy_inverse.precomputed_interpolateI(u, v));
                if (x < 0 || x >= this.targetCurrentWidth || y < 0 || y >= this.targetCurrentHeight) continue;
                double x2 = swx_direct.precomputed_interpolateI(x, y);
                double y2 = swy_direct.precomputed_interpolateI(x, y);
                double aux1 = (double)u - x2;
                double aux2 = (double)v - y2;
                f_inverse += aux1 * aux1 + aux2 * aux2;
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        int k;
                        if (swx_direct.prec_yIndex[y][l] == -1 || swx_direct.prec_xIndex[x][m] == -1) continue;
                        double weightI = swx_direct.precomputed_getWeightI(l, m, x, y);
                        int n = k = swx_direct.prec_yIndex[y][l] * cYdim + swx_direct.prec_xIndex[x][m];
                        vgrad[n] = vgrad[n] + -aux1 * weightI;
                        int n4 = k + twiceNk;
                        vgrad[n4] = vgrad[n4] + -aux2 * weightI;
                    }
                }
                for (l = 0; l < 4; ++l) {
                    for (m = 0; m < 4; ++m) {
                        if (swx_inverse.prec_yIndex[v][l] == -1 || swx_inverse.prec_xIndex[u][m] == -1) continue;
                        double diix = swx_inverse.precomputed_getWeightI(l, m, u, v);
                        double ddxx = swx_direct.precomputed_getWeightDx(l, m, x, y);
                        double ddyy = swy_direct.precomputed_getWeightDy(l, m, x, y);
                        double weightIx = (ddxx + ddyy) * diix;
                        double diiy = swy_inverse.precomputed_getWeightI(l, m, u, v);
                        double ddxy = swx_direct.precomputed_getWeightDy(l, m, x, y);
                        double ddyx = swy_direct.precomputed_getWeightDx(l, m, x, y);
                        double weightIy = (ddyx + ddxy) * diiy;
                        int k = swx_inverse.prec_yIndex[v][l] * cYdim + swx_inverse.prec_xIndex[u][m];
                        int n = k + Nk;
                        vgrad[n] = vgrad[n] + -aux1 * weightIx;
                        int n5 = k + Nk + twiceNk;
                        vgrad[n5] = vgrad[n5] + -aux2 * weightIy;
                    }
                }
                ++n_inverse;
            }
        }
        if (n_inverse != 0) {
            f_inverse /= (double)n_inverse;
        }
        if (n_inverse != 0) {
            double aux = this.consistencyWeight * 2.0 / (double)n_inverse;
            int k = 0;
            while (k < vgrad.length) {
                int n = k++;
                vgrad[n] = vgrad[n] * aux;
            }
        }
        for (int k = 0; k < grad.length; ++k) {
            int n = k;
            grad[n] = grad[n] + vgrad[k];
        }
        this.partialDirectConsitencyError = f_direct;
        this.partialInverseConsitencyError = f_inverse;
        double consistencyDirectError = n_direct == 0 ? 1.0 / this.FLT_EPSILON : this.consistencyWeight * f_direct;
        double d = consistencyInverseError = n_inverse == 0 ? 1.0 / this.FLT_EPSILON : this.consistencyWeight * f_inverse;
        if (this.showMarquardtOptim) {
            IJ.log((String)("    Consistency Error (s-t): " + consistencyDirectError));
            IJ.log((String)("    Consistency Error (t-s): " + consistencyInverseError));
        }
        if (n_direct == 0 || n_inverse == 0) {
            return 1.0 / this.FLT_EPSILON;
        }
        return this.consistencyWeight * (f_direct + f_inverse);
    }

    private double energyFunction(double[] c, int intervals, double[] grad, boolean only_image, boolean show_error) {
        int M = c.length / 2;
        int halfM = M / 2;
        double[] x1 = new double[M];
        double[] auxGrad1 = new double[M];
        double[] auxGrad2 = new double[M];
        int i = 0;
        int p = 0;
        while (i < halfM) {
            x1[p] = c[i];
            x1[p + halfM] = c[i + M];
            ++i;
            ++p;
        }
        double f = this.evaluateSimilarityMultiThread(x1, intervals, auxGrad1, only_image, false);
        double[] x2 = new double[M];
        int i2 = halfM;
        int p2 = 0;
        while (i2 < M) {
            x2[p2] = c[i2];
            x2[p2 + halfM] = c[i2 + M];
            ++i2;
            ++p2;
        }
        f += this.evaluateSimilarityMultiThread(x2, intervals, auxGrad2, only_image, true);
        i2 = 0;
        p2 = 0;
        while (i2 < halfM) {
            grad[p2] = auxGrad1[i2];
            grad[p2 + halfM] = auxGrad2[i2];
            grad[p2 + M] = auxGrad1[i2 + halfM];
            grad[p2 + M + halfM] = auxGrad2[i2 + halfM];
            ++i2;
            ++p2;
        }
        double f_consistency = 0.0;
        if (this.consistencyWeight != 0.0) {
            double[] vgradcons = new double[grad.length];
            f_consistency = this.evaluateConsistencyMultiThread(intervals, vgradcons);
            for (int i3 = 0; i3 < grad.length; ++i3) {
                int n = i3;
                grad[n] = grad[n] + vgradcons[i3];
            }
        }
        return f + f_consistency;
    }

    private double evaluateSimilarity(double[] c, int intervals, double[] grad, boolean only_image, boolean show_error, boolean bIsReverse) {
        int cYdim;
        BSplineModel auxTarget = this.target;
        BSplineModel auxSource = this.source;
        Mask auxTargetMsk = this.targetMsk;
        Mask auxSourceMsk = this.sourceMsk;
        PointHandler auxTargetPh = this.targetPh;
        PointHandler auxSourcePh = this.sourcePh;
        BSplineModel swx = this.swxTargetToSource;
        BSplineModel swy = this.swyTargetToSource;
        double auxFactorWidth = this.target.getFactorWidth();
        double auxFactorHeight = this.target.getFactorHeight();
        double[][] P11 = this.P11_TargetToSource;
        double[][] P12 = this.P12_TargetToSource;
        double[][] P22 = this.P22_TargetToSource;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        if (bIsReverse) {
            auxSource = this.target;
            auxTarget = this.source;
            auxSourceMsk = this.targetMsk;
            auxTargetMsk = this.sourceMsk;
            auxSourcePh = this.targetPh;
            auxTargetPh = this.sourcePh;
            swx = this.swxSourceToTarget;
            swy = this.swySourceToTarget;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
            P11 = this.P11_SourceToTarget;
            P12 = this.P12_SourceToTarget;
            P22 = this.P22_SourceToTarget;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
            auxTargetCurrentHeight = this.sourceCurrentHeight;
        }
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] vgradreg = new double[grad.length];
        double[] vgradland = new double[grad.length];
        swx.setCoefficients(c, cYdim, cXdim, 0);
        swy.setCoefficients(c, cYdim, cXdim, Nk);
        for (int k = 0; k < twiceNk; ++k) {
            grad[k] = 0.0;
            vgradland[k] = 0.0;
            vgradreg[k] = 0.0;
        }
        double imageSimilarity = 0.0;
        int Ydim = auxTarget.getCurrentHeight();
        int Xdim = auxTarget.getCurrentWidth();
        double[][] error_image = null;
        double[][] div_error_image = null;
        double[][] curl_error_image = null;
        double[][] laplacian_error_image = null;
        double[][] jacobian_error_image = null;
        if (show_error) {
            error_image = new double[Ydim][Xdim];
            div_error_image = new double[Ydim][Xdim];
            curl_error_image = new double[Ydim][Xdim];
            laplacian_error_image = new double[Ydim][Xdim];
            jacobian_error_image = new double[Ydim][Xdim];
            for (int v = 0; v < Ydim; ++v) {
                for (int u = 0; u < Xdim; ++u) {
                    jacobian_error_image[v][u] = -1.0;
                    laplacian_error_image[v][u] = -1.0;
                    curl_error_image[v][u] = -1.0;
                    div_error_image[v][u] = -1.0;
                    error_image[v][u] = -1.0;
                }
            }
        }
        int n = 0;
        if (this.imageWeight != 0.0 || show_error) {
            double[] xD2 = new double[3];
            double[] yD2 = new double[3];
            double[] xD = new double[2];
            double[] yD = new double[2];
            double[] I1D = new double[2];
            double hx = (Xdim - 1) / intervals;
            double hy = (Ydim - 1) / intervals;
            double[] targetCurrentImage = auxTarget.getCurrentImage();
            int uv = 0;
            for (int v = 0; v < Ydim; ++v) {
                int u = 0;
                while (u < Xdim) {
                    if (auxTargetMsk.getValue((double)u / auxFactorWidth, (double)v / auxFactorHeight)) {
                        double y;
                        double I2 = targetCurrentImage[uv];
                        double x = swx.precomputed_interpolateI(u, v);
                        if (auxSourceMsk.getValue(x / auxFactorWidth, (y = swy.precomputed_interpolateI(u, v)) / auxFactorHeight)) {
                            auxSource.prepareForInterpolation(x, y, true);
                            double I1 = auxSource.interpolateI();
                            auxSource.interpolateD(I1D);
                            double I1dx = I1D[0];
                            double I1dy = I1D[1];
                            double error = I2 - I1;
                            double error2 = error * error;
                            if (show_error) {
                                error_image[v][u] = error;
                            }
                            imageSimilarity += error2;
                            for (int l = 0; l < 4; ++l) {
                                for (int m = 0; m < 4; ++m) {
                                    if (swx.prec_yIndex[v][l] == -1 || swx.prec_xIndex[u][m] == -1) continue;
                                    double weightI = swx.precomputed_getWeightI(l, m, u, v);
                                    int k = swx.prec_yIndex[v][l] * cYdim + swx.prec_xIndex[u][m];
                                    double aux = -error * weightI;
                                    int n2 = k;
                                    grad[n2] = grad[n2] + aux * I1dx;
                                    int n3 = k + Nk;
                                    grad[n3] = grad[n3] + aux * I1dy;
                                }
                            }
                            ++n;
                        }
                    }
                    if (show_error) {
                        double gradcurlx = 0.0;
                        double gradcurly = 0.0;
                        double graddivx = 0.0;
                        double graddivy = 0.0;
                        double xdx = 0.0;
                        double xdy = 0.0;
                        double ydx = 0.0;
                        double ydy = 0.0;
                        double xdxdy = 0.0;
                        double xdxdx = 0.0;
                        double xdydy = 0.0;
                        double ydxdy = 0.0;
                        double ydxdx = 0.0;
                        double ydydy = 0.0;
                        swx.precomputed_interpolateD(xD, u, v);
                        xdx = xD[0] / hx;
                        xdy = xD[1] / hy;
                        swy.precomputed_interpolateD(yD, u, v);
                        ydx = yD[0] / hx;
                        ydy = yD[1] / hy;
                        swx.precomputed_interpolateD2(xD2, u, v);
                        xdxdy = xD2[0];
                        xdxdx = xD2[1];
                        xdydy = xD2[2];
                        swy.precomputed_interpolateD2(yD2, u, v);
                        ydxdy = yD2[0];
                        ydxdx = yD2[1];
                        ydydy = yD2[2];
                        graddivx = xdxdx + ydxdy;
                        graddivy = xdxdy + ydydy;
                        double graddiv = graddivx * graddivx + graddivy * graddivy;
                        double errorgraddiv = this.divWeight * graddiv;
                        div_error_image[v][u] = this.divWeight != 0.0 ? errorgraddiv : graddiv;
                        gradcurlx = -xdxdy + ydxdx;
                        gradcurly = -xdydy + ydxdy;
                        double gradcurl = gradcurlx * gradcurlx + gradcurly * gradcurly;
                        double errorgradcurl = this.curlWeight * gradcurl;
                        curl_error_image[v][u] = this.curlWeight != 0.0 ? errorgradcurl : gradcurl;
                        laplacian_error_image[v][u] = xdxdx * xdxdx;
                        double[] dArray = laplacian_error_image[v];
                        int n4 = u;
                        dArray[n4] = dArray[n4] + xdxdy * xdxdy;
                        double[] dArray2 = laplacian_error_image[v];
                        int n5 = u;
                        dArray2[n5] = dArray2[n5] + xdydy * xdydy;
                        double[] dArray3 = laplacian_error_image[v];
                        int n6 = u;
                        dArray3[n6] = dArray3[n6] + ydxdx * ydxdx;
                        double[] dArray4 = laplacian_error_image[v];
                        int n7 = u;
                        dArray4[n7] = dArray4[n7] + ydxdy * ydxdy;
                        double[] dArray5 = laplacian_error_image[v];
                        int n8 = u;
                        dArray5[n8] = dArray5[n8] + ydydy * ydydy;
                        jacobian_error_image[v][u] = xdx * ydy - xdy * ydx;
                    }
                    ++u;
                    ++uv;
                }
            }
        }
        if (n != 0) {
            imageSimilarity *= this.imageWeight / (double)n;
            double aux = this.imageWeight * 2.0 / (double)n;
            int k = 0;
            while (k < twiceNk) {
                int n9 = k++;
                grad[n9] = grad[n9] * aux;
            }
        } else {
            imageSimilarity = this.imageWeight == 0.0 ? 0.0 : 1.0 / this.FLT_EPSILON;
        }
        double regularization = 0.0;
        if (!only_image) {
            for (int i = 0; i < Nk; ++i) {
                for (int j = 0; j < Nk; ++j) {
                    regularization += c[i] * P11[i][j] * c[j] + c[Nk + i] * P22[i][j] * c[Nk + j] + c[i] * P12[i][j] * c[Nk + j];
                    int n10 = i;
                    vgradreg[n10] = vgradreg[n10] + 2.0 * P11[i][j] * c[j];
                    int n11 = Nk + i;
                    vgradreg[n11] = vgradreg[n11] + 2.0 * P22[i][j] * c[Nk + j];
                    int n12 = i;
                    vgradreg[n12] = vgradreg[n12] + P12[i][j] * c[Nk + j];
                    int n13 = Nk + i;
                    vgradreg[n13] = vgradreg[n13] + P12[j][i] * c[j];
                }
            }
            regularization *= 1.0 / (double)(Ydim * Xdim);
            int k = 0;
            while (k < twiceNk) {
                int n14 = k++;
                vgradreg[n14] = vgradreg[n14] * (1.0 / (double)(Ydim * Xdim));
            }
        }
        double landmarkError = 0.0;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.getPoints().size();
        }
        if (this.landmarkWeight != 0.0) {
            Vector<Point> sourceVector = null;
            sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
            Vector<Point> targetVector = null;
            targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
            for (int kp = 0; kp < K; ++kp) {
                Point sourcePoint = sourceVector.elementAt(kp);
                Point targetPoint = targetVector.elementAt(kp);
                double u = auxFactorWidth * (double)targetPoint.x;
                double v = auxFactorHeight * (double)targetPoint.y;
                double tu = u * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                double tv = v * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, false);
                double x = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, false);
                double y = swy.interpolateI();
                double dx = auxFactorWidth * (double)sourcePoint.x - x;
                double dy = auxFactorHeight * (double)sourcePoint.y - y;
                landmarkError += dx * dx + dy * dy;
                for (int l = 0; l < 4; ++l) {
                    for (int m = 0; m < 4; ++m) {
                        int k;
                        if (swx.yIndex[l] == -1 || swx.xIndex[m] == -1) continue;
                        int n15 = k = swx.yIndex[l] * cYdim + swx.xIndex[m];
                        vgradland[n15] = vgradland[n15] - dx * swx.getWeightI(l, m);
                        int n16 = k + Nk;
                        vgradland[n16] = vgradland[n16] - dy * swy.getWeightI(l, m);
                    }
                }
            }
        }
        if (K != 0) {
            landmarkError *= this.landmarkWeight / (double)K;
            double aux = 2.0 * this.landmarkWeight / (double)K;
            int k = 0;
            while (k < twiceNk) {
                int n17 = k++;
                vgradland[n17] = vgradland[n17] * aux;
            }
        }
        if (only_image) {
            landmarkError = 0.0;
        }
        for (int k = 0; k < twiceNk; ++k) {
            int n18 = k;
            grad[n18] = grad[n18] + (vgradreg[k] + vgradland[k]);
        }
        if (show_error) {
            MiscTools.showImage("Error", error_image);
            MiscTools.showImage("Divergence Error", div_error_image);
            MiscTools.showImage("Curl Error", curl_error_image);
            MiscTools.showImage("Laplacian Error", laplacian_error_image);
            MiscTools.showImage("Jacobian Error", jacobian_error_image);
        }
        if (this.showMarquardtOptim) {
            String s;
            String string = s = bIsReverse ? new String("(t-s)") : new String("(s-t)");
            if (this.imageWeight != 0.0) {
                IJ.log((String)("    Image          error " + s + ": " + imageSimilarity));
                if (bIsReverse) {
                    this.partialInverseSimilarityError = imageSimilarity;
                } else {
                    this.partialDirectSimilarityError = imageSimilarity;
                }
            }
            if (this.landmarkWeight != 0.0) {
                IJ.log((String)("    Landmark       error " + s + ": " + landmarkError));
                if (bIsReverse) {
                    this.partialInverseLandmarkError = landmarkError;
                } else {
                    this.partialDirectLandmarkError = landmarkError;
                }
            }
            if (this.divWeight != 0.0 || this.curlWeight != 0.0) {
                IJ.log((String)("    Regularization error " + s + ": " + regularization));
                if (bIsReverse) {
                    this.partialInverseRegularizationError = regularization;
                } else {
                    this.partialDirectRegularizationError = regularization;
                }
            }
        }
        return imageSimilarity + landmarkError + regularization;
    }

    private double evaluatePartialEnergy(double[] c, int intervals, double[] grad_direct, double[] grad_inverse, boolean only_image, boolean show_error, boolean bIsReverse) {
        int cYdim;
        BSplineModel auxTarget = this.target;
        BSplineModel auxSource = this.source;
        Mask auxTargetMsk = this.targetMsk;
        Mask auxSourceMsk = this.sourceMsk;
        PointHandler auxTargetPh = this.targetPh;
        PointHandler auxSourcePh = this.sourcePh;
        BSplineModel swx = this.swxTargetToSource;
        BSplineModel swy = this.swyTargetToSource;
        BSplineModel swx_inverse = this.swxSourceToTarget;
        BSplineModel swy_inverse = this.swySourceToTarget;
        double auxFactorWidth = this.target.getFactorWidth();
        double auxFactorHeight = this.target.getFactorHeight();
        double[][] P11 = this.P11_TargetToSource;
        double[][] P12 = this.P12_TargetToSource;
        double[][] P22 = this.P22_TargetToSource;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        if (bIsReverse) {
            auxSource = this.target;
            auxTarget = this.source;
            auxSourceMsk = this.targetMsk;
            auxTargetMsk = this.sourceMsk;
            auxSourcePh = this.targetPh;
            auxTargetPh = this.sourcePh;
            swx = this.swxSourceToTarget;
            swy = this.swySourceToTarget;
            swx_inverse = this.swxTargetToSource;
            swy_inverse = this.swyTargetToSource;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
            P11 = this.P11_SourceToTarget;
            P12 = this.P12_SourceToTarget;
            P22 = this.P22_SourceToTarget;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
            auxTargetCurrentHeight = this.sourceCurrentHeight;
        }
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] vgradimg = new double[twiceNk];
        double[] vgradcons = new double[twiceNk];
        double[] vgradreg = new double[twiceNk];
        double[] vgradland = new double[twiceNk];
        swx.setCoefficients(c, cYdim, cXdim, 0);
        swy.setCoefficients(c, cYdim, cXdim, Nk);
        for (int k = 0; k < twiceNk; ++k) {
            grad_inverse[k] = 0.0;
            grad_direct[k] = 0.0;
            vgradimg[k] = 0.0;
            vgradland[k] = 0.0;
            vgradreg[k] = 0.0;
            vgradcons[k] = 0.0;
        }
        double imageSimilarity = 0.0;
        double consistencyError = 0.0;
        int Ydim = auxTarget.getCurrentHeight();
        int Xdim = auxTarget.getCurrentWidth();
        double[][] error_image = null;
        double[][] div_error_image = null;
        double[][] curl_error_image = null;
        double[][] laplacian_error_image = null;
        double[][] jacobian_error_image = null;
        if (show_error) {
            error_image = new double[Ydim][Xdim];
            div_error_image = new double[Ydim][Xdim];
            curl_error_image = new double[Ydim][Xdim];
            laplacian_error_image = new double[Ydim][Xdim];
            jacobian_error_image = new double[Ydim][Xdim];
            for (int v = 0; v < Ydim; ++v) {
                for (int u = 0; u < Xdim; ++u) {
                    jacobian_error_image[v][u] = -1.0;
                    laplacian_error_image[v][u] = -1.0;
                    curl_error_image[v][u] = -1.0;
                    div_error_image[v][u] = -1.0;
                    error_image[v][u] = -1.0;
                }
            }
        }
        int n = 0;
        if (this.imageWeight != 0.0 || show_error) {
            double[] xD2 = new double[3];
            double[] yD2 = new double[3];
            double[] xD = new double[2];
            double[] yD = new double[2];
            double[] I1D = new double[2];
            double hx = (Xdim - 1) / intervals;
            double hy = (Ydim - 1) / intervals;
            double[] targetCurrentImage = auxTarget.getCurrentImage();
            int uv = 0;
            for (int v = 0; v < Ydim; ++v) {
                int u = 0;
                while (u < Xdim) {
                    if (auxTargetMsk.getValue((double)u / auxFactorWidth, (double)v / auxFactorHeight)) {
                        int iy;
                        double I2 = targetCurrentImage[uv];
                        double x = swx.precomputed_interpolateI(u, v);
                        double y = swy.precomputed_interpolateI(u, v);
                        int ix = (int)Math.round(x);
                        if (auxSourceMsk.getValue((double)ix / auxFactorWidth, (double)(iy = (int)Math.round(y)) / auxFactorHeight)) {
                            int k;
                            double weightI;
                            int m;
                            int l;
                            auxSource.prepareForInterpolation(x, y, true);
                            double I1 = auxSource.interpolateI();
                            auxSource.interpolateD(I1D);
                            double I1dx = I1D[0];
                            double I1dy = I1D[1];
                            double error = I2 - I1;
                            double error2 = error * error;
                            if (show_error) {
                                error_image[v][u] = error;
                            }
                            imageSimilarity += error2;
                            double x2 = swx_inverse.precomputed_interpolateI(ix, iy);
                            double y2 = swy_inverse.precomputed_interpolateI(ix, iy);
                            double aux1 = (double)u - x2;
                            double aux2 = (double)v - y2;
                            consistencyError += aux1 * aux1 + aux2 * aux2;
                            for (l = 0; l < 4; ++l) {
                                for (m = 0; m < 4; ++m) {
                                    if (swx.prec_yIndex[v][l] == -1 || swx.prec_xIndex[u][m] == -1) continue;
                                    weightI = swx.precomputed_getWeightI(l, m, u, v);
                                    k = swx.prec_yIndex[v][l] * cYdim + swx.prec_xIndex[u][m];
                                    double aux = -error * weightI;
                                    int n2 = k;
                                    vgradimg[n2] = vgradimg[n2] + aux * I1dx;
                                    int n3 = k + Nk;
                                    vgradimg[n3] = vgradimg[n3] + aux * I1dy;
                                    double dddx = weightI;
                                    double dixx = swx_inverse.precomputed_getWeightDx(l, m, ix, iy);
                                    double diyy = swy_inverse.precomputed_getWeightDy(l, m, ix, iy);
                                    double weightIx = (dixx + diyy) * dddx;
                                    double dddy = weightI;
                                    double dixy = swx_inverse.precomputed_getWeightDy(l, m, ix, iy);
                                    double diyx = swy_inverse.precomputed_getWeightDx(l, m, ix, iy);
                                    double weightIy = (diyx + dixy) * dddy;
                                    int n4 = k;
                                    vgradcons[n4] = vgradcons[n4] + -aux1 * weightIx;
                                    int n5 = k + Nk;
                                    vgradcons[n5] = vgradcons[n5] + -aux2 * weightIy;
                                }
                            }
                            for (l = 0; l < 4; ++l) {
                                for (m = 0; m < 4; ++m) {
                                    if (swx_inverse.prec_yIndex[iy][l] == -1 || swx_inverse.prec_xIndex[ix][m] == -1) continue;
                                    weightI = swx_inverse.precomputed_getWeightI(l, m, ix, iy);
                                    int n6 = k = swx_inverse.prec_yIndex[iy][l] * cYdim + swx_inverse.prec_xIndex[ix][m];
                                    grad_inverse[n6] = grad_inverse[n6] + -aux1 * weightI;
                                    int n7 = k + Nk;
                                    grad_inverse[n7] = grad_inverse[n7] + -aux2 * weightI;
                                }
                            }
                            ++n;
                        }
                    }
                    if (show_error) {
                        double gradcurlx = 0.0;
                        double gradcurly = 0.0;
                        double graddivx = 0.0;
                        double graddivy = 0.0;
                        double xdx = 0.0;
                        double xdy = 0.0;
                        double ydx = 0.0;
                        double ydy = 0.0;
                        double xdxdy = 0.0;
                        double xdxdx = 0.0;
                        double xdydy = 0.0;
                        double ydxdy = 0.0;
                        double ydxdx = 0.0;
                        double ydydy = 0.0;
                        swx.precomputed_interpolateD(xD, u, v);
                        xdx = xD[0] / hx;
                        xdy = xD[1] / hy;
                        swy.precomputed_interpolateD(yD, u, v);
                        ydx = yD[0] / hx;
                        ydy = yD[1] / hy;
                        swx.precomputed_interpolateD2(xD2, u, v);
                        xdxdy = xD2[0];
                        xdxdx = xD2[1];
                        xdydy = xD2[2];
                        swy.precomputed_interpolateD2(yD2, u, v);
                        ydxdy = yD2[0];
                        ydxdx = yD2[1];
                        ydydy = yD2[2];
                        graddivx = xdxdx + ydxdy;
                        graddivy = xdxdy + ydydy;
                        double graddiv = graddivx * graddivx + graddivy * graddivy;
                        double errorgraddiv = this.divWeight * graddiv;
                        div_error_image[v][u] = this.divWeight != 0.0 ? errorgraddiv : graddiv;
                        gradcurlx = -xdxdy + ydxdx;
                        gradcurly = -xdydy + ydxdy;
                        double gradcurl = gradcurlx * gradcurlx + gradcurly * gradcurly;
                        double errorgradcurl = this.curlWeight * gradcurl;
                        curl_error_image[v][u] = this.curlWeight != 0.0 ? errorgradcurl : gradcurl;
                        laplacian_error_image[v][u] = xdxdx * xdxdx;
                        double[] dArray = laplacian_error_image[v];
                        int n8 = u;
                        dArray[n8] = dArray[n8] + xdxdy * xdxdy;
                        double[] dArray2 = laplacian_error_image[v];
                        int n9 = u;
                        dArray2[n9] = dArray2[n9] + xdydy * xdydy;
                        double[] dArray3 = laplacian_error_image[v];
                        int n10 = u;
                        dArray3[n10] = dArray3[n10] + ydxdx * ydxdx;
                        double[] dArray4 = laplacian_error_image[v];
                        int n11 = u;
                        dArray4[n11] = dArray4[n11] + ydxdy * ydxdy;
                        double[] dArray5 = laplacian_error_image[v];
                        int n12 = u;
                        dArray5[n12] = dArray5[n12] + ydydy * ydydy;
                        jacobian_error_image[v][u] = xdx * ydy - xdy * ydx;
                    }
                    ++u;
                    ++uv;
                }
            }
        }
        if (n != 0) {
            consistencyError *= this.consistencyWeight / (double)n;
            double aux = this.consistencyWeight * 2.0 / (double)n;
            int k = 0;
            while (k < vgradcons.length) {
                int n13 = k;
                vgradcons[n13] = vgradcons[n13] * aux;
                int n14 = k++;
                grad_inverse[n14] = grad_inverse[n14] * aux;
            }
            imageSimilarity *= this.imageWeight / (double)n;
            aux = this.imageWeight * 2.0 / (double)n;
            k = 0;
            while (k < twiceNk) {
                int n15 = k++;
                vgradimg[n15] = vgradimg[n15] * aux;
            }
        } else {
            imageSimilarity = this.imageWeight == 0.0 ? 0.0 : 1.0 / this.FLT_EPSILON;
            consistencyError = this.consistencyWeight == 0.0 ? 0.0 : 1.0 / this.FLT_EPSILON;
        }
        double regularization = 0.0;
        if (!only_image) {
            for (int i = 0; i < Nk; ++i) {
                for (int j = 0; j < Nk; ++j) {
                    regularization += c[i] * P11[i][j] * c[j] + c[Nk + i] * P22[i][j] * c[Nk + j] + c[i] * P12[i][j] * c[Nk + j];
                    int n16 = i;
                    vgradreg[n16] = vgradreg[n16] + 2.0 * P11[i][j] * c[j];
                    int n17 = Nk + i;
                    vgradreg[n17] = vgradreg[n17] + 2.0 * P22[i][j] * c[Nk + j];
                    int n18 = i;
                    vgradreg[n18] = vgradreg[n18] + P12[i][j] * c[Nk + j];
                    int n19 = Nk + i;
                    vgradreg[n19] = vgradreg[n19] + P12[j][i] * c[j];
                }
            }
            regularization *= 1.0 / (double)(Ydim * Xdim);
            int k = 0;
            while (k < twiceNk) {
                int n20 = k++;
                vgradreg[n20] = vgradreg[n20] * (1.0 / (double)(Ydim * Xdim));
            }
        }
        double landmarkError = 0.0;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.getPoints().size();
        }
        if (this.landmarkWeight != 0.0) {
            Vector<Point> sourceVector = null;
            sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
            Vector<Point> targetVector = null;
            targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
            for (int kp = 0; kp < K; ++kp) {
                Point sourcePoint = sourceVector.elementAt(kp);
                Point targetPoint = targetVector.elementAt(kp);
                double u = auxFactorWidth * (double)targetPoint.x;
                double v = auxFactorHeight * (double)targetPoint.y;
                double tu = u * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                double tv = v * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, false);
                double x = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, false);
                double y = swy.interpolateI();
                double dx = auxFactorWidth * (double)sourcePoint.x - x;
                double dy = auxFactorHeight * (double)sourcePoint.y - y;
                landmarkError += dx * dx + dy * dy;
                for (int l = 0; l < 4; ++l) {
                    for (int m = 0; m < 4; ++m) {
                        int k;
                        if (swx.yIndex[l] == -1 || swx.xIndex[m] == -1) continue;
                        int n21 = k = swx.yIndex[l] * cYdim + swx.xIndex[m];
                        vgradland[n21] = vgradland[n21] - dx * swx.getWeightI(l, m);
                        int n22 = k + Nk;
                        vgradland[n22] = vgradland[n22] - dy * swy.getWeightI(l, m);
                    }
                }
            }
        }
        if (K != 0) {
            landmarkError *= this.landmarkWeight / (double)K;
            double aux = 2.0 * this.landmarkWeight / (double)K;
            int k = 0;
            while (k < twiceNk) {
                int n23 = k++;
                vgradland[n23] = vgradland[n23] * aux;
            }
        }
        if (only_image) {
            landmarkError = 0.0;
        }
        for (int k = 0; k < twiceNk; ++k) {
            int n24 = k;
            grad_direct[n24] = grad_direct[n24] + (vgradimg[k] + vgradcons[k] + vgradreg[k] + vgradland[k]);
        }
        if (show_error) {
            MiscTools.showImage("Error", error_image);
            MiscTools.showImage("Divergence Error", div_error_image);
            MiscTools.showImage("Curl Error", curl_error_image);
            MiscTools.showImage("Laplacian Error", laplacian_error_image);
            MiscTools.showImage("Jacobian Error", jacobian_error_image);
        }
        if (this.showMarquardtOptim) {
            String s;
            String string = s = bIsReverse ? new String("(t-s)") : new String("(s-t)");
            if (this.imageWeight != 0.0) {
                IJ.log((String)("    Image          error " + s + ": " + imageSimilarity));
                if (bIsReverse) {
                    this.partialInverseSimilarityError = imageSimilarity;
                } else {
                    this.partialDirectSimilarityError = imageSimilarity;
                }
            }
            if (this.consistencyWeight != 0.0) {
                IJ.log((String)("    Consistency          error " + s + ": " + consistencyError));
                if (bIsReverse) {
                    this.partialInverseConsitencyError = consistencyError;
                } else {
                    this.partialDirectConsitencyError = consistencyError;
                }
            }
            if (this.landmarkWeight != 0.0) {
                IJ.log((String)("    Landmark       error " + s + ": " + landmarkError));
                if (bIsReverse) {
                    this.partialInverseLandmarkError = landmarkError;
                } else {
                    this.partialDirectLandmarkError = landmarkError;
                }
            }
            if (this.divWeight != 0.0 || this.curlWeight != 0.0) {
                IJ.log((String)("    Regularization error " + s + ": " + regularization));
                if (bIsReverse) {
                    this.partialInverseRegularizationError = regularization;
                } else {
                    this.partialDirectRegularizationError = regularization;
                }
            }
        }
        return imageSimilarity + consistencyError + landmarkError + regularization;
    }

    private void Marquardt_it(double[] x, boolean[] optimize, double[] gradient, double[] Hessian, double lambda) {
        int i;
        int M = x.length;
        double[] sortedgradient = new double[M];
        for (int i2 = 0; i2 < M; ++i2) {
            sortedgradient[i2] = Math.abs(gradient[i2]);
        }
        Arrays.sort(sortedgradient);
        double largestGradient = sortedgradient[M - 1];
        double gradient_th = 0.09 * largestGradient;
        int Mused = 0;
        for (int i3 = 0; i3 < M; ++i3) {
            if (!(sortedgradient[i3] >= gradient_th)) continue;
            ++Mused;
        }
        double[][] u = new double[Mused][Mused];
        double[] g = new double[Mused];
        double[] update = new double[Mused];
        boolean[] optimizep = new boolean[M];
        System.arraycopy(optimize, 0, optimizep, 0, M);
        lambda += 1.0;
        int m = 0;
        for (i = 0; i < M; ++i) {
            if (optimizep[i] && Math.abs(gradient[i]) >= gradient_th) {
                if (++m != Mused) continue;
                break;
            }
            optimizep[i] = false;
        }
        ++i;
        while (i < M) {
            optimizep[i] = false;
            ++i;
        }
        int kr = 0;
        int iw = 0;
        for (int ir = 0; ir < M; ++ir) {
            if (optimizep[ir]) {
                int jw = 0;
                for (int jr = 0; jr < M; ++jr) {
                    if (!optimizep[jr]) continue;
                    u[iw][jw++] = Hessian[kr + jr];
                }
                g[iw] = gradient[ir];
                double[] dArray = u[iw];
                int n = iw++;
                dArray[n] = dArray[n] * lambda;
            }
            kr += M;
        }
        update = MathTools.linearLeastSquares(u, g);
        if (update == null) {
            IJ.log((String)"Error when calculating linear least square solution...");
            return;
        }
        kr = 0;
        for (int kw = 0; kw < M; ++kw) {
            if (!optimizep[kw]) continue;
            int n = kw;
            x[n] = x[n] - update[kr++];
        }
    }

    private double optimizeCoeffs(int intervals, double thChangef, double[][] cxTargetToSource, double[][] cyTargetToSource, double[][] cxSourceToTarget, double[][] cySourceToTarget) {
        boolean stop;
        int j;
        int i;
        if (this.dialog != null && this.dialog.isStopRegistrationSet()) {
            return 0.0;
        }
        if (this.source.isSubOutput()) {
            IJ.log((String)(" -----\n Intervals = " + intervals + "x" + intervals));
            IJ.log((String)(" Source Image Size = " + this.sourceCurrentWidth + "x" + this.sourceCurrentHeight));
        }
        double TINY = this.FLT_EPSILON;
        double EPS = 3.0E-8f;
        double FIRSTLAMBDA = 1.0;
        int MAXITER_OPTIMCOEFF = 300;
        int CUMULATIVE_SIZE = 5;
        int int3 = intervals + 3;
        int halfM = 2 * int3 * int3;
        int quarterM = halfM / 2;
        int threeQuarterM = quarterM * 3;
        int M = halfM * 2;
        double[] x = new double[M];
        double[] rescuedx = new double[M];
        double[] diffx = new double[M];
        double[] rescuedgrad = new double[M];
        double[] grad = new double[M];
        double[] diffgrad = new double[M];
        double[] Hdx = new double[M];
        double[] rescuedhess = new double[M * M];
        double[] hess = new double[M * M];
        double[] proposedHess = new double[M * M];
        boolean[] optimize = new boolean[M];
        int iter = 1;
        double improvementx = Math.sqrt(TINY);
        double lambda = 1.0;
        CumulativeQueue lastBest = new CumulativeQueue(5);
        for (i = 0; i < M; ++i) {
            optimize[i] = true;
        }
        int p = 0;
        for (i = 0; i < intervals + 3; ++i) {
            j = 0;
            while (j < intervals + 3) {
                x[p] = cxTargetToSource[i][j];
                x[quarterM + p] = cxSourceToTarget[i][j];
                x[halfM + p] = cyTargetToSource[i][j];
                x[threeQuarterM + p] = cySourceToTarget[i][j];
                ++j;
                ++p;
            }
        }
        this.swxTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, 0);
        this.swyTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, halfM);
        this.swxTargetToSource.precomputed_prepareForInterpolation(this.target.getCurrentHeight(), this.target.getCurrentWidth(), intervals);
        this.swyTargetToSource.precomputed_prepareForInterpolation(this.target.getCurrentHeight(), this.target.getCurrentWidth(), intervals);
        this.swxSourceToTarget = new BSplineModel(x, intervals + 3, intervals + 3, quarterM);
        this.swySourceToTarget = new BSplineModel(x, intervals + 3, intervals + 3, threeQuarterM);
        this.swxSourceToTarget.precomputed_prepareForInterpolation(this.source.getCurrentHeight(), this.source.getCurrentWidth(), intervals);
        this.swySourceToTarget.precomputed_prepareForInterpolation(this.source.getCurrentHeight(), this.source.getCurrentWidth(), intervals);
        double f = this.energyFunction(x, intervals, grad, false, false);
        if (this.showMarquardtOptim) {
            IJ.log((String)("f(1)=" + f));
        }
        p = 0;
        for (i = 0; i < M; ++i) {
            j = 0;
            while (j < M) {
                hess[p] = i == j ? 1.0 : 0.0;
                ++j;
                ++p;
            }
        }
        double rescuedf = f;
        p = 0;
        for (i = 0; i < M; ++i) {
            rescuedx[i] = x[i];
            rescuedgrad[i] = grad[i];
            j = 0;
            while (j < M) {
                rescuedhess[p] = hess[p];
                ++j;
                ++p;
            }
        }
        int maxiter = 300 * (this.source.getCurrentDepth() + 1);
        ProgressBar.stepProgressBar();
        int last_successful_iter = 0;
        boolean bl = stop = this.dialog != null && this.dialog.isStopRegistrationSet();
        while (iter < maxiter && !stop) {
            this.Marquardt_it(x, optimize, grad, hess, lambda);
            improvementx = 0.0;
            double max_normx = 0.0;
            for (i = 0; i < M; ++i) {
                diffx[i] = x[i] - rescuedx[i];
                double distx = Math.abs(diffx[i]);
                improvementx += distx * distx;
                double aux = Math.abs(rescuedx[i]) < Math.abs(x[i]) ? x[i] : rescuedx[i];
                max_normx += aux * aux;
            }
            if (TINY < max_normx) {
                improvementx /= max_normx;
            }
            if ((improvementx = Math.sqrt(Math.sqrt(improvementx))) < Math.sqrt(TINY)) break;
            f = this.energyFunction(x, intervals, grad, false, false);
            ++iter;
            if (this.showMarquardtOptim) {
                IJ.log((String)("f(" + iter + ")=" + f + " lambda=" + lambda));
            }
            ProgressBar.stepProgressBar();
            if (rescuedf > f) {
                this.finalDirectConsistencyError = this.partialDirectConsitencyError;
                this.finalDirectSimilarityError = this.partialDirectSimilarityError;
                this.finalDirectRegularizationError = this.partialDirectRegularizationError;
                this.finalDirectLandmarkError = this.partialDirectLandmarkError;
                this.finalInverseConsistencyError = this.partialInverseConsitencyError;
                this.finalInverseSimilarityError = this.partialInverseSimilarityError;
                this.finalInverseRegularizationError = this.partialInverseRegularizationError;
                this.finalInverseLandmarkError = this.partialInverseLandmarkError;
                lastBest.push_back(rescuedf - f);
                if (lastBest.currentSize() == 5 && lastBest.getSum() / f < thChangef) break;
                if (this.showMarquardtOptim) {
                    IJ.log((String)"  Accepted");
                }
                if (last_successful_iter++ % 10 == 0 && this.outputLevel > -1) {
                    this.update_outputs(x, intervals);
                }
                for (i = 0; i < M; ++i) {
                    diffgrad[i] = grad[i] - rescuedgrad[i];
                }
                p = 0;
                for (i = 0; i < M; ++i) {
                    Hdx[i] = 0.0;
                    j = 0;
                    while (j < M) {
                        int n = i;
                        Hdx[n] = Hdx[n] + hess[p] * diffx[j];
                        ++j;
                        ++p;
                    }
                }
                double sumdiffx = 0.0;
                double sumdiffg = 0.0;
                double dxHdx = 0.0;
                double dgdx = 0.0;
                boolean skip_update = true;
                for (i = 0; i < M; ++i) {
                    dgdx += diffgrad[i] * diffx[i];
                    dxHdx += diffx[i] * Hdx[i];
                    sumdiffg += diffgrad[i] * diffgrad[i];
                    sumdiffx += diffx[i] * diffx[i];
                    double gmax = Math.abs(grad[i]) >= Math.abs(rescuedgrad[i]) ? Math.abs(grad[i]) : Math.abs(rescuedgrad[i]);
                    if (gmax == 0.0 || !(Math.abs(diffgrad[i] - Hdx[i]) > Math.sqrt(3.0E-8f) * gmax)) continue;
                    skip_update = false;
                }
                if (dgdx > Math.sqrt((double)3.0E-8f * sumdiffg * sumdiffx) && !skip_update) {
                    double fae = 1.0 / dxHdx;
                    double fac = 1.0 / dgdx;
                    p = 0;
                    for (i = 0; i < M; ++i) {
                        j = 0;
                        while (j < M) {
                            proposedHess[p] = i <= j ? hess[p] + fac * diffgrad[i] * diffgrad[j] - fae * (Hdx[i] * Hdx[j]) : proposedHess[j * M + i];
                            ++j;
                            ++p;
                        }
                    }
                    boolean ill_hessian = false;
                    if (!ill_hessian) {
                        p = 0;
                        for (i = 0; i < M; ++i) {
                            j = 0;
                            while (j < M) {
                                hess[p] = proposedHess[p];
                                ++j;
                                ++p;
                            }
                        }
                    } else if (this.showMarquardtOptim) {
                        IJ.log((String)"Hessian cannot be safely updated, ill-conditioned");
                    }
                } else if (this.showMarquardtOptim) {
                    IJ.log((String)"Hessian cannot be safely updated");
                }
                rescuedf = f;
                p = 0;
                for (i = 0; i < M; ++i) {
                    rescuedx[i] = x[i];
                    rescuedgrad[i] = grad[i];
                    j = 0;
                    while (j < M) {
                        rescuedhess[p] = hess[p];
                        ++j;
                        ++p;
                    }
                }
                if (1.0E-4 < lambda) {
                    lambda /= 10.0;
                }
            } else {
                p = 0;
                for (i = 0; i < M; ++i) {
                    x[i] = rescuedx[i];
                    grad[i] = rescuedgrad[i];
                    j = 0;
                    while (j < M) {
                        hess[p] = rescuedhess[p];
                        ++j;
                        ++p;
                    }
                }
                if (!(lambda < 1.0 / TINY)) break;
                if ((lambda *= 10.0) < 1.0) {
                    lambda = 1.0;
                }
            }
            stop = this.dialog != null && this.dialog.isStopRegistrationSet();
        }
        p = 0;
        for (i = 0; i < intervals + 3; ++i) {
            j = 0;
            while (j < intervals + 3) {
                cxTargetToSource[i][j] = x[p];
                cxSourceToTarget[i][j] = x[quarterM + p];
                cyTargetToSource[i][j] = x[halfM + p];
                cySourceToTarget[i][j] = x[threeQuarterM + p];
                ++j;
                ++p;
            }
        }
        ProgressBar.skipProgressBar(maxiter - iter);
        return f;
    }

    private double optimizeCoeffs(int intervals, double thChangef, double[][] cxTargetToSource, double[][] cyTargetToSource) {
        boolean stop;
        int j;
        int i;
        if (this.source.isSubOutput()) {
            IJ.log((String)(" -----\n Intervals = " + intervals + "x" + intervals));
            IJ.log((String)(" Source Image Size = " + this.sourceCurrentWidth + "x" + this.sourceCurrentHeight));
        }
        if (this.dialog != null && this.dialog.isStopRegistrationSet()) {
            return 0.0;
        }
        double TINY = this.FLT_EPSILON;
        double EPS = 3.0E-8f;
        double FIRSTLAMBDA = 1.0;
        int MAXITER_OPTIMCOEFF = 300;
        int CUMULATIVE_SIZE = 5;
        int int3 = intervals + 3;
        int halfM = int3 * int3;
        int M = halfM * 2;
        double[] x = new double[M];
        double[] rescuedx = new double[M];
        double[] diffx = new double[M];
        double[] rescuedgrad = new double[M];
        double[] grad = new double[M];
        double[] diffgrad = new double[M];
        double[] Hdx = new double[M];
        double[] rescuedhess = new double[M * M];
        double[] hess = new double[M * M];
        double[] proposedHess = new double[M * M];
        boolean[] optimize = new boolean[M];
        int iter = 1;
        double improvementx = Math.sqrt(TINY);
        double lambda = 1.0;
        CumulativeQueue lastBest = new CumulativeQueue(5);
        for (i = 0; i < M; ++i) {
            optimize[i] = true;
        }
        int p = 0;
        for (i = 0; i < intervals + 3; ++i) {
            j = 0;
            while (j < intervals + 3) {
                x[p] = cxTargetToSource[i][j];
                x[halfM + p] = cyTargetToSource[i][j];
                ++j;
                ++p;
            }
        }
        this.swxTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, 0);
        this.swyTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, halfM);
        this.swxTargetToSource.precomputed_prepareForInterpolation(this.target.getCurrentHeight(), this.target.getCurrentWidth(), intervals);
        this.swyTargetToSource.precomputed_prepareForInterpolation(this.target.getCurrentHeight(), this.target.getCurrentWidth(), intervals);
        double f = this.evaluateSimilarityMultiThread(x, intervals, grad, false, false);
        if (this.showMarquardtOptim) {
            IJ.log((String)("f(1)=" + f));
        }
        p = 0;
        for (i = 0; i < M; ++i) {
            j = 0;
            while (j < M) {
                hess[p] = i == j ? 1.0 : 0.0;
                ++j;
                ++p;
            }
        }
        double rescuedf = f;
        p = 0;
        for (i = 0; i < M; ++i) {
            rescuedx[i] = x[i];
            rescuedgrad[i] = grad[i];
            j = 0;
            while (j < M) {
                rescuedhess[p] = hess[p];
                ++j;
                ++p;
            }
        }
        int maxiter = 300 * (this.source.getCurrentDepth() + 1);
        ProgressBar.stepProgressBar();
        int last_successful_iter = 0;
        boolean bl = stop = this.dialog != null && this.dialog.isStopRegistrationSet();
        while (iter < maxiter && !stop) {
            this.Marquardt_it(x, optimize, grad, hess, lambda);
            improvementx = 0.0;
            double max_normx = 0.0;
            for (i = 0; i < M; ++i) {
                diffx[i] = x[i] - rescuedx[i];
                double distx = Math.abs(diffx[i]);
                improvementx += distx * distx;
                double aux = Math.abs(rescuedx[i]) < Math.abs(x[i]) ? x[i] : rescuedx[i];
                max_normx += aux * aux;
            }
            if (TINY < max_normx) {
                improvementx /= max_normx;
            }
            if ((improvementx = Math.sqrt(Math.sqrt(improvementx))) < Math.sqrt(TINY)) break;
            f = this.evaluateSimilarityMultiThread(x, intervals, grad, false, false);
            ++iter;
            if (this.showMarquardtOptim) {
                IJ.log((String)("f(" + iter + ")=" + f + " lambda=" + lambda));
            }
            ProgressBar.stepProgressBar();
            if (rescuedf > f) {
                this.finalDirectConsistencyError = this.partialDirectConsitencyError;
                this.finalDirectSimilarityError = this.partialDirectSimilarityError;
                this.finalDirectRegularizationError = this.partialDirectRegularizationError;
                this.finalDirectLandmarkError = this.partialDirectLandmarkError;
                lastBest.push_back(rescuedf - f);
                if (lastBest.currentSize() == 5 && lastBest.getSum() / f < thChangef) break;
                if (this.showMarquardtOptim) {
                    IJ.log((String)"  Accepted");
                }
                if (last_successful_iter++ % 10 == 0 && this.outputLevel > -1) {
                    this.update_current_output(x, intervals, false);
                }
                for (i = 0; i < M; ++i) {
                    diffgrad[i] = grad[i] - rescuedgrad[i];
                }
                p = 0;
                for (i = 0; i < M; ++i) {
                    Hdx[i] = 0.0;
                    j = 0;
                    while (j < M) {
                        int n = i;
                        Hdx[n] = Hdx[n] + hess[p] * diffx[j];
                        ++j;
                        ++p;
                    }
                }
                double sumdiffx = 0.0;
                double sumdiffg = 0.0;
                double dxHdx = 0.0;
                double dgdx = 0.0;
                boolean skip_update = true;
                for (i = 0; i < M; ++i) {
                    dgdx += diffgrad[i] * diffx[i];
                    dxHdx += diffx[i] * Hdx[i];
                    sumdiffg += diffgrad[i] * diffgrad[i];
                    sumdiffx += diffx[i] * diffx[i];
                    double gmax = Math.abs(grad[i]) >= Math.abs(rescuedgrad[i]) ? Math.abs(grad[i]) : Math.abs(rescuedgrad[i]);
                    if (gmax == 0.0 || !(Math.abs(diffgrad[i] - Hdx[i]) > Math.sqrt(3.0E-8f) * gmax)) continue;
                    skip_update = false;
                }
                if (dgdx > Math.sqrt((double)3.0E-8f * sumdiffg * sumdiffx) && !skip_update) {
                    double fae = 1.0 / dxHdx;
                    double fac = 1.0 / dgdx;
                    p = 0;
                    for (i = 0; i < M; ++i) {
                        j = 0;
                        while (j < M) {
                            proposedHess[p] = i <= j ? hess[p] + fac * diffgrad[i] * diffgrad[j] - fae * (Hdx[i] * Hdx[j]) : proposedHess[j * M + i];
                            ++j;
                            ++p;
                        }
                    }
                    boolean ill_hessian = false;
                    if (!ill_hessian) {
                        p = 0;
                        for (i = 0; i < M; ++i) {
                            j = 0;
                            while (j < M) {
                                hess[p] = proposedHess[p];
                                ++j;
                                ++p;
                            }
                        }
                    } else if (this.showMarquardtOptim) {
                        IJ.log((String)"Hessian cannot be safely updated, ill-conditioned");
                    }
                } else if (this.showMarquardtOptim) {
                    IJ.log((String)"Hessian cannot be safely updated");
                }
                rescuedf = f;
                p = 0;
                for (i = 0; i < M; ++i) {
                    rescuedx[i] = x[i];
                    rescuedgrad[i] = grad[i];
                    j = 0;
                    while (j < M) {
                        rescuedhess[p] = hess[p];
                        ++j;
                        ++p;
                    }
                }
                if (1.0E-4 < lambda) {
                    lambda /= 10.0;
                }
            } else {
                p = 0;
                for (i = 0; i < M; ++i) {
                    x[i] = rescuedx[i];
                    grad[i] = rescuedgrad[i];
                    j = 0;
                    while (j < M) {
                        hess[p] = rescuedhess[p];
                        ++j;
                        ++p;
                    }
                }
                if (!(lambda < 1.0 / TINY)) break;
                if ((lambda *= 10.0) < 1.0) {
                    lambda = 1.0;
                }
            }
            stop = this.dialog != null && this.dialog.isStopRegistrationSet();
        }
        p = 0;
        for (i = 0; i < intervals + 3; ++i) {
            j = 0;
            while (j < intervals + 3) {
                cxTargetToSource[i][j] = x[p];
                cyTargetToSource[i][j] = x[halfM + p];
                ++j;
                ++p;
            }
        }
        ProgressBar.skipProgressBar(maxiter - iter);
        return f;
    }

    private double[][] propagateCoeffsToNextLevel(int intervals, double[][] c, double expansionFactor) {
        int k;
        int j;
        int i;
        double[][] cs_expand = new double[(intervals *= 2) + 7][intervals + 7];
        for (int i2 = 0; i2 < intervals + 7; ++i2) {
            for (int j2 = 0; j2 < intervals + 7; ++j2) {
                if (i2 % 2 == 0 || j2 % 2 == 0) {
                    cs_expand[i2][j2] = 0.0;
                    continue;
                }
                int ipc = (i2 - 1) / 2;
                int jpc = (j2 - 1) / 2;
                cs_expand[i2][j2] = c[ipc][jpc];
            }
        }
        double[][] u2n = new double[4][];
        u2n[0] = null;
        u2n[1] = new double[3];
        u2n[1][0] = 0.5;
        u2n[1][1] = 1.0;
        u2n[1][2] = 0.5;
        u2n[2] = null;
        u2n[3] = new double[5];
        u2n[3][0] = 0.125;
        u2n[3][1] = 0.5;
        u2n[3][2] = 0.75;
        u2n[3][3] = 0.5;
        u2n[3][4] = 0.125;
        int[] half_length_u2n = new int[]{0, 1, 0, 2};
        int kh = half_length_u2n[3];
        double[][] cs_expand_aux = new double[intervals + 7][intervals + 7];
        for (i = 1; i < intervals + 7; i += 2) {
            for (j = 0; j < intervals + 7; ++j) {
                cs_expand_aux[i][j] = 0.0;
                for (k = -kh; k <= kh; ++k) {
                    if (j + k < 0 || j + k > intervals + 6) continue;
                    double[] dArray = cs_expand_aux[i];
                    int n = j;
                    dArray[n] = dArray[n] + u2n[3][k + kh] * cs_expand[i][j + k];
                }
            }
        }
        for (i = 0; i < intervals + 7; ++i) {
            for (j = 0; j < intervals + 7; ++j) {
                cs_expand[i][j] = 0.0;
                for (k = -kh; k <= kh; ++k) {
                    if (i + k < 0 || i + k > intervals + 6) continue;
                    double[] dArray = cs_expand[i];
                    int n = j;
                    dArray[n] = dArray[n] + u2n[3][k + kh] * cs_expand_aux[i + k][j];
                }
            }
        }
        double[][] newc = new double[intervals + 3][intervals + 3];
        for (int i3 = 0; i3 < intervals + 3; ++i3) {
            for (int j3 = 0; j3 < intervals + 3; ++j3) {
                newc[i3][j3] = cs_expand[i3 + 2][j3 + 2] * expansionFactor;
            }
        }
        return newc;
    }

    public void saveDirectTransformation() {
        this.saveTransformation(this.intervals, this.cxTargetToSource, this.cyTargetToSource, false);
    }

    public void saveDirectTransformation(String fileName) {
        MiscTools.saveElasticTransformation(this.intervals, this.cxTargetToSource, this.cyTargetToSource, fileName);
    }

    public void saveInverseTransformation() {
        this.saveTransformation(this.intervals, this.cxSourceToTarget, this.cySourceToTarget, true);
    }

    public void saveInverseTransformation(String fileName) {
        MiscTools.saveElasticTransformation(this.intervals, this.cxSourceToTarget, this.cySourceToTarget, fileName);
    }

    public void loadDirectTransformation(String fileName) {
        MiscTools.loadTransformation(fileName, this.cxTargetToSource, this.cyTargetToSource);
    }

    public void loadInverseTransformation(String fileName) {
        MiscTools.loadTransformation(fileName, this.cxSourceToTarget, this.cySourceToTarget);
    }

    private void saveTransformation(int intervals, double[][] cx, double[][] cy, boolean bIsReverse) {
        String filename = this.fn_tnf_1;
        if (bIsReverse) {
            filename = this.fn_tnf_2;
        }
        if (filename.equals("")) {
            if (this.dialog.isMacroCall()) {
                if (!bIsReverse) {
                    int i0 = this.dialog.getMacroArgs().indexOf("save_direct_transformation=[");
                    if (i0 == -1) {
                        i0 = this.dialog.getMacroArgs().indexOf("save_direct_transformation=");
                        int i1 = this.dialog.getMacroArgs().indexOf(" ", i0 + 26);
                        filename = i1 == -1 ? this.dialog.getMacroArgs().substring(i0 + 27) : this.dialog.getMacroArgs().substring(i0 + 27, i1);
                    } else {
                        int i1 = this.dialog.getMacroArgs().indexOf("]", i0 + 26);
                        String string = filename = i1 == -1 ? this.dialog.getMacroArgs().substring(i0 + 28) : this.dialog.getMacroArgs().substring(i0 + 28, i1);
                    }
                    if (filename.length() == 0) {
                        filename = "./" + this.sourceImp.getTitle() + "_direct_transf.txt";
                    }
                } else {
                    int i0 = this.dialog.getMacroArgs().indexOf("save_inverse_transformation=[");
                    if (i0 == -1) {
                        i0 = this.dialog.getMacroArgs().indexOf("save_inverse_transformation=");
                        int i1 = this.dialog.getMacroArgs().indexOf(" ", i0 + 27);
                        filename = i1 == -1 ? this.dialog.getMacroArgs().substring(i0 + 28) : this.dialog.getMacroArgs().substring(i0 + 28, i1);
                    } else {
                        int i1 = this.dialog.getMacroArgs().indexOf("]", i0 + 27);
                        String string = filename = i1 == -1 ? this.dialog.getMacroArgs().substring(i0 + 29) : this.dialog.getMacroArgs().substring(i0 + 29, i1);
                    }
                    if (filename.length() == 0) {
                        filename = "./" + this.targetImp.getTitle() + "_inverse_transf.txt";
                    }
                }
            } else {
                File dir = new File(".");
                String path = "";
                try {
                    path = dir.getCanonicalPath() + "/";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                filename = bIsReverse ? this.targetImp.getTitle() : this.sourceImp.getTitle();
                String sDirection = bIsReverse ? "_inverse" : "_direct";
                String new_filename = "";
                int dot = filename.lastIndexOf(46);
                new_filename = dot == -1 ? filename + sDirection + "_transf" : filename.substring(0, dot) + sDirection + "_transf";
                filename = path + filename;
                if (this.outputLevel > -1 && this.dialog != null && !this.dialog.isMacroCall()) {
                    SaveDialog sd = new SaveDialog("Save" + sDirection + "_transformation", new_filename, ".txt");
                    path = sd.getDirectory();
                    filename = sd.getFileName();
                    if (path == null || filename == null) {
                        return;
                    }
                    filename = path + filename;
                } else {
                    filename = new_filename;
                }
            }
        }
        MiscTools.saveElasticTransformation(intervals, cx, cy, filename);
    }

    private void computeDeformationGrid(int intervals, double[][] cx, double[][] cy, ImageStack is, boolean bIsReverse) {
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        if (bIsReverse) {
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
        }
        int stepv = Math.min(Math.max(10, auxTargetCurrentHeight / 15), 30);
        int stepu = Math.min(Math.max(10, auxTargetCurrentWidth / 15), 30);
        double[][] transformedImage = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        for (int v = 0; v < auxTargetCurrentHeight; ++v) {
            for (int u = 0; u < auxTargetCurrentWidth; ++u) {
                transformedImage[v][u] = 255.0;
            }
        }
        double[][] transformation_x = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        double[][] transformation_y = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        this.computeDeformation(intervals, cx, cy, transformation_x, transformation_y, bIsReverse);
        for (int v = 0; v < auxTargetCurrentHeight; v += stepv) {
            for (int u = 0; u < auxTargetCurrentWidth; u += stepu) {
                int vv;
                double x = transformation_x[v][u];
                double y = transformation_y[v][u];
                int uh = u + stepu;
                if (uh < auxTargetCurrentWidth) {
                    double xh = transformation_x[v][uh];
                    double yh = transformation_y[v][uh];
                    MiscTools.drawLine(transformedImage, (int)Math.round(x), (int)Math.round(y), (int)Math.round(xh), (int)Math.round(yh), 0.0);
                }
                if ((vv = v + stepv) >= auxTargetCurrentHeight) continue;
                double xv = transformation_x[vv][u];
                double yv = transformation_y[vv][u];
                MiscTools.drawLine(transformedImage, (int)Math.round(x), (int)Math.round(y), (int)Math.round(xv), (int)Math.round(yv), 0.0);
            }
        }
        FloatProcessor fp = new FloatProcessor(auxTargetCurrentWidth, auxTargetCurrentHeight);
        for (int v = 0; v < auxTargetCurrentHeight; ++v) {
            for (int u = 0; u < auxTargetCurrentWidth; ++u) {
                fp.setf(u, v, (float)transformedImage[v][u]);
            }
        }
        if (!(this.originalSourceIP instanceof ColorProcessor)) {
            is.addSlice("Deformation Grid", (ImageProcessor)fp);
        } else {
            is.addSlice("Deformation Grid", fp.convertToRGB());
        }
    }

    private void computeDeformationVectors(int intervals, double[][] cx, double[][] cy, ImageStack is, boolean bIsReverse) {
        Mask auxTargetMsk = this.targetMsk;
        Mask auxSourceMsk = this.sourceMsk;
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        if (bIsReverse) {
            auxTargetMsk = this.sourceMsk;
            auxSourceMsk = this.targetMsk;
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
        }
        int stepv = Math.min(Math.max(10, auxTargetCurrentHeight / 15), 30);
        int stepu = Math.min(Math.max(10, auxTargetCurrentWidth / 15), 30);
        double[][] transformedImage = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        for (int v = 0; v < auxTargetCurrentHeight; ++v) {
            for (int u = 0; u < auxTargetCurrentWidth; ++u) {
                transformedImage[v][u] = 255.0;
            }
        }
        double[][] transformation_x = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        double[][] transformation_y = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        this.computeDeformation(intervals, cx, cy, transformation_x, transformation_y, bIsReverse);
        for (int v = 0; v < auxTargetCurrentHeight; v += stepv) {
            for (int u = 0; u < auxTargetCurrentWidth; u += stepu) {
                double y;
                double x;
                if (!auxTargetMsk.getValue(u, v) || !auxSourceMsk.getValue(x = transformation_x[v][u], y = transformation_y[v][u])) continue;
                MiscTools.drawArrow(transformedImage, u, v, (int)Math.round(x), (int)Math.round(y), 0.0, 2);
            }
        }
        FloatProcessor fp = new FloatProcessor(auxTargetCurrentWidth, auxTargetCurrentHeight);
        for (int v = 0; v < auxTargetCurrentHeight; ++v) {
            for (int u = 0; u < auxTargetCurrentWidth; ++u) {
                fp.setf(u, v, (float)transformedImage[v][u]);
            }
        }
        if (!(this.originalSourceIP instanceof ColorProcessor)) {
            is.addSlice("Deformation Field", (ImageProcessor)fp);
        } else {
            is.addSlice("Deformation Field", fp.convertToRGB());
        }
    }

    public void showDirectResults() {
        this.showTransformationMultiThread(this.intervals, this.cxTargetToSource, this.cyTargetToSource, false);
    }

    public void showInverseResults() {
        this.showTransformationMultiThread(this.intervals, this.cxSourceToTarget, this.cySourceToTarget, true);
    }

    private void showTransformationMultiThread(int intervals, double[][] cx, double[][] cy, boolean bIsReverse) {
        ImagePlus output_ip = !bIsReverse ? this.output_ip_1 : this.output_ip_2;
        IJ.showStatus((String)"Calculating result window...");
        ImagePlus result_imp = this.applyTransformationMultiThread(intervals, cx, cy, bIsReverse);
        output_ip.close();
        output_ip = result_imp;
        output_ip.show();
        output_ip.updateAndRepaintWindow();
    }

    public ImagePlus getDirectResults() {
        return this.applyTransformationMultiThread(this.intervals, this.cxTargetToSource, this.cyTargetToSource, false);
    }

    public ImagePlus getInverseResults() {
        if (this.cySourceToTarget != null && this.cxSourceToTarget != null) {
            return this.applyTransformationMultiThread(this.intervals, this.cxSourceToTarget, this.cySourceToTarget, true);
        }
        return null;
    }

    private ImagePlus applyTransformationMultiThread(int intervals, double[][] cx, double[][] cy, boolean bIsReverse) {
        BSplineModel auxTarget = this.target;
        BSplineModel auxSource = this.source;
        Mask auxTargetMsk = this.targetMsk;
        Mask auxSourceMsk = this.sourceMsk;
        int auxTargetWidth = this.originalTargetIP.getWidth();
        int auxTargetHeight = this.originalTargetIP.getHeight();
        ImageProcessor originalIP = this.originalSourceIP;
        if (bIsReverse) {
            auxTarget = this.source;
            auxSource = this.target;
            auxTargetMsk = this.sourceMsk;
            auxSourceMsk = this.targetMsk;
            auxTargetWidth = this.originalSourceIP.getWidth();
            auxTargetHeight = this.originalSourceIP.getHeight();
            originalIP = this.originalTargetIP;
        }
        ImagePlus output_ip = null;
        ImageStack is = new ImageStack(auxTargetWidth, auxTargetHeight);
        String s = bIsReverse ? new String("Target") : new String("Source");
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        if (!(originalIP instanceof ColorProcessor)) {
            int i;
            FloatProcessor fp = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            FloatProcessor fp_mask = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            FloatProcessor fp_target = new FloatProcessor(auxTargetWidth, auxTargetHeight, auxTarget.getOriginalImage());
            if (auxSource.getOriginalImageWidth() > auxSource.getWidth()) {
                auxSource = new BSplineModel(originalIP, false, 1);
                auxSource.setPyramidDepth(0);
                auxSource.startPyramids();
                try {
                    auxSource.getThread().join();
                }
                catch (InterruptedException e) {
                    IJ.error((String)("Unexpected interruption exception " + e));
                }
            }
            int nproc = Runtime.getRuntime().availableProcessors();
            int block_height = auxTargetHeight / nproc;
            int nThreads = nproc;
            Thread[] threads = new Thread[nThreads];
            Rectangle[] rects = new Rectangle[nThreads];
            FloatProcessor[] fp_tile = new FloatProcessor[nThreads];
            FloatProcessor[] fp_mask_tile = new FloatProcessor[nThreads];
            for (i = 0; i < nThreads; ++i) {
                int y_start = i * block_height;
                if (nThreads - 1 == i) {
                    block_height = auxTargetHeight - i * block_height;
                }
                rects[i] = new Rectangle(0, y_start, auxTargetWidth, block_height);
                fp_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
                fp_mask_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
                threads[i] = new Thread(new GrayscaleResultTileMaker(swx, swy, auxSource, auxTargetWidth, auxTargetHeight, auxTargetMsk, auxSourceMsk, rects[i], fp_tile[i], fp_mask_tile[i]));
                threads[i].start();
            }
            for (i = 0; i < nThreads; ++i) {
                try {
                    threads[i].join();
                    threads[i] = null;
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < nThreads; ++i) {
                fp.insert((ImageProcessor)fp_tile[i], rects[i].x, rects[i].y);
                fp_tile[i] = null;
                fp_mask.insert((ImageProcessor)fp_mask_tile[i], rects[i].x, rects[i].y);
                fp_mask_tile[i] = null;
                rects[i] = null;
            }
            fp.resetMinAndMax();
            is.addSlice("Registered " + s + " Image", (ImageProcessor)fp);
            is.addSlice("Target Image", (ImageProcessor)fp_target);
            is.addSlice("Warped Source Mask", (ImageProcessor)fp_mask);
        } else {
            int i;
            BSplineModel sourceR = new BSplineModel((ImageProcessor)((ColorProcessor)originalIP).toFloat(0, null), false, 1);
            sourceR.setPyramidDepth(0);
            sourceR.startPyramids();
            BSplineModel sourceG = new BSplineModel((ImageProcessor)((ColorProcessor)originalIP).toFloat(1, null), false, 1);
            sourceG.setPyramidDepth(0);
            sourceG.startPyramids();
            BSplineModel sourceB = new BSplineModel((ImageProcessor)((ColorProcessor)originalIP).toFloat(2, null), false, 1);
            sourceB.setPyramidDepth(0);
            sourceB.startPyramids();
            try {
                sourceR.getThread().join();
                sourceG.getThread().join();
                sourceB.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception " + e));
            }
            ColorProcessor cp = new ColorProcessor(auxTargetWidth, auxTargetHeight);
            FloatProcessor fpR = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            FloatProcessor fpG = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            FloatProcessor fpB = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            ColorProcessor cp_mask = new ColorProcessor(auxTargetWidth, auxTargetHeight);
            int nproc = Runtime.getRuntime().availableProcessors();
            int block_height = auxTargetHeight / nproc;
            int nThreads = nproc;
            Thread[] threads = new Thread[nThreads];
            Rectangle[] rects = new Rectangle[nThreads];
            FloatProcessor[] fpR_tile = new FloatProcessor[nThreads];
            FloatProcessor[] fpG_tile = new FloatProcessor[nThreads];
            FloatProcessor[] fpB_tile = new FloatProcessor[nThreads];
            ColorProcessor[] cp_mask_tile = new ColorProcessor[nThreads];
            for (i = 0; i < nThreads; ++i) {
                int y_start = i * block_height;
                if (nThreads - 1 == i) {
                    block_height = auxTargetHeight - i * block_height;
                }
                rects[i] = new Rectangle(0, y_start, auxTargetWidth, block_height);
                fpR_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
                fpG_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
                fpB_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
                cp_mask_tile[i] = new ColorProcessor(rects[i].width, rects[i].height);
                threads[i] = new Thread(new ColorResultTileMaker(swx, swy, sourceR, sourceG, sourceB, auxTargetWidth, auxTargetHeight, auxTargetMsk, auxSourceMsk, rects[i], fpR_tile[i], fpG_tile[i], fpB_tile[i], cp_mask_tile[i]));
                threads[i].start();
            }
            for (i = 0; i < nThreads; ++i) {
                try {
                    threads[i].join();
                    threads[i] = null;
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < nThreads; ++i) {
                fpR.insert((ImageProcessor)fpR_tile[i], rects[i].x, rects[i].y);
                fpG.insert((ImageProcessor)fpG_tile[i], rects[i].x, rects[i].y);
                fpB.insert((ImageProcessor)fpB_tile[i], rects[i].x, rects[i].y);
                fpR_tile[i] = null;
                fpG_tile[i] = null;
                fpB_tile[i] = null;
                cp_mask.insert((ImageProcessor)cp_mask_tile[i], rects[i].x, rects[i].y);
                cp_mask_tile[i] = null;
                rects[i] = null;
            }
            cp.setPixels(0, fpR);
            cp.setPixels(1, fpG);
            cp.setPixels(2, fpB);
            cp.resetMinAndMax();
            is.addSlice("Registered " + s + " Image", (ImageProcessor)cp);
            is.addSlice("Target Image", bIsReverse ? this.originalSourceIP : this.originalTargetIP);
            is.addSlice("Warped Source Mask", (ImageProcessor)cp_mask);
        }
        if (this.outputLevel == 2) {
            this.computeDeformationVectors(intervals, cx, cy, is, bIsReverse);
            this.computeDeformationGrid(intervals, cx, cy, is, bIsReverse);
        }
        output_ip = new ImagePlus("Registered " + s + " Image", is);
        output_ip.setSlice(1);
        output_ip.getProcessor().resetMinAndMax();
        return output_ip;
    }

    private void showTransformation(int intervals, double[][] cx, double[][] cy, boolean bIsReverse) {
        boolean show_deformation = false;
        BSplineModel auxTarget = this.target;
        BSplineModel auxSource = this.source;
        Mask auxTargetMsk = this.targetMsk;
        Mask auxSourceMsk = this.sourceMsk;
        int auxTargetWidth = this.targetWidth;
        int auxTargetHeight = this.targetHeight;
        ImagePlus output_ip = this.output_ip_1;
        ImageProcessor originalIP = this.originalSourceIP;
        if (bIsReverse) {
            auxTarget = this.source;
            auxSource = this.target;
            auxTargetMsk = this.sourceMsk;
            auxSourceMsk = this.targetMsk;
            auxTargetWidth = this.sourceWidth;
            auxTargetHeight = this.sourceHeight;
            output_ip = this.output_ip_2;
            originalIP = this.originalTargetIP;
        }
        if (auxSource.isSubOutput()) {
            output_ip.close();
            output_ip = new ImagePlus();
        }
        double[][] transformation_x = new double[auxTargetHeight][auxTargetWidth];
        double[][] transformation_y = new double[auxTargetHeight][auxTargetWidth];
        this.computeDeformation(intervals, cx, cy, transformation_x, transformation_y, bIsReverse);
        if (show_deformation) {
            MiscTools.showImage("Transf. X", transformation_x);
            MiscTools.showImage("Transf. Y", transformation_y);
        }
        if (!(originalIP instanceof ColorProcessor)) {
            FloatProcessor fp = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            float[] fp_array = (float[])fp.getPixels();
            FloatProcessor fp_mask = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            float[] fp_mask_array = (float[])fp_mask.getPixels();
            FloatProcessor fp_target = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            float[] fp_target_array = (float[])fp_target.getPixels();
            int uv = 0;
            for (int v = 0; v < auxTargetHeight; ++v) {
                int v_offset = v * auxTargetWidth;
                int u = 0;
                while (u < auxTargetWidth) {
                    fp_target_array[u + v_offset] = (float)auxTarget.getImage()[uv];
                    if (!auxTargetMsk.getValue(u, v)) {
                        fp_array[u + v_offset] = 0.0f;
                        fp_mask_array[u + v_offset] = 0.0f;
                    } else {
                        double x = transformation_x[v][u];
                        double y = transformation_y[v][u];
                        if (auxSourceMsk.getValue(x, y)) {
                            auxSource.prepareForInterpolation(x, y, false);
                            double sval = auxSource.interpolateI();
                            fp_array[u + v_offset] = (float)sval;
                            fp_mask_array[u + v_offset] = 255.0f;
                        } else {
                            fp_array[u + v_offset] = 0.0f;
                            fp_mask_array[u + v_offset] = 0.0f;
                        }
                    }
                    ++u;
                    ++uv;
                }
            }
            fp.resetMinAndMax();
            ImageStack is = new ImageStack(auxTargetWidth, auxTargetHeight);
            String s = bIsReverse ? new String("Target") : new String("Source");
            is.addSlice("Registered " + s + " Image", (ImageProcessor)fp);
            if (this.outputLevel > -1) {
                is.addSlice("Target Image", (ImageProcessor)fp_target);
            }
            if (this.outputLevel > -1) {
                is.addSlice("Warped Source Mask", (ImageProcessor)fp_mask);
            }
            if (this.outputLevel == 2) {
                this.computeDeformationVectors(intervals, cx, cy, is, bIsReverse);
                this.computeDeformationGrid(intervals, cx, cy, is, bIsReverse);
            }
            output_ip.setStack("Registered " + s + " Image", is);
            output_ip.setSlice(1);
            output_ip.getProcessor().resetMinAndMax();
            if (this.outputLevel > -1) {
                output_ip.updateAndRepaintWindow();
            }
        } else {
            BSplineModel sourceR = new BSplineModel((ImageProcessor)((ColorProcessor)originalIP).toFloat(0, null), false, 1);
            sourceR.setPyramidDepth(0);
            sourceR.startPyramids();
            BSplineModel sourceG = new BSplineModel((ImageProcessor)((ColorProcessor)originalIP).toFloat(1, null), false, 1);
            sourceG.setPyramidDepth(0);
            sourceG.startPyramids();
            BSplineModel sourceB = new BSplineModel((ImageProcessor)((ColorProcessor)originalIP).toFloat(2, null), false, 1);
            sourceB.setPyramidDepth(0);
            sourceB.startPyramids();
            try {
                sourceR.getThread().join();
                sourceG.getThread().join();
                sourceB.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception " + e));
            }
            ColorProcessor cp = new ColorProcessor(auxTargetWidth, auxTargetHeight);
            FloatProcessor fpR = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            float[] fpR_array = (float[])fpR.getPixels();
            FloatProcessor fpG = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            float[] fpG_array = (float[])fpG.getPixels();
            FloatProcessor fpB = new FloatProcessor(auxTargetWidth, auxTargetHeight);
            float[] fpB_array = (float[])fpB.getPixels();
            ColorProcessor cp_mask = new ColorProcessor(auxTargetWidth, auxTargetHeight);
            for (int v = 0; v < this.targetHeight; ++v) {
                int v_offset = v * auxTargetWidth;
                for (int u = 0; u < this.targetWidth; ++u) {
                    if (!auxTargetMsk.getValue(u, v)) {
                        fpR_array[u + v_offset] = 0.0f;
                        fpG_array[u + v_offset] = 0.0f;
                        fpB_array[u + v_offset] = 0.0f;
                        cp_mask.setf(u, v, 0.0f);
                        continue;
                    }
                    double x = transformation_x[v][u];
                    double y = transformation_y[v][u];
                    if (auxSourceMsk.getValue(x, y)) {
                        sourceR.prepareForInterpolation(x, y, false);
                        fpR_array[u + v_offset] = (float)sourceR.interpolateI();
                        sourceG.prepareForInterpolation(x, y, false);
                        fpG_array[u + v_offset] = (float)sourceG.interpolateI();
                        sourceB.prepareForInterpolation(x, y, false);
                        fpB_array[u + v_offset] = (float)sourceB.interpolateI();
                        cp_mask.setf(u, v, 255.0f);
                        continue;
                    }
                    fpR_array[u + v_offset] = 0.0f;
                    fpG_array[u + v_offset] = 0.0f;
                    fpB_array[u + v_offset] = 0.0f;
                    cp_mask.setf(u, v, 0.0f);
                }
            }
            cp.setPixels(0, fpR);
            cp.setPixels(1, fpG);
            cp.setPixels(2, fpB);
            cp.resetMinAndMax();
            ImageStack is = new ImageStack(auxTargetWidth, auxTargetHeight);
            String s = bIsReverse ? new String("Target") : new String("Source");
            is.addSlice("Registered " + s + " Image", (ImageProcessor)cp);
            if (this.outputLevel > -1) {
                is.addSlice("Target Image", bIsReverse ? this.originalSourceIP : this.originalTargetIP);
            }
            if (this.outputLevel > -1) {
                is.addSlice("Warped Source Mask", (ImageProcessor)cp_mask);
            }
            if (this.outputLevel == 2) {
                this.computeDeformationVectors(intervals, cx, cy, is, bIsReverse);
                this.computeDeformationGrid(intervals, cx, cy, is, bIsReverse);
            }
            output_ip.setStack("Registered " + s + " Image", is);
            output_ip.setSlice(1);
            output_ip.getProcessor().resetMinAndMax();
            if (this.outputLevel > -1) {
                output_ip.updateAndRepaintWindow();
            }
        }
        if (auxSource.isSubOutput()) {
            output_ip.show();
        }
    }

    private void update_outputs(double[] c, int intervals) {
        int M = c.length / 2;
        int halfM = M / 2;
        double[] x1 = new double[M];
        int i = 0;
        int p = 0;
        while (i < halfM) {
            x1[p] = c[i];
            x1[p + halfM] = c[i + M];
            ++i;
            ++p;
        }
        double[] x2 = new double[M];
        int i2 = halfM;
        int p2 = 0;
        while (i2 < M) {
            x2[p2] = c[i2];
            x2[p2 + halfM] = c[i2 + M];
            ++i2;
            ++p2;
        }
        this.update_current_output(x1, intervals, false);
        this.update_current_output(x2, intervals, true);
    }

    private void update_current_output(double[] c, int intervals, boolean bIsReverse) {
        int u;
        int v;
        int i;
        double subFactorHeight;
        int cYdim;
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        BSplineModel auxTarget = this.target;
        BSplineModel auxSource = this.source;
        Mask auxTargetMsk = this.targetMsk;
        Mask auxSourceMsk = this.sourceMsk;
        BSplineModel swx = this.swxTargetToSource;
        BSplineModel swy = this.swyTargetToSource;
        int auxTargetWidth = this.targetWidth;
        int auxTargetHeight = this.targetHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxSourceWidth = this.sourceWidth;
        int auxSourceHeight = this.sourceHeight;
        ImagePlus auxSourceImp = this.sourceImp;
        ImagePlus output_ip = this.output_ip_1;
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        double subFactorWidth = this.target.isSubOutput() ? (double)(this.target.getWidth() / this.target.getSubWidth()) : 1.0;
        double d = subFactorHeight = this.target.isSubOutput() ? (double)(this.target.getHeight() / this.target.getSubHeight()) : 1.0;
        if (bIsReverse) {
            auxTarget = this.source;
            auxSource = this.target;
            auxTargetMsk = this.sourceMsk;
            auxSourceMsk = this.targetMsk;
            swx = this.swxSourceToTarget;
            swy = this.swySourceToTarget;
            auxTargetWidth = this.sourceWidth;
            auxTargetHeight = this.sourceHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxSourceWidth = this.targetWidth;
            auxSourceHeight = this.targetHeight;
            auxSourceImp = this.targetImp;
            output_ip = this.output_ip_2;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
            subFactorWidth = this.source.isSubOutput() ? (double)(this.source.getWidth() / this.source.getSubWidth()) : 1.0;
            subFactorHeight = this.source.isSubOutput() ? (double)(this.source.getHeight() / this.source.getSubHeight()) : 1.0;
        }
        swx.setCoefficients(c, cYdim, cXdim, 0);
        swy.setCoefficients(c, cYdim, cXdim, Nk);
        FloatProcessor fp = (FloatProcessor)output_ip.getProcessor();
        int uv = 0;
        int nproc = Runtime.getRuntime().availableProcessors();
        int block_height = auxTargetHeight / ((int)subFactorHeight * nproc);
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rects = new Rectangle[nThreads];
        FloatProcessor[] fp_tile = new FloatProcessor[nThreads];
        for (i = 0; i < nThreads; ++i) {
            int x_start = i * block_height;
            if (nThreads - 1 == i) {
                block_height = auxTargetHeight / (int)subFactorWidth - i * block_height;
            }
            rects[i] = new Rectangle(0, x_start, auxTargetWidth / (int)subFactorWidth, block_height);
            fp_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
            threads[i] = new Thread(new OutputTileMaker(swx, swy, auxSource, auxTarget, auxSourceMsk, auxTargetMsk, auxFactorWidth * subFactorWidth, auxFactorHeight * subFactorHeight, auxTargetCurrentHeight, auxTargetCurrentWidth, rects[i], fp_tile[i]));
            threads[i].start();
        }
        for (i = 0; i < nThreads; ++i) {
            try {
                threads[i].join();
                threads[i] = null;
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < nThreads; ++i) {
            fp.insert((ImageProcessor)fp_tile[i], rects[i].x, rects[i].y);
            fp_tile[i] = null;
            rects[i] = null;
        }
        double min_val = output_ip.getProcessor().getMin();
        double max_val = output_ip.getProcessor().getMax();
        fp.setMinAndMax(min_val, max_val);
        output_ip.updateAndDraw();
        auxTargetHeight = bIsReverse ? this.originalSourceIP.getHeight() : this.originalTargetIP.getHeight();
        auxTargetWidth = bIsReverse ? this.originalSourceIP.getWidth() : this.originalTargetIP.getWidth();
        auxSourceHeight = bIsReverse ? this.originalTargetIP.getHeight() : this.originalSourceIP.getHeight();
        auxSourceWidth = bIsReverse ? this.originalTargetIP.getWidth() : this.originalSourceIP.getWidth();
        auxFactorWidth = (double)auxTargetCurrentWidth / (double)auxTargetWidth;
        auxFactorHeight = (double)auxTargetCurrentHeight / (double)auxTargetHeight;
        int stepv = Math.min(Math.max(10, auxTargetHeight / 15), 60);
        int stepu = Math.min(Math.max(10, auxTargetWidth / 15), 60);
        double[][] transformedImage = new double[auxSourceHeight][auxSourceWidth];
        double grid_colour = -1.0E-10;
        uv = 0;
        for (v = 0; v < auxSourceHeight; ++v) {
            u = 0;
            while (u < auxSourceWidth) {
                transformedImage[v][u] = auxSource.getOriginalImage()[uv];
                if (transformedImage[v][u] > grid_colour) {
                    grid_colour = transformedImage[v][u];
                }
                ++u;
                ++uv;
            }
        }
        for (v = 0; v < auxTargetHeight + stepv; v += stepv) {
            for (u = 0; u < auxTargetWidth + stepu; u += stepu) {
                int vv;
                double down_u = (double)u * auxFactorWidth;
                double down_v = (double)v * auxFactorHeight;
                double tv = down_v * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                double tu = down_u * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, false);
                double x = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, false);
                double y = swy.interpolateI();
                double up_x = x / auxFactorWidth;
                double up_y = y / auxFactorHeight;
                int uh = u + stepu;
                if (uh < auxTargetWidth + stepu) {
                    double down_uh = (double)uh * auxFactorWidth;
                    double tuh = down_uh * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                    swx.prepareForInterpolation(tuh, tv, false);
                    double xh = swx.interpolateI();
                    swy.prepareForInterpolation(tuh, tv, false);
                    double yh = swy.interpolateI();
                    double up_xh = xh / auxFactorWidth;
                    double up_yh = yh / auxFactorHeight;
                    MiscTools.drawLine(transformedImage, (int)Math.round(up_x), (int)Math.round(up_y), (int)Math.round(up_xh), (int)Math.round(up_yh), grid_colour);
                }
                if ((vv = v + stepv) >= auxTargetHeight + stepv) continue;
                double down_vv = (double)vv * auxFactorHeight;
                double tvv = down_vv * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                swx.prepareForInterpolation(tu, tvv, false);
                double xv = swx.interpolateI();
                swy.prepareForInterpolation(tu, tvv, false);
                double yv = swy.interpolateI();
                double up_xv = xv / auxFactorWidth;
                double up_yv = yv / auxFactorHeight;
                MiscTools.drawLine(transformedImage, (int)Math.round(up_x), (int)Math.round(up_y), (int)Math.round(up_xv), (int)Math.round(up_yv), grid_colour);
            }
        }
        FloatProcessor fpg = new FloatProcessor(auxSourceWidth, auxSourceHeight);
        for (int v2 = 0; v2 < auxSourceHeight; ++v2) {
            for (int u2 = 0; u2 < auxSourceWidth; ++u2) {
                fpg.setf(u2, v2, (float)transformedImage[v2][u2]);
            }
        }
        min_val = auxSourceImp.getProcessor().getMin();
        max_val = auxSourceImp.getProcessor().getMax();
        fpg.setMinAndMax(min_val, max_val);
        if (auxSourceImp.getImageStackSize() < 2) {
            auxSourceImp.setProcessor(auxSourceImp.getTitle(), (ImageProcessor)fpg);
        } else {
            Object ipToDisplay = auxSourceImp.getProcessor() instanceof ByteProcessor ? fpg.convertToByte(false) : (auxSourceImp.getProcessor() instanceof ShortProcessor ? fpg.convertToShort(false) : fpg);
            auxSourceImp.setProcessor(auxSourceImp.getTitle(), ipToDisplay);
        }
        auxSourceImp.updateImage();
    }

    private double[] xWeight(double x, int xIntervals, boolean extended, boolean bIsReverse) {
        int auxTargetCurrentWidth = bIsReverse ? this.sourceCurrentWidth : this.targetCurrentWidth;
        int length = xIntervals + 1;
        int j0 = 0;
        int jF = xIntervals;
        if (extended) {
            length += 2;
            --j0;
            ++jF;
        }
        double[] b = new double[length];
        double interX = (double)xIntervals / (double)(auxTargetCurrentWidth - 1);
        for (int j = j0; j <= jF; ++j) {
            b[j - j0] = MathTools.Bspline03(x * interX - (double)j);
        }
        return b;
    }

    private double[] yWeight(double y, int yIntervals, boolean extended, boolean bIsReverse) {
        int auxTargetCurrentHeight = bIsReverse ? this.sourceCurrentHeight : this.targetCurrentHeight;
        int length = yIntervals + 1;
        int i0 = 0;
        int iF = yIntervals;
        if (extended) {
            length += 2;
            --i0;
            ++iF;
        }
        double[] b = new double[length];
        double interY = (double)yIntervals / (double)(auxTargetCurrentHeight - 1);
        for (int i = i0; i <= iF; ++i) {
            b[i - i0] = MathTools.Bspline03(y * interY - (double)i);
        }
        return b;
    }

    private double evaluateSimilarityMultiThread(double[] c, int intervals, double[] grad, boolean only_image, boolean bIsReverse) {
        int cYdim;
        BSplineModel auxTarget = !bIsReverse ? this.target : this.source;
        BSplineModel auxSource = !bIsReverse ? this.source : this.target;
        Mask auxTargetMsk = !bIsReverse ? this.targetMsk : this.sourceMsk;
        Mask auxSourceMsk = !bIsReverse ? this.sourceMsk : this.targetMsk;
        PointHandler auxTargetPh = !bIsReverse ? this.targetPh : this.sourcePh;
        PointHandler auxSourcePh = !bIsReverse ? this.sourcePh : this.targetPh;
        BSplineModel swx = !bIsReverse ? this.swxTargetToSource : this.swxSourceToTarget;
        BSplineModel swy = !bIsReverse ? this.swyTargetToSource : this.swySourceToTarget;
        double auxFactorWidth = !bIsReverse ? this.target.getFactorWidth() : this.sourceFactorWidth;
        double auxFactorHeight = !bIsReverse ? this.target.getFactorHeight() : this.sourceFactorHeight;
        double[][] P11 = !bIsReverse ? this.P11_TargetToSource : this.P11_SourceToTarget;
        double[][] P12 = !bIsReverse ? this.P12_TargetToSource : this.P12_SourceToTarget;
        double[][] P22 = !bIsReverse ? this.P22_TargetToSource : this.P12_SourceToTarget;
        int auxTargetCurrentWidth = !bIsReverse ? this.targetCurrentWidth : this.sourceCurrentWidth;
        int auxTargetCurrentHeight = !bIsReverse ? this.targetCurrentHeight : this.sourceCurrentHeight;
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] vgradreg = new double[grad.length];
        double[] vgradland = new double[grad.length];
        swx.setCoefficients(c, cYdim, cXdim, 0);
        swy.setCoefficients(c, cYdim, cXdim, Nk);
        for (int k = 0; k < twiceNk; ++k) {
            grad[k] = 0.0;
            vgradland[k] = 0.0;
            vgradreg[k] = 0.0;
        }
        double imageSimilarity = 0.0;
        if (this.imageWeight != 0.0) {
            int i;
            int nproc = Runtime.getRuntime().availableProcessors();
            int block_height = auxTargetCurrentHeight / nproc;
            int nThreads = nproc;
            Thread[] threads = new Thread[nThreads];
            Rectangle[] rects = new Rectangle[nThreads];
            double[][] grad_thread = new double[nThreads][grad.length];
            double[][] result = new double[nThreads][2];
            int n = 0;
            for (i = 0; i < nThreads; ++i) {
                int y_start = i * block_height;
                if (nThreads - 1 == i) {
                    block_height = auxTargetCurrentHeight - i * block_height;
                }
                rects[i] = new Rectangle(0, y_start, auxTargetCurrentWidth, block_height);
                threads[i] = new Thread(new EvaluateSimilarityTile(auxTarget, auxSource, auxTargetMsk, auxSourceMsk, swx, swy, auxFactorWidth, auxFactorHeight, intervals, grad_thread[i], result[i], rects[i]));
                threads[i].start();
            }
            for (i = 0; i < nThreads; ++i) {
                try {
                    threads[i].join();
                    threads[i] = null;
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < nThreads; ++i) {
                imageSimilarity += result[i][0];
                n = (int)((double)n + result[i][1]);
            }
            imageSimilarity /= (double)n;
            for (i = 0; i < nThreads; ++i) {
                for (int j = 0; j < grad.length; ++j) {
                    int n2 = j;
                    grad[n2] = grad[n2] + grad_thread[i][j] / (double)n;
                }
            }
        }
        double regularization = 0.0;
        if (!only_image) {
            for (int i = 0; i < Nk; ++i) {
                for (int j = 0; j < Nk; ++j) {
                    regularization += c[i] * P11[i][j] * c[j] + c[Nk + i] * P22[i][j] * c[Nk + j] + c[i] * P12[i][j] * c[Nk + j];
                    int n = i;
                    vgradreg[n] = vgradreg[n] + 2.0 * P11[i][j] * c[j];
                    int n3 = Nk + i;
                    vgradreg[n3] = vgradreg[n3] + 2.0 * P22[i][j] * c[Nk + j];
                    int n4 = i;
                    vgradreg[n4] = vgradreg[n4] + P12[i][j] * c[Nk + j];
                    int n5 = Nk + i;
                    vgradreg[n5] = vgradreg[n5] + P12[j][i] * c[j];
                }
            }
            regularization *= 1.0 / (double)(auxTargetCurrentHeight * auxTargetCurrentWidth);
            int k = 0;
            while (k < twiceNk) {
                int n = k++;
                vgradreg[n] = vgradreg[n] * (1.0 / (double)(auxTargetCurrentHeight * auxTargetCurrentWidth));
            }
        }
        double landmarkError = 0.0;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.getPoints().size();
        }
        if (this.landmarkWeight != 0.0) {
            Vector<Point> sourceVector = null;
            sourceVector = auxSourcePh != null ? auxSourcePh.getPoints() : new Vector();
            Vector<Point> targetVector = null;
            targetVector = auxTargetPh != null ? auxTargetPh.getPoints() : new Vector();
            for (int kp = 0; kp < K; ++kp) {
                Point sourcePoint = sourceVector.elementAt(kp);
                Point targetPoint = targetVector.elementAt(kp);
                double u = auxFactorWidth * (double)targetPoint.x;
                double v = auxFactorHeight * (double)targetPoint.y;
                double tu = u * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                double tv = v * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, false);
                double x = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, false);
                double y = swy.interpolateI();
                double dx = auxFactorWidth * (double)sourcePoint.x - x;
                double dy = auxFactorHeight * (double)sourcePoint.y - y;
                landmarkError += dx * dx + dy * dy;
                for (int l = 0; l < 4; ++l) {
                    for (int m = 0; m < 4; ++m) {
                        int k;
                        if (swx.yIndex[l] == -1 || swx.xIndex[m] == -1) continue;
                        int n = k = swx.yIndex[l] * cYdim + swx.xIndex[m];
                        vgradland[n] = vgradland[n] - dx * swx.getWeightI(l, m);
                        int n6 = k + Nk;
                        vgradland[n6] = vgradland[n6] - dy * swy.getWeightI(l, m);
                    }
                }
            }
        }
        if (K != 0) {
            landmarkError *= this.landmarkWeight / (double)K;
            double aux = 2.0 * this.landmarkWeight / (double)K;
            int k = 0;
            while (k < twiceNk) {
                int n = k++;
                vgradland[n] = vgradland[n] * aux;
            }
        }
        if (only_image) {
            landmarkError = 0.0;
        }
        for (int k = 0; k < twiceNk; ++k) {
            int n = k;
            grad[n] = grad[n] + (vgradreg[k] + vgradland[k]);
        }
        if (this.showMarquardtOptim) {
            String s;
            String string = s = bIsReverse ? new String("(t-s)") : new String("(s-t)");
            if (this.imageWeight != 0.0) {
                IJ.log((String)("    Image          error " + s + ": " + imageSimilarity));
                if (bIsReverse) {
                    this.partialInverseSimilarityError = imageSimilarity;
                } else {
                    this.partialDirectSimilarityError = imageSimilarity;
                }
            }
            if (this.landmarkWeight != 0.0) {
                IJ.log((String)("    Landmark       error " + s + ": " + landmarkError));
                if (bIsReverse) {
                    this.partialInverseLandmarkError = landmarkError;
                } else {
                    this.partialDirectLandmarkError = landmarkError;
                }
            }
            if (this.divWeight != 0.0 || this.curlWeight != 0.0) {
                IJ.log((String)("    Regularization error " + s + ": " + regularization));
                if (bIsReverse) {
                    this.partialInverseRegularizationError = regularization;
                } else {
                    this.partialDirectRegularizationError = regularization;
                }
            }
        }
        return imageSimilarity + landmarkError + regularization;
    }

    private double evaluateConsistencyMultiThread(int intervals, double[] grad) {
        double consistencyInverseError;
        int i;
        double f_direct = 0.0;
        double f_inverse = 0.0;
        int nproc = Runtime.getRuntime().availableProcessors();
        int block_height_target = this.targetCurrentHeight / nproc;
        int block_height_source = this.sourceCurrentHeight / nproc;
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rect_target = new Rectangle[nThreads];
        Rectangle[] rect_source = new Rectangle[nThreads];
        double[][] grad_direct = new double[nThreads][grad.length];
        double[][] grad_inverse = new double[nThreads][grad.length];
        double[][] result = new double[nThreads][4];
        int n_direct = 0;
        int n_inverse = 0;
        for (i = 0; i < nThreads; ++i) {
            int y_start_target = i * block_height_target;
            int y_start_source = i * block_height_source;
            if (nThreads - 1 == i) {
                block_height_target = this.targetCurrentHeight - i * block_height_target;
                block_height_source = this.sourceCurrentHeight - i * block_height_source;
            }
            rect_target[i] = new Rectangle(0, y_start_target, this.targetCurrentWidth, block_height_target);
            rect_source[i] = new Rectangle(0, y_start_source, this.sourceCurrentWidth, block_height_source);
            threads[i] = new Thread(new EvaluateConsistencyTile(this, grad_direct[i], grad_inverse[i], result[i], rect_target[i], rect_source[i]));
            threads[i].start();
        }
        for (i = 0; i < nThreads; ++i) {
            try {
                threads[i].join();
                threads[i] = null;
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < nThreads; ++i) {
            f_direct += result[i][0];
            n_direct = (int)((double)n_direct + result[i][1]);
            f_inverse += result[i][2];
            n_inverse = (int)((double)n_inverse + result[i][3]);
        }
        f_direct /= (double)n_direct;
        f_inverse /= (double)n_inverse;
        for (i = 0; i < nThreads; ++i) {
            for (int j = 0; j < grad.length; ++j) {
                int n = j;
                grad[n] = grad[n] + (grad_direct[i][j] / (double)n_direct + grad_inverse[i][j] / (double)n_inverse);
            }
        }
        this.partialDirectConsitencyError = this.consistencyWeight * f_direct;
        this.partialInverseConsitencyError = this.consistencyWeight * f_inverse;
        double consistencyDirectError = n_direct == 0 ? 1.0 / this.FLT_EPSILON : this.consistencyWeight * f_direct;
        double d = consistencyInverseError = n_inverse == 0 ? 1.0 / this.FLT_EPSILON : this.consistencyWeight * f_inverse;
        if (this.showMarquardtOptim) {
            IJ.log((String)("    Consistency Error (s-t): " + consistencyDirectError));
            IJ.log((String)("    Consistency Error (t-s): " + consistencyInverseError));
        }
        if (n_direct == 0 || n_inverse == 0) {
            return 1.0 / this.FLT_EPSILON;
        }
        return this.consistencyWeight * (f_direct + f_inverse);
    }

    public void setShearCorrection(double shearCorrection) {
        if (shearCorrection >= 0.0 && shearCorrection <= 1.0) {
            this.tweakShear = shearCorrection;
        }
    }

    public void setScaleCorrection(double scaleCorrection) {
        if (scaleCorrection >= 0.0 && scaleCorrection <= 1.0) {
            this.tweakScale = scaleCorrection;
        }
    }

    public void setAnisotropyCorrection(double isoCorrection) {
        if (isoCorrection >= 0.0 && isoCorrection <= 1.0) {
            this.tweakIso = isoCorrection;
        }
    }

    private class EvaluateConsistencyTile
    implements Runnable {
        final Transformation transf;
        final double[] grad_direct;
        final double[] grad_inverse;
        final double[] result;
        final Rectangle rect_target;
        final Rectangle rect_source;

        EvaluateConsistencyTile(Transformation transf, double[] grad_direct, double[] grad_inverse, double[] result, Rectangle rect_target, Rectangle rect_source) {
            this.transf = transf;
            this.grad_direct = grad_direct;
            this.grad_inverse = grad_inverse;
            this.result = result;
            this.rect_target = rect_target;
            this.rect_source = rect_source;
        }

        @Override
        public void run() {
            int cYdim;
            int cXdim = cYdim = this.transf.intervals + 3;
            int Nk = cYdim * cXdim;
            int twiceNk = 2 * Nk;
            for (int k = 0; k < this.grad_direct.length; ++k) {
                this.grad_direct[k] = 0.0;
            }
            int YdimT = this.rect_target.y + this.rect_target.height;
            int XdimT = this.rect_target.x + this.rect_target.width;
            BSplineModel swx_direct = this.transf.swxTargetToSource;
            BSplineModel swy_direct = this.transf.swyTargetToSource;
            BSplineModel swx_inverse = this.transf.swxSourceToTarget;
            BSplineModel swy_inverse = this.transf.swySourceToTarget;
            double f_direct = 0.0;
            int n_direct = 0;
            for (int v = this.rect_target.y; v < YdimT; ++v) {
                for (int u = this.rect_target.x; u < XdimT; ++u) {
                    int m;
                    int l;
                    if (!this.transf.targetMsk.getValue((double)u / this.transf.targetFactorWidth, (double)v / this.transf.targetFactorHeight)) continue;
                    int x = (int)Math.round(swx_direct.precomputed_interpolateI(u, v));
                    int y = (int)Math.round(swy_direct.precomputed_interpolateI(u, v));
                    if (x < 0 || x >= this.transf.sourceCurrentWidth || y < 0 || y >= this.transf.sourceCurrentHeight) continue;
                    double x2 = swx_inverse.precomputed_interpolateI(x, y);
                    double y2 = swy_inverse.precomputed_interpolateI(x, y);
                    double aux1 = (double)u - x2;
                    double aux2 = (double)v - y2;
                    f_direct += aux1 * aux1 + aux2 * aux2;
                    for (l = 0; l < 4; ++l) {
                        for (m = 0; m < 4; ++m) {
                            int k;
                            if (swx_direct.prec_yIndex[v][l] == -1 || swx_direct.prec_xIndex[u][m] == -1) continue;
                            double dddx = swx_direct.precomputed_getWeightI(l, m, u, v);
                            double dixx = swx_inverse.precomputed_getWeightDx(l, m, x, y);
                            double diyy = swy_inverse.precomputed_getWeightDy(l, m, x, y);
                            double weightIx = (dixx + diyy) * dddx;
                            double dddy = swy_direct.precomputed_getWeightI(l, m, u, v);
                            double dixy = swx_inverse.precomputed_getWeightDy(l, m, x, y);
                            double diyx = swy_inverse.precomputed_getWeightDx(l, m, x, y);
                            double weightIy = (diyx + dixy) * dddy;
                            int n = k = swx_direct.prec_yIndex[v][l] * cYdim + swx_direct.prec_xIndex[u][m];
                            this.grad_direct[n] = this.grad_direct[n] + -aux1 * weightIx;
                            int n2 = k + twiceNk;
                            this.grad_direct[n2] = this.grad_direct[n2] + -aux2 * weightIy;
                        }
                    }
                    for (l = 0; l < 4; ++l) {
                        for (m = 0; m < 4; ++m) {
                            if (swx_inverse.prec_yIndex[y][l] == -1 || swx_inverse.prec_xIndex[x][m] == -1) continue;
                            double weightI = swx_inverse.precomputed_getWeightI(l, m, x, y);
                            int k = swx_inverse.prec_yIndex[y][l] * cYdim + swx_inverse.prec_xIndex[x][m];
                            int n = k + Nk;
                            this.grad_direct[n] = this.grad_direct[n] + -aux1 * weightI;
                            int n3 = k + Nk + twiceNk;
                            this.grad_direct[n3] = this.grad_direct[n3] + -aux2 * weightI;
                        }
                    }
                    ++n_direct;
                }
            }
            if (n_direct != 0) {
                double aux = Transformation.this.consistencyWeight * 2.0;
                int k = 0;
                while (k < this.grad_direct.length) {
                    int n = k++;
                    this.grad_direct[n] = this.grad_direct[n] * aux;
                }
            }
            for (int k = 0; k < this.grad_inverse.length; ++k) {
                this.grad_inverse[k] = 0.0;
            }
            int YdimS = this.rect_source.y + this.rect_source.height;
            int XdimS = this.rect_source.x + this.rect_source.width;
            double f_inverse = 0.0;
            int n_inverse = 0;
            for (int v = this.rect_source.y; v < YdimS; ++v) {
                for (int u = this.rect_source.x; u < XdimS; ++u) {
                    int m;
                    int l;
                    if (!this.transf.sourceMsk.getValue((double)u / this.transf.sourceFactorWidth, (double)v / this.transf.sourceFactorHeight)) continue;
                    int x = (int)Math.round(swx_inverse.precomputed_interpolateI(u, v));
                    int y = (int)Math.round(swy_inverse.precomputed_interpolateI(u, v));
                    if (x < 0 || x >= this.transf.targetCurrentWidth || y < 0 || y >= this.transf.targetCurrentHeight) continue;
                    double x2 = swx_direct.precomputed_interpolateI(x, y);
                    double y2 = swy_direct.precomputed_interpolateI(x, y);
                    double aux1 = (double)u - x2;
                    double aux2 = (double)v - y2;
                    f_inverse += aux1 * aux1 + aux2 * aux2;
                    for (l = 0; l < 4; ++l) {
                        for (m = 0; m < 4; ++m) {
                            int k;
                            if (swx_direct.prec_yIndex[y][l] == -1 || swx_direct.prec_xIndex[x][m] == -1) continue;
                            double weightI = swx_direct.precomputed_getWeightI(l, m, x, y);
                            int n = k = swx_direct.prec_yIndex[y][l] * cYdim + swx_direct.prec_xIndex[x][m];
                            this.grad_inverse[n] = this.grad_inverse[n] + -aux1 * weightI;
                            int n4 = k + twiceNk;
                            this.grad_inverse[n4] = this.grad_inverse[n4] + -aux2 * weightI;
                        }
                    }
                    for (l = 0; l < 4; ++l) {
                        for (m = 0; m < 4; ++m) {
                            if (swx_inverse.prec_yIndex[v][l] == -1 || swx_inverse.prec_xIndex[u][m] == -1) continue;
                            double diix = swx_inverse.precomputed_getWeightI(l, m, u, v);
                            double ddxx = swx_direct.precomputed_getWeightDx(l, m, x, y);
                            double ddyy = swy_direct.precomputed_getWeightDy(l, m, x, y);
                            double weightIx = (ddxx + ddyy) * diix;
                            double diiy = swy_inverse.precomputed_getWeightI(l, m, u, v);
                            double ddxy = swx_direct.precomputed_getWeightDy(l, m, x, y);
                            double ddyx = swy_direct.precomputed_getWeightDx(l, m, x, y);
                            double weightIy = (ddyx + ddxy) * diiy;
                            int k = swx_inverse.prec_yIndex[v][l] * cYdim + swx_inverse.prec_xIndex[u][m];
                            int n = k + Nk;
                            this.grad_inverse[n] = this.grad_inverse[n] + -aux1 * weightIx;
                            int n5 = k + Nk + twiceNk;
                            this.grad_inverse[n5] = this.grad_inverse[n5] + -aux2 * weightIy;
                        }
                    }
                    ++n_inverse;
                }
            }
            if (n_inverse != 0) {
                double aux = Transformation.this.consistencyWeight * 2.0;
                int k = 0;
                while (k < this.grad_inverse.length) {
                    int n = k++;
                    this.grad_inverse[n] = this.grad_inverse[n] * aux;
                }
            }
            this.result[0] = f_direct;
            this.result[1] = n_direct;
            this.result[2] = f_inverse;
            this.result[3] = n_inverse;
        }
    }

    private class EvaluateSimilarityTile
    implements Runnable {
        final BSplineModel auxTarget;
        final BSplineModel auxSource;
        final Mask auxTargetMsk;
        final Mask auxSourceMsk;
        final BSplineModel swx;
        final BSplineModel swy;
        final double auxFactorWidth;
        final double auxFactorHeight;
        final int intervals;
        final double[] grad;
        final double[] result;
        final Rectangle rect;

        EvaluateSimilarityTile(BSplineModel auxTarget, BSplineModel auxSource, Mask auxTargetMsk, Mask auxSourceMsk, BSplineModel swx, BSplineModel swy, double auxFactorWidth, double auxFactorHeight, int intervals, double[] grad, double[] result, Rectangle rect) {
            this.auxTarget = auxTarget;
            this.auxSource = auxSource;
            this.auxTargetMsk = auxTargetMsk;
            this.auxSourceMsk = auxSourceMsk;
            this.swx = swx;
            this.swy = swy;
            this.auxFactorWidth = auxFactorWidth;
            this.auxFactorHeight = auxFactorHeight;
            this.intervals = intervals;
            this.grad = grad;
            this.result = result;
            this.rect = rect;
        }

        @Override
        public void run() {
            int cYdim;
            int cXdim = cYdim = this.intervals + 3;
            int Nk = cYdim * cXdim;
            int twiceNk = 2 * Nk;
            double imageSimilarity = 0.0;
            int uv = this.rect.y * this.rect.width + this.rect.x;
            int Ydim = this.rect.y + this.rect.height;
            int Xdim = this.rect.x + this.rect.width;
            int n = 0;
            double[] I1D = new double[2];
            double[] targetCurrentImage = this.auxTarget.getCurrentImage();
            for (int v = this.rect.y; v < Ydim; ++v) {
                int u = this.rect.x;
                while (u < Xdim) {
                    if (this.auxTargetMsk.getValue((double)u / this.auxFactorWidth, (double)v / this.auxFactorHeight)) {
                        double y;
                        double I2 = targetCurrentImage[uv];
                        double x = this.swx.precomputed_interpolateI(u, v);
                        if (this.auxSourceMsk.getValue(x / this.auxFactorWidth, (y = this.swy.precomputed_interpolateI(u, v)) / this.auxFactorHeight)) {
                            double I1 = this.auxSource.prepareForInterpolationAndInterpolateIAndD(x, y, I1D, false, true);
                            double I1dx = I1D[0];
                            double I1dy = I1D[1];
                            double error = I2 - I1;
                            double error2 = error * error;
                            imageSimilarity += error2;
                            for (int l = 0; l < 4; ++l) {
                                for (int m = 0; m < 4; ++m) {
                                    if (this.swx.prec_yIndex[v][l] == -1 || this.swx.prec_xIndex[u][m] == -1) continue;
                                    double weightI = this.swx.precomputed_getWeightI(l, m, u, v);
                                    int k = this.swx.prec_yIndex[v][l] * cYdim + this.swx.prec_xIndex[u][m];
                                    double aux = -error * weightI;
                                    int n2 = k;
                                    this.grad[n2] = this.grad[n2] + aux * I1dx;
                                    int n3 = k + Nk;
                                    this.grad[n3] = this.grad[n3] + aux * I1dy;
                                }
                            }
                            ++n;
                        }
                    }
                    ++u;
                    ++uv;
                }
            }
            if (n != 0) {
                imageSimilarity *= Transformation.this.imageWeight;
                double aux = Transformation.this.imageWeight * 2.0;
                int k = 0;
                while (k < twiceNk) {
                    int n4 = k++;
                    this.grad[n4] = this.grad[n4] * aux;
                }
            } else {
                imageSimilarity = 1.0 / Transformation.this.FLT_EPSILON;
            }
            this.result[0] = imageSimilarity;
            this.result[1] = n;
        }
    }

    private class OutputTileMaker
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel auxSource;
        final BSplineModel auxTarget;
        final Mask auxTargetMsk;
        final Mask auxSourceMsk;
        final double auxFactorWidth;
        final double auxFactorHeight;
        final int auxTargetCurrentHeight;
        final int auxTargetCurrentWidth;
        final Rectangle rect;
        private final FloatProcessor fp;

        OutputTileMaker(BSplineModel swx, BSplineModel swy, BSplineModel auxSource, BSplineModel auxTarget, Mask auxSourceMsk, Mask auxTargetMsk, double auxFactorWidth, double auxFactorHeight, int auxTargetCurrentHeight, int auxTargetCurrentWidth, Rectangle rect, FloatProcessor fp) {
            this.swx = swx;
            this.swy = swy;
            this.auxSource = auxSource;
            this.auxTarget = auxTarget;
            this.auxTargetMsk = auxTargetMsk;
            this.auxSourceMsk = auxSourceMsk;
            this.auxFactorWidth = auxFactorWidth;
            this.auxFactorHeight = auxFactorHeight;
            this.auxTargetCurrentWidth = auxTargetCurrentWidth;
            this.auxTargetCurrentHeight = auxTargetCurrentHeight;
            this.rect = rect;
            this.fp = fp;
        }

        @Override
        public void run() {
            int uv = this.rect.y * this.rect.width + this.rect.x;
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            int subFactorT = this.auxTarget.getOriginalImageWidth() / this.auxTarget.getSubWidth();
            int subFactorS = this.auxSource.getOriginalImageWidth() / this.auxSource.getSubWidth();
            boolean fromSubT = this.auxTarget.isSubOutput();
            boolean fromSubS = this.auxSource.isSubOutput();
            double[] tImage = fromSubT ? this.auxTarget.getSubImage() : this.auxTarget.getImage();
            float[] f_array = (float[])this.fp.getPixels();
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    if (this.auxTargetMsk.getValue(u * subFactorT, v * subFactorT)) {
                        double y;
                        double up_y;
                        double down_u = (double)u * this.auxFactorWidth;
                        double down_v = (double)v * this.auxFactorHeight;
                        double tv = down_v * (double)Transformation.this.intervals / (double)(this.auxTargetCurrentHeight - 1) + 1.0;
                        double tu = down_u * (double)Transformation.this.intervals / (double)(this.auxTargetCurrentWidth - 1) + 1.0;
                        double x = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, fromSubT, false);
                        double up_x = x / this.auxFactorWidth;
                        if (this.auxSourceMsk.getValue(up_x * (double)subFactorS, (up_y = (y = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, fromSubT, false)) / this.auxFactorHeight) * (double)subFactorS)) {
                            double sourceValue = this.auxSource.prepareForInterpolationAndInterpolateI(up_x, up_y, fromSubS, false);
                            f_array[u_rect + v_offset] = (float)(tImage[uv] - sourceValue);
                        } else {
                            f_array[u_rect + v_offset] = 0.0f;
                        }
                    } else {
                        f_array[u_rect + v_offset] = 0.0f;
                    }
                    ++u;
                    ++uv;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
        }
    }

    private class ColorResultTileMaker
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel sourceR;
        final BSplineModel sourceG;
        final BSplineModel sourceB;
        final int auxTargetCurrentWidth;
        final int auxTargetCurrentHeight;
        final Mask auxTargetMsk;
        final Mask auxSourceMsk;
        final Rectangle rect;
        private final FloatProcessor fpR;
        private final FloatProcessor fpG;
        private final FloatProcessor fpB;
        private final ColorProcessor cp_mask;

        ColorResultTileMaker(BSplineModel swx, BSplineModel swy, BSplineModel sourceR, BSplineModel sourceG, BSplineModel sourceB, int auxTargetCurrentWidth, int auxTargetCurrentHeight, Mask auxTargetMsk, Mask auxSourceMsk, Rectangle rect, FloatProcessor fpR, FloatProcessor fpG, FloatProcessor fpB, ColorProcessor cp_mask) {
            this.swx = swx;
            this.swy = swy;
            this.sourceR = sourceR;
            this.sourceG = sourceG;
            this.sourceB = sourceB;
            this.auxTargetCurrentWidth = auxTargetCurrentWidth;
            this.auxTargetCurrentHeight = auxTargetCurrentHeight;
            this.auxTargetMsk = auxTargetMsk;
            this.auxSourceMsk = auxSourceMsk;
            this.rect = rect;
            this.fpR = fpR;
            this.fpG = fpG;
            this.fpB = fpB;
            this.cp_mask = cp_mask;
        }

        @Override
        public void run() {
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            float[] fpR_array = (float[])this.fpR.getPixels();
            float[] fpG_array = (float[])this.fpG.getPixels();
            float[] fpB_array = (float[])this.fpB.getPixels();
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                double tv = (double)(v * Transformation.this.intervals) / (double)(this.auxTargetCurrentHeight - 1) + 1.0;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    double tu = (double)(u * Transformation.this.intervals) / (double)(this.auxTargetCurrentWidth - 1) + 1.0;
                    double transformation_x_v_u = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double transformation_y_v_u = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    if (!this.auxTargetMsk.getValue(u, v)) {
                        fpR_array[u_rect + v_offset] = 0.0f;
                        fpG_array[u_rect + v_offset] = 0.0f;
                        fpB_array[u_rect + v_offset] = 0.0f;
                        this.cp_mask.setf(u_rect, v_rect, 0.0f);
                    } else {
                        double x = transformation_x_v_u;
                        double y = transformation_y_v_u;
                        if (this.auxSourceMsk.getValue(x, y)) {
                            fpR_array[u_rect + v_offset] = (float)this.sourceR.prepareForInterpolationAndInterpolateI(x, y, false, false);
                            fpG_array[u_rect + v_offset] = (float)this.sourceG.prepareForInterpolationAndInterpolateI(x, y, false, false);
                            fpB_array[u_rect + v_offset] = (float)this.sourceB.prepareForInterpolationAndInterpolateI(x, y, false, false);
                            this.cp_mask.putPixelValue(u_rect, v_rect, 255.0);
                        } else {
                            fpR_array[u_rect + v_offset] = 0.0f;
                            fpG_array[u_rect + v_offset] = 0.0f;
                            fpB_array[u_rect + v_offset] = 0.0f;
                            this.cp_mask.setf(u_rect, v_rect, 0.0f);
                        }
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
        }
    }

    private class GrayscaleResultTileMaker
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel auxSource;
        final int auxTargetCurrentWidth;
        final int auxTargetCurrentHeight;
        final Mask auxTargetMsk;
        final Mask auxSourceMsk;
        final Rectangle rect;
        private final FloatProcessor fp;
        private final FloatProcessor fp_mask;

        GrayscaleResultTileMaker(BSplineModel swx, BSplineModel swy, BSplineModel auxSource, int auxTargetCurrentWidth, int auxTargetCurrentHeight, Mask auxTargetMsk, Mask auxSourceMsk, Rectangle rect, FloatProcessor fp, FloatProcessor fp_mask) {
            this.swx = swx;
            this.swy = swy;
            this.auxSource = auxSource;
            this.auxTargetCurrentWidth = auxTargetCurrentWidth;
            this.auxTargetCurrentHeight = auxTargetCurrentHeight;
            this.auxTargetMsk = auxTargetMsk;
            this.auxSourceMsk = auxSourceMsk;
            this.rect = rect;
            this.fp = fp;
            this.fp_mask = fp_mask;
        }

        @Override
        public void run() {
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            float[] fp_array = (float[])this.fp.getPixels();
            float[] fp_mask_array = (float[])this.fp_mask.getPixels();
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                double tv = (double)(v * Transformation.this.intervals) / (double)(this.auxTargetCurrentHeight - 1) + 1.0;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    double tu = (double)(u * Transformation.this.intervals) / (double)(this.auxTargetCurrentWidth - 1) + 1.0;
                    double transformation_x_v_u = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double transformation_y_v_u = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    if (!this.auxTargetMsk.getValue(u, v)) {
                        fp_array[u_rect + v_offset] = 0.0f;
                        fp_mask_array[u_rect + v_offset] = 0.0f;
                    } else {
                        double x = transformation_x_v_u;
                        double y = transformation_y_v_u;
                        if (this.auxSourceMsk.getValue(x, y)) {
                            fp_array[u_rect + v_offset] = (float)this.auxSource.prepareForInterpolationAndInterpolateI(x, y, false, false);
                            fp_mask_array[u_rect + v_offset] = 255.0f;
                        } else {
                            fp_array[u_rect + v_offset] = 0.0f;
                            fp_mask_array[u_rect + v_offset] = 0.0f;
                        }
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
        }
    }

    private class ConcurrentDeformation
    extends Thread {
        final double[][] c;
        final int auxTargetCurrentHeight;
        final int auxTargetCurrentWidth;
        final double[][] transformation;
        final int intervals;

        ConcurrentDeformation(double[][] c, int auxTargetCurrentHeight, int auxTargetCurrentWidth, double[][] transformation2, int intervals) {
            this.c = c;
            this.auxTargetCurrentWidth = auxTargetCurrentWidth;
            this.auxTargetCurrentHeight = auxTargetCurrentHeight;
            this.transformation = transformation2;
            this.intervals = intervals;
        }

        @Override
        public void run() {
            BSplineModel sw = new BSplineModel(this.c);
            for (int v = 0; v < this.auxTargetCurrentHeight; ++v) {
                double tv = (double)(v * this.intervals) / (double)(this.auxTargetCurrentHeight - 1) + 1.0;
                for (int u = 0; u < this.auxTargetCurrentWidth; ++u) {
                    double tu = (double)(u * this.intervals) / (double)(this.auxTargetCurrentWidth - 1) + 1.0;
                    this.transformation[v][u] = sw.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                }
            }
        }
    }
}

