/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh;

import java.util.Iterator;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Vertex;

public interface Vertices
extends Iterable<Vertex> {
    public Mesh mesh();

    public long sizel();

    default public int size() {
        long size = this.sizel();
        if (size >= Integer.MAX_VALUE) {
            throw new RuntimeException("Too many vertices: " + size);
        }
        return (int)size;
    }

    public float xf(long var1);

    public float yf(long var1);

    public float zf(long var1);

    public float nxf(long var1);

    public float nyf(long var1);

    public float nzf(long var1);

    public float uf(long var1);

    public float vf(long var1);

    public long addf(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    default public int addfi(float x, float y, float z, float nx, float ny, float nz, float u, float v) {
        long vi = this.addf(x, y, z, nx, ny, nz, u, v);
        if (vi >= Integer.MAX_VALUE) {
            throw new RuntimeException("Too many vertices: " + vi);
        }
        return (int)vi;
    }

    public void setf(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    public void setPositionf(long var1, float var3, float var4, float var5);

    public void setNormalf(long var1, float var3, float var4, float var5);

    public void setTexturef(long var1, float var3, float var4);

    default public long addf(float x, float y, float z) {
        return this.addf(x, y, z, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    default public int addfi(float x, float y, float z) {
        return this.addfi(x, y, z, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    default public void setf(long vIndex, float x, float y, float z) {
        this.setf(vIndex, x, y, z, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    default public double x(long vIndex) {
        return this.xf(vIndex);
    }

    default public double y(long vIndex) {
        return this.yf(vIndex);
    }

    default public double z(long vIndex) {
        return this.zf(vIndex);
    }

    default public double nx(long vIndex) {
        return this.nxf(vIndex);
    }

    default public double ny(long vIndex) {
        return this.nyf(vIndex);
    }

    default public double nz(long vIndex) {
        return this.nzf(vIndex);
    }

    default public double u(long vIndex) {
        return this.uf(vIndex);
    }

    default public double v(long vIndex) {
        return this.vf(vIndex);
    }

    default public long add(double x, double y, double z) {
        return this.addf((float)x, (float)y, (float)z);
    }

    default public int addi(double x, double y, double z) {
        return this.addfi((float)x, (float)y, (float)z);
    }

    default public long add(double x, double y, double z, double nx, double ny, double nz, double u, double v) {
        return this.addf((float)x, (float)y, (float)z, (float)nx, (float)ny, (float)nz, (float)u, (float)v);
    }

    default public int addi(double x, double y, double z, double nx, double ny, double nz, double u, double v) {
        return this.addfi((float)x, (float)y, (float)z, (float)nx, (float)ny, (float)nz, (float)u, (float)v);
    }

    default public void set(long vIndex, double x, double y, double z) {
        this.set(vIndex, x, y, z, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    default public void set(long vIndex, double x, double y, double z, double nx, double ny, double nz, double u, double v) {
        this.setf(vIndex, (float)x, (float)y, (float)z, (float)nx, (float)ny, (float)nz, (float)u, (float)v);
    }

    default public void setPosition(long vIndex, double x, double y, double z) {
        this.setPositionf(vIndex, (float)x, (float)y, (float)z);
    }

    default public void setNormal(long vIndex, double nx, double ny, double nz) {
        this.setNormalf(vIndex, (float)nx, (float)ny, (float)nz);
    }

    default public void setTexture(long vIndex, double u, double v) {
        this.setTexturef(vIndex, (float)u, (float)v);
    }

    @Override
    default public Iterator<Vertex> iterator() {
        return new Iterator<Vertex>(){
            private long index = -1L;
            private final Vertex vertex = new Vertex(){

                @Override
                public Mesh mesh() {
                    return Vertices.this.mesh();
                }

                @Override
                public long index() {
                    return index;
                }
            };

            @Override
            public boolean hasNext() {
                return this.index + 1L < Vertices.this.sizel();
            }

            @Override
            public Vertex next() {
                ++this.index;
                return this.vertex;
            }
        };
    }
}

