/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.apache.commons.math3.util.MathArrays;

public class MarchingCubesRealType {
    private static final double[] p0 = new double[]{0.0, 0.0, 1.0};
    private static final double[] p1 = new double[]{1.0, 0.0, 1.0};
    private static final double[] p2 = new double[]{1.0, 0.0, 0.0};
    private static final double[] p3 = new double[]{0.0, 0.0, 0.0};
    private static final double[] p4 = new double[]{0.0, 1.0, 1.0};
    private static final double[] p5 = new double[]{1.0, 1.0, 1.0};
    private static final double[] p6 = new double[]{1.0, 1.0, 0.0};
    private static final double[] p7 = new double[]{0.0, 1.0, 0.0};
    static final int[] EDGE_TABLE = new int[]{0, 2060, 1030, 3082, 2240, 204, 3270, 1226, 1120, 3180, 102, 2154, 3232, 1196, 2214, 170, 265, 2309, 1295, 3331, 2505, 453, 3535, 1475, 1385, 3429, 367, 2403, 3497, 1445, 2479, 419, 515, 2575, 1541, 3593, 2755, 719, 3781, 1737, 1635, 3695, 613, 2665, 3747, 1711, 2725, 681, 778, 2822, 1804, 3840, 3018, 966, 4044, 1984, 1898, 3942, 876, 2912, 4010, 1958, 2988, 928, 400, 2460, 1430, 3482, 2384, 348, 3414, 1370, 1520, 3580, 502, 2554, 3376, 1340, 2358, 314, 153, 2197, 1183, 3219, 2137, 85, 3167, 1107, 1273, 3317, 255, 2291, 3129, 1077, 2111, 51, 915, 2975, 1941, 3993, 2899, 863, 3925, 1881, 2035, 4095, 1013, 3065, 3891, 1855, 2869, 825, 666, 2710, 1692, 3728, 2650, 598, 3676, 1616, 1786, 3830, 764, 2800, 3642, 1590, 2620, 560, 560, 2620, 1590, 3642, 2800, 764, 3830, 1786, 1616, 3676, 598, 2650, 3728, 1692, 2710, 666, 825, 2869, 1855, 3891, 3065, 1013, 4095, 2035, 1881, 3925, 863, 2899, 3993, 1941, 2975, 915, 51, 2111, 1077, 3129, 2291, 255, 3317, 1273, 1107, 3167, 85, 2137, 3219, 1183, 2197, 153, 314, 2358, 1340, 3376, 2554, 502, 3580, 1520, 1370, 3414, 348, 2384, 3482, 1430, 2460, 400, 928, 2988, 1958, 4010, 2912, 876, 3942, 1898, 1984, 4044, 966, 3018, 3840, 1804, 2822, 778, 681, 2725, 1711, 3747, 2665, 613, 3695, 1635, 1737, 3781, 719, 2755, 3593, 1541, 2575, 515, 419, 2479, 1445, 3497, 2403, 367, 3429, 1385, 1475, 3535, 453, 2505, 3331, 1295, 2309, 265, 170, 2214, 1196, 3232, 2154, 102, 3180, 1120, 1226, 3270, 204, 2240, 3082, 1030, 2060, 0};
    static final byte[][] TRIANGLE_TABLE = new byte[][]{new byte[0], {11, 2, 3}, {2, 10, 1}, {10, 1, 3, 10, 3, 11}, {6, 11, 7}, {2, 3, 7, 2, 7, 6}, {1, 2, 11, 7, 1, 11, 1, 6, 10, 1, 7, 6}, {7, 6, 10, 1, 7, 10, 3, 7, 1}, {6, 5, 10}, {3, 11, 6, 5, 3, 6, 3, 10, 2, 3, 5, 10}, {6, 5, 1, 6, 1, 2}, {3, 11, 6, 5, 3, 6, 1, 3, 5}, {5, 10, 11, 5, 11, 7}, {5, 10, 2, 3, 5, 2, 7, 5, 3}, {1, 2, 11, 7, 1, 11, 5, 1, 7}, {3, 5, 1, 7, 5, 3}, {8, 3, 0}, {11, 2, 0, 11, 0, 8}, {8, 3, 2, 10, 8, 2, 8, 1, 0, 8, 10, 1}, {10, 1, 0, 8, 10, 0, 11, 10, 8}, {0, 8, 7, 6, 0, 7, 0, 11, 3, 0, 6, 11}, {0, 8, 7, 6, 0, 7, 2, 0, 6}, {0, 8, 1, 8, 7, 1, 7, 10, 1, 10, 7, 6, 11, 3, 2}, {7, 6, 10, 7, 10, 1, 8, 7, 1, 0, 8, 1}, {8, 3, 0, 10, 6, 5}, {5, 8, 11, 6, 5, 11, 5, 0, 8, 2, 5, 10, 5, 2, 0}, {8, 5, 1, 0, 8, 1, 8, 6, 5, 2, 8, 3, 8, 2, 6}, {8, 11, 0, 11, 5, 0, 5, 1, 0, 11, 6, 5}, {0, 10, 11, 3, 0, 11, 0, 5, 10, 7, 0, 8, 0, 7, 5}, {2, 0, 8, 5, 2, 8, 7, 5, 8, 2, 5, 10}, {11, 3, 2, 8, 1, 0, 8, 7, 1, 7, 5, 1}, {8, 7, 0, 7, 1, 0, 7, 5, 1}, {1, 9, 0}, {9, 0, 3, 11, 9, 3, 9, 2, 1, 9, 11, 2}, {2, 10, 9, 2, 9, 0}, {9, 0, 3, 11, 9, 3, 10, 9, 11}, {1, 9, 0, 7, 6, 11}, {9, 6, 2, 1, 9, 2, 9, 7, 6, 3, 9, 0, 9, 3, 7}, {7, 0, 2, 11, 7, 2, 7, 9, 0, 10, 7, 6, 7, 10, 9}, {3, 7, 0, 7, 10, 0, 10, 9, 0, 10, 7, 6}, {0, 1, 10, 6, 0, 10, 0, 5, 9, 0, 6, 5}, {3, 11, 0, 11, 6, 0, 6, 9, 0, 9, 6, 5, 10, 2, 1}, {6, 5, 9, 0, 6, 9, 2, 6, 0}, {11, 6, 3, 3, 6, 0, 6, 5, 0, 5, 9, 0}, {0, 7, 5, 9, 0, 5, 0, 11, 7, 10, 0, 1, 0, 10, 11}, {2, 1, 10, 0, 5, 9, 0, 3, 5, 3, 7, 5}, {7, 5, 9, 2, 7, 9, 0, 2, 9, 11, 7, 2}, {0, 3, 9, 3, 5, 9, 3, 7, 5}, {8, 3, 1, 8, 1, 9}, {11, 2, 1, 9, 11, 1, 8, 11, 9}, {8, 3, 2, 10, 8, 2, 9, 8, 10}, {8, 10, 9, 8, 11, 10}, {6, 9, 8, 7, 6, 8, 6, 1, 9, 3, 6, 11, 6, 3, 1}, {6, 2, 1, 8, 6, 1, 9, 8, 1, 7, 6, 8}, {11, 3, 2, 8, 6, 10, 9, 8, 10, 7, 6, 8}, {6, 10, 7, 10, 8, 7, 10, 9, 8}, {6, 3, 1, 10, 6, 1, 6, 8, 3, 9, 6, 5, 6, 9, 8}, {10, 2, 1, 11, 5, 9, 8, 11, 9, 6, 5, 11}, {9, 8, 5, 8, 2, 5, 2, 6, 5, 2, 8, 3}, {5, 9, 6, 9, 11, 6, 9, 8, 11}, {8, 5, 9, 7, 5, 8, 3, 1, 10, 11, 3, 10}, {8, 7, 9, 7, 5, 9, 2, 1, 10}, {5, 9, 7, 9, 8, 7, 2, 11, 3}, {8, 7, 9, 9, 7, 5}, {7, 8, 4}, {4, 7, 11, 2, 4, 11, 4, 3, 8, 4, 2, 3}, {2, 10, 1, 4, 7, 8}, {4, 1, 3, 8, 4, 3, 4, 10, 1, 11, 4, 7, 4, 11, 10}, {8, 4, 6, 8, 6, 11}, {2, 3, 8, 4, 2, 8, 6, 2, 4}, {1, 4, 6, 10, 1, 6, 1, 8, 4, 11, 1, 2, 1, 11, 8}, {1, 3, 8, 6, 1, 8, 4, 6, 8, 10, 1, 6}, {10, 6, 7, 8, 10, 7, 10, 4, 5, 10, 8, 4}, {8, 4, 3, 4, 5, 3, 5, 2, 3, 2, 5, 10, 6, 7, 11}, {8, 2, 6, 7, 8, 6, 8, 1, 2, 5, 8, 4, 8, 5, 1}, {6, 7, 11, 4, 3, 8, 4, 5, 3, 5, 1, 3}, {8, 4, 5, 10, 8, 5, 11, 8, 10}, {5, 10, 2, 5, 2, 3, 4, 5, 3, 8, 4, 3}, {5, 1, 2, 8, 5, 2, 11, 8, 2, 5, 8, 4}, {4, 5, 8, 5, 3, 8, 5, 1, 3}, {3, 0, 4, 3, 4, 7}, {4, 7, 11, 2, 4, 11, 0, 4, 2}, {10, 7, 3, 2, 10, 3, 10, 4, 7, 0, 10, 1, 10, 0, 4}, {11, 10, 1, 4, 11, 1, 0, 4, 1, 11, 4, 7}, {6, 11, 3, 0, 6, 3, 4, 6, 0}, {4, 2, 0, 6, 2, 4}, {2, 11, 3, 6, 1, 0, 4, 6, 0, 10, 1, 6}, {1, 0, 10, 0, 6, 10, 0, 4, 6}, {10, 0, 4, 5, 10, 4, 10, 3, 0, 7, 10, 6, 10, 7, 3}, {11, 6, 7, 10, 4, 5, 10, 2, 4, 2, 0, 4}, {2, 6, 3, 6, 7, 3, 0, 5, 1, 0, 4, 5}, {1, 0, 5, 0, 4, 5, 11, 6, 7}, {0, 4, 5, 11, 0, 5, 10, 11, 5, 3, 0, 11}, {10, 2, 5, 2, 4, 5, 2, 0, 4}, {4, 5, 0, 5, 1, 0, 11, 3, 2}, {4, 5, 0, 0, 5, 1}, {1, 9, 4, 7, 1, 4, 1, 8, 0, 1, 7, 8}, {4, 7, 9, 7, 11, 9, 11, 1, 9, 1, 11, 2, 3, 8, 0}, {7, 10, 9, 4, 7, 9, 7, 2, 10, 0, 7, 8, 7, 0, 2}, {3, 8, 0, 7, 9, 4, 7, 11, 9, 11, 10, 9}, {1, 11, 8, 0, 1, 8, 1, 6, 11, 4, 1, 9, 1, 4, 6}, {8, 0, 3, 9, 2, 1, 9, 4, 2, 4, 6, 2}, {2, 8, 0, 11, 8, 2, 10, 9, 4, 6, 10, 4}, {6, 10, 4, 10, 9, 4, 3, 8, 0}, {10, 6, 1, 6, 7, 1, 7, 0, 1, 0, 7, 8, 4, 5, 9}, {7, 11, 6, 10, 2, 1, 3, 8, 0, 5, 9, 4}, {4, 5, 9, 6, 8, 0, 2, 6, 0, 7, 8, 6}, {3, 8, 0, 5, 9, 4, 6, 7, 11}, {5, 9, 4, 1, 8, 0, 1, 10, 8, 10, 11, 8}, {8, 0, 3, 10, 2, 1, 5, 9, 4}, {2, 11, 0, 11, 8, 0, 5, 9, 4}, {4, 5, 9, 3, 8, 0}, {1, 9, 4, 7, 1, 4, 3, 1, 7}, {7, 11, 4, 4, 11, 9, 11, 2, 9, 2, 1, 9}, {10, 9, 2, 9, 7, 2, 7, 3, 2, 9, 4, 7}, {7, 11, 4, 11, 9, 4, 11, 10, 9}, {4, 6, 9, 6, 3, 9, 3, 1, 9, 3, 6, 11}, {9, 4, 1, 4, 2, 1, 4, 6, 2}, {9, 4, 10, 4, 6, 10, 3, 2, 11}, {9, 4, 10, 10, 4, 6}, {4, 5, 9, 6, 1, 10, 6, 7, 1, 7, 3, 1}, {4, 5, 9, 2, 1, 10, 11, 6, 7}, {3, 2, 7, 2, 6, 7, 9, 4, 5}, {5, 9, 4, 11, 6, 7}, {11, 3, 10, 3, 1, 10, 4, 5, 9}, {10, 2, 1, 4, 5, 9}, {4, 5, 9, 11, 3, 2}, {4, 5, 9}, {5, 4, 9}, {5, 4, 9, 3, 11, 2}, {2, 10, 5, 4, 2, 5, 2, 9, 1, 2, 4, 9}, {4, 11, 10, 5, 4, 10, 4, 3, 11, 1, 4, 9, 4, 1, 3}, {9, 5, 6, 11, 9, 6, 9, 7, 4, 9, 11, 7}, {9, 3, 7, 4, 9, 7, 9, 2, 3, 6, 9, 5, 9, 6, 2}, {1, 2, 9, 2, 11, 9, 11, 4, 9, 4, 11, 7, 6, 10, 5}, {5, 6, 10, 7, 9, 1, 3, 7, 1, 4, 9, 7}, {4, 9, 10, 4, 10, 6}, {3, 9, 10, 2, 3, 10, 3, 4, 9, 6, 3, 11, 3, 6, 4}, {4, 9, 1, 2, 4, 1, 6, 4, 2}, {6, 4, 9, 3, 6, 9, 1, 3, 9, 6, 3, 11}, {11, 7, 4, 9, 11, 4, 10, 11, 9}, {9, 10, 2, 7, 9, 2, 3, 7, 2, 4, 9, 7}, {11, 7, 4, 11, 4, 9, 2, 11, 9, 1, 2, 9}, {9, 1, 4, 1, 7, 4, 1, 3, 7}, {5, 4, 8, 3, 5, 8, 5, 0, 9, 5, 3, 0}, {5, 2, 0, 9, 5, 0, 5, 11, 2, 8, 5, 4, 5, 8, 11}, {2, 10, 3, 10, 5, 3, 5, 8, 3, 8, 5, 4, 9, 1, 0}, {9, 1, 0, 10, 4, 8, 11, 10, 8, 5, 4, 10}, {9, 5, 0, 5, 6, 0, 6, 3, 0, 3, 6, 11, 7, 4, 8}, {7, 4, 8, 5, 0, 9, 5, 6, 0, 6, 2, 0}, {9, 1, 0, 8, 7, 4, 11, 3, 2, 6, 10, 5}, {0, 9, 1, 6, 10, 5, 7, 4, 8}, {3, 6, 4, 8, 3, 4, 3, 10, 6, 9, 3, 0, 3, 9, 10}, {8, 11, 4, 11, 6, 4, 9, 2, 0, 9, 10, 2}, {0, 9, 1, 4, 3, 2, 6, 4, 2, 8, 3, 4}, {11, 6, 8, 6, 4, 8, 1, 0, 9}, {8, 7, 4, 11, 0, 9, 10, 11, 9, 3, 0, 11}, {10, 2, 9, 2, 0, 9, 7, 4, 8}, {1, 0, 9, 7, 4, 8, 11, 3, 2}, {9, 1, 0, 7, 4, 8}, {5, 4, 0, 5, 0, 1}, {11, 4, 0, 3, 11, 0, 11, 5, 4, 1, 11, 2, 11, 1, 5}, {2, 10, 5, 4, 2, 5, 0, 2, 4}, {4, 0, 5, 0, 11, 5, 11, 10, 5, 0, 3, 11}, {11, 1, 5, 6, 11, 5, 11, 0, 1, 4, 11, 7, 11, 4, 0}, {5, 2, 1, 6, 2, 5, 4, 0, 3, 7, 4, 3}, {6, 10, 5, 2, 7, 4, 0, 2, 4, 11, 7, 2}, {0, 3, 4, 3, 7, 4, 10, 5, 6}, {0, 1, 10, 6, 0, 10, 4, 0, 6}, {10, 2, 1, 11, 0, 3, 11, 6, 0, 6, 4, 0}, {2, 4, 0, 2, 6, 4}, {11, 6, 3, 6, 0, 3, 6, 4, 0}, {10, 11, 1, 11, 4, 1, 4, 0, 1, 4, 11, 7}, {7, 4, 3, 4, 0, 3, 10, 2, 1}, {7, 4, 11, 4, 2, 11, 4, 0, 2}, {0, 3, 4, 4, 3, 7}, {5, 4, 8, 3, 5, 8, 1, 5, 3}, {1, 5, 2, 5, 8, 2, 8, 11, 2, 8, 5, 4}, {10, 5, 2, 2, 5, 3, 5, 4, 3, 4, 8, 3}, {4, 8, 5, 8, 10, 5, 8, 11, 10}, {7, 4, 8, 5, 11, 3, 1, 5, 3, 6, 11, 5}, {2, 1, 6, 1, 5, 6, 8, 7, 4}, {2, 11, 3, 4, 8, 7, 5, 6, 10}, {6, 10, 5, 8, 7, 4}, {3, 1, 8, 1, 6, 8, 6, 4, 8, 1, 10, 6}, {4, 8, 6, 8, 11, 6, 1, 10, 2}, {3, 2, 8, 2, 4, 8, 2, 6, 4}, {4, 8, 6, 6, 8, 11}, {1, 10, 3, 10, 11, 3, 4, 8, 7}, {10, 2, 1, 7, 4, 8}, {7, 4, 8, 2, 11, 3}, {8, 7, 4}, {7, 8, 9, 7, 9, 5}, {2, 5, 7, 11, 2, 7, 2, 9, 5, 8, 2, 3, 2, 8, 9}, {2, 8, 9, 1, 2, 9, 2, 7, 8, 5, 2, 10, 2, 5, 7}, {5, 7, 10, 7, 11, 10, 1, 8, 9, 1, 3, 8}, {9, 5, 6, 11, 9, 6, 8, 9, 11}, {8, 9, 5, 2, 8, 5, 6, 2, 5, 8, 2, 3}, {6, 10, 5, 2, 9, 1, 2, 11, 9, 11, 8, 9}, {3, 8, 1, 8, 9, 1, 6, 10, 5}, {10, 6, 7, 8, 10, 7, 9, 10, 8}, {7, 11, 6, 3, 10, 2, 3, 8, 10, 8, 9, 10}, {2, 6, 1, 6, 8, 1, 8, 9, 1, 6, 7, 8}, {9, 1, 8, 1, 3, 8, 6, 7, 11}, {10, 8, 9, 11, 8, 10}, {3, 8, 2, 8, 10, 2, 8, 9, 10}, {2, 11, 1, 11, 9, 1, 11, 8, 9}, {3, 8, 1, 1, 8, 9}, {3, 0, 9, 5, 3, 9, 7, 3, 5}, {5, 7, 9, 7, 2, 9, 2, 0, 9, 7, 11, 2}, {1, 0, 9, 3, 10, 5, 7, 3, 5, 2, 10, 3}, {7, 11, 5, 11, 10, 5, 0, 9, 1}, {6, 11, 3, 6, 3, 0, 5, 6, 0, 9, 5, 0}, {5, 6, 9, 6, 0, 9, 6, 2, 0}, {9, 1, 0, 11, 3, 2, 6, 10, 5}, {1, 0, 9, 6, 10, 5}, {7, 3, 0, 10, 7, 0, 9, 10, 0, 7, 10, 6}, {0, 9, 2, 9, 10, 2, 7, 11, 6}, {6, 7, 2, 7, 3, 2, 9, 1, 0}, {9, 1, 0, 6, 7, 11}, {0, 9, 3, 9, 11, 3, 9, 10, 11}, {10, 2, 9, 9, 2, 0}, {0, 9, 1, 11, 3, 2}, {9, 1, 0}, {7, 8, 0, 1, 7, 0, 5, 7, 1}, {3, 8, 0, 7, 2, 1, 5, 7, 1, 11, 2, 7}, {0, 2, 8, 2, 5, 8, 5, 7, 8, 5, 2, 10}, {10, 5, 11, 5, 7, 11, 0, 3, 8}, {11, 8, 0, 5, 11, 0, 1, 5, 0, 6, 11, 5}, {5, 6, 1, 6, 2, 1, 8, 0, 3}, {8, 0, 11, 0, 2, 11, 5, 6, 10}, {3, 8, 0, 6, 10, 5}, {6, 7, 10, 10, 7, 1, 7, 8, 1, 8, 0, 1}, {10, 2, 1, 8, 0, 3, 7, 11, 6}, {8, 0, 7, 0, 6, 7, 0, 2, 6}, {8, 0, 3, 6, 7, 11}, {1, 10, 0, 10, 8, 0, 10, 11, 8}, {3, 8, 0, 10, 2, 1}, {2, 11, 0, 0, 11, 8}, {3, 8, 0}, {5, 3, 1, 5, 7, 3}, {2, 1, 11, 1, 7, 11, 1, 5, 7}, {10, 5, 2, 5, 3, 2, 5, 7, 3}, {10, 5, 11, 11, 5, 7}, {11, 3, 6, 3, 5, 6, 3, 1, 5}, {5, 6, 1, 1, 6, 2}, {11, 3, 2, 5, 6, 10}, {5, 6, 10}, {6, 7, 10, 7, 1, 10, 7, 3, 1}, {2, 1, 10, 7, 11, 6}, {3, 2, 7, 7, 2, 6}, {11, 6, 7}, {1, 10, 3, 3, 10, 11}, {10, 2, 1}, {2, 11, 3}, new byte[0]};

    private static <T extends RealType<T>> byte[] mask(RandomAccessibleInterval<T> input, double isoLevel) {
        int i;
        int msx = (int)input.dimension(0);
        int msy = (int)input.dimension(1);
        int msz = (int)input.dimension(2);
        int isx = msx + 2;
        int isy = msy + 2;
        int isz = msz + 2;
        int is = isx * isy * isz;
        byte[] indices = new byte[is];
        Cursor c = Views.flatIterable(input).cursor();
        int j = isx * isy + isx + 1;
        for (int z = 0; z < msz; ++z) {
            for (int y = 0; y < msy; ++y) {
                for (int x = 0; x < msx; ++x) {
                    if (((RealType)c.next()).getRealDouble() >= isoLevel) {
                        indices[j] = 1;
                    }
                    ++j;
                }
                j += 2;
            }
            j += 2 * isx;
        }
        for (i = 0; i < is - 1; ++i) {
            indices[i] = MarchingCubesRealType.ubyte(indices[i] | indices[i + 1] << 1);
        }
        for (i = 0; i < is - isx; ++i) {
            indices[i] = MarchingCubesRealType.ubyte(indices[i] | indices[i + isx] << 2);
        }
        for (i = 0; i < is - isx * isy; ++i) {
            indices[i] = MarchingCubesRealType.ubyte(indices[i] | indices[i + isx * isy] << 4);
        }
        return indices;
    }

    private static byte ubyte(int unsignedByte) {
        return (byte)(unsignedByte & 0xFF);
    }

    public static <T extends RealType<T>> Mesh calculate(RandomAccessibleInterval<T> input, double isoLevel) {
        NaiveDoubleMesh output = new NaiveDoubleMesh();
        MarchingCubesRealType.compute(input, isoLevel, output);
        return output;
    }

    public static <T extends RealType<T>> Mesh compute(RandomAccessibleInterval<T> input, double isoLevel, Mesh output) {
        double[][] vertlist = new double[12][3];
        double[] vertex_values = new double[8];
        int msx = (int)input.dimension(0);
        int msy = (int)input.dimension(1);
        int isx = msx + 2;
        int isy = msy + 2;
        byte[] mask = MarchingCubesRealType.mask(input, isoLevel);
        RandomAccess ra = Views.extendZero(input).randomAccess((Interval)Intervals.expand(input, (long)1L));
        int[] pos = new int[3];
        int minX = (int)input.min(0) - 1;
        int minY = (int)input.min(1) - 1;
        int minZ = (int)input.min(2) - 1;
        int maxX = (int)input.max(0) + 1;
        int maxY = (int)input.max(1) + 1;
        int maxZ = (int)input.max(2) + 1;
        for (int z = minZ; z < maxZ; ++z) {
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    int mz = z - minZ;
                    int my = y - minY;
                    int mx = x - minX;
                    int mindex = mask[mz * (isx * isy) + my * isx + mx] & 0xFF;
                    int EDGE = EDGE_TABLE[mindex];
                    if (EDGE == 0) continue;
                    pos[0] = x;
                    pos[1] = y;
                    pos[2] = z;
                    ra.setPosition(pos);
                    vertex_values[3] = ((RealType)ra.get()).getRealDouble();
                    ra.fwd(0);
                    vertex_values[2] = ((RealType)ra.get()).getRealDouble();
                    ra.fwd(1);
                    vertex_values[6] = ((RealType)ra.get()).getRealDouble();
                    ra.bck(0);
                    vertex_values[7] = ((RealType)ra.get()).getRealDouble();
                    ra.bck(1);
                    ra.fwd(2);
                    vertex_values[0] = ((RealType)ra.get()).getRealDouble();
                    ra.fwd(0);
                    vertex_values[1] = ((RealType)ra.get()).getRealDouble();
                    ra.fwd(1);
                    vertex_values[5] = ((RealType)ra.get()).getRealDouble();
                    ra.bck(0);
                    vertex_values[4] = ((RealType)ra.get()).getRealDouble();
                    if (0 != (EDGE & 1)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[0], p0, p1, vertex_values[0], vertex_values[1], isoLevel);
                    }
                    if (0 != (EDGE & 2)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[1], p1, p2, vertex_values[1], vertex_values[2], isoLevel);
                    }
                    if (0 != (EDGE & 4)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[2], p2, p3, vertex_values[2], vertex_values[3], isoLevel);
                    }
                    if (0 != (EDGE & 8)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[3], p3, p0, vertex_values[3], vertex_values[0], isoLevel);
                    }
                    if (0 != (EDGE & 0x10)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[4], p4, p5, vertex_values[4], vertex_values[5], isoLevel);
                    }
                    if (0 != (EDGE & 0x20)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[5], p5, p6, vertex_values[5], vertex_values[6], isoLevel);
                    }
                    if (0 != (EDGE & 0x40)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[6], p6, p7, vertex_values[6], vertex_values[7], isoLevel);
                    }
                    if (0 != (EDGE & 0x80)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[7], p7, p4, vertex_values[7], vertex_values[4], isoLevel);
                    }
                    if (0 != (EDGE & 0x100)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[8], p0, p4, vertex_values[0], vertex_values[4], isoLevel);
                    }
                    if (0 != (EDGE & 0x200)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[9], p1, p5, vertex_values[1], vertex_values[5], isoLevel);
                    }
                    if (0 != (EDGE & 0x400)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[10], p2, p6, vertex_values[2], vertex_values[6], isoLevel);
                    }
                    if (0 != (EDGE & 0x800)) {
                        MarchingCubesRealType.interpolatePoint(vertlist[11], p3, p7, vertex_values[3], vertex_values[7], isoLevel);
                    }
                    byte[] TRIANGLE = TRIANGLE_TABLE[mindex];
                    for (int i = 0; i < TRIANGLE.length; i += 3) {
                        double v0x = vertlist[TRIANGLE[i + 2]][0];
                        double v0y = vertlist[TRIANGLE[i + 2]][1];
                        double v0z = vertlist[TRIANGLE[i + 2]][2];
                        double v1x = vertlist[TRIANGLE[i + 1]][0];
                        double v1y = vertlist[TRIANGLE[i + 1]][1];
                        double v1z = vertlist[TRIANGLE[i + 1]][2];
                        double v2x = vertlist[TRIANGLE[i]][0];
                        double v2y = vertlist[TRIANGLE[i]][1];
                        double v2z = vertlist[TRIANGLE[i]][2];
                        if (!MarchingCubesRealType.positiveArea(v0x, v0y, v0z, v1x, v1y, v1z, v2x, v2y, v2z)) continue;
                        output.triangles().add((double)x + v0x, (double)y + v0y, (double)z + v0z, (double)x + v1x, (double)y + v1y, (double)z + v1z, (double)x + v2x, (double)y + v2y, (double)z + v2z);
                    }
                }
            }
        }
        return output;
    }

    private static boolean positiveArea(double v0x, double v0y, double v0z, double v1x, double v1y, double v1z, double v2x, double v2y, double v2z) {
        double p1x = v0x - v1x;
        double p1y = v0y - v1y;
        double p1z = v0z - v1z;
        double p2x = v2x - v0x;
        double p2y = v2y - v0y;
        double p2z = v2z - v0z;
        double cpx = MathArrays.linearCombination(p1y, p2z, -p1z, p2y);
        double cpy = MathArrays.linearCombination(p1z, p2x, -p1x, p2z);
        double cpz = MathArrays.linearCombination(p1x, p2y, -p1y, p2x);
        return cpx != 0.0 || cpy != 0.0 || cpz != 0.0;
    }

    private static void interpolatePoint(double[] output, double[] p0, double[] p1, double v0, double v1, double isolevel) {
        if (Math.abs(isolevel - v0) < 1.0E-5) {
            for (int i = 0; i < 3; ++i) {
                output[i] = p0[i];
            }
        } else if (Math.abs(isolevel - v1) < 1.0E-5) {
            for (int i = 0; i < 3; ++i) {
                output[i] = p1[i];
            }
        } else if (Math.abs(v0 - v1) < 1.0E-5) {
            for (int i = 0; i < 3; ++i) {
                output[i] = p0[i];
            }
        } else {
            double mu = (isolevel - v0) / (v1 - v0);
            output[0] = p0[0] + mu * (p1[0] - p0[0]);
            output[1] = p0[1] + mu * (p1[1] - p0[1]);
            output[2] = p0[2] + mu * (p1[2] - p0[2]);
        }
    }
}

