/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RealInterval;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Meshes;
import net.imglib2.mesh.alg.zslicer.RamerDouglasPeucker;
import net.imglib2.mesh.alg.zslicer.Slice;
import net.imglib2.mesh.alg.zslicer.ZSlicer;
import net.imglib2.mesh.impl.nio.BufferMesh;

public class MeshCursor<T>
implements Cursor<T> {
    private final double[] cal;
    private final int minX;
    private final int maxX;
    private final int minY;
    private final int maxY;
    private final int minZ;
    private final int maxZ;
    private final RandomAccess<T> ra;
    private final Mesh mesh;
    private boolean hasNext;
    private int iy;
    private int iz;
    private int ix;
    private final TDoubleArrayList intersectionXs = new TDoubleArrayList();
    private Slice slice;
    private final Map<Integer, Slice> sliceMap;

    public MeshCursor(RandomAccess<T> ra, Mesh mesh, double[] cal) {
        this(ra, mesh, cal, Meshes.boundingBox(mesh));
    }

    public MeshCursor(RandomAccess<T> ra, Mesh mesh, double[] cal, RealInterval boundingBox) {
        this.ra = ra;
        this.mesh = mesh;
        this.cal = cal;
        this.minX = (int)Math.floor(boundingBox.realMin(0) / cal[0]);
        this.maxX = (int)Math.ceil(boundingBox.realMax(0) / cal[0]);
        this.minY = (int)Math.floor(boundingBox.realMin(1) / cal[1]);
        this.maxY = (int)Math.ceil(boundingBox.realMax(1) / cal[1]);
        this.minZ = (int)Math.floor(boundingBox.realMin(2) / cal[2]);
        this.maxZ = (int)Math.ceil(boundingBox.realMax(2) / cal[2]);
        this.sliceMap = MeshCursor.buildSliceMap(mesh, boundingBox, cal[0], cal[2]);
        this.reset();
    }

    public void reset() {
        this.ix = this.maxX;
        this.iy = this.minY - 1;
        this.iz = this.minZ;
        this.hasNext = false;
        do {
            ++this.iz;
            if (this.iz > this.maxZ) {
                return;
            }
            this.slice = this.sliceMap.get(this.iz);
        } while (this.slice == null);
        this.hasNext = true;
        this.preFetch();
    }

    public void fwd() {
        this.ra.setPosition(this.ix, 0);
        this.ra.setPosition(this.iy, 1);
        this.ra.setPosition(this.iz, 2);
        this.preFetch();
    }

    private void preFetch() {
        this.hasNext = false;
        while (true) {
            ++this.ix;
            if (this.ix > this.maxX) {
                this.ix = this.minX;
                do {
                    this.ix = this.minX;
                    ++this.iy;
                    if (this.iy > this.maxY) {
                        this.iy = this.minY;
                        do {
                            ++this.iz;
                            if (this.iz > this.maxZ) {
                                return;
                            }
                            this.slice = this.sliceMap.get(this.iz);
                        } while (this.slice == null);
                    }
                    double y = (double)this.iy * this.cal[1];
                    this.slice.xRayCast(y, this.intersectionXs, this.cal[1]);
                } while (this.intersectionXs.isEmpty());
            }
            double x = (double)this.ix * this.cal[0];
            if (this.intersectionXs.size() == 1) {
                if (x != this.intersectionXs.getQuick(0)) continue;
                this.hasNext = true;
                return;
            }
            int i = this.intersectionXs.binarySearch(x);
            if (i >= 0) {
                this.hasNext = true;
                return;
            }
            int ip = -(i + 1);
            if (ip % 2 != 0) break;
        }
        this.hasNext = true;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    public T next() {
        this.fwd();
        return this.get();
    }

    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    public Cursor<T> copyCursor() {
        BufferMesh dest = new BufferMesh(this.mesh.vertices().size(), this.mesh.triangles().size());
        Meshes.copy(this.mesh, dest);
        return new MeshCursor<T>(this.ra.copy(), dest, (double[])this.cal.clone());
    }

    public Cursor<T> copy() {
        return this.copyCursor();
    }

    public int numDimensions() {
        return 3;
    }

    public T get() {
        return (T)this.ra.get();
    }

    private static final Map<Integer, Slice> buildSliceMap(Mesh mesh, RealInterval boundingBox, double xyScale, double zScale) {
        int minZ = (int)Math.ceil(boundingBox.realMin(2) / zScale);
        int maxZ = (int)Math.floor(boundingBox.realMax(2) / zScale);
        int[] zSlices = new int[maxZ - minZ + 1];
        double[] zPos = new double[zSlices.length];
        for (int i = 0; i < zSlices.length; ++i) {
            zSlices[i] = minZ + i;
            zPos[i] = (double)zSlices[i] * zScale;
        }
        List<Slice> slices = ZSlicer.slices(mesh, zPos, zScale);
        double epsilon = xyScale * 0.25;
        List simplifiedSlices = slices.stream().map(s -> RamerDouglasPeucker.simplify(s, epsilon)).collect(Collectors.toList());
        HashMap<Integer, Slice> sliceMap = new HashMap<Integer, Slice>();
        for (int i = 0; i < zSlices.length; ++i) {
            sliceMap.put(zSlices[i], (Slice)simplifiedSlices.get(i));
        }
        return sliceMap;
    }
}

