/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertices;

public class MollerTrumbore {
    private static final double EPSILON = 1.0E-7;
    private final Vertices vertices;
    private final Triangles triangles;
    private final double[] tmp;

    public MollerTrumbore(Mesh mesh) {
        this.vertices = mesh.vertices();
        this.triangles = mesh.triangles();
        this.tmp = new double[3];
    }

    public boolean rayIntersectsTriangle(long id, double ox, double oy, double oz, double rx, double ry, double rz, double[] intersection) {
        long vertex0 = this.triangles.vertex0(id);
        long vertex1 = this.triangles.vertex1(id);
        long vertex2 = this.triangles.vertex2(id);
        double x0 = this.vertices.x(vertex0);
        double y0 = this.vertices.y(vertex0);
        double z0 = this.vertices.z(vertex0);
        double x1 = this.vertices.x(vertex1);
        double y1 = this.vertices.y(vertex1);
        double z1 = this.vertices.z(vertex1);
        double x2 = this.vertices.x(vertex2);
        double y2 = this.vertices.y(vertex2);
        double z2 = this.vertices.z(vertex2);
        double e1x = x1 - x0;
        double e1y = y1 - y0;
        double e1z = z1 - z0;
        double e2x = x2 - x0;
        double e2y = y2 - y0;
        double e2z = z2 - z0;
        this.cross(rx, ry, rz, e2x, e2y, e2z, this.tmp);
        double hx = this.tmp[0];
        double hy = this.tmp[1];
        double hz = this.tmp[2];
        double a = this.dot(e1x, e1y, e1z, hx, hy, hz);
        if (a > -1.0E-7 && a < 1.0E-7) {
            return false;
        }
        double f = 1.0 / a;
        double sx = ox - x0;
        double sy = oy - y0;
        double sz = oz - z0;
        double u = f * this.dot(sx, sy, sz, hx, hy, hz);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        this.cross(sx, sy, sz, e1x, e1y, e1z, this.tmp);
        double qx = this.tmp[0];
        double qy = this.tmp[1];
        double qz = this.tmp[2];
        double v = f * this.dot(rx, ry, rz, qx, qy, qz);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = f * this.dot(e2x, e2y, e2z, qx, qy, qz);
        if (t < 1.0E-7) {
            return false;
        }
        intersection[0] = ox + t * rx;
        intersection[1] = oy + t * ry;
        intersection[2] = oy + t * rz;
        return true;
    }

    private double dot(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    private void cross(double x1, double y1, double z1, double x2, double y2, double z2, double[] out) {
        out[0] = y1 * z2 - z1 * y2;
        out[1] = -x1 * z2 + z1 * x2;
        out[2] = x1 * y2 - y1 * x2;
    }
}

