/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import java.util.LinkedHashMap;
import java.util.Map;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.mesh.impl.nio.BufferMesh;

public class RemoveDuplicateVertices {
    public static BufferMesh calculate(Mesh mesh, int precision) {
        LinkedHashMap<String, IndexedVertex> vertices = new LinkedHashMap<String, IndexedVertex>();
        int[][] triangles = new int[mesh.triangles().size()][3];
        int trianglesCount = 0;
        for (Triangle triangle : mesh.triangles()) {
            RealPoint p1 = new RealPoint(new double[]{triangle.v0x(), triangle.v0y(), triangle.v0z()});
            RealPoint p2 = new RealPoint(new double[]{triangle.v1x(), triangle.v1y(), triangle.v1z()});
            RealPoint p3 = new RealPoint(new double[]{triangle.v2x(), triangle.v2y(), triangle.v2z()});
            triangles[trianglesCount][0] = RemoveDuplicateVertices.getVertex(vertices, p1, precision);
            triangles[trianglesCount][1] = RemoveDuplicateVertices.getVertex(vertices, p2, precision);
            triangles[trianglesCount][2] = RemoveDuplicateVertices.getVertex(vertices, p3, precision);
            ++trianglesCount;
        }
        BufferMesh res = new BufferMesh(vertices.size(), triangles.length);
        vertices.values().forEach(vertex -> res.vertices().add(vertex.point.getFloatPosition(0), vertex.point.getFloatPosition(1), vertex.point.getFloatPosition(2)));
        for (int[] triangle : triangles) {
            res.triangles().add(triangle[0], triangle[1], triangle[2]);
        }
        return res;
    }

    private static int getVertex(Map<String, IndexedVertex> vertices, RealPoint point, int precision) {
        String hash = RemoveDuplicateVertices.getHash(point, precision);
        IndexedVertex vertex = vertices.get(hash);
        if (vertex == null) {
            return RemoveDuplicateVertices.createVertex(vertices, hash, point, precision);
        }
        return vertex.index;
    }

    private static int createVertex(Map<String, IndexedVertex> vertices, String hash, RealPoint point, int precision) {
        int index = vertices.size();
        IndexedVertex vertex = new IndexedVertex((RealLocalizable)point, index, precision);
        vertices.put(hash, vertex);
        return index;
    }

    private static String getHash(RealPoint point, int precision) {
        int factor = (int)Math.pow(10.0, precision);
        return Math.round(point.getFloatPosition(0) * (float)factor) + "-" + Math.round(point.getFloatPosition(1) * (float)factor) + "-" + Math.round(point.getFloatPosition(2) * (float)factor);
    }

    private static class IndexedVertex {
        int index;
        RealLocalizable point;

        IndexedVertex(RealLocalizable pos, int index, int precision) {
            double[] newpos = new double[pos.numDimensions()];
            double factor = Math.pow(10.0, precision);
            for (int i = 0; i < newpos.length; ++i) {
                newpos[i] = (double)Math.round(pos.getDoublePosition(i) * factor) / factor;
            }
            this.point = new RealPoint(newpos);
            this.index = index;
        }
    }
}

