/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import java.util.Arrays;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Meshes;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.impl.nio.BufferMesh;

public class TaubinSmoothing {
    public static final BufferMesh smooth(Mesh mesh) {
        return TaubinSmoothing.smooth(mesh, 10, 0.1);
    }

    public static final BufferMesh smooth(Mesh mesh, int iters, double passBand) {
        double A = -1.0;
        double B = passBand;
        double C = 2.0;
        double discr = Math.sqrt(B * B - -8.0);
        double r0 = (-B + discr) / -4.0;
        double r1 = (-B - discr) / -4.0;
        double lambda = Math.max(r0, r1);
        double mu = Math.min(r0, r1);
        return TaubinSmoothing.smooth(mesh, iters, lambda, mu, TaubinWeightType.COTANGENT);
    }

    public static final BufferMesh smooth(Mesh mesh, int iters, double lambda, double mu, TaubinWeightType weightType) {
        int nvs = mesh.vertices().size();
        int nts = mesh.triangles().size();
        BufferMesh meshA = new BufferMesh(nvs, nts);
        Meshes.copy(mesh, meshA);
        BufferMesh meshB = new BufferMesh(nvs, nts);
        Meshes.copy(mesh, meshB);
        double[] trace = new double[nvs];
        switch (weightType) {
            case COTANGENT: {
                int i;
                for (i = 0; i < iters; ++i) {
                    TaubinSmoothing.smoothStepCotangent(mesh.triangles(), meshA, meshB, trace, lambda);
                    TaubinSmoothing.smoothStepCotangent(mesh.triangles(), meshB, meshA, trace, mu);
                }
                break;
            }
            case NAIVE: {
                int i;
                for (i = 0; i < iters; ++i) {
                    TaubinSmoothing.smoothStepNaive(mesh.triangles(), meshA, meshB, trace, lambda);
                    TaubinSmoothing.smoothStepNaive(mesh.triangles(), meshB, meshA, trace, mu);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled weight type: " + (Object)((Object)weightType));
            }
        }
        BufferMesh out = new BufferMesh(meshA.vertices().size(), meshA.triangles().size());
        Meshes.calculateNormals(meshA, out);
        return out;
    }

    private static void smoothStepCotangent(Triangles triangles, BufferMesh source, BufferMesh target, double[] trace, double weigth) {
        int i;
        int nvs = source.vertices().size();
        int nts = source.triangles().size();
        for (i = 0; i < nvs; ++i) {
            target.vertices().set(i, 0.0, 0.0, 0.0);
        }
        Arrays.fill(trace, 0.0);
        for (i = 0; i < nts; ++i) {
            int ia = source.triangles().vertex0(i);
            double ax = source.vertices().x(ia);
            double ay = source.vertices().y(ia);
            double az = source.vertices().z(ia);
            int ib = source.triangles().vertex1(i);
            double bx = source.vertices().x(ib);
            double by = source.vertices().y(ib);
            double bz = source.vertices().z(ib);
            int ic = source.triangles().vertex2(i);
            double cx = source.vertices().x(ic);
            double cy = source.vertices().y(ic);
            double cz = source.vertices().z(ic);
            double abx = ax - bx;
            double aby = ay - by;
            double abz = az - bz;
            double bcx = bx - cx;
            double bcy = by - cy;
            double bcz = bz - cz;
            double caz = cz - az;
            double cay = cy - ay;
            double cax = cx - ax;
            double area = 0.5 * TaubinSmoothing.hypot(aby * caz - abz * cay, abz * cax - abx * caz, abx * cay - aby * cax);
            if (area < 1.0E-8) continue;
            double w = -0.5 / area;
            double wa = w * (abx * cax + aby * cay + abz * caz);
            double wb = w * (bcx * abx + bcy * aby + bcz * abz);
            double wc = w * (cax * bcx + cay * bcy + caz * bcz);
            int n = ia;
            trace[n] = trace[n] + (wb + wc);
            int n2 = ib;
            trace[n2] = trace[n2] + (wc + wa);
            int n3 = ic;
            trace[n3] = trace[n3] + (wa + wb);
            TaubinSmoothing.accumulate(target.vertices(), ib, source.vertices(), ic, wa);
            TaubinSmoothing.accumulate(target.vertices(), ic, source.vertices(), ib, wa);
            TaubinSmoothing.accumulate(target.vertices(), ic, source.vertices(), ia, wb);
            TaubinSmoothing.accumulate(target.vertices(), ia, source.vertices(), ic, wb);
            TaubinSmoothing.accumulate(target.vertices(), ia, source.vertices(), ib, wc);
            TaubinSmoothing.accumulate(target.vertices(), ib, source.vertices(), ia, wc);
        }
        for (i = 0; i < nvs; ++i) {
            double ox = target.vertices().x(i);
            double oy = target.vertices().y(i);
            double oz = target.vertices().z(i);
            double ix = source.vertices().x(i);
            double iy = source.vertices().y(i);
            double iz = source.vertices().z(i);
            double tr = trace[i];
            target.vertices().set(i, ix + weigth * (ox / tr - ix), iy + weigth * (oy / tr - iy), iz + weigth * (oz / tr - iz));
        }
    }

    private static void smoothStepNaive(Triangles triangles, BufferMesh source, BufferMesh target, double[] trace, double weigth) {
        int i;
        int nvs = source.vertices().size();
        int nts = source.triangles().size();
        for (i = 0; i < nvs; ++i) {
            target.vertices().set(i, 0.0, 0.0, 0.0);
        }
        Arrays.fill(trace, 0.0);
        for (i = 0; i < nts; ++i) {
            int ia = source.triangles().vertex0(i);
            int ib = source.triangles().vertex1(i);
            int ic = source.triangles().vertex2(i);
            double w = 0.5;
            double wa = 0.5;
            double wb = 0.5;
            double wc = 0.5;
            int n = ia;
            trace[n] = trace[n] + 1.0;
            int n2 = ib;
            trace[n2] = trace[n2] + 1.0;
            int n3 = ic;
            trace[n3] = trace[n3] + 1.0;
            TaubinSmoothing.accumulate(target.vertices(), ib, source.vertices(), ic, 0.5);
            TaubinSmoothing.accumulate(target.vertices(), ic, source.vertices(), ib, 0.5);
            TaubinSmoothing.accumulate(target.vertices(), ic, source.vertices(), ia, 0.5);
            TaubinSmoothing.accumulate(target.vertices(), ia, source.vertices(), ic, 0.5);
            TaubinSmoothing.accumulate(target.vertices(), ia, source.vertices(), ib, 0.5);
            TaubinSmoothing.accumulate(target.vertices(), ib, source.vertices(), ia, 0.5);
        }
        for (i = 0; i < nvs; ++i) {
            double ox = target.vertices().x(i);
            double oy = target.vertices().y(i);
            double oz = target.vertices().z(i);
            double ix = source.vertices().x(i);
            double iy = source.vertices().y(i);
            double iz = source.vertices().z(i);
            double tr = trace[i];
            target.vertices().set(i, ix + weigth * (ox / tr - ix), iy + weigth * (oy / tr - iy), iz + weigth * (oz / tr - iz));
        }
    }

    private static final void accumulate(Vertices out, int ok, Vertices in, int ik, double w) {
        double xo = out.x(ok);
        double yo = out.y(ok);
        double zo = out.z(ok);
        double xi = in.x(ik);
        double yi = in.y(ik);
        double zi = in.z(ik);
        out.set(ok, xo + xi * w, yo + yi * w, zo + zi * w);
    }

    private static final double hypot(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static enum TaubinWeightType {
        COTANGENT,
        NAIVE;

    }
}

