/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg.hull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Vertex;
import net.imglib2.mesh.alg.hull.Horizon;
import net.imglib2.mesh.alg.hull.TriangularFacet;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class ConvexHull {
    private static final double DOUBLE_PREC = 2.220446049250313E-16;
    private static double epsilon;

    public static NaiveDoubleMesh calculate(Mesh input) {
        NaiveDoubleMesh output = new NaiveDoubleMesh();
        LinkedHashSet<net.imglib2.mesh.alg.hull.Vertex> vertices = new LinkedHashSet<net.imglib2.mesh.alg.hull.Vertex>();
        for (Vertex v2 : input.vertices()) {
            net.imglib2.mesh.alg.hull.Vertex vertex = new net.imglib2.mesh.alg.hull.Vertex(v2.x(), v2.y(), v2.z());
            vertices.add(vertex);
        }
        ArrayList<TriangularFacet> facets = new ArrayList<TriangularFacet>();
        ArrayList<TriangularFacet> facetsWithPointInFront = new ArrayList<TriangularFacet>();
        epsilon = ConvexHull.computeHull(vertices, facets, facetsWithPointInFront);
        HashMap<net.imglib2.mesh.alg.hull.Vertex, Long> vertexIndices = new HashMap<net.imglib2.mesh.alg.hull.Vertex, Long>();
        for (TriangularFacet f : facets) {
            net.imglib2.mesh.alg.hull.Vertex v0 = f.getP0();
            net.imglib2.mesh.alg.hull.Vertex v1 = f.getP1();
            net.imglib2.mesh.alg.hull.Vertex v2 = f.getP2();
            long vIndex0 = vertexIndices.computeIfAbsent(v0, v -> output.vertices().add(v0.getX(), v0.getY(), v0.getZ()));
            long vIndex1 = vertexIndices.computeIfAbsent(v1, v -> output.vertices().add(v1.getX(), v1.getY(), v1.getZ()));
            long vIndex2 = vertexIndices.computeIfAbsent(v2, v -> output.vertices().add(v2.getX(), v2.getY(), v2.getZ()));
            Vector3D normal = f.getNormal();
            double nx = normal.getX();
            double ny = normal.getY();
            double nz = normal.getZ();
            output.triangles().add(vIndex0, vIndex1, vIndex2, nx, ny, nz);
        }
        return output;
    }

    public static double calculateEpsilon(Mesh input) {
        LinkedHashSet<net.imglib2.mesh.alg.hull.Vertex> vertices = new LinkedHashSet<net.imglib2.mesh.alg.hull.Vertex>();
        for (Vertex v : input.vertices()) {
            net.imglib2.mesh.alg.hull.Vertex vertex = new net.imglib2.mesh.alg.hull.Vertex(v.x(), v.y(), v.z());
            vertices.add(vertex);
        }
        ArrayList<TriangularFacet> facets = new ArrayList<TriangularFacet>();
        ArrayList<TriangularFacet> facetsWithPointInFront = new ArrayList<TriangularFacet>();
        return ConvexHull.computeHull(vertices, facets, facetsWithPointInFront);
    }

    private static double computeHull(Set<net.imglib2.mesh.alg.hull.Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront) {
        double eps = ConvexHull.createSimplex(vertices, facets, facetsWithPointInFront);
        while (!facetsWithPointInFront.isEmpty()) {
            ConvexHull.replaceFacet(eps, vertices, facets, facetsWithPointInFront, facetsWithPointInFront.remove(0));
        }
        return eps;
    }

    private static void replaceFacet(double eps, Set<net.imglib2.mesh.alg.hull.Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsPointInFront, TriangularFacet facet) {
        net.imglib2.mesh.alg.hull.Vertex v = facet.getMaximumDistanceVertex();
        Horizon horizon = ConvexHull.computeHorizon(eps, vertices, facets, facetsPointInFront, facet, v);
        ConvexHull.assignPointsToFacets(eps, vertices, ConvexHull.createFacets(horizon, v), facets, facetsPointInFront);
    }

    private static List<TriangularFacet> createFacets(Horizon horizon, net.imglib2.mesh.alg.hull.Vertex vTop) {
        net.imglib2.mesh.alg.hull.Vertex vRight;
        net.imglib2.mesh.alg.hull.Vertex vLeft;
        ArrayList<TriangularFacet> newFacets = new ArrayList<TriangularFacet>();
        for (int i = 1; i < horizon.size(); ++i) {
            vLeft = horizon.getVertex(i - 1);
            vRight = horizon.getVertex(i);
            TriangularFacet f = new TriangularFacet(vRight, vTop, vLeft);
            ConvexHull.setNeighborZero(f, (TriangularFacet)horizon.getNeighbor(i));
            newFacets.add(f);
        }
        vRight = horizon.getVertex(0);
        vLeft = horizon.getLastVertex();
        TriangularFacet f = new TriangularFacet(vRight, vTop, vLeft);
        ConvexHull.setNeighborZero(f, (TriangularFacet)horizon.getNeighbor(0));
        newFacets.add(f);
        ConvexHull.connectTriangles(newFacets);
        return newFacets;
    }

    private static void connectTriangles(List<TriangularFacet> newFacets) {
        int lastFacetIndex = newFacets.size() - 1;
        for (int i = 1; i < lastFacetIndex; ++i) {
            newFacets.get(i).setNeighbor(1, newFacets.get(i + 1));
            newFacets.get(i).setNeighbor(2, newFacets.get(i - 1));
        }
        newFacets.get(0).setNeighbor(1, newFacets.get(1));
        newFacets.get(0).setNeighbor(2, newFacets.get(lastFacetIndex));
        newFacets.get(lastFacetIndex).setNeighbor(1, newFacets.get(0));
        newFacets.get(lastFacetIndex).setNeighbor(2, newFacets.get(newFacets.size() - 2));
    }

    private static void setNeighborZero(TriangularFacet f, TriangularFacet n) {
        int vertexIndex = n.indexOfVertex(f.getVertex(2));
        n.replaceNeighbor(vertexIndex, f);
        f.setNeighbor(0, n);
    }

    private static Horizon computeHorizon(double eps, Set<net.imglib2.mesh.alg.hull.Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront, TriangularFacet frontFacet, net.imglib2.mesh.alg.hull.Vertex vTop) {
        vertices.addAll(frontFacet.getVerticesInFront());
        facets.remove(frontFacet);
        Horizon h = new Horizon(frontFacet);
        TriangularFacet merge = ConvexHull.nextFacetToMerge(eps, h, vTop);
        while (merge != null) {
            vertices.addAll(merge.getVerticesInFront());
            facets.remove(merge);
            facetsWithPointInFront.remove(merge);
            if (h.containsAll(merge.getVertices())) {
                ConvexHull.updateNeighbors(frontFacet, merge);
                h.complexMerge(merge);
            } else {
                ConvexHull.updateNeighbors(frontFacet, merge);
                h.simpleMerge(merge);
            }
            merge = ConvexHull.nextFacetToMerge(eps, h, vTop);
        }
        return h;
    }

    private static void updateNeighbors(TriangularFacet frontFacet, TriangularFacet merge) {
        for (TriangularFacet f : merge.getNeighbors()) {
            if (f.equals(frontFacet)) continue;
            f.replaceNeighbor(f.indexOfNeighbor(merge), frontFacet);
        }
    }

    private static TriangularFacet nextFacetToMerge(double eps, Horizon frontFacet, net.imglib2.mesh.alg.hull.Vertex vTop) {
        for (TriangularFacet f : frontFacet.getNeighbors()) {
            if (!(f.distanceToPlane(vTop) > eps)) continue;
            if (frontFacet.containsAll(f.getVertices())) {
                net.imglib2.mesh.alg.hull.Vertex v0 = f.getVertex(0);
                net.imglib2.mesh.alg.hull.Vertex v1 = f.getVertex(1);
                net.imglib2.mesh.alg.hull.Vertex v2 = f.getVertex(2);
                int numEdges = 0;
                if (frontFacet.hasEdge(v0, v2)) {
                    ++numEdges;
                }
                if (frontFacet.hasEdge(v2, v1)) {
                    ++numEdges;
                }
                if (frontFacet.hasEdge(v1, v0)) {
                    ++numEdges;
                }
                if (numEdges == 1) continue;
            }
            return f;
        }
        return null;
    }

    private static void assignPointsToFacets(double eps, Set<net.imglib2.mesh.alg.hull.Vertex> vertices, List<TriangularFacet> newFacets, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront) {
        for (net.imglib2.mesh.alg.hull.Vertex v : vertices) {
            Iterator<TriangularFacet> facetIt = newFacets.iterator();
            TriangularFacet maxFacet = null;
            double maxdis = eps;
            while (facetIt.hasNext()) {
                TriangularFacet f = facetIt.next();
                double distanceToPlane = f.distanceToPlane(v);
                if (!(distanceToPlane > maxdis)) continue;
                maxdis = distanceToPlane;
                maxFacet = f;
            }
            if (maxFacet == null) continue;
            maxFacet.setVertexInFront(v, maxdis);
            if (facetsWithPointInFront.contains(maxFacet)) continue;
            facetsWithPointInFront.add(maxFacet);
        }
        facets.addAll(newFacets);
        vertices.clear();
    }

    private static double createSimplex(Set<net.imglib2.mesh.alg.hull.Vertex> vertices, List<TriangularFacet> facets, List<TriangularFacet> facetsWithPointInFront) {
        Pair<Double, net.imglib2.mesh.alg.hull.Vertex[]> minMax = ConvexHull.computeMinMax(vertices);
        double eps = (Double)minMax.getA();
        int i = ConvexHull.getMaxDistPointIndex((net.imglib2.mesh.alg.hull.Vertex[])minMax.getB());
        net.imglib2.mesh.alg.hull.Vertex v0 = ((net.imglib2.mesh.alg.hull.Vertex[])minMax.getB())[i];
        net.imglib2.mesh.alg.hull.Vertex v1 = ((net.imglib2.mesh.alg.hull.Vertex[])minMax.getB())[i + 3];
        vertices.remove(v0);
        vertices.remove(v1);
        net.imglib2.mesh.alg.hull.Vertex v2 = ConvexHull.getV2(eps, vertices, v0, v1);
        vertices.remove(v2);
        net.imglib2.mesh.alg.hull.Vertex v3 = ConvexHull.getV3(eps, vertices, v0, v1, v2);
        vertices.remove(v3);
        TriangularFacet f0 = new TriangularFacet(v0, v1, v2);
        if (f0.distanceToPlane(v3) > eps) {
            net.imglib2.mesh.alg.hull.Vertex tmp = v1;
            v1 = v2;
            v2 = tmp;
            f0 = new TriangularFacet(v0, v1, v2);
        }
        assert (f0.distanceToPlane(v3) < eps);
        TriangularFacet f1 = new TriangularFacet(v1, v0, v3);
        TriangularFacet f2 = new TriangularFacet(v2, v1, v3);
        TriangularFacet f3 = new TriangularFacet(v0, v2, v3);
        f0.setNeighbor(0, f3);
        f0.setNeighbor(1, f1);
        f0.setNeighbor(2, f2);
        f1.setNeighbor(0, f2);
        f1.setNeighbor(1, f0);
        f1.setNeighbor(2, f3);
        f2.setNeighbor(0, f3);
        f2.setNeighbor(1, f0);
        f2.setNeighbor(2, f1);
        f3.setNeighbor(0, f1);
        f3.setNeighbor(1, f0);
        f3.setNeighbor(2, f2);
        assert (f0.distanceToPlane(v3) < eps);
        assert (f1.distanceToPlane(v2) < eps);
        assert (f2.distanceToPlane(v0) < eps);
        assert (f3.distanceToPlane(v1) < eps);
        ArrayList<TriangularFacet> newFacets = new ArrayList<TriangularFacet>();
        newFacets.add(f0);
        newFacets.add(f1);
        newFacets.add(f2);
        newFacets.add(f3);
        ConvexHull.assignPointsToFacets(eps, vertices, newFacets, facets, facetsWithPointInFront);
        return eps;
    }

    private static net.imglib2.mesh.alg.hull.Vertex getV3(double eps, Set<net.imglib2.mesh.alg.hull.Vertex> vertices, net.imglib2.mesh.alg.hull.Vertex v0, net.imglib2.mesh.alg.hull.Vertex v1, net.imglib2.mesh.alg.hull.Vertex v2) {
        double distPlanePoint = eps;
        net.imglib2.mesh.alg.hull.Vertex v3 = null;
        Vector d0 = v1.subtract((Vector)v0);
        Vector d1 = v2.subtract((Vector)v0);
        Vector3D normal = ((Vector3D)d0).crossProduct(d1).normalize();
        for (net.imglib2.mesh.alg.hull.Vertex v : vertices) {
            double d = Math.abs(normal.dotProduct(v.subtract((Vector)v0)));
            if (!(d > distPlanePoint)) continue;
            distPlanePoint = d;
            v3 = v;
        }
        return v3;
    }

    private static net.imglib2.mesh.alg.hull.Vertex getV2(double eps, Set<net.imglib2.mesh.alg.hull.Vertex> vertices, net.imglib2.mesh.alg.hull.Vertex v0, net.imglib2.mesh.alg.hull.Vertex v1) {
        Iterator<net.imglib2.mesh.alg.hull.Vertex> it = vertices.iterator();
        double distLinePoint = eps;
        net.imglib2.mesh.alg.hull.Vertex v2 = null;
        while (it.hasNext()) {
            Vector d1;
            net.imglib2.mesh.alg.hull.Vertex v = it.next();
            Vector d0 = v.subtract((Vector)v1);
            double lengthSq = ((Vector3D)d0).crossProduct(d1 = v.subtract((Vector)v0)).getNormSq();
            if (!(lengthSq > distLinePoint)) continue;
            distLinePoint = lengthSq;
            v2 = v;
        }
        return v2;
    }

    private static int getMaxDistPointIndex(net.imglib2.mesh.alg.hull.Vertex[] minMax) {
        double[] diff = new double[]{minMax[3].getX() - minMax[0].getX(), minMax[4].getY() - minMax[1].getY(), minMax[5].getZ() - minMax[2].getZ()};
        double max = 0.0;
        int imax = 0;
        for (int i = 0; i < diff.length; ++i) {
            if (!(diff[i] > max)) continue;
            max = diff[i];
            imax = i;
        }
        return imax;
    }

    private static Pair<Double, net.imglib2.mesh.alg.hull.Vertex[]> computeMinMax(Set<net.imglib2.mesh.alg.hull.Vertex> vertices) {
        double maxZ;
        double maxY;
        double maxX;
        net.imglib2.mesh.alg.hull.Vertex[] minMax = new net.imglib2.mesh.alg.hull.Vertex[6];
        Iterator<net.imglib2.mesh.alg.hull.Vertex> it = vertices.iterator();
        net.imglib2.mesh.alg.hull.Vertex initPoint = it.next();
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = initPoint;
        }
        double minX = maxX = initPoint.getX();
        double minY = maxY = initPoint.getY();
        double minZ = maxZ = initPoint.getZ();
        while (it.hasNext()) {
            net.imglib2.mesh.alg.hull.Vertex v = it.next();
            if (v.getX() > maxX) {
                maxX = v.getX();
                minMax[3] = v;
            } else if (v.getX() < minX) {
                minX = v.getX();
                minMax[0] = v;
            }
            if (v.getY() > maxY) {
                maxY = v.getY();
                minMax[4] = v;
            } else if (v.getY() < minY) {
                minY = v.getY();
                minMax[2] = v;
            }
            if (v.getZ() > maxZ) {
                maxZ = v.getZ();
                minMax[5] = v;
                continue;
            }
            if (!(v.getZ() < minZ)) continue;
            minZ = v.getZ();
            minMax[3] = v;
        }
        double eps = 6.661338147750939E-16 * (Math.max(Math.abs(maxX), Math.abs(minX)) + Math.max(Math.abs(maxY), Math.abs(minY)) + Math.max(Math.abs(maxZ), Math.abs(minZ)));
        return new ValuePair((Object)eps, (Object)minMax);
    }

    public static double lastEpsilon() {
        return epsilon;
    }
}

