/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg.zslicer;

import gnu.trove.list.array.TDoubleArrayList;

public final class Contour {
    private final TDoubleArrayList x;
    private final TDoubleArrayList y;
    private final TDoubleArrayList nx;
    private final TDoubleArrayList ny;
    private final boolean isInterior;

    public Contour(boolean isInterior) {
        this(new TDoubleArrayList(), new TDoubleArrayList(), new TDoubleArrayList(), new TDoubleArrayList(), isInterior);
    }

    public Contour(TDoubleArrayList x, TDoubleArrayList y, TDoubleArrayList nx, TDoubleArrayList ny, boolean isInterior) {
        this.x = x;
        this.y = y;
        this.nx = nx;
        this.ny = ny;
        this.isInterior = isInterior;
    }

    void add(double x, double y, double nx, double ny) {
        this.x.add(x);
        this.y.add(y);
        this.nx.add(nx);
        this.ny.add(ny);
    }

    public boolean isInterior() {
        return this.isInterior;
    }

    public double centerX() {
        double sum = 0.0;
        for (int i = 0; i < this.x.size(); ++i) {
            sum += this.x.getQuick(i);
        }
        return sum / (double)this.x.size();
    }

    public double centerY() {
        double sum = 0.0;
        for (int i = 0; i < this.y.size(); ++i) {
            sum += this.y.getQuick(i);
        }
        return sum / (double)this.y.size();
    }

    public int size() {
        return this.x.size();
    }

    public double x(int i) {
        return this.x.getQuick(i);
    }

    public double y(int i) {
        return this.y.getQuick(i);
    }

    public double nx(int i) {
        return this.nx.getQuick(i);
    }

    public double ny(int i) {
        return this.ny.getQuick(i);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(super.toString());
        str.append(String.format("\n%d vertices, is interior: %s", this.x.size(), this.isInterior));
        return str.toString();
    }

    public double area() {
        return Math.abs(Contour.signedArea(this.x, this.y));
    }

    private static final double signedArea(TDoubleArrayList x, TDoubleArrayList y) {
        int n = x.size();
        double a = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            a += x.getQuick(i) * y.getQuick(i + 1) - x.getQuick(i + 1) * y.getQuick(i);
        }
        return (a + x.getQuick(n - 1) * y.getQuick(0) - x.getQuick(0) * y.getQuick(n - 1)) / 2.0;
    }
}

