/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg.zslicer;

import java.util.ArrayList;
import net.imglib2.mesh.alg.zslicer.Contour;
import net.imglib2.mesh.alg.zslicer.Slice;

public class RamerDouglasPeucker {
    public static final Slice simplify(Slice slice, double epsilon) {
        ArrayList<Contour> simplifiedSlice = new ArrayList<Contour>(slice.size());
        for (Contour contour : slice) {
            Contour out = new Contour(contour.isInterior());
            RamerDouglasPeucker.douglasPeucker(contour, 0, contour.size(), epsilon, out);
            simplifiedSlice.add(out);
        }
        return new Slice(simplifiedSlice);
    }

    public static final Contour simplify(Contour in, double epsilon) {
        Contour out = new Contour(in.isInterior());
        RamerDouglasPeucker.douglasPeucker(in, 0, in.size(), epsilon, out);
        return out;
    }

    private static final void douglasPeucker(Contour in, int s, int e, double epsilon, Contour out) {
        double dmax = 0.0;
        int index = 0;
        int start = s;
        int end = e - 1;
        for (int i = start + 1; i < end; ++i) {
            double wy;
            double wx;
            double vy;
            double vx;
            double py;
            double px = in.x(i);
            double d = RamerDouglasPeucker.perpendicularDistance(px, py = in.y(i), vx = in.x(start), vy = in.y(start), wx = in.x(end), wy = in.y(end));
            if (!(d > dmax)) continue;
            index = i;
            dmax = d;
        }
        if (dmax > epsilon) {
            RamerDouglasPeucker.douglasPeucker(in, s, index, epsilon, out);
            RamerDouglasPeucker.douglasPeucker(in, index, e, epsilon, out);
        } else if (end - start > 0) {
            out.add(in.x(start), in.y(start), in.nx(start), in.ny(start));
            out.add(in.x(end), in.y(end), in.nx(end), in.ny(end));
        } else {
            double sumnx = 0.0;
            double sumny = 0.0;
            for (int i = start; i < end; ++i) {
                sumnx += in.nx(i);
                sumny += in.ny(i);
            }
            int n = end - start;
            out.add(in.x(start), in.y(start), sumnx / (double)n, sumny / (double)n);
        }
    }

    private static final double perpendicularDistance(double px, double py, double vx, double vy, double wx, double wy) {
        return Math.sqrt(RamerDouglasPeucker.distanceToSegmentSquared(px, py, vx, vy, wx, wy));
    }

    private static final double distanceToSegmentSquared(double px, double py, double vx, double vy, double wx, double wy) {
        double l2 = RamerDouglasPeucker.distanceSquaredBetweenPoints(vx, vy, wx, wy);
        if (l2 == 0.0) {
            return RamerDouglasPeucker.distanceSquaredBetweenPoints(px, py, vx, vy);
        }
        double t = ((px - vx) * (wx - vx) + (py - vy) * (wy - vy)) / l2;
        if (t < 0.0) {
            return RamerDouglasPeucker.distanceSquaredBetweenPoints(px, py, vx, vy);
        }
        if (t > 1.0) {
            return RamerDouglasPeucker.distanceSquaredBetweenPoints(px, py, wx, wy);
        }
        return RamerDouglasPeucker.distanceSquaredBetweenPoints(px, py, vx + t * (wx - vx), vy + t * (wy - vy));
    }

    private static final double distanceSquaredBetweenPoints(double vx, double vy, double wx, double wy) {
        double deltax = vx - wx;
        double deltay = vy - wy;
        return deltax * deltax + deltay * deltay;
    }
}

