/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg.zslicer;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.imglib2.mesh.alg.zslicer.Contour;
import net.imglib2.mesh.util.MeshUtil;
import net.imglib2.mesh.util.SortTrove;

public class Slice
implements Collection<Contour> {
    private final List<Contour> contours;

    Slice(Collection<Contour> contours) {
        this.contours = new ArrayList<Contour>(contours);
        this.contours.sort(Comparator.comparing(Contour::area).reversed());
    }

    @Override
    public int size() {
        return this.contours.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contours.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.contours.contains(o);
    }

    @Override
    public Iterator<Contour> iterator() {
        return this.contours.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.contours.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.contours.toArray(a);
    }

    @Override
    public boolean add(Contour e) {
        throw new UnsupportedOperationException("Slice class is unmodifiable.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Slice class is unmodifiable.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.contours.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Contour> c) {
        throw new UnsupportedOperationException("Slice class is unmodifiable.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Slice class is unmodifiable.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Slice class is unmodifiable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Slice class is unmodifiable.");
    }

    public void xRayCast(double y, TDoubleArrayList x, TDoubleArrayList nx, double yScale) {
        x.resetQuick();
        nx.resetQuick();
        double yr = MeshUtil.mround(y, yScale * 4.0E-4, 2, 1);
        for (Contour c : this.contours) {
            int i = 0;
            int j = c.size() - 1;
            while (i < c.size()) {
                double yi = MeshUtil.mround(c.y(i), yScale * 4.0E-4, 2, 0);
                double yj = MeshUtil.mround(c.y(j), yScale * 4.0E-4, 2, 0);
                if (!(yj > yr && yi > yr || yj < yr && yi < yr)) {
                    double xi = c.x(i);
                    double xj = c.x(j);
                    double s = (yr - yj) / (yi - yj);
                    double xr = xj + s * (xi - xj);
                    x.add(xr);
                    nx.add(c.nx(j));
                }
                j = i++;
            }
        }
        int[] index = SortTrove.quicksort(x);
        SortTrove.reorder(nx, index);
    }

    public void xRayCast(double y, TDoubleArrayList x, double yScale) {
        x.resetQuick();
        double yr = MeshUtil.mround(y, yScale * 4.0E-4, 2, 1);
        for (Contour c : this.contours) {
            int i = 0;
            int j = c.size() - 1;
            while (i < c.size()) {
                double yi = MeshUtil.mround(c.y(i), yScale * 4.0E-4, 2, 0);
                double yj = MeshUtil.mround(c.y(j), yScale * 4.0E-4, 2, 0);
                if (!(yj > yr && yi > yr || yj < yr && yi < yr)) {
                    double xi = c.x(i);
                    double xj = c.x(j);
                    double s = (yr - yj) / (yi - yj);
                    double xr = xj + s * (xi - xj);
                    x.add(xr);
                }
                j = i++;
            }
        }
        x.sort();
    }
}

