/*
 * Decompiled with CFR 0.152.
 */
package flimlib;

import flimlib.DecayModel;
import flimlib.FLIMLibConstants;
import flimlib.FLIMLibJNI;
import flimlib.FitFunc;
import flimlib.FitFuncNative;
import flimlib.FitType;
import flimlib.Float2DMatrix;
import flimlib.Int2DMatrix;
import flimlib.NoiseType;
import flimlib.RestrainType;

public class FLIMLib
implements FLIMLibConstants {
    public static float getSPAProgress() {
        return FLIMLibJNI.getSPAProgress();
    }

    public static int GCI_triple_integral_fitting_engine(float xincr, float[] y, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, float[] Z, float[] A, float[] tau, float[] fitted, float[] residuals, float[] chisq, float chisq_target) {
        return FLIMLibJNI.GCI_triple_integral_fitting_engine(xincr, y, fit_start, fit_end, instr, noise.swigValue(), sig, Z, A, tau, fitted, residuals, chisq, chisq_target);
    }

    public static int GCI_marquardt_fitting_engine(float xincr, float[] trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, float[] param, boolean[] paramfree, RestrainType restrain, FitFunc fitfunc, float[] fitted, float[] residuals, float[] chisq, Float2DMatrix covar, Float2DMatrix alpha, Float2DMatrix erraxes, float chisq_target, float chisq_delta, int chisq_percent) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_marquardt_fitting_engine(xincr, trans, fit_start, fit_end, instr, noise.swigValue(), sig, param, paramfree, restrain.swigValue(), FitFuncNative.getCPtr(n), fitted, residuals, chisq, Float2DMatrix.getCPtr(covar), covar, Float2DMatrix.getCPtr(alpha), alpha, Float2DMatrix.getCPtr(erraxes), erraxes, chisq_target, chisq_delta, chisq_percent);
    }

    public static int GCI_triple_integral(float xincr, float[] y, int fit_start, int fit_end, NoiseType noise, float[] sig, float[] Z, float[] A, float[] tau, float[] fitted, float[] residuals, float[] chisq, int division) {
        return FLIMLibJNI.GCI_triple_integral(xincr, y, fit_start, fit_end, noise.swigValue(), sig, Z, A, tau, fitted, residuals, chisq, division);
    }

    public static int GCI_triple_integral_instr(float xincr, float[] y, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, float[] Z, float[] A, float[] tau, float[] fitted, float[] residuals, float[] chisq, int division) {
        return FLIMLibJNI.GCI_triple_integral_instr(xincr, y, fit_start, fit_end, instr, noise.swigValue(), sig, Z, A, tau, fitted, residuals, chisq, division);
    }

    public static int GCI_marquardt(float[] x, float[] y, NoiseType noise, float[] sig, float[] param, boolean[] paramfree, RestrainType restrain, FitFunc fitfunc, float[] fitted, float[] residuals, Float2DMatrix covar, Float2DMatrix alpha, float[] chisq, float chisq_delta, float chisq_percent, Float2DMatrix erraxes) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_marquardt(x, y, noise.swigValue(), sig, param, paramfree, restrain.swigValue(), FitFuncNative.getCPtr(n), fitted, residuals, Float2DMatrix.getCPtr(covar), covar, Float2DMatrix.getCPtr(alpha), alpha, chisq, chisq_delta, chisq_percent, Float2DMatrix.getCPtr(erraxes), erraxes);
    }

    public static int GCI_marquardt_instr(float xincr, float[] y, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, float[] param, boolean[] paramfree, RestrainType restrain, FitFunc fitfunc, float[] fitted, float[] residuals, Float2DMatrix covar, Float2DMatrix alpha, float[] chisq, float chisq_delta, float chisq_percent, Float2DMatrix erraxes) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_marquardt_instr(xincr, y, fit_start, fit_end, instr, noise.swigValue(), sig, param, paramfree, restrain.swigValue(), FitFuncNative.getCPtr(n), fitted, residuals, Float2DMatrix.getCPtr(covar), covar, Float2DMatrix.getCPtr(alpha), alpha, chisq, chisq_delta, chisq_percent, Float2DMatrix.getCPtr(erraxes), erraxes);
    }

    public static void GCI_marquardt_cleanup() {
        FLIMLibJNI.GCI_marquardt_cleanup();
    }

    public static int GCI_EcfModelSelectionEngine(float xincr, float[] trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, DecayModel[] paramsandfits, float[] chisq_diff, int[] model) {
        if (paramsandfits.length != 2) {
            throw new IllegalArgumentException("Requires 2 models.");
        }
        if (paramsandfits[0] == null || paramsandfits[1] == null) {
            throw new NullPointerException("Array contains null");
        }
        return FLIMLibJNI.GCI_EcfModelSelectionEngine(xincr, trans, fit_start, fit_end, instr, noise.swigValue(), sig, paramsandfits, chisq_diff, model);
    }

    public static int GCI_marquardt_global_exps_instr(float xincr, Float2DMatrix trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, FitType ftype, Float2DMatrix param, boolean[] paramfree, RestrainType restrain, float chisq_delta, Float2DMatrix fitted, Float2DMatrix residuals, float[] chisq_trans, float[] chisq_global, int[] df, int drop_bad_transients) {
        return FLIMLibJNI.GCI_marquardt_global_exps_instr(xincr, Float2DMatrix.getCPtr(trans), trans, fit_start, fit_end, instr, noise.swigValue(), sig, ftype.swigValue(), Float2DMatrix.getCPtr(param), param, paramfree, restrain.swigValue(), chisq_delta, Float2DMatrix.getCPtr(fitted), fitted, Float2DMatrix.getCPtr(residuals), residuals, chisq_trans, chisq_global, df, drop_bad_transients);
    }

    public static int GCI_marquardt_global_generic_instr(float xincr, Float2DMatrix trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, Float2DMatrix param, boolean[] paramfree, int[] gparam, RestrainType restrain, float chisq_delta, FitFunc fitfunc, Float2DMatrix fitted, Float2DMatrix residuals, float[] chisq_trans, float[] chisq_global, int[] df) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_marquardt_global_generic_instr(xincr, Float2DMatrix.getCPtr(trans), trans, fit_start, fit_end, instr, noise.swigValue(), sig, Float2DMatrix.getCPtr(param), param, paramfree, gparam, restrain.swigValue(), chisq_delta, FitFuncNative.getCPtr(n), Float2DMatrix.getCPtr(fitted), fitted, Float2DMatrix.getCPtr(residuals), residuals, chisq_trans, chisq_global, df);
    }

    public static int GCI_SPA_1D_marquardt(float[] x, float[] y, NoiseType noise, float[] sig, float[] param, boolean[] paramfree, RestrainType restrain, float chisq_delta, FitFunc fitfunc, int spa_param, int spa_nvalues, float spa_low, float spa_high, float[] chisq) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_SPA_1D_marquardt(x, y, noise.swigValue(), sig, param, paramfree, restrain.swigValue(), chisq_delta, FitFuncNative.getCPtr(n), spa_param, spa_nvalues, spa_low, spa_high, chisq);
    }

    public static int GCI_SPA_2D_marquardt(float[] x, float[] y, NoiseType noise, float[] sig, float[] param, boolean[] paramfree, RestrainType restrain, float chisq_delta, FitFunc fitfunc, int spa_param1, int spa_nvalues1, float spa_low1, float spa_high1, int spa_param2, int spa_nvalues2, float spa_low2, float spa_high2, Float2DMatrix chisq) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_SPA_2D_marquardt(x, y, noise.swigValue(), sig, param, paramfree, restrain.swigValue(), chisq_delta, FitFuncNative.getCPtr(n), spa_param1, spa_nvalues1, spa_low1, spa_high1, spa_param2, spa_nvalues2, spa_low2, spa_high2, Float2DMatrix.getCPtr(chisq), chisq);
    }

    public static int GCI_SPA_1D_marquardt_instr(float xincr, float[] y, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, float[] param, boolean[] paramfree, RestrainType restrain, float chisq_delta, FitFunc fitfunc, int spa_param, int spa_nvalues, float spa_low, float spa_high, float[] chisq, float chisq_target) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_SPA_1D_marquardt_instr(xincr, y, fit_start, fit_end, instr, noise.swigValue(), sig, param, paramfree, restrain.swigValue(), chisq_delta, FitFuncNative.getCPtr(n), spa_param, spa_nvalues, spa_low, spa_high, chisq, chisq_target);
    }

    public static int GCI_SPA_2D_marquardt_instr(float xincr, float[] y, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, float[] param, boolean[] paramfree, RestrainType restrain, float chisq_delta, FitFunc fitfunc, int spa_param1, int spa_nvalues1, float spa_low1, float spa_high1, int spa_param2, int spa_nvalues2, float spa_low2, float spa_high2, Float2DMatrix chisq, float chisq_target) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_SPA_2D_marquardt_instr(xincr, y, fit_start, fit_end, instr, noise.swigValue(), sig, param, paramfree, restrain.swigValue(), chisq_delta, FitFuncNative.getCPtr(n), spa_param1, spa_nvalues1, spa_low1, spa_high1, spa_param2, spa_nvalues2, spa_low2, spa_high2, Float2DMatrix.getCPtr(chisq), chisq, chisq_target);
    }

    public static int GCI_SPA_1D_marquardt_global_exps_instr(float xincr, Float2DMatrix trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, FitType ftype, Float2DMatrix param, boolean[] paramfree, RestrainType restrain, float chisq_delta, int drop_bad_transients, int spa_param, int spa_nvalues, float spa_low, float spa_high, float[] chisq_global, int[] df) {
        return FLIMLibJNI.GCI_SPA_1D_marquardt_global_exps_instr(xincr, Float2DMatrix.getCPtr(trans), trans, fit_start, fit_end, instr, noise.swigValue(), sig, ftype.swigValue(), Float2DMatrix.getCPtr(param), param, paramfree, restrain.swigValue(), chisq_delta, drop_bad_transients, spa_param, spa_nvalues, spa_low, spa_high, chisq_global, df);
    }

    public static int GCI_SPA_2D_marquardt_global_exps_instr(float xincr, Float2DMatrix trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, FitType ftype, Float2DMatrix param, boolean[] paramfree, RestrainType restrain, float chisq_delta, int drop_bad_transients, int spa_param1, int spa_nvalues1, float spa_low1, float spa_high1, int spa_param2, int spa_nvalues2, float spa_low2, float spa_high2, Float2DMatrix chisq_global, Int2DMatrix df) {
        return FLIMLibJNI.GCI_SPA_2D_marquardt_global_exps_instr(xincr, Float2DMatrix.getCPtr(trans), trans, fit_start, fit_end, instr, noise.swigValue(), sig, ftype.swigValue(), Float2DMatrix.getCPtr(param), param, paramfree, restrain.swigValue(), chisq_delta, drop_bad_transients, spa_param1, spa_nvalues1, spa_low1, spa_high1, spa_param2, spa_nvalues2, spa_low2, spa_high2, Float2DMatrix.getCPtr(chisq_global), chisq_global, Int2DMatrix.getCPtr(df), df);
    }

    public static int GCI_SPA_1D_marquardt_global_generic_instr(float xincr, Float2DMatrix trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, Float2DMatrix param, boolean[] paramfree, int[] gparam, RestrainType restrain, float chisq_delta, FitFunc fitfunc, int spa_param, int spa_nvalues, float spa_low, float spa_high, float[] chisq_global, int[] df) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_SPA_1D_marquardt_global_generic_instr(xincr, Float2DMatrix.getCPtr(trans), trans, fit_start, fit_end, instr, noise.swigValue(), sig, Float2DMatrix.getCPtr(param), param, paramfree, gparam, restrain.swigValue(), chisq_delta, FitFuncNative.getCPtr(n), spa_param, spa_nvalues, spa_low, spa_high, chisq_global, df);
    }

    public static int GCI_SPA_2D_marquardt_global_generic_instr(float xincr, Float2DMatrix trans, int fit_start, int fit_end, float[] instr, NoiseType noise, float[] sig, Float2DMatrix param, boolean[] paramfree, int[] gparam, RestrainType restrain, float chisq_delta, FitFunc fitfunc, int spa_param1, int spa_nvalues1, float spa_low1, float spa_high1, int spa_param2, int spa_nvalues2, float spa_low2, float spa_high2, Float2DMatrix chisq_global, Int2DMatrix df) {
        FitFuncNative n = FitFuncNative.makeNative(fitfunc);
        return FLIMLibJNI.GCI_SPA_2D_marquardt_global_generic_instr(xincr, Float2DMatrix.getCPtr(trans), trans, fit_start, fit_end, instr, noise.swigValue(), sig, Float2DMatrix.getCPtr(param), param, paramfree, gparam, restrain.swigValue(), chisq_delta, FitFuncNative.getCPtr(n), spa_param1, spa_nvalues1, spa_low1, spa_high1, spa_param2, spa_nvalues2, spa_low2, spa_high2, Float2DMatrix.getCPtr(chisq_global), chisq_global, Int2DMatrix.getCPtr(df), df);
    }

    public static int GCI_set_restrain_limits(boolean[] restrain, float[] minval, float[] maxval) {
        return FLIMLibJNI.GCI_set_restrain_limits(restrain, minval, maxval);
    }

    public static void ECF_ExportParams_start(String path) {
        FLIMLibJNI.ECF_ExportParams_start(path);
    }

    public static void ECF_ExportParams_stop() {
        FLIMLibJNI.ECF_ExportParams_stop();
    }

    public static int RLD_fit(double x_inc, double[] y, int fit_start, int fit_end, double[] instr, int noise, double[] sig, double[] z, double[] a, double[] tau, double[] fitted, double[] chi_square, double chi_square_target) {
        return FLIMLibJNI.RLD_fit(x_inc, y, fit_start, fit_end, instr, noise, sig, z, a, tau, fitted, chi_square, chi_square_target);
    }

    public static int LMA_fit(double x_inc, double[] y, int fit_start, int fit_end, double[] instr, int noise, double[] sig, double[] param, boolean[] param_free, double[] fitted, double[] chi_square, double chi_square_target, double chi_square_delta) {
        return FLIMLibJNI.LMA_fit(x_inc, y, fit_start, fit_end, instr, noise, sig, param, param_free, fitted, chi_square, chi_square_target, chi_square_delta);
    }

    public static int GCI_Phasor(float xincr, float[] y, int fit_start, int fit_end, float[] Z, float[] u, float[] v, float[] taup, float[] taum, float[] tau, float[] fitted, float[] residuals, float[] chisq) {
        return FLIMLibJNI.GCI_Phasor(xincr, y, fit_start, fit_end, Z, u, v, taup, taum, tau, fitted, residuals, chisq);
    }

    public static double GCI_Phasor_getPeriod() {
        return FLIMLibJNI.GCI_Phasor_getPeriod();
    }

    public static void Bayes_set_search_grid(float[] parammin, float[] parammax) {
        FLIMLibJNI.Bayes_set_search_grid(parammin, parammax);
    }

    public static int Bayes_fitting_engine(float xincr, float[] trans, int fit_start, int fit_end, float laser_period, float[] instr, float[] param, boolean[] paramfree, float[] fitted, float[] residuals, float[] error, float[] minuslogprob, int[] nphotons, float[] chisq) {
        return FLIMLibJNI.Bayes_fitting_engine(xincr, trans, fit_start, fit_end, laser_period, instr, param, paramfree, fitted, residuals, error, minuslogprob, nphotons, chisq);
    }
}

