/*
 * Decompiled with CFR 0.152.
 */
package flimlib;

import flimlib.FLIMLibJNI;

public class Float2DMatrix {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Float2DMatrix(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Float2DMatrix obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                FLIMLibJNI.delete_Float2DMatrix(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    private static void checkArray(float[][] arr) {
        if (arr == null) {
            throw new NullPointerException("Array is null");
        }
        int row = arr.length;
        if (row == 0) {
            throw new IllegalArgumentException("Array should have at least 1 row");
        }
        int col = arr[0].length;
        if (col == 0) {
            throw new IllegalArgumentException("Array should have at least 1 column");
        }
        for (float[] arrRow : arr) {
            if (arrRow.length == col) continue;
            throw new IllegalArgumentException("Array not rectangular");
        }
    }

    public String toString() {
        String data = "";
        float[][] arr = this.asArray();
        for (int i = 0; i < arr.length; ++i) {
            String row = "";
            for (int j = 0; j < arr[i].length; ++j) {
                float abs = Math.abs(arr[i][j]);
                row = row + String.format((double)abs >= 1000000.0 || (double)abs <= 1.0E-6 ? "%13e " : "%13f ", Float.valueOf(arr[i][j]));
            }
            data = i == 0 ? data + "[ [ " + row + "]\n" : (i < arr.length - 1 ? data + "  [ " + row + "]\n" : data + "  [ " + row + "] ]\n");
        }
        return data;
    }

    public int getNrow() {
        return FLIMLibJNI.Float2DMatrix_nrow_get(this.swigCPtr, this);
    }

    public int getNcol() {
        return FLIMLibJNI.Float2DMatrix_ncol_get(this.swigCPtr, this);
    }

    public Float2DMatrix(int row, int col) {
        this(FLIMLibJNI.new_Float2DMatrix__SWIG_0(row, col), true);
    }

    private static long SwigConstructFloat2DMatrix(float[][] arr) {
        Float2DMatrix.checkArray(arr);
        return FLIMLibJNI.new_Float2DMatrix__SWIG_1(arr);
    }

    public Float2DMatrix(float[][] arr) {
        this(Float2DMatrix.SwigConstructFloat2DMatrix(arr), true);
    }

    public float[][] asArray() {
        return FLIMLibJNI.Float2DMatrix_asArray(this.swigCPtr, this);
    }
}

