/*
 * Decompiled with CFR 0.152.
 */
package levelsets.ij;

import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import levelsets.ij.ImageContainer;

public class ImageProgressContainer
extends ImageContainer {
    protected int[][] cproc_pixels;

    public ImageProgressContainer() {
    }

    public ImageProgressContainer(ImageContainer cont) {
        this.duplicateImages(cont.sproc);
        if (null != this.ip && null != cont.ip) {
            this.ip.setSlice(cont.ip.getCurrentSlice());
        }
    }

    public void duplicateImages(ImageContainer cont) {
        this.duplicateImages(cont.sproc);
        if (null != this.ip && null != cont.ip) {
            this.ip.setSlice(cont.ip.getCurrentSlice());
        }
    }

    public void duplicateImages(ImageProcessor[] iproc) {
        this.stack_size = iproc.length;
        this.isStack = this.stack_size > 1;
        this.sproc = new ColorProcessor[this.stack_size];
        this.cproc_pixels = new int[this.stack_size][];
        for (int i = 0; i < this.stack_size; ++i) {
            this.sproc[i] = (ColorProcessor)iproc[i].duplicate().convertToRGB();
            this.cproc_pixels[i] = (int[])this.sproc[i].getPixels();
        }
        this.width = this.sproc[0].getWidth();
        this.updateImagePlus(null);
    }

    public void showProgressStep() {
        this.ip.show();
        this.ip.updateAndDraw();
    }

    public void setPixel(int x, int y, int z, int[] pixel) {
        int ij_pixelval;
        this.cproc_pixels[z][y * this.width + x] = ij_pixelval = pixel[0] << 16 | pixel[1] << 8 | pixel[2];
    }
}

