/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.collections;

import java.lang.reflect.Array;
import java.util.AbstractList;
import org.scijava.collections.PrimitiveArray;

public abstract class AbstractPrimitiveArray<ArrayType, BaseType>
extends AbstractList<BaseType>
implements PrimitiveArray<ArrayType, BaseType> {
    private final Class<BaseType> type;
    private int size;
    private int maximumGrowth = Integer.MAX_VALUE;

    public AbstractPrimitiveArray(Class<BaseType> type) {
        this(type, false);
    }

    public AbstractPrimitiveArray(Class<BaseType> type, int size) {
        this.type = type;
        this.size = size;
        this.ensureCapacity(size);
    }

    public AbstractPrimitiveArray(Class<BaseType> type, ArrayType array) {
        this.type = type;
        this.setArray(array);
        this.size = this.capacity();
    }

    @Override
    public int getMaximumGrowth() {
        return this.maximumGrowth;
    }

    @Override
    public void setMaximumGrowth(int growth) {
        if (this.maximumGrowth < 1) {
            throw new IllegalArgumentException("Invalid growth value: " + growth);
        }
        this.maximumGrowth = growth;
    }

    @Override
    public ArrayType copyArray() {
        return this.copyArray(this.size());
    }

    @Override
    public int capacity() {
        Object array = this.getArray();
        return array == null ? 0 : Array.getLength(array);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.capacity();
        if (minCapacity <= oldCapacity) {
            return;
        }
        int growth = Math.min(oldCapacity / 2 + 16, this.maximumGrowth);
        int newCapacity = growth > Integer.MAX_VALUE - oldCapacity ? Integer.MAX_VALUE : oldCapacity + growth;
        int newLength = Math.max(minCapacity, newCapacity);
        this.setArray(this.copyArray(newLength));
    }

    @Override
    public void insert(int index, int count) {
        int oldSize = this.size();
        if (index < 0 || index > oldSize) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
        if (count > Integer.MAX_VALUE - oldSize) {
            throw new IllegalArgumentException("Too many elements");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive");
        }
        this.setSize(oldSize + count);
        if (index < oldSize) {
            Object array = this.getArray();
            System.arraycopy(array, index, array, index + count, oldSize - index);
        }
    }

    @Override
    public void delete(int index, int count) {
        int oldSize = this.size();
        if (index < 0 || index > oldSize) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
        if (index < 0 || index + count > oldSize) {
            throw new IllegalArgumentException("Invalid range: index=" + index + ", count=" + count + ", size=" + oldSize);
        }
        this.setSize(oldSize - count);
        if (index + count < oldSize) {
            Object array = this.getArray();
            System.arraycopy(array, index + count, array, index, oldSize - index - count);
        }
    }

    @Override
    public abstract BaseType set(int var1, BaseType var2);

    @Override
    public abstract void add(int var1, BaseType var2);

    @Override
    public BaseType remove(int index) {
        Object removed = this.get(index);
        this.delete(index, 1);
        return (BaseType)removed;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.setSize(0);
    }

    @Override
    public void setSize(int size) {
        this.ensureCapacity(size);
        this.size = size;
    }

    protected void checkBounds(int index) {
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
    }

    private ArrayType copyArray(int newLength) {
        Object copy = Array.newInstance(this.type, newLength);
        Object oldArray = this.getArray();
        if (oldArray != null) {
            System.arraycopy(oldArray, 0, copy, 0, this.size());
        }
        return (ArrayType)copy;
    }
}

