/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.opencv;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.opencv.opencv_core.Mat;
import org.opencv.core.CvType;
import org.scijava.Prioritized;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.log.LogService;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-100.0)
public class ImgToMatConverter
extends AbstractConverter<RandomAccessibleInterval, Mat> {
    public int compareTo(Prioritized o) {
        return super.compareTo(o);
    }

    public LogService log() {
        return super.log();
    }

    public String getIdentifier() {
        return super.getIdentifier();
    }

    public <T> T convert(Object o, Class<T> type) {
        RandomAccessibleInterval imp = (RandomAccessibleInterval)o;
        return (T)ImgToMatConverter.toMat(imp);
    }

    public Class<Mat> getOutputType() {
        return Mat.class;
    }

    public Class<RandomAccessibleInterval> getInputType() {
        return RandomAccessibleInterval.class;
    }

    public static <T> Mat toMat(RandomAccessibleInterval<T> image) {
        if (image.numDimensions() > 2) {
            throw new IllegalArgumentException("Images with more than 2 dimensions are not supported here, use ImgToMatVectorConverter");
        }
        Object type = Util.getTypeFromInterval(image);
        if (type instanceof UnsignedByteType) {
            return ImgToMatConverter.getUnsignedByteMat(image);
        }
        if (type instanceof ByteType) {
            return ImgToMatConverter.getByteMat(image);
        }
        if (type instanceof UnsignedShortType) {
            return ImgToMatConverter.getUnsignedShortMat(image);
        }
        if (type instanceof ShortType) {
            return ImgToMatConverter.getShortMat(image);
        }
        if (type instanceof IntType) {
            return ImgToMatConverter.getIntMat(image);
        }
        if (type instanceof FloatType) {
            return ImgToMatConverter.getFloatMat(image);
        }
        if (type instanceof DoubleType) {
            return ImgToMatConverter.getDoubleMat(image);
        }
        throw new IllegalArgumentException("Unsupported image type: " + type.getClass().getName());
    }

    public static Mat getUnsignedByteMat(RandomAccessibleInterval<UnsignedByteType> image) {
        int[] shape = Intervals.dimensionsAsIntArray(image);
        byte[] data = ImgToMatConverter.toUByteArray(image);
        return ImgToMatConverter.createByteMat(shape, CvType.CV_8UC1, data);
    }

    public static Mat getByteMat(RandomAccessibleInterval<ByteType> image) {
        int[] shape = Intervals.dimensionsAsIntArray(image);
        byte[] data = ImgToMatConverter.toByteArray(image);
        return ImgToMatConverter.createByteMat(shape, CvType.CV_8SC1, data);
    }

    private static Mat createByteMat(int[] shape, int cvType, byte[] data) {
        if (shape.length == 2) {
            return new Mat(shape[1], shape[0], cvType, (Pointer)new BytePointer(data));
        }
        int[] reshape = (int[])shape.clone();
        reshape[0] = shape[1];
        reshape[1] = shape[0];
        return new Mat(reshape.length, reshape, cvType, (Pointer)new BytePointer(data));
    }

    public static Mat getIntMat(RandomAccessibleInterval<IntType> image) {
        int[] shape = Intervals.dimensionsAsIntArray(image);
        int[] data = ImgToMatConverter.toIntArray(image);
        return ImgToMatConverter.createIntMat(shape, data);
    }

    private static Mat createIntMat(int[] shape, int[] data) {
        if (shape.length == 2) {
            return new Mat(shape[1], shape[0], CvType.CV_32SC1, (Pointer)new IntPointer(data));
        }
        int[] reshape = (int[])shape.clone();
        reshape[0] = shape[1];
        reshape[1] = shape[0];
        return new Mat(reshape.length, reshape, CvType.CV_32SC1, (Pointer)new IntPointer(data));
    }

    public static Mat getShortMat(RandomAccessibleInterval<ShortType> image) {
        int[] shape = Intervals.dimensionsAsIntArray(image);
        short[] data = ImgToMatConverter.toShortArray(image);
        return ImgToMatConverter.createShortMat(shape, CvType.CV_16SC1, data);
    }

    public static Mat getUnsignedShortMat(RandomAccessibleInterval<UnsignedShortType> image) {
        int[] shape = Intervals.dimensionsAsIntArray(image);
        short[] data = ImgToMatConverter.toUShortArray(image);
        return ImgToMatConverter.createShortMat(shape, CvType.CV_16UC1, data);
    }

    private static Mat createShortMat(int[] shape, int cvType, short[] data) {
        if (shape.length == 2) {
            return new Mat(shape[1], shape[0], cvType, (Pointer)new ShortPointer(data));
        }
        int[] reshape = (int[])shape.clone();
        reshape[0] = shape[1];
        reshape[1] = shape[0];
        return new Mat(reshape.length, reshape, cvType, (Pointer)new ShortPointer(data));
    }

    public static Mat getFloatMat(RandomAccessibleInterval<FloatType> image) {
        int[] shape = Intervals.dimensionsAsIntArray(image);
        float[] data = ImgToMatConverter.toFloatArray(image);
        return ImgToMatConverter.createFloatMat(shape, data);
    }

    private static Mat createFloatMat(int[] shape, float[] data) {
        if (shape.length == 2) {
            return new Mat(shape[1], shape[0], CvType.CV_32FC1, (Pointer)new FloatPointer(data));
        }
        int[] reshape = (int[])shape.clone();
        reshape[0] = shape[1];
        reshape[1] = shape[0];
        return new Mat(reshape.length, reshape, CvType.CV_32FC1, (Pointer)new FloatPointer(data));
    }

    public static Mat getDoubleMat(RandomAccessibleInterval<DoubleType> image) {
        int[] shape = Intervals.dimensionsAsIntArray(image);
        double[] data = ImgToMatConverter.toDoubleArray(image);
        return ImgToMatConverter.createDoubleMat(shape, data);
    }

    private static Mat createDoubleMat(int[] shape, double[] data) {
        if (shape.length == 2) {
            return new Mat(shape[1], shape[0], CvType.CV_64FC1, (Pointer)new DoublePointer(data));
        }
        int[] reshape = (int[])shape.clone();
        reshape[0] = shape[1];
        reshape[1] = shape[0];
        return new Mat(reshape.length, reshape, CvType.CV_64FC1, (Pointer)new DoublePointer(data));
    }

    public static byte[] toUByteArray(RandomAccessibleInterval<UnsignedByteType> image) {
        byte[] outputArray = new byte[(int)Intervals.numElements(image)];
        long[] shape = Intervals.dimensionsAsLongArray(image);
        ImgToMatConverter.copyFromTo(image, ArrayImgs.unsignedBytes((byte[])outputArray, (long[])shape));
        return outputArray;
    }

    public static byte[] toByteArray(RandomAccessibleInterval<ByteType> image) {
        byte[] outputArray = new byte[(int)Intervals.numElements(image)];
        long[] shape = Intervals.dimensionsAsLongArray(image);
        ImgToMatConverter.copyFromTo(image, ArrayImgs.bytes((byte[])outputArray, (long[])shape));
        return outputArray;
    }

    public static short[] toUShortArray(RandomAccessibleInterval<UnsignedShortType> image) {
        short[] outputArray = new short[(int)Intervals.numElements(image)];
        long[] shape = Intervals.dimensionsAsLongArray(image);
        ImgToMatConverter.copyFromTo(image, ArrayImgs.unsignedShorts((short[])outputArray, (long[])shape));
        return outputArray;
    }

    public static short[] toShortArray(RandomAccessibleInterval<ShortType> image) {
        short[] outputArray = new short[(int)Intervals.numElements(image)];
        long[] shape = Intervals.dimensionsAsLongArray(image);
        ImgToMatConverter.copyFromTo(image, ArrayImgs.shorts((short[])outputArray, (long[])shape));
        return outputArray;
    }

    public static int[] toIntArray(RandomAccessibleInterval<IntType> image) {
        int[] outputArray = new int[(int)Intervals.numElements(image)];
        long[] shape = Intervals.dimensionsAsLongArray(image);
        ImgToMatConverter.copyFromTo(image, ArrayImgs.ints((int[])outputArray, (long[])shape));
        return outputArray;
    }

    public static float[] toFloatArray(RandomAccessibleInterval<FloatType> image) {
        float[] outputArray = new float[(int)Intervals.numElements(image)];
        long[] shape = Intervals.dimensionsAsLongArray(image);
        ImgToMatConverter.copyFromTo(image, ArrayImgs.floats((float[])outputArray, (long[])shape));
        return outputArray;
    }

    public static double[] toDoubleArray(RandomAccessibleInterval<DoubleType> image) {
        double[] outputArray = new double[(int)Intervals.numElements(image)];
        long[] shape = Intervals.dimensionsAsLongArray(image);
        ImgToMatConverter.copyFromTo(image, ArrayImgs.doubles((double[])outputArray, (long[])shape));
        return outputArray;
    }

    private static <T extends Type<T>> void copyFromTo(RandomAccessibleInterval<T> source, RandomAccessibleInterval<T> destination) {
        LoopBuilder.setImages(source, destination).forEachPixel((i, o) -> o.set(i));
    }
}

