/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.overlay;

import bdv.img.WarpedSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bdv.viewer.overlay.SourceInfoOverlayRenderer;
import java.awt.Font;
import java.awt.Graphics2D;

public class BigWarpSourceOverlayRenderer
extends SourceInfoOverlayRenderer {
    private boolean indicateTransformed = true;
    private boolean anyTransformed = false;

    public synchronized void paint(Graphics2D g) {
        super.paint(g);
        if (this.indicateTransformed && this.anyTransformed) {
            g.setFont(new Font("Monospaced", 1, 16));
            int tformedWidth = g.getFontMetrics().stringWidth("TRANSFORMED");
            g.drawString("TRANSFORMED", (int)(g.getClipBounds().getWidth() - (double)tformedWidth) / 2, (int)g.getClipBounds().getHeight() - 16);
        }
    }

    public synchronized void setViewerState(ViewerState state) {
        super.setViewerState(state);
        this.anyTransformed = false;
        for (SourceAndConverter vs : state.getVisibleSources()) {
            WarpedSource ws;
            Source src = vs.getSpimSource();
            if (!(src instanceof WarpedSource) || !(ws = (WarpedSource)src).isTransformed()) continue;
            this.anyTransformed = true;
            break;
        }
    }

    public void setIndicateTransformed(boolean indicateTransformed) {
        this.indicateTransformed = indicateTransformed;
    }
}

