/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractWriter;
import io.scif.DefaultMetadata;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.imaris.ImarisWriter;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Imaris 5.5")
public class ImarisFormat
extends AbstractFormat {
    public String getFormatName() {
        return "Imaris 5.5 files";
    }

    protected String[] makeSuffixArray() {
        return new String[]{"ims"};
    }

    public static class Writer
    extends AbstractWriter<DefaultMetadata> {
        private ImarisWriter imsWriter;
        private String path;
        private int bitDepth;
        private long sizeX;
        private long sizeY;
        private long sizeZ;
        private long sizeC;
        private long sizeT;
        private double pixelSizeXY;
        private double pixelSizeZ;
        private ColorModel colorModel;

        public void setMetadata(Metadata meta) throws FormatException {
            this.bitDepth = meta.get(0).getBitsPerPixel();
            this.sizeX = meta.get(0).getAxisLength(Axes.X);
            this.sizeY = meta.get(0).getAxisLength(Axes.Y);
            this.sizeZ = Math.max(1L, meta.get(0).getAxisLength(Axes.Z));
            this.sizeC = Math.max(1L, meta.get(0).getAxisLength(Axes.CHANNEL));
            this.sizeT = Math.max(1L, meta.get(0).getAxisLength(Axes.TIME));
            if (meta.get(0).getPlaneCount() != this.sizeZ * this.sizeC * this.sizeT) {
                throw new FormatException("Channels * Frames * Z Slices must equal number of planes");
            }
            this.pixelSizeXY = FormatTools.getScale((Metadata)meta, (int)0, (AxisType)Axes.X);
            this.pixelSizeZ = FormatTools.getScale((Metadata)meta, (int)0, (AxisType)Axes.Z);
            super.setMetadata(meta);
        }

        public void setDest(Location fileName, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            if (!(fileName instanceof FileLocation)) {
                throw new IllegalArgumentException("Imaris format only supports local files!");
            }
            this.path = ((FileLocation)fileName).getFile().getAbsolutePath();
            this.setDest((DataHandle<Location>)((DataHandle)null), imageIndex, config);
        }

        public void setDest(DataHandle<Location> out, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            this.colorModel = config.writerGetColorModel();
        }

        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        protected void initialize(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        }

        public void savePlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
            this.savePlane(imageIndex, planeIndex, plane, plane.getBounds());
        }

        public boolean isInitialized(int imageIndex, long planeIndex) {
            return true;
        }

        public void writePlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
            Object[] pixels;
            int c;
            int z;
            if (!SCIFIOMetadataTools.wholePlane((int)imageIndex, (Metadata)this.getMetadata(), (Interval)bounds)) {
                throw new FormatException("Imaris writer does not support saving image tiles.");
            }
            if (this.imsWriter == null) {
                this.imsWriter = new ImarisWriter(this.path, this.sizeX, this.sizeY, this.sizeZ, this.sizeC, this.sizeT, this.pixelSizeXY, this.pixelSizeZ, this.bitDepth, null);
            }
            int zAxis = plane.getImageMetadata().getAxisIndex(Axes.Z);
            int channelAxis = plane.getImageMetadata().getAxisIndex(Axes.CHANNEL);
            int frameAxis = plane.getImageMetadata().getAxisIndex(Axes.TIME);
            if (frameAxis != -1 && (frameAxis < zAxis || frameAxis < channelAxis)) {
                throw new FormatException("Unsupported plane ordering: Imaris writer can only writein CZT or ZCT sequence");
            }
            int t = (int)(planeIndex / (this.sizeC * this.sizeZ));
            if (channelAxis < zAxis) {
                z = (int)(planeIndex / this.sizeC % this.sizeZ);
                c = (int)(planeIndex % this.sizeC);
            } else {
                c = (int)(planeIndex / this.sizeZ % this.sizeC);
                z = (int)(planeIndex % this.sizeZ);
            }
            String dnt = "2014-01-01 00:00:00.00" + t;
            int pixelType = plane.getImageMetadata().getPixelType();
            if (pixelType == 0 || pixelType == 1) {
                pixels = plane.getBytes();
            } else if (pixelType == 2 || pixelType == 3) {
                byte[] bytes = plane.getBytes();
                short[] shorts = new short[bytes.length / 2];
                ByteBuffer.wrap(bytes).order(plane.getImageMetadata().isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN).asShortBuffer().get(shorts);
                pixels = shorts;
            } else {
                throw new FormatException("Unsupported pixel type: Imaris writer only supports 8 or 16 bit pixels");
            }
            this.imsWriter.addImage(pixels, z, c, t, dnt);
        }

        public void close() throws IOException {
            this.imsWriter.close();
        }
    }
}

