/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.apply;

import bdv.BigDataViewer;
import bdv.viewer.ViewerFrame;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import net.imglib2.realtransform.AffineTransform3D;
import spim.vecmath.Transform3D;

public class BigDataViewerTransformationWindow {
    final AffineTransform3D t = new AffineTransform3D();
    protected final Timer timer;
    protected boolean isRunning = true;
    protected boolean wasCancelled = false;
    protected boolean ignoreScaling = true;

    public BigDataViewerTransformationWindow(BigDataViewer bdv) {
        Frame frame = new Frame("Current Global Transformation");
        frame.setSize(400, 200);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Label text1 = new Label("1.00000   0.00000   0.00000   0.00000", 1);
        Label text2 = new Label("0.00000   1.00000   0.00000   0.00000", 1);
        Label text3 = new Label("0.00000   0.00000   1.00000   0.00000", 1);
        text1.setFont(new Font("Monospaced", 0, 14));
        text2.setFont(new Font("Monospaced", 0, 14));
        text3.setFont(new Font("Monospaced", 0, 14));
        Button apply = new Button("Apply Transformation");
        Button cancel = new Button("Cancel");
        final Checkbox ignoreScale = new Checkbox("Ignore scaling factor from BigDataViewer", this.ignoreScaling);
        frame.setLayout(layout);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        frame.add((Component)text1, c);
        ++c.gridy;
        frame.add((Component)text2, c);
        ++c.gridy;
        frame.add((Component)text3, c);
        c.insets = new Insets(20, 0, 0, 0);
        ++c.gridy;
        frame.add((Component)ignoreScale, c);
        c.insets = new Insets(20, 0, 0, 0);
        ++c.gridy;
        frame.add((Component)apply, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        frame.add((Component)cancel, c);
        apply.addActionListener(new ApplyButtonListener(frame, bdv));
        cancel.addActionListener(new CancelButtonListener(frame, bdv));
        ignoreScale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                BigDataViewerTransformationWindow.this.ignoreScaling = ignoreScale.getState();
            }
        });
        frame.setVisible(true);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new BDVChecker(bdv, text1, text2, text3), 500L);
    }

    public AffineTransform3D getTransform() {
        return this.t;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    protected void close(Frame parent, BigDataViewer bdv) {
        if (parent != null) {
            parent.dispose();
        }
        this.isRunning = false;
    }

    public static void disposeViewerWindow(final BigDataViewer bdv) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ViewerFrame frame = bdv.getViewerFrame();
                    WindowEvent windowClosing = new WindowEvent((Window)frame, 201);
                    frame.dispatchEvent((AWTEvent)windowClosing);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class ApplyButtonListener
    implements ActionListener {
        final Frame parent;
        final BigDataViewer bdv;

        public ApplyButtonListener(Frame parent, BigDataViewer bdv) {
            this.parent = parent;
            this.bdv = bdv;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            BigDataViewerTransformationWindow.this.wasCancelled = false;
            BigDataViewerTransformationWindow.this.close(this.parent, this.bdv);
        }
    }

    protected class BDVChecker
    extends TimerTask {
        final BigDataViewer bdv;
        final Label text1;
        final Label text2;
        final Label text3;

        public BDVChecker(BigDataViewer bdv, Label text1, Label text2, Label text3) {
            this.bdv = bdv;
            this.text1 = text1;
            this.text2 = text2;
            this.text3 = text3;
        }

        @Override
        public void run() {
            if (BigDataViewerTransformationWindow.this.isRunning) {
                if (this.bdv != null) {
                    this.bdv.getViewer().getState().getViewerTransform(BigDataViewerTransformationWindow.this.t);
                }
                BigDataViewerTransformationWindow.this.t.set(0.0, 0, 3);
                BigDataViewerTransformationWindow.this.t.set(0.0, 1, 3);
                BigDataViewerTransformationWindow.this.t.set(0.0, 2, 3);
                if (BigDataViewerTransformationWindow.this.ignoreScaling) {
                    double[] m = new double[16];
                    int i = 0;
                    for (int row = 0; row < 3; ++row) {
                        for (int col = 0; col < 4; ++col) {
                            m[i++] = BigDataViewerTransformationWindow.this.t.get(row, col);
                        }
                    }
                    m[15] = 1.0;
                    Transform3D trans = new Transform3D(m);
                    trans.setScale(1.0);
                    trans.get(m);
                    i = 0;
                    for (int row = 0; row < 3; ++row) {
                        for (int col = 0; col < 4; ++col) {
                            BigDataViewerTransformationWindow.this.t.set(m[i++], row, col);
                        }
                    }
                }
                DecimalFormat df = new DecimalFormat("0.00000");
                this.text1.setText(df.format(BigDataViewerTransformationWindow.this.t.get(0, 0)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(0, 1)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(0, 2)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(0, 3)).substring(0, 7));
                this.text2.setText(df.format(BigDataViewerTransformationWindow.this.t.get(1, 0)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(1, 1)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(1, 2)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(1, 3)).substring(0, 7));
                this.text3.setText(df.format(BigDataViewerTransformationWindow.this.t.get(2, 0)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(2, 1)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(2, 2)).substring(0, 7) + "   " + df.format(BigDataViewerTransformationWindow.this.t.get(2, 3)).substring(0, 7));
                BigDataViewerTransformationWindow.this.timer.schedule((TimerTask)new BDVChecker(this.bdv, this.text1, this.text2, this.text3), 500L);
            }
        }
    }

    protected class CancelButtonListener
    implements ActionListener {
        final Frame parent;
        final BigDataViewer bdv;

        public CancelButtonListener(Frame parent, BigDataViewer bdv) {
            this.parent = parent;
            this.bdv = bdv;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            BigDataViewerTransformationWindow.this.wasCancelled = true;
            BigDataViewerTransformationWindow.this.close(this.parent, this.bdv);
        }
    }
}

