/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.cluster;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.XmlIoSpimData2;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class MergeClusterJobs {
    public static void merge(List<File> xmls, File output) throws SpimDataException {
        ArrayList<ValuePair> instances = new ArrayList<ValuePair>();
        for (File xml : xmls) {
            XmlIoSpimData2 io = new XmlIoSpimData2("");
            SpimData2 data = (SpimData2)io.load(xml.getAbsolutePath());
            instances.add(new ValuePair((Object)io, (Object)data));
        }
        XmlIoSpimData2 ioOut = (XmlIoSpimData2)((Object)((Pair)instances.get(0)).getA());
        SpimData2 dataOut = (SpimData2)((Object)((Pair)instances.get(0)).getB());
        ViewRegistrations vrOut = dataOut.getViewRegistrations();
        ViewInterestPoints vipOut = dataOut.getViewInterestPoints();
        for (int i = 1; i < instances.size(); ++i) {
            ViewSetup vOut;
            SpimData2 data = (SpimData2)((Object)((Pair)instances.get(i)).getB());
            for (ViewSetup v : ((SequenceDescription)data.getSequenceDescription()).getViewSetupsOrdered()) {
                vOut = (ViewSetup)((SequenceDescription)dataOut.getSequenceDescription()).getViewSetups().get(v.getId());
                if (vOut == null) {
                    throw new SpimDataException("Could not find corresponding ViewSetupId=" + v.getId() + " in xml '" + xmls.get(i) + "'");
                }
                if (vOut.getSize() == null && v.getSize() != null) {
                    vOut.setSize(v.getSize());
                }
                if (vOut.getVoxelSize() == null && v.getVoxelSize() != null) {
                    vOut.setVoxelSize(v.getVoxelSize());
                }
                if (vOut.getAngle().hasRotation() || !v.getAngle().hasRotation()) continue;
                vOut.getAngle().setRotation(v.getAngle().getRotationAxis(), v.getAngle().getRotationAngleDegrees());
            }
            for (ViewSetup v : data.getViewRegistrations().getViewRegistrationsOrdered()) {
                vOut = vrOut.getViewRegistration((ViewId)v);
                if (vOut == null) {
                    throw new SpimDataException("Could not find corresponding ViewRegistration for Timepoint=" + v.getTimePointId() + " ViewSetupId=" + v.getViewSetupId() + " in xml '" + xmls.get(i) + "'");
                }
                if (v.getTransformList().size() <= vOut.getTransformList().size()) continue;
                vOut.getTransformList().clear();
                vOut.getTransformList().addAll(v.getTransformList());
                vOut.updateModel();
            }
            ViewInterestPoints vip = data.getViewInterestPoints();
            for (TimePoint tp : ((SequenceDescription)data.getSequenceDescription()).getTimePoints().getTimePointsOrdered()) {
                for (ViewSetup vs : ((SequenceDescription)data.getSequenceDescription()).getViewSetupsOrdered()) {
                    ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(tp.getId(), vs.getId());
                    if (!vd.isPresent()) continue;
                    ViewInterestPointLists vipl = vip.getViewInterestPointLists(tp.getId(), vs.getId());
                    ViewInterestPointLists viplOut = vipOut.getViewInterestPointLists(tp.getId(), vs.getId());
                    HashMap<String, InterestPointList> map = vipl.getHashMap();
                    for (String label : map.keySet()) {
                        InterestPointList ipl = map.get(label);
                        viplOut.addInterestPointList(label, ipl);
                    }
                }
            }
        }
        try {
            ioOut.save(dataOut, output.getAbsolutePath());
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Saved xml '" + output + "'.");
        }
        catch (Exception e) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Could not save xml '" + output + "': " + e);
            e.printStackTrace();
        }
    }
}

