/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.Display_View;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;

public class DisplayViewPopup
extends JMenu
implements ViewExplorerSetable {
    public static final int askWhenMoreThan = 5;
    private static final long serialVersionUID = 5234649267634013390L;
    ViewSetupExplorerPanel<?, ?> panel;

    public DisplayViewPopup() {
        super("Display View(s)");
        JMenuItem as32bit = new JMenuItem("As 32-Bit (ImageJ Stack)");
        JMenuItem as16bit = new JMenuItem("As 16-Bit (ImageJ Stack)");
        as16bit.addActionListener(new MyActionListener(true));
        as32bit.addActionListener(new MyActionListener(false));
        this.add(as16bit);
        this.add(as32bit);
    }

    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<?, ?> panel) {
        this.panel = panel;
        return this;
    }

    public class MyActionListener
    implements ActionListener {
        final boolean as16bit;

        public MyActionListener(boolean as16bit) {
            this.as16bit = as16bit;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DisplayViewPopup.this.panel == null) {
                IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    List<BasicViewDescription<BasicViewSetup>> vds = DisplayViewPopup.this.panel.selectedRows();
                    if (vds.size() > 5 && JOptionPane.showConfirmDialog(null, "Are you sure to display " + vds.size() + " views?", "Warning", 0) == 1) {
                        return;
                    }
                    IOFunctions.println("Opening as" + (MyActionListener.this.as16bit ? " 16 bit" : "32 bit") + " using " + DisplayViewPopup.this.panel.getSpimData().getSequenceDescription().getImgLoader().getClass().getSimpleName());
                    for (BasicViewDescription<BasicViewSetup> vd : DisplayViewPopup.this.panel.selectedRows()) {
                        IOFunctions.println("Loading timepoint: " + vd.getTimePointId() + " ViewSetup: " + vd.getViewSetupId());
                        String name = SpimData2.class.isInstance(DisplayViewPopup.this.panel.getSpimData()) ? Display_View.name((ViewDescription)vd) : "Timepoint: " + vd.getTimePointId() + " ViewSetup: " + vd.getViewSetupId();
                        if (MyActionListener.this.as16bit) {
                            Display_View.display(DisplayViewPopup.this.panel.getSpimData(), vd, 1, name, true);
                            continue;
                        }
                        Display_View.display(DisplayViewPopup.this.panel.getSpimData(), vd, 0, name, true);
                    }
                }
            }).start();
        }
    }
}

