/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.Visualize_Detections;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;

public class VisualizeDetectionsPopup
extends JMenuItem
implements ViewExplorerSetable {
    private static final long serialVersionUID = 5234649267634013390L;
    ViewSetupExplorerPanel<? extends AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>>, ?> panel;

    public VisualizeDetectionsPopup() {
        super("Visualize Interest Points ...");
        this.addActionListener(new MyActionListener());
    }

    @Override
    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<? extends AbstractSpimData<? extends AbstractSequenceDescription<?, ?, ?>>, ?> panel) {
        this.panel = panel;
        return this;
    }

    public class MyActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (VisualizeDetectionsPopup.this.panel == null) {
                IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
                return;
            }
            if (!SpimData2.class.isInstance(VisualizeDetectionsPopup.this.panel.getSpimData())) {
                IOFunctions.println("Only supported for SpimData2 objects: " + this.getClass().getSimpleName());
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    List<ViewId> viewIds = VisualizeDetectionsPopup.this.panel.selectedRowsViewId();
                    SpimData2 data = (SpimData2)VisualizeDetectionsPopup.this.panel.getSpimData();
                    Visualize_Detections.Params params = Visualize_Detections.queryDetails(data, viewIds);
                    if (params == null) {
                        return;
                    }
                    Visualize_Detections.visualize(data, viewIds, params.channelsToProcess, params.detections, params.downsample, params.displayInput);
                }
            }).start();
        }
    }
}

