/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.boundingbox;

import ij.gui.GenericDialog;
import java.awt.Choice;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBox;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.ImgExport;

public class PreDefinedBoundingBox
extends BoundingBoxGUI {
    public static int defaultBoundingBox = 0;
    public static boolean defaultAllowModify = false;

    public PreDefinedBoundingBox(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
    }

    @Override
    public boolean queryParameters(Fusion fusion, ImgExport imgExport) {
        if (this.spimData.getBoundingBoxes().getBoundingBoxes().size() == 0) {
            IOFunctions.println("No bounding boxes pre-defined.");
            return false;
        }
        GenericDialog gd1 = new GenericDialog("Pre-defined Bounding Box");
        String[] boundingBoxes = new String[this.spimData.getBoundingBoxes().getBoundingBoxes().size()];
        for (int i = 0; i < boundingBoxes.length; ++i) {
            boundingBoxes[i] = this.spimData.getBoundingBoxes().getBoundingBoxes().get(i).getTitle();
        }
        if (defaultBoundingBox >= boundingBoxes.length) {
            defaultBoundingBox = 0;
        }
        gd1.addChoice("Bounding_box_title", boundingBoxes, boundingBoxes[defaultBoundingBox]);
        Choice choice = (Choice)gd1.getChoices().lastElement();
        gd1.addCheckbox("Allow_to_modify bounding box in next dialog", defaultAllowModify);
        gd1.addMessage("Note: Not allowing this is very useful for macro programming", GUIHelper.smallStatusFont);
        gd1.addMessage("");
        gd1.addMessage("BoundingBox size: ???x???x??? pixels", GUIHelper.mediumstatusfont);
        Label l1 = (Label)gd1.getMessage();
        gd1.addMessage("BoundingBox offset: ???x???x??? pixels", GUIHelper.mediumstatusfont);
        Label l2 = (Label)gd1.getMessage();
        this.addListeners(gd1, choice, l1, l2);
        gd1.showDialog();
        if (gd1.wasCanceled()) {
            return false;
        }
        defaultBoundingBox = gd1.getNextChoiceIndex();
        BoundingBox bb = this.spimData.getBoundingBoxes().getBoundingBoxes().get(defaultBoundingBox);
        boolean allowModifyDimensions = defaultAllowModify = gd1.getNextBoolean();
        this.min = (int[])bb.getMin().clone();
        this.max = (int[])bb.getMax().clone();
        return super.queryParameters(fusion, imgExport, allowModifyDimensions);
    }

    public static String getBoundingBoxDescription(BoundingBox bb) {
        int d;
        String title = bb.getTitle() + " (dim=";
        for (d = 0; d < bb.numDimensions(); ++d) {
            title = title + bb.dimension(d) + "x";
        }
        title = title.substring(0, title.length() - 1) + "px, offset=";
        for (d = 0; d < bb.numDimensions(); ++d) {
            title = title + bb.min(d) + "x";
        }
        title = title.substring(0, title.length() - 1) + "px)";
        return title;
    }

    @Override
    public PreDefinedBoundingBox newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new PreDefinedBoundingBox(spimData, viewIdsToProcess);
    }

    @Override
    public String getDescription() {
        return "Use pre-defined Bounding Box";
    }

    protected void addListeners(GenericDialog gd, final Choice choice, final Label label1, final Label label2) {
        choice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PreDefinedBoundingBox.update(PreDefinedBoundingBox.this.spimData, choice, label1, label2);
            }
        });
        PreDefinedBoundingBox.update(this.spimData, choice, label1, label2);
    }

    protected static final void update(SpimData2 spimData, Choice choice, Label label1, Label label2) {
        int index = choice.getSelectedIndex();
        BoundingBox bb = spimData.getBoundingBoxes().getBoundingBoxes().get(index);
        label1.setText("Bounding Box size: " + bb.dimension(0) + "x" + bb.dimension(1) + "x" + bb.dimension(2) + " pixels");
        label2.setText("Bounding Box offset: " + bb.min(0) + "x" + bb.min(1) + "x" + bb.min(2) + " pixels");
    }
}

