/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointdetection;

import java.util.ArrayList;
import java.util.Date;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.segmentation.DOM;
import mpicbg.spim.segmentation.IntegralImage3d;
import mpicbg.spim.segmentation.InteractiveIntegral;
import mpicbg.spim.segmentation.SimplePeak;
import net.imglib2.img.Img;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.fusion.FusionHelper;
import spim.process.interestpointdetection.Localization;

public class ProcessDOM {
    public static ArrayList<InterestPoint> compute(Image<FloatType> img, Img<net.imglib2.type.numeric.real.FloatType> imglib2img, int radius1, int radius2, float threshold, int localization, double imageSigmaX, double imageSigmaY, double imageSigmaZ, boolean findMin, boolean findMax, double minIntensity, double maxIntensity, boolean keepIntensity) {
        Image domImg;
        float max;
        float min;
        Image<LongType> integralImg = IntegralImage3d.compute(img);
        if (Double.isNaN(minIntensity) || Double.isNaN(maxIntensity) || Double.isInfinite(minIntensity) || Double.isInfinite(maxIntensity) || minIntensity == maxIntensity) {
            float[] minmax = FusionHelper.minMax(imglib2img);
            min = minmax[0];
            max = minmax[1];
        } else {
            min = (float)minIntensity;
            max = (float)maxIntensity;
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): min intensity = " + min + ", max intensity = " + max);
        int sX1 = Math.max(3, (int)Math.round((double)radius1 * (0.5 / imageSigmaX)) * 2 + 1);
        int sX2 = Math.max(5, (int)Math.round((double)radius2 * (0.5 / imageSigmaX)) * 2 + 1);
        int sY1 = Math.max(3, (int)Math.round((double)radius1 * (0.5 / imageSigmaY)) * 2 + 1);
        int sY2 = Math.max(5, (int)Math.round((double)radius2 * (0.5 / imageSigmaY)) * 2 + 1);
        int sZ1 = Math.max(3, (int)Math.round((double)radius1 * (0.5 / imageSigmaZ)) * 2 + 1);
        int sZ2 = Math.max(5, (int)Math.round((double)radius2 * (0.5 / imageSigmaZ)) * 2 + 1);
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing Difference-of-Mean, diameters = (" + sX1 + ", " + sX2 + ", " + sY1 + ", " + sY2 + ", " + sZ1 + ", " + sZ2 + ")");
        if (localization == 2) {
            domImg = img.createNewImage();
        } else {
            domImg = img;
            for (FloatType tt : img) {
                tt.setZero();
            }
        }
        DOM.computeDifferencOfMean3d(integralImg, (Image<FloatType>)domImg, sX1, sY1, sZ1, sX2, sY2, sZ2, min, max);
        integralImg.close();
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Extracting peaks (radius=" + radius1 + ", threshold=" + threshold + ")");
        ArrayList<SimplePeak> peaks = InteractiveIntegral.findPeaks((Image<FloatType>)domImg, threshold);
        ArrayList<InterestPoint> finalPeaks = localization == 0 ? Localization.noLocalization(peaks, findMin, findMax, keepIntensity) : (localization == 1 ? Localization.computeQuadraticLocalization(peaks, (Image<FloatType>)domImg, findMin, findMax, threshold, keepIntensity) : Localization.computeGaussLocalization(peaks, (Image<FloatType>)domImg, (double)(radius2 + radius1) / 2.0, findMin, findMax, threshold, keepIntensity));
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Found " + finalPeaks.size() + " peaks.");
        return finalPeaks;
    }
}

