/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import math3d.Point3d;
import vib.FastMatrix;
import vib.TransformedImage;
import vib.oldregistration.RegistrationAlgorithm;

public class RigidFromLandmarks
extends RegistrationAlgorithm {
    boolean allowScaling;

    @Override
    public ImagePlus register() {
        NamedPointSet points0 = null;
        NamedPointSet points1 = null;
        try {
            points0 = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException e) {
            IJ.error((String)("No corresponding .points file found for image: \"" + this.sourceImages[0].getTitle() + "\""));
            System.out.println("for 0 in Rigid_From_Landmarks.register()");
            return null;
        }
        try {
            points1 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException e) {
            IJ.error((String)("No corresponding .points file found for image: \"" + this.sourceImages[1].getTitle() + "\""));
            System.out.println("for 1 in Rigid_From_Landmarks.register()");
            return null;
        }
        return this.register(points0, points1);
    }

    @Override
    public ImagePlus register(NamedPointSet points0, NamedPointSet points1) {
        ArrayList<String> sharedNames = points0.namesSharedWith(points1, true);
        Point3d[] fromPoints = new Point3d[sharedNames.size()];
        Point3d[] toPoints = new Point3d[sharedNames.size()];
        int pointIndex = 0;
        for (String name : sharedNames) {
            NamedPointWorld npw0 = points0.getPoint(name);
            NamedPointWorld npw1 = points1.getPoint(name);
            toPoints[pointIndex] = npw0.toPoint3d();
            fromPoints[pointIndex] = npw1.toPoint3d();
            ++pointIndex;
        }
        FastMatrix fm = FastMatrix.bestRigid(fromPoints, toPoints, this.allowScaling);
        TransformedImage ti = new TransformedImage(this.sourceImages[0], this.sourceImages[1]);
        ti.setTransformation(fm);
        ImagePlus transformed = ti.getTransformed();
        transformed.setTitle("Transformed");
        return transformed;
    }
}

