/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import ij.IJ;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class FloatMatrixN {
    public static void invert(float[][] matrix) {
        FloatMatrixN.invert(matrix, false);
    }

    public static void invert(float[][] matrix, boolean showStatus) {
        int i;
        int M = matrix.length;
        if (M != matrix[0].length) {
            throw new RuntimeException("invert: no square matrix");
        }
        float[][] other = new float[M][M];
        for (i = 0; i < M; ++i) {
            other[i][i] = 1.0f;
        }
        for (i = 0; i < M; ++i) {
            int j;
            if (showStatus) {
                IJ.showStatus((String)("invert matrix: " + i + "/" + 2 * M));
            }
            int p = i;
            for (j = i + 1; j < M; ++j) {
                if (!(Math.abs(matrix[j][i]) > Math.abs(matrix[p][i]))) continue;
                p = j;
            }
            if (p != i) {
                float[] d = matrix[p];
                matrix[p] = matrix[i];
                matrix[i] = d;
                d = other[p];
                other[p] = other[i];
                other[i] = d;
            }
            if (matrix[i][i] != 1.0f) {
                float f = matrix[i][i];
                int j2 = i;
                while (j2 < M) {
                    float[] fArray = matrix[i];
                    int n = j2++;
                    fArray[n] = fArray[n] / f;
                }
                j2 = 0;
                while (j2 < M) {
                    float[] fArray = other[i];
                    int n = j2++;
                    fArray[n] = fArray[n] / f;
                }
            }
            for (j = i + 1; j < M; ++j) {
                int k;
                float f = matrix[j][i];
                for (k = i; k < M; ++k) {
                    float[] fArray = matrix[j];
                    int n = k;
                    fArray[n] = fArray[n] - f * matrix[i][k];
                }
                for (k = 0; k < M; ++k) {
                    float[] fArray = other[j];
                    int n = k;
                    fArray[n] = fArray[n] - f * other[i][k];
                }
            }
        }
        for (i = M - 1; i > 0; --i) {
            if (showStatus) {
                IJ.showStatus((String)("invert matrix: " + (2 * M - i) + "/" + 2 * M));
            }
            for (int j = i - 1; j >= 0; --j) {
                int k;
                float f = matrix[j][i] / matrix[i][i];
                for (k = i; k < M; ++k) {
                    float[] fArray = matrix[j];
                    int n = k;
                    fArray[n] = fArray[n] - f * matrix[i][k];
                }
                for (k = 0; k < M; ++k) {
                    float[] fArray = other[j];
                    int n = k;
                    fArray[n] = fArray[n] - f * other[i][k];
                }
            }
        }
        for (i = 0; i < M; ++i) {
            matrix[i] = other[i];
        }
    }

    public static float[][] clone(float[][] matrix) {
        int M = matrix.length;
        int N = matrix[0].length;
        float[][] result = new float[M][N];
        for (int i = 0; i < M; ++i) {
            System.arraycopy(matrix[i], 0, result[i], 0, N);
        }
        return result;
    }

    public static float[][] times(float[][] m1, float[][] m2) {
        int K = m2.length;
        if (m1[0].length != m2.length) {
            throw new RuntimeException("rank mismatch");
        }
        int M = m1.length;
        int N = m2[0].length;
        float[][] result = new float[M][N];
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                for (int k = 0; k < K; ++k) {
                    float[] fArray = result[i];
                    int n = j;
                    fArray[n] = fArray[n] + m1[i][k] * m2[k][j];
                }
            }
        }
        return result;
    }

    public static float[] times(float[][] m, float[] v) {
        int K = v.length;
        if (m[0].length != v.length) {
            throw new RuntimeException("rank mismatch");
        }
        int M = m.length;
        float[] result = new float[M];
        for (int i = 0; i < M; ++i) {
            for (int k = 0; k < K; ++k) {
                int n = i;
                result[n] = result[n] + m[i][k] * v[k];
            }
        }
        return result;
    }

    static float[][] LU_decomposition(float[][] m) {
        int N = m.length;
        float[][] R = new float[N][N];
        float[][] L = new float[N][N];
        for (int i = 0; i < N; ++i) {
            int k;
            int j;
            for (j = i; j < N; ++j) {
                R[i][j] = m[i][j];
                for (k = 0; k < i; ++k) {
                    float[] fArray = R[i];
                    int n = j;
                    fArray[n] = fArray[n] - L[i][k] * R[k][j];
                }
            }
            for (j = i + 1; j < N; ++j) {
                L[j][i] = m[j][i];
                for (k = 0; k < i; ++k) {
                    float[] fArray = L[j];
                    int n = i;
                    fArray[n] = fArray[n] - L[j][k] * R[k][i];
                }
                float[] fArray = L[j];
                int n = i;
                fArray[n] = fArray[n] / R[i][i];
            }
        }
        float[][] LU = new float[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                LU[i][j] = L[i][j] + R[i][j];
            }
        }
        return LU;
    }

    static float[][] choleskyDecomposition(float[][] m) {
        if (m.length != m[0].length) {
            throw new RuntimeException("Row and column rank must be equal");
        }
        int N = m.length;
        float[][] l = new float[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                l[i][j] = 0.0f;
            }
        }
        float sum = 0.0f;
        for (int i = 0; i < N; ++i) {
            sum = 0.0f;
            for (int k = 0; k < i; ++k) {
                sum += l[k][i] * l[k][i];
            }
            if (m[i][i] - sum < 0.0f) {
                throw new RuntimeException("Matrix must be positive definite (trace is " + sum + ", but diagonal element " + i + " is " + m[i][i] + ")");
            }
            l[i][i] = (float)Math.sqrt(m[i][i] - sum);
            for (int j = i + 1; j < N; ++j) {
                sum = 0.0f;
                for (int k = 0; k < i; ++k) {
                    sum += l[k][j] * l[k][i];
                }
                l[i][j] = (m[i][j] - sum) / l[i][i];
            }
        }
        return l;
    }

    public static float[][] transpose(float[][] m) {
        float[][] ret = new float[m[0].length][m.length];
        for (int i = 0; i < ret.length; ++i) {
            for (int j = 0; j < ret[i].length; ++j) {
                ret[i][j] = m[j][i];
            }
        }
        return ret;
    }

    public static float[] solve_UL(float[][] A, float[] b) {
        float[][] LU = FloatMatrixN.LU_decomposition(A);
        float[] y = new float[b.length];
        for (int i = 0; i < y.length; ++i) {
            float sum = 0.0f;
            for (int j = 0; j < i; ++j) {
                sum += LU[i][j] * y[j];
            }
            y[i] = b[i] - sum;
        }
        float[] x = new float[b.length];
        for (int i = x.length - 1; i >= 0; --i) {
            float sum = 0.0f;
            for (int j = i + 1; j < x.length; ++j) {
                sum += LU[i][j] * x[j];
            }
            x[i] = (y[i] - sum) / LU[i][i];
        }
        return x;
    }

    public static float[] solve_cholesky(float[][] A, float[] b) {
        float[][] U = FloatMatrixN.choleskyDecomposition(A);
        U = FloatMatrixN.choleskyDecomposition(A);
        float[][] L = FloatMatrixN.transpose(U);
        float[] y = FloatMatrixN.forward_substitution(L, b);
        float[] x = FloatMatrixN.backward_substitution(U, y);
        return x;
    }

    private static float[] backward_substitution(float[][] U, float[] b) {
        float[] x = new float[b.length];
        for (int i = x.length - 1; i >= 0; --i) {
            float sum = 0.0f;
            for (int j = i + 1; j < x.length; ++j) {
                sum += U[i][j] * x[j];
            }
            x[i] = (b[i] - sum) / U[i][i];
        }
        return x;
    }

    private static float[] forward_substitution(float[][] L, float[] b) {
        float[] y = new float[b.length];
        for (int i = 0; i < y.length; ++i) {
            float sum = 0.0f;
            for (int j = 0; j < i; ++j) {
                sum += L[i][j] * y[j];
            }
            y[i] = (b[i] - sum) / L[i][i];
        }
        return y;
    }

    public static float[] apply(float[][] A, float[] x) {
        int m = A.length;
        int n = A[0].length;
        float[] b = new float[x.length];
        for (int i = 0; i < m; ++i) {
            b[i] = 0.0f;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                b[n2] = b[n2] + A[i][j] * x[j];
            }
        }
        return b;
    }

    public static void print(float[] v) {
        System.out.print("[");
        for (int i = 0; i < v.length; ++i) {
            System.out.print(v[i] + ", ");
        }
        System.out.print("]");
        System.out.println();
    }

    public static void print(float[][] m) {
        FloatMatrixN.print(m, System.out);
    }

    public static void print(float[][] m, PrintStream out, char del) {
        DecimalFormat f = new DecimalFormat("0.00f");
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                out.print(f.format(m[i][j]) + del);
            }
            out.println("");
        }
        out.println();
    }

    public static float round(float d, int scale, RoundingMode mode) {
        BigDecimal bd = BigDecimal.valueOf(d);
        return bd.setScale(scale, mode).floatValue();
    }

    public static void print(float[][] m, PrintStream out) {
        FloatMatrixN.print(m, out, '\t');
    }

    public static void main(String[] args) {
        float dou = 1234.1234f;
        BigDecimal bd = BigDecimal.valueOf(dou);
        System.out.println(bd.unscaledValue() + " " + bd.scale());
        int inte = BigDecimal.valueOf(dou).movePointLeft(2).unscaledValue().intValue() * 100;
        bd = bd.movePointLeft(2);
        System.out.println(bd.unscaledValue());
        System.out.println("Test rounding");
        float d = 1.2345679f;
        System.out.println("Math.round(" + d + ") = " + Math.round(d));
        System.out.println("round(" + d + ",2) = " + FloatMatrixN.round(d, 2, RoundingMode.HALF_EVEN));
        float[][] m = new float[][]{{1.0f, 2.0f, 3.0f, 2.0f}, {-1.0f, 0.0f, 2.0f, -3.0f}, {-2.0f, 1.0f, 1.0f, 1.0f}, {0.0f, -2.0f, 3.0f, 0.0f}};
        float[][] m1 = FloatMatrixN.clone(m);
        FloatMatrixN.invert(m1);
        float[][] m2 = FloatMatrixN.times((float[][])m, m1);
        FloatMatrixN.print(m2);
        float[][] k = new float[5][5];
        for (int i = 0; i < k.length; ++i) {
            for (int j = i; j < k.length; ++j) {
                float f = 1.0f / (float)(i + j + 1);
                k[j][i] = f;
                k[i][j] = f;
            }
        }
        System.out.println("Original matrix ");
        FloatMatrixN.print(k);
        float[][] l = FloatMatrixN.choleskyDecomposition(k);
        System.out.println("Upper triangular form u of cholesky decomposition ");
        FloatMatrixN.print(l);
        float[][] l_t = FloatMatrixN.transpose(l);
        System.out.println("Transposed form u^T of u ");
        FloatMatrixN.print(l_t);
        float[][] prod = FloatMatrixN.times(l_t, l);
        System.out.println("Finally the product of the u^T and u, which should give the original matrix ");
        FloatMatrixN.print(prod);
        float[] x = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        System.out.println("A vector x: x = [1.0f 2.0f 3.0f]^T\n");
        float[] b = FloatMatrixN.apply(k, x);
        System.out.println("Applying the original matrix to x gives b: ");
        FloatMatrixN.print(b);
        System.out.println("\n\nTest different solve methods");
        System.out.println("\nTest Cholesky decomposition");
        float[] x_n = FloatMatrixN.solve_cholesky(k, b);
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        FloatMatrixN.print(x_n);
        System.out.println("\nTest LU decomposition");
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        x_n = FloatMatrixN.solve_UL(k, b);
        FloatMatrixN.print(x_n);
        System.out.println("\nTest ordinary invert method");
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        float[][] k_inv = FloatMatrixN.clone(k);
        FloatMatrixN.invert(k_inv);
        x_n = FloatMatrixN.apply(k_inv, b);
        FloatMatrixN.print(x_n);
    }
}

