/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.ImageCalculator;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.List;
import util.CancelDialog;

public class FindConnectedRegions {
    volatile boolean pleaseStop = false;
    private static final byte IN_QUEUE = 1;
    private static final byte ADDED_TO_CURRENT_REGION = 2;
    private static final byte IN_PREVIOUS_REGION = 3;
    static final boolean verbose = false;

    public void cancel() {
        this.pleaseStop = true;
    }

    public static IndexColorModel backgroundAndSpectrum() {
        return FindConnectedRegions.backgroundAndSpectrum(255);
    }

    public static IndexColorModel backgroundAndSpectrum(int maximum) {
        if (maximum > 255) {
            maximum = 255;
        }
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        for (int i = 0; i < 256; ++i) {
            blues[i] = -1;
            greens[i] = -1;
            reds[i] = -1;
        }
        blues[0] = 0;
        greens[0] = 0;
        reds[0] = 0;
        float divisions = maximum;
        for (int i = 1; i <= maximum; ++i) {
            float h = (float)(i - 1) / divisions;
            Color c = Color.getHSBColor(h, 1.0f, 1.0f);
            reds[i] = (byte)c.getRed();
            greens[i] = (byte)c.getGreen();
            blues[i] = (byte)c.getBlue();
        }
        return new IndexColorModel(8, 256, reds, greens, blues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results run(ImagePlus imagePlus, boolean diagonal, boolean imagePerRegion, boolean imageAllRegions, boolean showResults, boolean mustHaveSameValue, boolean startFromPointROI, boolean autoSubtract, double valuesOverDouble, double minimumPointsInRegionDouble, int stopAfterNumberOfRegions, boolean noUI) {
        ByteProcessor bp;
        int z;
        int depth;
        int height;
        int width;
        Results results = new Results();
        if (imagePerRegion) {
            results.perRegion = new ArrayList<ImagePlus>();
        }
        results.regionInfo = new ArrayList<Region>();
        ImageCalculator iCalc = new ImageCalculator();
        int type = imagePlus.getType();
        if (0 != type && 3 != type && 2 != type) {
            throw new IllegalArgumentException("The image must be either 8 bit or 32 bit for this plugin.");
        }
        boolean byteImage = false;
        if (0 == type || 3 == type) {
            byteImage = true;
        }
        if (!byteImage && mustHaveSameValue) {
            throw new IllegalArgumentException("You can only specify that each region must have the same value for 8 bit images.");
        }
        int point_roi_x = -1;
        int point_roi_y = -1;
        int point_roi_z = -1;
        if (startFromPointROI) {
            Roi roi = imagePlus.getRoi();
            if (roi == null) {
                throw new IllegalArgumentException("There's no point selected in the image.");
            }
            if (roi.getType() != 10) {
                throw new IllegalArgumentException("There's a selection in the image, but it's not a point selection.");
            }
            Polygon p = roi.getPolygon();
            if (p.npoints > 1) {
                throw new IllegalArgumentException("You can only have one point selected.");
            }
            point_roi_x = p.xpoints[0];
            point_roi_y = p.ypoints[0];
            point_roi_z = imagePlus.getCurrentSlice() - 1;
        }
        if ((width = imagePlus.getWidth()) * (height = imagePlus.getHeight()) * (depth = imagePlus.getStackSize()) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This stack is too large for this plugin (must have less than 2147483647 points.");
        }
        String[] materialList = null;
        AmiraParameters parameters = null;
        if (AmiraParameters.isAmiraLabelfield(imagePlus)) {
            parameters = new AmiraParameters(imagePlus);
            materialList = parameters.getMaterialList();
        }
        ImageStack stack = imagePlus.getStack();
        Object sliceDataBytes = null;
        Object sliceDataFloats = null;
        if (byteImage) {
            sliceDataBytes = new byte[depth][];
            for (z = 0; z < depth; ++z) {
                bp = (ByteProcessor)stack.getProcessor(z + 1);
                sliceDataBytes[z] = (byte[])bp.getPixelsCopy();
            }
        } else {
            sliceDataFloats = new float[depth][];
            for (z = 0; z < depth; ++z) {
                bp = (FloatProcessor)stack.getProcessor(z + 1);
                sliceDataFloats[z] = (float[])bp.getPixelsCopy();
            }
        }
        Calibration calibration = imagePlus.getCalibration();
        ColorModel cm = null;
        if (3 == type) {
            cm = stack.getColorModel();
        }
        String defaultAllRegionsTitle = "All connected regions";
        ImageStack allRegionsStack = null;
        short[][] allRegionsPixels = null;
        if (imageAllRegions) {
            allRegionsStack = new ImageStack(width, height);
            allRegionsPixels = new short[depth][width * height];
            for (int z2 = 0; z2 < depth; ++z2) {
                ShortProcessor sp = new ShortProcessor(width, height);
                sp.setPixels((Object)allRegionsPixels[z2]);
                allRegionsStack.addSlice("", (ImageProcessor)sp);
            }
            allRegionsStack.setColorModel((ColorModel)FindConnectedRegions.backgroundAndSpectrum(0));
            results.allRegions = new ImagePlus(defaultAllRegionsTitle + " (still generating...)", allRegionsStack);
            if (calibration != null) {
                results.allRegions.setCalibration(calibration);
            }
            if (parameters != null) {
                parameters.setParameters(results.allRegions, true);
            }
            if (!noUI) {
                results.allRegions.show();
            }
        }
        ResultsTable rt = ResultsTable.getResultsTable();
        rt.reset();
        CancelDialog cancelDialog = null;
        try {
            if (!noUI) {
                cancelDialog = new CancelDialog(this);
                cancelDialog.setVisible(true);
            }
            boolean firstTime = true;
            int regionNumber = 0;
            long numberOfPointsInStack = (long)width * (long)height * (long)depth;
            PointState pointState = new PointState(numberOfPointsInStack);
            int ignoreBeforeX = 0;
            int ignoreBeforeY = 0;
            int ignoreBeforeZ = 0;
            IJ.showProgress((double)0.0);
            int lastProgessZ = 0;
            while (!this.pleaseStop) {
                long index;
                int startY;
                int y;
                boolean foundPoint;
                int initial_x = -1;
                int initial_y = -1;
                int initial_z = -1;
                int foundValueInt = -1;
                float foundValueFloat = Float.MIN_VALUE;
                if (firstTime && startFromPointROI) {
                    boolean tooSmall;
                    initial_x = point_roi_x;
                    initial_y = point_roi_y;
                    initial_z = point_roi_z;
                    if (byteImage) {
                        foundValueInt = sliceDataBytes[initial_z][initial_y * width + initial_x] & 0xFF;
                        tooSmall = (double)foundValueInt <= valuesOverDouble;
                    } else {
                        foundValueFloat = sliceDataFloats[initial_z][initial_y * width + initial_x];
                        boolean bl = tooSmall = (double)foundValueFloat <= valuesOverDouble;
                    }
                    if (tooSmall) {
                        throw new IllegalArgumentException("The value at the point you selected is not over the threshold you specified (" + valuesOverDouble + ")");
                    }
                } else if (byteImage) {
                    foundPoint = false;
                    for (int z3 = ignoreBeforeZ; z3 < depth && !foundPoint; ++z3) {
                        if (z3 != lastProgessZ) {
                            IJ.showProgress((double)((double)z3 / (double)depth));
                            lastProgessZ = z3;
                        }
                        block8: for (y = startY = z3 == ignoreBeforeZ ? ignoreBeforeY : 0; y < height && !foundPoint; ++y) {
                            int startX;
                            for (int x = startX = z3 == ignoreBeforeZ && y == ignoreBeforeY ? ignoreBeforeX : 0; x < width; ++x) {
                                int value;
                                index = (long)width * (long)(z3 * height + y) + (long)x;
                                if (3 == pointState.get(index) || !((double)(value = sliceDataBytes[z3][y * width + x] & 0xFF) > valuesOverDouble)) continue;
                                initial_x = x;
                                initial_y = y;
                                initial_z = z3;
                                foundValueInt = value;
                                foundPoint = true;
                                continue block8;
                            }
                        }
                    }
                    if (foundValueInt == -1) {
                        break;
                    }
                } else {
                    assert (!byteImage);
                    foundPoint = false;
                    for (int z4 = ignoreBeforeZ; z4 < depth && !foundPoint; ++z4) {
                        if (z4 != lastProgessZ) {
                            IJ.showProgress((double)((double)z4 / (double)depth));
                            lastProgessZ = z4;
                        }
                        block11: for (y = startY = z4 == ignoreBeforeZ ? ignoreBeforeY : 0; y < height && !foundPoint; ++y) {
                            int startX;
                            for (int x = startX = z4 == ignoreBeforeZ && y == ignoreBeforeY ? ignoreBeforeX : 0; x < width; ++x) {
                                float value;
                                index = (long)width * (long)(z4 * height + y) + (long)x;
                                if (3 == pointState.get(index) || !((double)(value = sliceDataFloats[z4][y * width + x]) > valuesOverDouble)) continue;
                                initial_x = x;
                                initial_y = y;
                                initial_z = z4;
                                foundValueFloat = value;
                                foundPoint = true;
                                continue block11;
                            }
                        }
                    }
                    if (foundValueFloat == Float.MIN_VALUE) break;
                }
                ignoreBeforeX = initial_x + 1;
                ignoreBeforeZ = initial_z;
                ignoreBeforeY = initial_y;
                firstTime = false;
                int vint = foundValueInt;
                String materialName = null;
                if (materialList != null) {
                    materialName = materialList[vint];
                }
                int pointsInQueue = 0;
                int queueArrayLength = 1024;
                long[] queue = new long[queueArrayLength];
                long index2 = (long)width * (long)(initial_z * height + initial_y) + (long)initial_x;
                pointState.set(index2, (byte)1);
                queue[pointsInQueue++] = index2;
                int pointsInThisRegion = 0;
                while (pointsInQueue > 0 && !this.pleaseStop) {
                    long nextIndex;
                    long currentPointStateIndex = nextIndex = queue[--pointsInQueue];
                    int pz = (int)(nextIndex / (long)(width * height));
                    int currentSliceIndex = (int)(nextIndex % (long)(width * height));
                    int py = currentSliceIndex / width;
                    int px = currentSliceIndex % width;
                    pointState.set(currentPointStateIndex, (byte)2);
                    if (byteImage) {
                        sliceDataBytes[pz][currentSliceIndex] = 0;
                    } else {
                        sliceDataFloats[pz][currentSliceIndex] = Float.MIN_VALUE;
                    }
                    ++pointsInThisRegion;
                    int x_unchecked_min = px - 1;
                    int y_unchecked_min = py - 1;
                    int z_unchecked_min = pz - 1;
                    int x_unchecked_max = px + 1;
                    int y_unchecked_max = py + 1;
                    int z_unchecked_max = pz + 1;
                    int x_min = Math.max(0, x_unchecked_min);
                    int y_min = Math.max(0, y_unchecked_min);
                    int z_min = Math.max(0, z_unchecked_min);
                    int x_max = Math.min(x_unchecked_max, width - 1);
                    int y_max = Math.min(y_unchecked_max, height - 1);
                    int z_max = Math.min(z_unchecked_max, depth - 1);
                    for (int z5 = z_min; z5 <= z_max; ++z5) {
                        for (int y2 = y_min; y2 <= y_max; ++y2) {
                            for (int x = x_min; x <= x_max; ++x) {
                                int z_off_centre;
                                int y_off_centre;
                                int x_off_centre = x == x_unchecked_min || x == x_unchecked_max ? 1 : 0;
                                int off_centre_total = x_off_centre + (y_off_centre = y2 == y_unchecked_min || y2 == y_unchecked_max ? 1 : 0) + (z_off_centre = z5 == z_unchecked_min || z5 == z_unchecked_max ? 1 : 0);
                                if (off_centre_total == 0 || !diagonal && x_off_centre + y_off_centre + z_off_centre > 1) continue;
                                int newSliceIndex = y2 * width + x;
                                int newPointStateIndex = width * (z5 * height + y2) + x;
                                if (byteImage) {
                                    int neighbourValue = sliceDataBytes[z5][newSliceIndex] & 0xFF;
                                    if (mustHaveSameValue ? neighbourValue != vint : (double)neighbourValue <= valuesOverDouble) {
                                        continue;
                                    }
                                } else {
                                    float neighbourValue = sliceDataFloats[z5][newSliceIndex];
                                    if ((double)neighbourValue <= valuesOverDouble) continue;
                                }
                                if (0 != pointState.get(newPointStateIndex)) continue;
                                pointState.set(newPointStateIndex, (byte)1);
                                if (pointsInQueue == queueArrayLength) {
                                    int newArrayLength = (int)((double)queueArrayLength * 1.2);
                                    long[] newArray = new long[newArrayLength];
                                    System.arraycopy(queue, 0, newArray, 0, pointsInQueue);
                                    queue = newArray;
                                    queueArrayLength = newArrayLength;
                                }
                                queue[pointsInQueue++] = newPointStateIndex;
                            }
                        }
                    }
                }
                if (this.pleaseStop) break;
                Region region = byteImage ? new Region(vint, materialName, pointsInThisRegion, mustHaveSameValue) : new Region(pointsInThisRegion, mustHaveSameValue);
                if ((double)pointsInThisRegion < minimumPointsInRegionDouble) {
                    for (long p = 0L; p < numberOfPointsInStack; ++p) {
                        if (pointState.get(p) != 2) continue;
                        pointState.set(p, (byte)3);
                    }
                    continue;
                }
                ++regionNumber;
                results.regionInfo.add(region);
                int replacementValue = byteImage ? (int)((byte)(cm == null ? 255 : vint)) : -1;
                if (imageAllRegions) {
                    if (regionNumber == 32768) {
                        IJ.showMessage((String)"Found more regions than Short.MAX_VALUE, so the all regions image will have overflowed values...");
                    }
                    for (int z6 = 0; z6 < depth; ++z6) {
                        for (int y3 = 0; y3 < height; ++y3) {
                            for (int x = 0; x < width; ++x) {
                                long i = (long)width * (long)(z6 * height + y3) + (long)x;
                                if (pointState.get(i) != 2) continue;
                                allRegionsPixels[z6][y3 * width + x] = (short)regionNumber;
                            }
                        }
                    }
                    allRegionsStack.setColorModel((ColorModel)FindConnectedRegions.backgroundAndSpectrum(Math.min(regionNumber, 255)));
                    ImageProcessor ip = results.allRegions.getProcessor();
                    if (ip != null) {
                        ip.setColorModel((ColorModel)FindConnectedRegions.backgroundAndSpectrum(Math.min(regionNumber, 255)));
                        boolean min = false;
                        int max = Math.max(regionNumber, 255);
                        ip.setMinAndMax((double)min, (double)max);
                    }
                    results.allRegions.updateAndDraw();
                }
                if (imagePerRegion || autoSubtract) {
                    ImageStack newStack = new ImageStack(width, height);
                    for (int z7 = 0; z7 < depth; ++z7) {
                        byte[] sliceBytes = new byte[width * height];
                        for (int y4 = 0; y4 < height; ++y4) {
                            for (int x = 0; x < width; ++x) {
                                long i = (long)width * (long)(z7 * height + y4) + (long)x;
                                byte status = pointState.get(i);
                                if (status == 1) {
                                    IJ.log((String)("BUG: point " + x + "," + y4 + "," + z7 + " is still marked as IN_QUEUE"));
                                }
                                if (status != 2) continue;
                                sliceBytes[y4 * width + x] = replacementValue;
                            }
                        }
                        ByteProcessor bp2 = new ByteProcessor(width, height);
                        bp2.setPixels((Object)sliceBytes);
                        newStack.addSlice("", (ImageProcessor)bp2);
                    }
                    if (3 == type && cm != null) {
                        newStack.setColorModel(cm);
                    }
                    ImagePlus newImagePlus = new ImagePlus(region.toString(), newStack);
                    if (calibration != null) {
                        newImagePlus.setCalibration(calibration);
                    }
                    if (parameters != null) {
                        parameters.setParameters(newImagePlus, true);
                    }
                    if (autoSubtract) {
                        iCalc.calculate("Subtract stack", imagePlus, newImagePlus);
                    }
                    if (imagePerRegion) {
                        if (!noUI) {
                            newImagePlus.show();
                        }
                        results.perRegion.add(newImagePlus);
                    } else {
                        newImagePlus.changes = false;
                        newImagePlus.close();
                    }
                }
                for (long p = 0L; p < numberOfPointsInStack; ++p) {
                    if (pointState.get(p) != 2) continue;
                    pointState.set(p, (byte)3);
                }
                if (stopAfterNumberOfRegions <= 0 || results.regionInfo.size() < stopAfterNumberOfRegions) continue;
                break;
            }
            IJ.showProgress((double)1.0);
            if (imageAllRegions) {
                results.allRegions.setTitle(defaultAllRegionsTitle);
            }
        }
        finally {
            if (!noUI && cancelDialog != null) {
                cancelDialog.dispose();
            }
        }
        for (Region r : results.regionInfo) {
            if (!showResults) continue;
            r.addRow(rt);
        }
        if (showResults && !noUI) {
            rt.show("Results");
        }
        return results;
    }

    public class PointState {
        private static final int CHUNK_SIZE = 0x40000000;
        private final byte[][] state;

        public PointState(long size) {
            int len;
            int numArrays = (int)(size / 0x40000000L) + 1;
            this.state = new byte[numArrays][];
            int i = 0;
            for (long remain = size; remain > 0L; remain -= (long)len) {
                len = remain > 0x40000000L ? 0x40000000 : (int)remain;
                this.state[i++] = new byte[len];
            }
        }

        public void set(long index, byte value) {
            int a = (int)(index / 0x40000000L);
            int i = (int)(index % 0x40000000L);
            this.state[a][i] = value;
        }

        public byte get(long index) {
            int a = (int)(index / 0x40000000L);
            int i = (int)(index % 0x40000000L);
            return this.state[a][i];
        }
    }

    public class Results {
        public List<ImagePlus> perRegion;
        public ImagePlus allRegions;
        public List<Region> regionInfo;
    }

    public class Region
    implements Comparable<Region> {
        boolean byteImage;
        int points;
        String materialName;
        int value;
        boolean sameValue;

        Region(int value, String materialName, int points, boolean sameValue) {
            this.byteImage = true;
            this.value = value;
            this.materialName = materialName;
            this.points = points;
            this.sameValue = sameValue;
        }

        public int getNumberOfPoints() {
            return this.points;
        }

        public int getValue() {
            return this.value;
        }

        Region(int points, boolean sameValue) {
            this.byteImage = false;
            this.points = points;
            this.sameValue = sameValue;
        }

        @Override
        public int compareTo(Region o) {
            return this.points < o.points ? -1 : (this.points > o.points ? 1 : 0);
        }

        public String toString() {
            if (this.byteImage) {
                String materialBit = "";
                if (this.materialName != null) {
                    materialBit = " (" + this.materialName + ")";
                }
                return "Region of value " + this.value + materialBit + " containing " + this.points + " points";
            }
            return "Region containing " + this.points + " points";
        }

        public void addRow(ResultsTable rt) {
            rt.incrementCounter();
            if (this.byteImage) {
                if (this.sameValue) {
                    rt.addValue("Value in Region", (double)this.value);
                }
                rt.addValue("Points In Region", (double)this.points);
                if (this.materialName != null) {
                    rt.addLabel("Material Name", this.materialName);
                }
            } else {
                rt.addValue("Points in Region", (double)this.points);
            }
        }
    }
}

