/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.tamura2d;

import net.imagej.ops.Ops;
import net.imagej.ops.features.tamura2d.AbstractTamuraFeature;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Tamura.Contrast.class, label="Tamura 2D: Contrast")
public class DefaultContrastFeature<I extends RealType<I>, O extends RealType<O>>
extends AbstractTamuraFeature<I, O>
implements Ops.Tamura.Contrast {
    private UnaryFunctionOp<RandomAccessibleInterval<I>, O> m4Op;
    private UnaryFunctionOp<RandomAccessibleInterval<I>, O> varOp;
    private UnaryFunctionOp<RandomAccessibleInterval<I>, O> stdOp;

    @Override
    public void initialize() {
        this.m4Op = RTs.function(this.ops(), Ops.Stats.Moment4AboutMean.class, this.in(), new Object[0]);
        this.varOp = RTs.function(this.ops(), Ops.Stats.Variance.class, this.in(), new Object[0]);
        this.stdOp = RTs.function(this.ops(), Ops.Stats.StdDev.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(RandomAccessibleInterval<I> input, O output) {
        double m4 = ((RealType)this.m4Op.calculate(input)).getRealDouble();
        double var = ((RealType)this.varOp.calculate(input)).getRealDouble();
        double std = ((RealType)this.stdOp.calculate(input)).getRealDouble();
        double l4 = m4 / (var * var);
        double fCon = std / Math.pow(l4, 0.25);
        output.setReal(fCon);
    }
}

