/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.topology;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.ValuePair;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Topology.BoxCount.class)
public class BoxCount<B extends BooleanType<B>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<B>, List<ValuePair<DoubleType, DoubleType>>>
implements Ops.Topology.BoxCount {
    @Parameter
    private LogService logService;
    @Parameter(required=false, persist=false)
    private Long maxSize = 48L;
    @Parameter(required=false, persist=false)
    private Long minSize = 6L;
    @Parameter(required=false, persist=false)
    private Double scaling = 1.2;
    @Parameter(required=false, persist=false)
    private Long gridMoves = 0L;

    @Override
    public List<ValuePair<DoubleType, DoubleType>> calculate(RandomAccessibleInterval<B> input) {
        if (this.scaling < 1.0 || this.scaling == 1.0 && this.maxSize > this.minSize) {
            throw new IllegalArgumentException("Scaling must be > 1.0 or algorithm won't stop.");
        }
        ArrayList<ValuePair<DoubleType, DoubleType>> points = new ArrayList<ValuePair<DoubleType, DoubleType>>();
        int dimensions = input.numDimensions();
        long[] sizes = new long[dimensions];
        input.dimensions(sizes);
        long boxSize = this.maxSize;
        while (boxSize >= this.minSize) {
            long numTranslations = BoxCount.limitTranslations(boxSize, 1L + this.gridMoves);
            long translationAmount = boxSize / numTranslations;
            Stream<long[]> translations = BoxCount.translationStream(numTranslations, translationAmount, dimensions - 1, new long[dimensions]);
            LongStream foregroundCounts = this.countTranslatedGrids(input, translations, sizes, boxSize);
            long foreground = foregroundCounts.min().orElse(0L);
            double logSize = -Math.log(boxSize);
            double logCount = Math.log(foreground);
            ValuePair point = new ValuePair((Object)new DoubleType(logSize), (Object)new DoubleType(logCount));
            points.add((ValuePair<DoubleType, DoubleType>)point);
            boxSize = (long)((double)boxSize / this.scaling);
        }
        return points;
    }

    static long limitTranslations(long size, long translations) throws IllegalArgumentException {
        if (size < 1L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        if (translations < 1L) {
            return 1L;
        }
        return Math.min(size, translations);
    }

    private LongStream countTranslatedGrids(RandomAccessibleInterval<B> input, Stream<long[]> translations, long[] sizes, long boxSize) {
        return translations.mapToLong(t -> this.countForegroundBoxes(input, boxSize, sizes, (long[])t));
    }

    private int countNThreads(long boxCount, long boxSize) {
        int processors = this.ops().getMaxThreads();
        return boxSize >= 2L ? (int)Math.min((long)processors, boxCount) : 1;
    }

    private long countForegroundBoxes(RandomAccessibleInterval<B> input, long boxSize, long[] sizes, long[] translation) {
        long[] dimensions = new long[input.numDimensions()];
        input.dimensions(dimensions);
        long boxCount = 1L;
        for (int i = 0; i < sizes.length; ++i) {
            boxCount = (long)((double)boxCount * Math.ceil((1.0 * (double)sizes[i] - (double)translation[i]) / (double)boxSize));
        }
        int nThreads = this.countNThreads(boxCount, boxSize);
        long boxesPerThread = Math.max(1L, boxCount / (long)nThreads);
        long remainder = boxCount % (long)nThreads;
        ExecutorService pool = Executors.newFixedThreadPool(nThreads);
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            long first = (long)i * boxesPerThread;
            long l = i < nThreads - 1 ? boxesPerThread : boxesPerThread + remainder;
            Callable<Long> task = BoxCount.createCalculationTask(dimensions, boxSize, translation, first, input, l);
            futures.add(pool.submit(task));
        }
        long foregroundBoxes = 0L;
        for (Future future : futures) {
            try {
                foregroundBoxes += ((Long)future.get()).longValue();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.shutdownAndAwaitTermination(pool);
        return foregroundBoxes;
    }

    private void shutdownAndAwaitTermination(ExecutorService executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.logService.trace((Object)"Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
            this.logService.trace((Throwable)ie);
        }
    }

    private static <B extends BooleanType<B>> Callable<Long> createCalculationTask(long[] dimensions, long boxSize, long[] translation, long first, RandomAccessibleInterval<B> input, long boxes) {
        return () -> {
            CoordinateGenerator boxer = new CoordinateGenerator(dimensions, boxSize, translation);
            boxer.skip(first);
            RandomAccess access = input.randomAccess();
            long[] boxPosition = new long[access.numDimensions()];
            long[] position = new long[access.numDimensions()];
            long foreground = 0L;
            for (long generated = 0L; generated < boxes; ++generated) {
                boxer.next(boxPosition);
                int d = access.numDimensions() - 1;
                if (!BoxCount.hasBoxForeground(d, access, boxPosition, boxSize, dimensions, position)) continue;
                ++foreground;
            }
            return foreground;
        };
    }

    private static <B extends BooleanType<B>> boolean hasBoxForeground(int dimension, RandomAccess<B> access, long[] boxStart, long boxSize, long[] sizes, long[] position) {
        long min = Math.max(boxStart[dimension], 0L);
        long max = Math.min(boxStart[dimension] + boxSize, sizes[dimension]);
        for (long p = min; p < max; ++p) {
            position[dimension] = p;
            if (dimension > 0) {
                if (!BoxCount.hasBoxForeground(dimension - 1, access, boxStart, boxSize, sizes, position)) continue;
                return true;
            }
            access.setPosition(position);
            if (!((BooleanType)access.get()).get()) continue;
            return true;
        }
        return false;
    }

    private static Stream<long[]> translationStream(long numTranslations, long amount, int dimension, long[] translation) {
        Stream.Builder<long[]> builder = Stream.builder();
        BoxCount.generateTranslations(numTranslations, amount, dimension, translation, builder);
        return builder.build();
    }

    private static void generateTranslations(long numTranslations, long amount, int dimension, long[] translation, Stream.Builder<long[]> builder) {
        int t = 0;
        while ((long)t < numTranslations) {
            translation[dimension] = (long)(-t) * amount;
            if (dimension == 0) {
                builder.add((long[])translation.clone());
            } else {
                BoxCount.generateTranslations(numTranslations, amount, dimension - 1, translation, builder);
            }
            ++t;
        }
    }

    private static class CoordinateGenerator {
        private final long[] dimensions;
        private final long[] position;
        private final long[] start;
        private final long increment;
        private boolean hasNext;

        private CoordinateGenerator(long[] dimensions, long increment, long[] start) {
            this.start = new long[dimensions.length];
            System.arraycopy(start, 0, this.start, 0, start.length);
            this.position = new long[dimensions.length];
            System.arraycopy(this.start, 0, this.position, 0, this.start.length);
            this.increment = increment;
            this.dimensions = dimensions;
            this.hasNext = dimensions.length > 0 && Arrays.stream(dimensions).allMatch(d -> d > 0L);
        }

        private void skip(long n) {
            int skipped = 0;
            while ((long)skipped < n && this.hasNext) {
                this.incrementPosition(0);
                ++skipped;
            }
        }

        private void next(long[] position) {
            System.arraycopy(this.position, 0, position, 0, position.length);
            this.incrementPosition(0);
        }

        private void incrementPosition(int dimension) {
            if (dimension >= this.dimensions.length) {
                this.hasNext = false;
                return;
            }
            int n = dimension;
            this.position[n] = this.position[n] + this.increment;
            if (this.position[dimension] >= this.dimensions[dimension]) {
                this.position[dimension] = this.start[dimension];
                this.incrementPosition(dimension + 1);
            }
        }
    }
}

