/*
 * Decompiled with CFR 0.152.
 */
package volume;

import volume.Kernel2D;

public class Gaussian2D
extends Kernel2D {
    protected double sigma;

    public Gaussian2D() {
        this.sigma = 0.0;
    }

    public Gaussian2D(double sigma) {
        this.sigma = sigma;
        if (sigma != 0.0) {
            int width = (int)(6.0 * sigma + 1.0);
            if (width % 2 == 0) {
                ++width;
            }
            this.halfwidth = width / 2;
            this.k = new double[this.halfwidth * 2 + 1][this.halfwidth * 2 + 1];
            for (int m = -this.halfwidth; m <= this.halfwidth; ++m) {
                for (int l = -this.halfwidth; l <= this.halfwidth; ++l) {
                    this.k[m + this.halfwidth][l + this.halfwidth] = this.function(l, m);
                }
            }
        } else {
            this.halfwidth = 0;
        }
    }

    protected double function(double x, double y) {
        return 1.0 / (Math.PI * 2 * Math.pow(this.sigma, 2.0)) * Math.exp(-(x * x + y * y) / (2.0 * Math.pow(this.sigma, 2.0)));
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public String toString() {
        return "Gauss 2D" + this.sigma;
    }
}

