/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.scijava.Context;
import org.scijava.app.AppService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.swing.script.FileDrop;
import org.scijava.ui.swing.script.FileSystemTree;
import org.scijava.ui.swing.script.TextEditor;

class FileSystemTreePanel
extends JPanel {
    private static final long serialVersionUID = -710040159139542578L;
    private final FileSystemTree tree;
    private final SearchField searchField;
    private boolean regex;
    private boolean caseSensitive;
    @Parameter
    private AppService appService;

    FileSystemTreePanel(FileSystemTree tree, Context context) {
        this.tree = tree;
        context.inject(this);
        this.searchField = this.initializedField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.gridx = 0;
        bc.gridy = 0;
        bc.weightx = 0.0;
        bc.weighty = 0.0;
        bc.anchor = 10;
        bc.fill = 2;
        this.add((Component)this.addDirectoryButton(), bc);
        bc.gridx = 1;
        this.add((Component)this.removeDirectoryButton(), bc);
        bc.gridx = 2;
        bc.fill = 1;
        bc.weightx = 1.0;
        this.add((Component)this.searchField, bc);
        bc.fill = 0;
        bc.weightx = 0.0;
        bc.gridx = 3;
        this.add((Component)this.searchOptionsButton(), bc);
        bc.gridx = 0;
        bc.gridwidth = 4;
        bc.gridy = 1;
        bc.weightx = 1.0;
        bc.weighty = 1.0;
        bc.fill = 1;
        JScrollPane treePane = new JScrollPane(tree);
        this.add((Component)treePane, bc);
        new FileDrop(treePane, files -> {
            List<File> dirs = Arrays.asList(files).stream().filter(f -> f.isDirectory()).collect(Collectors.toList());
            if (dirs.isEmpty()) {
                TextEditor.GuiUtils.warn(this, "Only folders can be dropped into the file tree.");
                return;
            }
            if (TextEditor.GuiUtils.confirm(this, "Confirm loading of " + dirs.size() + " folders?", "Confirm?", "Confirm")) {
                dirs.forEach(dir -> tree.addRootDirectory(dir.getAbsolutePath(), true));
            }
        });
        this.addContextualMenuToTree();
    }

    private SearchField initializedField() {
        final SearchField field = new SearchField();
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (0 == field.getText().length()) {
                    FileSystemTreePanel.this.tree.setFileFilter(f -> true);
                }
            }
        });
        field.addKeyListener(new KeyAdapter(){
            Pattern pattern = null;

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    String text = field.getText();
                    if (0 == text.length()) {
                        FileSystemTreePanel.this.tree.setFileFilter(f -> true);
                        return;
                    }
                    if (FileSystemTreePanel.this.isRegexEnabled()) {
                        try {
                            String regex = text;
                            if ('^' != regex.charAt(1)) {
                                regex = "^.*" + regex;
                            }
                            if ('$' != regex.charAt(regex.length() - 1)) {
                                regex = regex + ".*$";
                            }
                            this.pattern = Pattern.compile(regex);
                            field.setForeground(FileSystemTreePanel.this.tree.getForeground());
                        }
                        catch (StringIndexOutOfBoundsException | PatternSyntaxException pse) {
                            ((FileSystemTreePanel)FileSystemTreePanel.this).tree.log.warn(pse.getLocalizedMessage());
                            field.setForeground(Color.RED);
                            this.pattern = null;
                            return;
                        }
                        if (null != this.pattern) {
                            FileSystemTreePanel.this.tree.setFileFilter(f -> this.pattern.matcher(f.getName()).matches());
                        }
                    } else if (FileSystemTreePanel.this.isCaseSensitive()) {
                        FileSystemTreePanel.this.tree.setFileFilter(f -> -1 != f.getName().indexOf(text));
                    } else {
                        FileSystemTreePanel.this.tree.setFileFilter(f -> -1 != f.getName().toLowerCase().indexOf(text.toLowerCase()));
                    }
                } else if (field.getForeground() == Color.RED) {
                    field.setForeground(FileSystemTreePanel.this.tree.getForeground());
                }
            }
        });
        return field;
    }

    private JButton thinButton(String label, float factor) {
        JButton b = new JButton(label);
        try {
            if ("com.apple.laf.AquaLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
                b.setOpaque(true);
                b.setBackground(new JPanel().getBackground());
                b.setBorderPainted(false);
                b.setBorder(BorderFactory.createEmptyBorder());
                b.setMargin(new Insets(0, 2, 0, 2));
            } else {
                Insets insets = b.getMargin();
                b.setMargin(new Insets((int)((float)insets.top * factor), (int)((float)insets.left * factor), (int)((float)insets.bottom * factor), (int)((float)insets.right * factor)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        b.setPreferredSize(new Dimension(b.getPreferredSize().width, (int)this.searchField.getPreferredSize().getHeight()));
        b.setMaximumSize(new Dimension(b.getMaximumSize().width, (int)this.searchField.getPreferredSize().getHeight()));
        return b;
    }

    private JButton addDirectoryButton() {
        JButton add_directory = this.thinButton("+", 0.25f);
        add_directory.setToolTipText("Add a directory");
        add_directory.addActionListener(e -> {
            File f;
            String folders = this.tree.getTopLevelFoldersString();
            String lastFolder = folders.substring(folders.lastIndexOf(":") + 1);
            JFileChooser c = new JFileChooser();
            c.setDialogTitle("Choose Top-Level Folder");
            c.setCurrentDirectory(new File(lastFolder));
            c.setFileSelectionMode(1);
            c.setFileHidingEnabled(true);
            c.setAcceptAllFileFilterUsed(false);
            c.setApproveButtonText("Choose Folder");
            c.setMultiSelectionEnabled(false);
            c.setDragEnabled(true);
            new FileDrop(c, files -> {
                if (files.length == 0) {
                    return;
                }
                File firstFile = files[0];
                c.setCurrentDirectory(firstFile.isDirectory() ? firstFile : firstFile.getParentFile());
                c.rescanCurrentDirectory();
            });
            if (0 == c.showOpenDialog(this) && (f = c.getSelectedFile()).isDirectory()) {
                this.tree.addRootDirectory(f.getAbsolutePath(), false);
            }
            FileDrop.remove(c);
        });
        return add_directory;
    }

    private JButton removeDirectoryButton() {
        JButton remove_directory = this.thinButton("\u2212", 0.25f);
        remove_directory.setToolTipText("Remove a top-level directory");
        remove_directory.addActionListener(e -> {
            TreePath p = this.tree.getSelectionPath();
            if (null == p) {
                TextEditor.GuiUtils.error(this, "Select a top-level folder first.");
                return;
            }
            if (2 == p.getPathCount()) {
                this.tree.getModel().removeNodeFromParent((FileSystemTree.Node)p.getLastPathComponent());
            } else {
                TextEditor.GuiUtils.error(this, "Can only remove top-level folders.");
            }
        });
        return remove_directory;
    }

    private JButton searchOptionsButton() {
        JButton options = this.thinButton("\u22ee", 0.05f);
        options.setToolTipText("Filtering options");
        JPopupMenu popup = new JPopupMenu();
        JCheckBoxMenuItem jcbmi1 = new JCheckBoxMenuItem("Case Sensitive", this.isCaseSensitive());
        jcbmi1.addItemListener(e -> this.setCaseSensitive(jcbmi1.isSelected()));
        popup.add(jcbmi1);
        JCheckBoxMenuItem jcbmi2 = new JCheckBoxMenuItem("Enable Regex", this.isCaseSensitive());
        jcbmi2.addItemListener(e -> this.setRegexEnabled(jcbmi2.isSelected()));
        popup.add(jcbmi2);
        popup.addSeparator();
        JMenuItem jmi = new JMenuItem("Reset Filter");
        jmi.addActionListener(e -> {
            jcbmi1.setSelected(false);
            this.setCaseSensitive(false);
            jcbmi2.setSelected(false);
            this.setRegexEnabled(false);
            this.searchField.setText("");
            this.tree.setFileFilter(f -> true);
        });
        popup.add(jmi);
        popup.addSeparator();
        jmi = new JMenuItem("About File Explorer...");
        jmi.addActionListener(e -> this.showHelpMsg());
        popup.add(jmi);
        options.addActionListener(e -> popup.show(options, options.getWidth() / 2, options.getHeight() / 2));
        return options;
    }

    private boolean allTreeNodesCollapsed() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            if (this.tree.isCollapsed(i)) continue;
            return false;
        }
        return true;
    }

    private void addContextualMenuToTree() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem jmi = new JMenuItem("Collapse All");
        jmi.addActionListener(e -> TextEditor.GuiUtils.collapseAllTreeNodes(this.tree));
        popup.add(jmi);
        jmi = new JMenuItem("Expand Folders");
        jmi.addActionListener(e -> this.expandImmediateNodes());
        popup.add(jmi);
        popup.addSeparator();
        jmi = new JMenuItem("Open in System Explorer");
        jmi.addActionListener(e -> {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                TextEditor.GuiUtils.info(this, "No items are currently selected.", "Invalid Selection");
                return;
            }
            try {
                String filepath = (String)((FileSystemTree.Node)path.getLastPathComponent()).getUserObject();
                File f = new File(filepath);
                Desktop.getDesktop().open(f.isDirectory() ? f : f.getParentFile());
            }
            catch (Error | Exception ignored) {
                TextEditor.GuiUtils.error(this, "Folder of selected item does not seem to be accessible.");
            }
        });
        popup.add(jmi);
        jmi = new JMenuItem("Open in Terminal");
        jmi.addActionListener(e -> {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                TextEditor.GuiUtils.info(this, "No items are currently selected.", "Invalid Selection");
                return;
            }
            try {
                String filepath = (String)((FileSystemTree.Node)path.getLastPathComponent()).getUserObject();
                TextEditor.GuiUtils.openTerminal(new File(filepath));
            }
            catch (Exception ignored) {
                TextEditor.GuiUtils.error(this, "Could not open path in Terminal.");
            }
        });
        popup.add(jmi);
        popup.addSeparator();
        jmi = new JMenuItem("Reset to Home Folder");
        jmi.addActionListener(e -> this.changeRootPath(System.getProperty("user.home")));
        popup.add(jmi);
        jmi = new JMenuItem("Reset to Fiji.app/");
        jmi.addActionListener(e -> this.changeRootPath(this.appService.getApp().getBaseDirectory().getAbsolutePath()));
        popup.add(jmi);
        this.tree.setComponentPopupMenu(popup);
    }

    void changeRootPath(String path) {
        ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).removeAllChildren();
        this.tree.addTopLevelFoldersFrom(path);
        this.tree.getModel().reload();
        this.expandImmediateNodes();
    }

    private void expandImmediateNodes() {
        for (int i = this.tree.getRowCount() - 1; i >= 0; --i) {
            this.tree.expandRow(i);
        }
    }

    private void showHelpMsg() {
        String msg = "<HTML><p><b>Overview</b></p><p>The File Explorer pane provides a direct view of selected folders. Changes in the native file system are synchronized in real time.</p><br><p><b>Add/Remove Folders</b></p><p>To add a folder, use the [+] button, or drag &amp; drop folders from the native System Explorer. To remove a folder: select it, then use the [-] button. To reset or reveal items: use the commands in the contextual popup menu.</p><br><p><b>Accessing Files &amp; Paths</b></p><p>Double-click on a file to open it. Drag &amp; drop items into the editor pane to paste their paths into the active script.</p><br><p><b>Filtering Files</b></p><p>Filters affect filenames (not folders) and are applied by typing a filtering string + [Enter]. Filters act only on files being listed in expanded directories, and ignore the content of collapsed folders. Examples of regex usage:</p><br><table align='center'>  <tr>   <th>Pattern</th>   <th>Result</th>  </tr>  <tr>   <td>py$</td>   <td>Display filenames ending with <i>py</i></td>  </tr>  <tr>   <td>^Demo</td>   <td>Display filenames starting with <i>Demo</i></td>  </tr></table>";
        TextEditor.GuiUtils.showHTMLDialog(this.getRootPane(), "File Explorer Pane", "<HTML><p><b>Overview</b></p><p>The File Explorer pane provides a direct view of selected folders. Changes in the native file system are synchronized in real time.</p><br><p><b>Add/Remove Folders</b></p><p>To add a folder, use the [+] button, or drag &amp; drop folders from the native System Explorer. To remove a folder: select it, then use the [-] button. To reset or reveal items: use the commands in the contextual popup menu.</p><br><p><b>Accessing Files &amp; Paths</b></p><p>Double-click on a file to open it. Drag &amp; drop items into the editor pane to paste their paths into the active script.</p><br><p><b>Filtering Files</b></p><p>Filters affect filenames (not folders) and are applied by typing a filtering string + [Enter]. Filters act only on files being listed in expanded directories, and ignore the content of collapsed folders. Examples of regex usage:</p><br><table align='center'>  <tr>   <th>Pattern</th>   <th>Result</th>  </tr>  <tr>   <td>py$</td>   <td>Display filenames ending with <i>py</i></td>  </tr>  <tr>   <td>^Demo</td>   <td>Display filenames starting with <i>Demo</i></td>  </tr></table>");
    }

    private boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private boolean isRegexEnabled() {
        return this.regex;
    }

    private void setCaseSensitive(boolean b) {
        this.caseSensitive = b;
        this.searchField.update();
    }

    private void setRegexEnabled(boolean b) {
        this.regex = b;
        this.searchField.update();
    }

    private class SearchField
    extends TextEditor.TextFieldWithPlaceholder {
        private static final long serialVersionUID = 7004232238240585434L;
        private static final String REGEX_HOLDER = "[?*]";
        private static final String CASE_HOLDER = "[Aa]";
        private static final String DEF_HOLDER = "File filter... ";

        SearchField() {
            try {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                FontRenderContext frc = fm.getFontRenderContext();
                String buf = "[Aa][?*]File filter... ";
                Rectangle2D rect = this.getFont().getStringBounds("[Aa][?*]File filter... ", frc);
                int prefWidth = (int)rect.getWidth();
                this.setColumns(prefWidth / this.getColumnWidth());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void update() {
            this.update(this.getGraphics());
        }

        @Override
        String getPlaceholder() {
            StringBuilder sb = new StringBuilder(DEF_HOLDER);
            if (FileSystemTreePanel.this.isCaseSensitive()) {
                sb.append(CASE_HOLDER);
            }
            if (FileSystemTreePanel.this.isRegexEnabled()) {
                sb.append(REGEX_HOLDER);
            }
            return sb.toString();
        }
    }
}

