/*
 * Decompiled with CFR 0.152.
 */
package preview.net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import preview.net.imglib2.algorithm.neighborhood.NeighborhoodFactory;

public class HyperEllipsoidNeighborhood<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final RandomAccess<T> sourceRandomAccess;
    private final long[] radii;
    private final double[] radiusRatii;
    private final double lastRadius;
    private final int maxDim;
    private final long size;
    private final Interval structuringElementBoundingBox;

    public static NeighborhoodFactory factory(final double[] radius) {
        return new NeighborhoodFactory(){

            @Override
            public <T> Neighborhood<T> create(long[] position, RandomAccess<T> sourceRandomAccess) {
                return new HyperEllipsoidNeighborhood<T>(position, radius, sourceRandomAccess);
            }
        };
    }

    HyperEllipsoidNeighborhood(long[] position, double[] radii, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.sourceRandomAccess = sourceRandomAccess;
        this.radii = new long[radii.length];
        for (int i = 0; i < radii.length; ++i) {
            this.radii[i] = (long)radii[i];
        }
        this.maxDim = this.n - 1;
        this.lastRadius = radii[this.maxDim];
        this.radiusRatii = new double[this.maxDim];
        for (int d = 0; d < this.maxDim; ++d) {
            this.radiusRatii[d] = radii[d] / radii[d + 1];
        }
        this.size = this.computeSize();
        long[] min = new long[this.n];
        long[] max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            min[d] = -this.radii[d];
            max[d] = this.radii[d];
        }
        this.structuringElementBoundingBox = new FinalInterval(min, max);
    }

    protected long computeSize() {
        LocalCursor cursor = new LocalCursor(this.sourceRandomAccess);
        long size = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            ++size;
        }
        return size;
    }

    public Interval getStructuringElementBoundingBox() {
        return this.structuringElementBoundingBox;
    }

    public long size() {
        return this.size;
    }

    public T firstElement() {
        return this.cursor().next();
    }

    public Object iterationOrder() {
        return this;
    }

    public Iterator<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return this.position[d] - this.radii[d];
    }

    public long max(int d) {
        return this.position[d] + this.radii[d];
    }

    public long dimension(int d) {
        return 2L * this.radii[d] + 1L;
    }

    public LocalCursor cursor() {
        return new LocalCursor(this.sourceRandomAccess.copyRandomAccess());
    }

    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    public final class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        private final RandomAccess<T> source;
        private final double[] r;
        private final long[] ri;
        private final long[] s;

        public LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.r = new double[this.n];
            this.ri = new long[this.n];
            this.s = new long[this.n];
            this.reset();
        }

        protected LocalCursor(LocalCursor c) {
            super(c.numDimensions());
            this.source = c.source.copyRandomAccess();
            this.r = (double[])c.r.clone();
            this.ri = (long[])c.ri.clone();
            this.s = (long[])c.s.clone();
        }

        public T get() {
            return this.source.get();
        }

        public void fwd() {
            this.s[0] = this.s[0] - 1L;
            if (this.s[0] >= 0L) {
                this.source.fwd(0);
            } else {
                int d = 1;
                while (d < this.n) {
                    int n = d++;
                    this.s[n] = this.s[n] - 1L;
                    if (this.s[n] < 0L) continue;
                    this.source.fwd(d);
                    break;
                }
                while (d > 0) {
                    int e = d - 1;
                    double rd = this.r[d];
                    long pd = this.s[d] - this.ri[d];
                    double rad = HyperEllipsoidNeighborhood.this.radiusRatii[e] * Math.sqrt(rd * rd - (double)(pd * pd));
                    long radi = (long)rad;
                    this.r[e] = rad;
                    this.ri[e] = radi;
                    this.s[e] = 2L * radi;
                    this.source.setPosition(HyperEllipsoidNeighborhood.this.position[e] - radi, e);
                    --d;
                }
            }
        }

        public void jumpFwd(long steps) {
            for (long i = 0L; i < steps; ++i) {
                this.fwd();
            }
        }

        public T next() {
            this.fwd();
            return this.get();
        }

        public void remove() {
        }

        public void reset() {
            for (int d = 0; d < HyperEllipsoidNeighborhood.this.maxDim; ++d) {
                this.s[d] = 0L;
                this.ri[d] = 0L;
                this.r[d] = 0L;
                this.source.setPosition(HyperEllipsoidNeighborhood.this.position[d], d);
            }
            this.source.setPosition(HyperEllipsoidNeighborhood.this.position[HyperEllipsoidNeighborhood.this.maxDim] - HyperEllipsoidNeighborhood.this.radii[HyperEllipsoidNeighborhood.this.maxDim] - 1L, HyperEllipsoidNeighborhood.this.maxDim);
            this.r[((HyperEllipsoidNeighborhood)HyperEllipsoidNeighborhood.this).maxDim] = HyperEllipsoidNeighborhood.this.lastRadius;
            this.ri[((HyperEllipsoidNeighborhood)HyperEllipsoidNeighborhood.this).maxDim] = HyperEllipsoidNeighborhood.this.radii[HyperEllipsoidNeighborhood.this.maxDim];
            this.s[((HyperEllipsoidNeighborhood)HyperEllipsoidNeighborhood.this).maxDim] = 1L + 2L * HyperEllipsoidNeighborhood.this.radii[HyperEllipsoidNeighborhood.this.maxDim];
        }

        public boolean hasNext() {
            if (this.s[0] > 0L) {
                return true;
            }
            for (int d = 1; d < this.n; ++d) {
                if (this.s[d] <= 0L) continue;
                return true;
            }
            return false;
        }

        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        public void localize(long[] position) {
            this.source.localize(position);
        }

        public void localize(float[] position) {
            this.source.localize(position);
        }

        public void localize(double[] position) {
            this.source.localize(position);
        }

        public void localize(int[] position) {
            this.source.localize(position);
        }

        public LocalCursor copy() {
            return new LocalCursor(this);
        }

        public LocalCursor copyCursor() {
            return this.copy();
        }
    }
}

