/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import com.google.common.collect.Iterables;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class SwitchFunction
extends SpecialFunction {
    public SwitchFunction() {
        super("switch");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        return SwitchFunction.doApply(context, rho, call2, args2);
    }

    private static SEXP doApply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        int branchIndex;
        EvalException.check(call2.length() > 1, "argument \"EXPR\" is missing", new Object[0]);
        SEXP expr = context.evaluate((SEXP)args2.getElementAsSEXP(0), rho);
        EvalException.check(expr.length() == 1, "EXPR must return a length 1 vector", new Object[0]);
        Iterable branches = Iterables.skip(args2.nodes(), (int)1);
        if (expr instanceof StringVector) {
            PairList.Node last;
            String name = ((StringVector)expr).getElementAsString(0);
            if (StringVector.isNA(name)) {
                context.setInvisibleFlag();
                return Null.INSTANCE;
            }
            SEXP partialMatch = null;
            int partialMatchCount = 0;
            for (PairList.Node node : branches) {
                if (!node.hasTag()) continue;
                String branchName = node.getTag().getPrintName();
                if (branchName.equals(name)) {
                    return context.evaluate(SwitchFunction.nextNonMissing(node), rho);
                }
                if (!branchName.startsWith(name)) continue;
                partialMatch = SwitchFunction.nextNonMissing(node);
                ++partialMatchCount;
            }
            if (partialMatchCount == 1) {
                return context.evaluate(partialMatch, rho);
            }
            if (Iterables.size((Iterable)branches) > 0 && !(last = (PairList.Node)Iterables.getLast((Iterable)branches)).hasTag()) {
                return context.evaluate(last.getValue(), rho);
            }
        } else if (expr instanceof AtomicVector && (branchIndex = ((AtomicVector)expr).getElementAsInt(0)) >= 1 && branchIndex <= Iterables.size((Iterable)branches)) {
            return context.evaluate(((PairList.Node)Iterables.get((Iterable)branches, (int)(branchIndex - 1))).getValue(), rho);
        }
        return Null.INSTANCE;
    }

    private static SEXP nextNonMissing(PairList.Node node) {
        while (node.getValue() == Symbol.MISSING_ARG) {
            if (!node.hasNextNode()) {
                return Null.INSTANCE;
            }
            node = node.getNextNode();
        }
        return node.getValue();
    }

    public static SEXP matchAndApply(Context context, Environment rho, FunctionCall call2, String[] argumentNames, SEXP[] arguments) {
        PairList.Builder args2 = new PairList.Builder();
        for (int i = 0; i != arguments.length; ++i) {
            args2.add(argumentNames[i], arguments[i]);
        }
        return SwitchFunction.doApply(context, rho, call2, args2.build());
    }
}

