/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.RenderAtomListInfo;
import org.jogamp.java3d.RenderMethod;
import org.jogamp.java3d.RenderMolecule;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.VirtualUniverse;

class OrientedShape3DRenderMethod
implements RenderMethod {
    OrientedShape3DRenderMethod() {
    }

    @Override
    public boolean render(RenderMolecule rm, Canvas3D cv, RenderAtomListInfo ra, int dirtyBits) {
        Transform3D trans = null;
        boolean useAlpha = rm.useAlpha;
        GeometryArrayRetained geo = (GeometryArrayRetained)ra.geometry();
        geo.setVertexFormat(rm.useAlpha && (geo.vertexFormat & 4) != 0, rm.textureBin.attributeBin.ignoreVertexColors, cv.ctx);
        if (rm.doInfinite) {
            cv.updateState(dirtyBits);
            while (ra != null) {
                trans = ra.infLocalToVworld;
                boolean isNonUniformScale = !trans.isCongruent();
                cv.setModelViewMatrix(cv.ctx, cv.vworldToEc.mat, trans);
                ra.geometry().execute(cv, ra.renderAtom, isNonUniformScale, useAlpha && ra.geometry().noAlpha, rm.alpha, cv.screen.screen, rm.textureBin.attributeBin.ignoreVertexColors);
                ra = ra.next;
            }
            return true;
        }
        boolean isVisible = false;
        while (ra != null) {
            boolean isNonUniformScale;
            if (cv.ra == ra.renderAtom) {
                if (cv.raIsVisible) {
                    cv.updateState(dirtyBits);
                    trans = ra.localToVworld;
                    isNonUniformScale = !trans.isCongruent();
                    cv.setModelViewMatrix(cv.ctx, cv.vworldToEc.mat, trans);
                    ra.geometry().execute(cv, ra.renderAtom, isNonUniformScale, useAlpha && ra.geometry().noAlpha, rm.alpha, cv.screen.screen, rm.textureBin.attributeBin.ignoreVertexColors);
                    isVisible = true;
                }
            } else {
                if (!VirtualUniverse.mc.viewFrustumCulling || ra.renderAtom.localeVwcBounds.intersect(cv.viewFrustum)) {
                    cv.updateState(dirtyBits);
                    cv.raIsVisible = true;
                    trans = ra.localToVworld;
                    isNonUniformScale = !trans.isCongruent();
                    cv.setModelViewMatrix(cv.ctx, cv.vworldToEc.mat, trans);
                    ra.geometry().execute(cv, ra.renderAtom, isNonUniformScale, useAlpha && ra.geometry().noAlpha, rm.alpha, cv.screen.screen, rm.textureBin.attributeBin.ignoreVertexColors);
                    isVisible = true;
                } else {
                    cv.raIsVisible = false;
                }
                cv.ra = ra.renderAtom;
            }
            ra = ra.next;
        }
        return isVisible;
    }
}

