/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public abstract class GenericIntType<T extends GenericIntType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    final Index i = new Index();
    protected final NativeImg<?, ? extends IntAccess> img;
    protected IntAccess dataAccess;

    public GenericIntType(NativeImg<?, ? extends IntAccess> intStorage) {
        this.img = intStorage;
    }

    public GenericIntType(int value) {
        this.img = null;
        this.dataAccess = new IntArray(1);
        this.setInt(value);
    }

    public GenericIntType(IntAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericIntType() {
        this(0);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public abstract NativeTypeFactory<T, IntAccess> getNativeTypeFactory();

    @Deprecated
    protected int getValue() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Deprecated
    protected void setValue(int f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    public int getInt() {
        return this.dataAccess.getValue(this.i.get());
    }

    public void setInt(int f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public void mul(float c) {
        int a = this.getInt();
        this.setInt(Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        int a = this.getInt();
        this.setInt((int)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        int a = this.getInt();
        this.setInt(a + ((GenericIntType)c).getInt());
    }

    @Override
    public void div(T c) {
        int a = this.getInt();
        this.setInt(a / ((GenericIntType)c).getInt());
    }

    @Override
    public void mul(T c) {
        int a = this.getInt();
        this.setInt(a * ((GenericIntType)c).getInt());
    }

    @Override
    public void sub(T c) {
        int a = this.getInt();
        this.setInt(a - ((GenericIntType)c).getInt());
    }

    @Override
    public void pow(T c) {
        int a = this.getInt();
        this.setReal(Math.pow(a, ((GenericIntType)c).getInt()));
    }

    @Override
    public void pow(double power) {
        int a = this.getInt();
        this.setReal(Math.pow(a, power));
    }

    @Override
    public void set(T c) {
        this.setInt(((GenericIntType)c).getInt());
    }

    @Override
    public void setOne() {
        this.setInt(1);
    }

    @Override
    public void setZero() {
        this.setInt(0);
    }

    @Override
    public void inc() {
        int a = this.getInt();
        this.setInt(++a);
    }

    @Override
    public void dec() {
        int a = this.getInt();
        this.setInt(--a);
    }

    @Override
    public String toString() {
        return "" + this.getInt();
    }

    @Override
    public int getBitsPerPixel() {
        return 32;
    }

    @Override
    public int compareTo(T other) {
        return Integer.compare(this.getInt(), ((GenericIntType)other).getInt());
    }

    @Override
    public boolean valueEquals(T t) {
        return this.getInt() == ((GenericIntType)t).getInt();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        GenericIntType t = (GenericIntType)obj;
        return this.valueEquals((T)t);
    }

    @Override
    public int hashCode() {
        return Integer.hashCode(this.getInt());
    }
}

